/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_join.h"

static const char       rcsid[] = "$Id: map_field_names_with_alias.c,v 1.2 2009/10/16 20:07:58 keith Exp $";

/*
** $Log: map_field_names_with_alias.c,v $
** Revision 1.2  2009/10/16 20:07:58  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/08 13:36:33  keith
** Initial revision
**
*/

/*
** This function remaps field names with correct bind entry.
*/
int map_field_names_with_alias( dfile_bind_t ***input_map_bind_tbl, dfile_bind_t ***output_map_bind_tbl, unsigned short *map_bind_tbl_cnt, dfile_bind_t *to_bind, unsigned short to_bind_cnt, void *from_bind_hash_table, map_field_t *map_field_tbl, unsigned short map_field_tbl_cnt, const char *source, const char *target )
{
	static const char	func[] = "map_field_names_with_alias";
	unsigned short	map_cnt;
	dfile_bind_t	**input_map_bind, **output_map_bind;
	dfile_bind_t	key_bind, **bind_entry;
	size_t	alloc_size;
	const char	*field_alias;

	assert( input_map_bind_tbl != (dfile_bind_t ***)0 );
	assert( output_map_bind_tbl != (dfile_bind_t ***)0 );
	assert( map_bind_tbl_cnt != (unsigned short *)0 );
	assert( to_bind != (dfile_bind_t *)0 );
	assert( to_bind_cnt > (unsigned short)0 );
	assert( from_bind_hash_table != (void *)0 );
	assert( source != (const char *)0 );
	assert( target != (const char *)0 );

	DEBUG_FUNC_START;

	*input_map_bind_tbl = (dfile_bind_t **)0;
	*output_map_bind_tbl = (dfile_bind_t **)0;
	*map_bind_tbl_cnt = (unsigned short)0;

	alloc_size = (size_t)to_bind_cnt * sizeof( dfile_bind_t * );

	input_map_bind = (dfile_bind_t **)malloc( alloc_size );
	if ( input_map_bind == (dfile_bind_t **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	output_map_bind = (dfile_bind_t **)malloc( alloc_size );
	if ( output_map_bind == (dfile_bind_t **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	map_cnt = (unsigned short)0;

	for ( ; to_bind_cnt > (unsigned short)0; --to_bind_cnt ) {
		find_field_alias( &field_alias, to_bind->field_name, map_field_tbl, map_field_tbl_cnt, target, source );

		if ( field_alias == (const char *)0 ) {
			key_bind.field_name = to_bind->field_name;
		} else {
			key_bind.field_name = field_alias;
		}

		bind_entry = (dfile_bind_t **)dhfind( (void *)&key_bind, from_bind_hash_table, strhkey( key_bind.field_name ), dfile_bind_field_name_cmp );

		if ( bind_entry == (dfile_bind_t **)0 ) {
			++to_bind;
			continue;
		}

		if ( Debug ) {
			(void) fprintf( stderr, "[%s] match\n", ( *bind_entry )->field_name );
		}

		input_map_bind[ map_cnt ] = *bind_entry;
		output_map_bind[ map_cnt ] = to_bind;
		++map_cnt;
		++to_bind;
	}

	*input_map_bind_tbl = input_map_bind;
	*output_map_bind_tbl = output_map_bind;
	*map_bind_tbl_cnt = map_cnt;

	if ( Debug ) {
		(void) fprintf( stderr, "Mapped %hu fields.\n", map_cnt );
	}

	RETURN_INT( 0 );
}
