/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile_exec.h"

static const char       rcsid[] = "$Id: release_allocated_jobs.c,v 1.2 2009/10/16 20:05:35 keith Exp $";

/*
** $Log: release_allocated_jobs.c,v $
** Revision 1.2  2009/10/16 20:05:35  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/07 06:30:33  keith
** Initial revision
**
*/

/*
** This function releases unneeded job slots that were previously allocated.
*/
int release_allocated_jobs( unsigned short unneeded_job_cnt, int semid )
{
	static const char	func[] = "release_allocated_jobs";
	int	ret;
	struct sembuf	sops;

	DEBUG_FUNC_START;

	ret = 0;

	sops.sem_num = 0;
	sops.sem_op = unneeded_job_cnt;
	sops.sem_flg = SEM_UNDO;

	if ( semop( semid, &sops, (size_t)1 ) == -1 ) {
		UNIX_ERROR( "semop() failed" );
		ret = -1;
	}

	RETURN_INT( ret );
}
