/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile_exec.h"

static const char       rcsid[] = "$Id: alloc_job_tbl.c,v 1.2 2009/10/16 20:05:35 keith Exp $";

/*
** $Log: alloc_job_tbl.c,v $
** Revision 1.2  2009/10/16 20:05:35  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/06 10:02:33  keith
** Initial revision
**
*/

/*
** This function allocates job table array. Its size corresponds to
** number of slices to be processed.
*/
job_t *alloc_job_tbl( unsigned short cnt )
{
	static const char	func[] = "alloc_job_tbl";
	size_t	alloc_size;
	job_t	*job_tbl;

	DEBUG_FUNC_START;

	alloc_size = sizeof( job_t ) * (size_t)cnt;
	job_tbl = (job_t *)malloc( alloc_size );
	if ( job_tbl == (job_t *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_POINTER( (job_t *)0 );
	}

	(void) memset( (void *)job_tbl, 0, alloc_size );

	RETURN_POINTER( job_tbl );
}
