// Dezyne --- Dezyne command line tools
//
// Copyright © 2020 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
// Copyright © 2023 Rutger van Beusekom <rutger@dezyne.org>
//
// This file is part of Dezyne.
//
// Dezyne is free software: you can redistribute it and/or modify it
// under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// Dezyne is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public
// License along with Dezyne.  If not, see <http://www.gnu.org/licenses/>.
//
#ifndef LIBRARY_FOREIGN_HH
#define LIBRARY_FOREIGN_HH

#include "hello.hh"

namespace library
{

struct foreign: public dzn::component
{
  dzn::meta dzn_meta;
  dzn::runtime &dzn_runtime;
  dzn::locator const &dzn_locator;
  ::library::iworld w;
  foreign (const dzn::locator &);
  friend std::ostream &operator << (std::ostream &os, foreign const &)
  {
    return os << "[" << "]" ;
  }
};
};

#endif // LIBRARY_FOREIGN_HH
