#!/bin/bash

# A desktop user needs to belong to a couple groups so as to mount USB
# keys, use the scanner, administrate CUPS, etc.

mainuser=$1

if [ -z "$mainuser" ]; then
    # debinstall creates user #1000
    mainuser=`getent passwd 1000 | cut -d: -f1`
fi

for group in \
    src adm lpadmin plugdev dialout dip fax cdrom floppy\
    tape audio video camera scanner uml-net
  do
  if [ -z "`getent group $group`" ]; then
      addgroup --system $group
  fi
  gpasswd -a $mainuser $group
done
