#!/usr/bin/perl -wT
use strict;
use English qw( -no_match_vars ) ;  # Avoids regex performance penalty
use Net::FTP;
use POSIX qw(strftime);

our $ftp_hostname;
our $ftp_username;
our $ftp_password;
my $params_file = "/etc/ftpbackup_params.pl";
do($params_file) or die "Could not use parameters file $params_file: $OS_ERROR\n";


# -T security boilerplate
$ENV{'PATH'} = '/bin:/usr/bin';
delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};

# We do not wish localized error messages, so we can filter them
$ENV{'LANG'} = 'C';

print STDERR "Connecting to $ftp_hostname...\n";
my $ftp = Net::FTP->new($ftp_hostname, Debug => 0)
    or die "Cannot connect to $ftp_hostname: $@";

print STDERR "Loging in as $ftp_username...\n";
$ftp->login($ftp_username, $ftp_password)
    or die "Cannot login ", $ftp->message;

STDOUT->autoflush(1);

my $remote_filename = $ARGV[0] || strftime("%Y-%m-%d.tar.gz", gmtime());
$ftp->binary();
$ftp->get($remote_filename, *STDOUT{IO})
    or die "get failed ", $ftp->message;

$ftp->quit;
