#!/usr/bin/perl -wT
use strict;
use English qw( -no_match_vars ) ;  # Avoids regex performance penalty
use Net::FTP;
use POSIX qw(strftime);

sub human_readable {
    my ($n) = @_;
    my $unit = 'B';
    if ($n > 1024) {
	$n /= 1024;
	$unit = 'kB';
    }
    if ($n > 1024) {
	$n /= 1024;
	$unit = 'MB';
    }
    if ($n > 1024) {
	$n /= 1024;
	$unit = 'GB';
    }
    return sprintf("%4.2g$unit", $n);
}

our $ftp_hostname;
our $ftp_username;
our $ftp_password;
my $params_file = "/etc/ftpbackup_params.pl";
do($params_file) or die "Could not use parameters file $params_file: $OS_ERROR\n";

# -T security boilerplate
$ENV{'PATH'} = '/bin:/usr/bin';
delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};

my $verbose = 1;

print STDERR "Connecting to $ftp_hostname...\n" if $verbose;
my $ftp = Net::FTP->new($ftp_hostname, Debug => 0)
    or die "Cannot connect to $ftp_hostname: $@";

print STDERR "Loging in as $ftp_username...\n" if $verbose;
$ftp->login($ftp_username, $ftp_password)
    or die "Cannot login ", $ftp->message;

# Debug:
map {print "$_\t" . $ftp->size($_) . "\t" . human_readable($ftp->size($_)); print "\n"; } $ftp->ls;

$ftp->quit;
