#!/usr/bin/perl -wT
use strict;
use English qw(-no_match_vars);  # Avoids regex performance penalty
use Net::FTP;
use POSIX qw(strftime);
use Getopt::Long;

# -T security boilerplate
$ENV{'PATH'} = '/bin:/usr/bin';
delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};


my $help = '';
my $verbose = '';
my $remote_filename = strftime("%Y-%m-%d.tar.gz", gmtime());

my $options_are_valid = GetOptions("help" => \$help,
				   "verbose" => \$verbose);
if (!$options_are_valid) {
    exit 1;
}
if ($help) {
    print "usage: $0 [--verbose] remote_filename";
    exit 0;
}
if (defined($ARGV[0])) {
    $remote_filename = $ARGV[0];
}


our $ftp_hostname;
our $ftp_username;
our $ftp_password;
my $params_file = "/etc/ftpbackup_params.pl";
do($params_file) or die "Could not use parameters file $params_file: $OS_ERROR\n";


print STDERR "Connecting to $ftp_hostname...\n" if $verbose;
my $ftp = Net::FTP->new($ftp_hostname, Debug => 0)
    or die "Cannot connect to $ftp_hostname: $@";

print STDERR "Loging in as $ftp_username...\n" if $verbose;
$ftp->login($ftp_username, $ftp_password)
    or die "Cannot login ", $ftp->message;

print "Sending tar output to $remote_filename...\n" if $verbose;
$ftp->binary;
$ftp->put(*STDIN{IO}, $remote_filename)
    or die "put failed ", $ftp->message;

$ftp->quit;
