#!/bin/bash

# TODO: contribute this as a system-imager mode - that is, instead of
# replicating the client to a central server and then replicating it
# again to another client, just sync client B from client B directly.

IP=$1
if [ -z "$IP" ]; then
    echo "Usage: $0 IP"
    exit 1
fi


target_part='/dev/hda3'
target='.'

# Get the system
rsync --quiet \
  --archive --hard-links --sparse --delete-excluded \
  --numeric-ids \
  --exclude '/dev/pts/*' --exclude '/proc/*' --exclude '/sys/*' \
  --exclude '/mnt/*/*' \
  --exclude '/var/cache/apt/archives/*' \
  --exclude '/var/cache/apt-proxy/*' \
  root@$IP:/ $target

# Populate /dev/ for GRUB to use
mount -o bind /dev/ $target/dev

# Fake mtab so that GRUB doesn't complain
cat <<EOF > $target/etc/mtab
$target_part / ext3 rw,errors=remount-ro 0 0
devpts /dev/pts devpts rw,gid=5,mode=620 0 0
proc /proc proc rw 0 0
none /proc/bus/usb usbfs defaults 0 0
sysfs /sys sysfs rw 0 0
EOF

rm $target/boot/grub/device.map
target_disk=`echo $target_partition | sed 's/[0-9]$//'`
chroot $target grub-install $target_disk

echo "TODO: edit $target/boot/grub/menu.lst"
echo "TODO: check the cdrom in /etc/fstab"
