# Base install
aptitude --assume-yes install x-window-system gnome gdm

# Additional packages
aptitude --assume-yes install \
    gnome-backgrounds gdm-themes grub-splashimages\
    mozilla-thunderbird mozilla-thunderbird-locale-fr \
    gaim gftp \
    xine-ui vlc xmms \
    gqview evince gv \
    gthumb gphoto2 \
    cupsys hp-ppd \
    twm xterm

# Take new printers PPDs into account
invoke-rc.d cupsys restart

aptitude -t sarge-backports install grsync ssh-askpass-fullscreen \
    firefox firefox-locale-fr

# Other suggestions:
# - offline work: webhttrack
# - mind-mapping: -t sarge-backports kdissert vym


# Give users more time to choose their OS if dual-booting
sed -i -e 's/^timeout.*/timeout 15/' /boot/grub/menu.lst

# X11: Authorize users to launch additional X servers
sed -i 's/^allowed_users=.*/allowed_users=anybody/' /etc/X11/Xwrapper.config

# GDM
sed -i 's|#Greeter=.*|Greeter=/usr/bin/gdmgreeter|' /etc/gdm/gdm.conf
sed -i 's|#GraphicalTheme=.*|GraphicalTheme=circles|' /etc/gdm/gdm.conf
sed -i 's|^SecureSystemMenu=.*|SecureSystemMenu=false|' /etc/gdm/gdm.conf

# Konqueror is the default browser, let's change this
update-alternatives --set x-www-browser /usr/bin/firefox

# Fix the "Print Screen" key
cp printkey.patch /tmp
(cd /etc/X11/xkb && patch -p3 < /tmp/printkey.patch)
