# Automation to the max in attempting to install AlternC in a
# debootstrap'd system

# Copyright (C) 2005  Cliss XXI
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#
# Author: Sylvain Beucler <beuc@beuc.net>

APTITUDE="aptitude --without-recommends --assume-yes"

# No overwrite
#if [ -e /subsystems/alternc ]; then
#    echo "/subsytems/alternc already exists."
#    exit 1
#fi


# Do not send tricky environment variables in the subsystem
unset LANG LC_ALL LANGUAGE DISPLAY
unset IFS CDPATH ENV BASH_ENV # from perlsec(1), just in case

## Initial setup
#$APTITUDE install equivs debootstrap
mkdir /subsystems 2>/dev/null
cd /subsystems
#debootstrap sarge /subsystems/sarge-vanilla http://192.168.1.1:9999/debian
#tar czf sarge-vanilla.tar.gz sarge-vanilla

# FIXME During debugging, remove existing installation
chroot alternc mount procfs -t proc /proc
chroot alternc bash -c 'for i in /etc/rc2.d/*; do $i stop; done'
chroot alternc umount /proc 2> /dev/null
rm -rf alternc

# subsystem bootstrap
echo "Extracting the subsystem archive..."
tar xzf sarge-vanilla.tar.gz
mv sarge-vanilla alternc

# Some adjustments
echo "Adusting subsystem config files"
# IMHO not needed
#cat >> alternc/etc/hosts <<EOF
#127.0.0.1       localhost.localdomain   localhost
#192.168.1.50    loos.interne.cliss21.org loos
#192.168.1.52    test-alternc.interne.cliss21.org test-alternc
#EOF

cp /etc/apt/sources.list alternc/etc/apt
cat >>alternc/etc/apt/sources.list <<EOF
deb http://debian.alternc.org sarge main
deb-src http://debian.alternc.org sarge main
EOF


# Create a fake package to work-around AlternC's broken dependencies
echo "Creating a fake sasl-bin-package"
tempdir=/tmp/alternc-$$-$RANDOM
mkdir $tempdir
cd $tempdir
cat > sasl-bin-empty <<EOF
Package: sasl-bin-empty
Maintainer: Sylvain Beucler <Sylvain.Beucler@cliss21.org>
Provides: sasl-bin
Description: Empty/fake package to trick alternc
EOF
equivs-build sasl-bin-empty > /dev/null
cp sasl-bin-empty_1.0_all.deb /subsystems/alternc/root
rm -rf $tempdir


# Install AlternC
echo "Installing AlternC"
cd /subsystems
chroot alternc mount procfs /proc -t proc

chroot alternc $APTITUDE update
chroot alternc dpkg -i /root/sasl-bin-empty_1.0_all.deb

# Install dependencies
export DEBIAN_FRONTEND=noninteractive
chroot alternc $APTITUDE install alternc postfix

# Install AlternC itself
unset DEBIAN_FRONTEND
chroot alternc $APTITUDE install alternc

# Fix a bug
chroot alternc ln -s /etc/apache/conf.d/phpmyadmin.conf /etc/phpmyadmin/apache.conf
chroot alternc invoke-rc.d apache start
chroot alternc invoke-rc.d apache-ssl start

chroot alternc umount /proc
