#!/bin/bash

# RESTORE
rootpass=`cat /home/password_root.txt`
#sed -i -e "s/^root:[^:]*:\(.*\)$/root:$rootpass:\1/" /etc/shadow
usermod -p "$rootpass" root

# Forcibly remove user#1000
grep -v '^[^:]\+:x:1000:' < /etc/passwd > /etc/passwd.temp
mv /etc/passwd.temp /etc/passwd

# Forcibly remove group#1000
grep -v '^[^:]\+:x:1000:' < /etc/group > /etc/group.temp
mv /etc/group.temp /etc/group

chmod 644 /etc/passwd /etc/group


localuser=`cat /home/password_1000_username.txt`
groupadd -g 1000 $localuser
useradd -u 1000 -g $localuser \
    -G adm,dialout,fax,cdrom,floppy,tape,audio,dip,video,plugdev,camera,scanner,lpadmin \
    $localuser
# Explicit shell, to have GDM display that user:
chsh -s /bin/bash $localuser

localpass=`cat /home/password_1000.txt`
#sed -i -e "s/^$localuser:[^:]*:\(.*\)$/$localuser:$localpass:\1/" /etc/shadow
usermod -p "$localpass" $localuser

fullname=`cat /home/password_1000_fullname.txt`
chfn -f "$fullname" $localuser
