#!/bin/sh
# Maintain a copy of a remote machine
# Copyright (C) 2005  Cliss XXI
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#
# Author: Sylvain Beucler <beuc@beuc.net>

HOSTNAME=$1
IP=$2
DIR=/mnt/backup/$HOSTNAME/copy

if [ -z "$HOSTNAME" ]; then
    echo "Usage: $0 hostname [IP]"
fi
# Uses DNS if possible
if [ -z "$IP" ]; then
    IP=$HOSTNAME
fi

mkdir -m 700 -p $DIR 2> /dev/null

rsync --quiet \
    --archive --hard-links --sparse --delete-excluded \
    -e 'ssh -i /root/.ssh/backup' root@$IP::root \
    --exclude dev/pts --exclude proc --exclude sys \
    $DIR
