#!/bin/bash
# Install Debian without installer
# Copyright (C) 2006  Cliss XXI
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#
# Author: Sylvain Beucler <beuc@beuc.net>


# Use the latest version of debootstrap!
boot_device=/dev/sda
target_device=/dev/sda1
suite=sarge

mirror_stable="http://ftp.fr.debian.org/debian/"
mirror_security="http://security.debian.org/"
mirror_backports="http://www.backports.org/debian/"

# mirror_stable="http://192.168.1.52/mirrors/debian"
# mirror_security="http://192.168.1.52/mirrors/debian-security"
# mirror_backports="http://192.168.1.52/mirrors/backports.org"


##########

target=/tmp/debian_system

if cat /etc/mtab | grep "$target_device " > /dev/null; then
# or grep $target
    echo "* $target_device is mounted, please umount it."
    echo "The following commands might come in handy:"
    echo "chroot $target bash -c 'for i in /etc/rc2.d/*; do \$i stop; done'"
    echo "umount $target/dev/pts"
    echo "umount $target/proc"
    echo "sleep 1"
    echo "umount $target_device"
    exit 1
fi

# Clean-up environment
unset DISPLAY LANGUAGE LC_ALL LANG

echo "* Cleaning target directory"
rm -rf $target || exit 1
mkdir -m 700 $target || exit 1
mount $target_device $target || exit 1
rm -rf $target/*

echo "* Installing base system"
debootstrap $suite $target $mirror_stable
if [ $? -ne 0 ]; then
    echo "debootstrap failed."
    exit 1
fi

cd $target

echo "* Configuring filesystems"
# fake fstab so that filesystems are setup next boot
cat <<EOF > etc/fstab
proc            /proc           proc    defaults        0 0
$target_device  /               auto    defaults,errors=remount-ro 0 1
EOF
# TODO: what about CD-ROMs and the like, detected by the current system?

chroot $target mount -a
# Can be done that way:
# invoke-rc.d mountvirtfs start
# But it's easier to remove them this way, if we tried to remove this
# root without umounting these first
mount devptsfs -t devpts $target/dev/pts
mount procfs -t proc $target/proc

# fake mtab, used by GRUB-related tools
# Is /proc needed?
cat <<EOF >> etc/mtab
$target_device / ext3 rw,errors=remount-ro 0 0
proc /proc proc rw 0 0
none /proc/bus/usb usbfs defaults 0 0
EOF

echo "* Configuring network"
# Support 'localhost'
cat <<'EOF' > etc/hosts
127.0.0.1       localhost.localdomain localhost
EOF

# Start network on boot
interface=`route -n | grep ^0.0.0.0 | awk '{ print $8 }'`
interface=${interface:-eth0}
cat <<'EOF' > etc/network/interfaces 
######################################################################
# /etc/network/interfaces -- configuration file for ifup(8), ifdown(8)
# See the interfaces(5) manpage for information on what options are 
# available.
######################################################################

# We always want the loopback interface.
#
auto lo
iface lo inet loopback
EOF

echo "auto $interface" >> etc/network/interfaces
echo "iface $interface inet dhcp" >> etc/network/interfaces

cat <<'EOF' >> etc/network/interfaces
# An example static IP setup:
# iface eth0 inet static
#   address 192.168.0.42
#   netmask 255.255.255.0
#   gateway 192.168.0.1
#   #network 192.168.0.0
#   #broadcast 192.168.0.255
#   ## dns-* options by the resolvconf package, if installed
#   #dns-nameservers 192.168.1.1


# An example wireless setup
# auto ethwl
# iface ethwl inet dhcp
#   wireless_essid   Wanadoo_ad02
#   wireless_key     FgKe...
#   #wireless_channel 10
#   #wireless_mode    Master
EOF

# Already done by debootstrap:
# /etc/resolv.conf

# not needed IMHO
# echo DebianHostName > /etc/hostname

echo "* Configuring APT sources"
# APT sources for when we'll use aptitude
cat <<EOF > etc/apt/sources.list
deb $mirror_stable sarge main
#deb-src $mirror_stable $suite main
deb $mirror_security  $suite/updates main

# Only enable backports _after_ the install is completed.
# Enabling it causes 'base-config' to fail due to dependency errors.
#deb $mirror_backports sarge-backports main
EOF
cat <<EOF > etc/apt/preferences
Package: *
Pin: release a=sarge-backports
Pin-Priority: 200
EOF
chroot $target apt-get update

echo "* Configuring language"
# Add support for the future user's language
# Work around stupid and unexplainable bug
# (default language not taken into account the first time)
DEBIAN_FRONTEND=noninteractive chroot $target aptitude install locales
# Configure for real
chroot $target dpkg-reconfigure locales

. $target/etc/environment
export LANG

echo "* Debian base configuration"
chroot $target /usr/sbin/base-config new

# Is it possible to run udev at this point?
# else:
echo "* Populating /dev..."
chroot $target bash -c 'cd dev && ./MAKEDEV generic-i386'

echo "* Configuring kernel and boot loader"
chroot $target aptitude install grub
chroot $target grub-install $boot_device

cat <<'EOF' > etc/kernel-img.conf
# Kernel Image management overrides
# See kernel-img.conf(5) for details
do_symlinks = Yes
postinst_hook = /sbin/update-grub
postrm_hook = /sbin/update-grub
do_initrd = Yes
relative_links = yes
EOF

# heuristic to get the latest kernel package:
kernel_package=`chroot $target aptitude search kernel-image | awk '{ print $2 }' | grep \`uname -r | sed 's/.*-\(.*\)/\1/'\`$ | sort -nr | head -1`
chroot $target aptitude install $kernel_package # no '--assume-yes'


# - maybe manually update /boot/grub/device.map
# - maybe manually update /boot/grub/menu.lst:
#   groot=(hd0,1)
#   kopt=root=/dev/sda2 ro
#   grub-install && update-grub

echo "* Appling security fixes"
chroot $target aptitude --assume-yes upgrade


# Post-job check-list:
# * Are other systems still offered by GRUB?
# * Is CD-ROM/floppy/etc. configured? (CD-ROM is taken into account by gnome-vfs, btw)
# * ...
# * Reboot and fire your custom script to install everything that's needed! :)
# Suggestions: emacs21 less rsync ntpdate ethtool ifrename...
