/**
    Copyright (C) 2009,2010,2011  Dawn - 2D roleplaying game

    This file is a part of the dawn-rpg project <https://github.com/frusen/Dawn>.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>. **/

#ifndef BUFFWINDOW_HPP
#define BUFFWINDOW_HPP

#include "texture.hpp"
#include "GLFT_Font.h"
#include "spell.hpp"
#include "framesbase.hpp"
#include "tooltip.hpp"

class Player;

class BuffWindow : public FramesBase
{
public:
	BuffWindow( Player* player );
	~BuffWindow();

	void initFonts();
	void loadTextures();
	void draw( int mouseX, int mouseY );
	void clicked( int mouseX, int mouseY, uint8_t mouseState );
	CSpellActionBase* getSpellAtMouse( int mouseX, int mouseY );

private:
	Tooltip* tooltip;
	Player* player;
	GLFT_Font* spellFont;
	CTexture textures;
	std::vector<std::pair<CSpellActionBase*, uint32_t> > activeSpells;
};

#endif
