/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.settlements;

import gde.Analyzer;
import gde.data.Record;
import gde.device.MeasurementMappingType;
import gde.device.ReferenceGroupType;
import gde.device.ReferenceRuleTypes;
import gde.histo.settlements.SettlementRecord;
import gde.histo.utils.Spot;
import gde.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class RecordGroup {
    private static final String $CLASS_NAME = RecordGroup.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final ReferenceGroupType referenceGroupType;
    private final SettlementRecord settlementRecord;
    private final Analyzer analyzer;
    private final Record[] records;

    public RecordGroup(SettlementRecord settlementRecord, ReferenceGroupType referenceGroupType, Analyzer analyzer) {
        this.settlementRecord = settlementRecord;
        this.analyzer = analyzer;
        this.referenceGroupType = referenceGroupType;
        this.records = new Record[referenceGroupType.getMeasurementMapping().size() + referenceGroupType.getSettlementMapping().size()];
        int i = 0;
        for (MeasurementMappingType measurementMappingType : referenceGroupType.getMeasurementMapping()) {
            this.records[i] = settlementRecord.getParent().get(settlementRecord.getParent().getRecordNames()[measurementMappingType.getMeasurementOrdinal()]);
            ++i;
        }
        if (!referenceGroupType.getSettlementMapping().isEmpty()) {
            throw new UnsupportedOperationException("settlements based on settlements not supported");
        }
    }

    public boolean hasReasonableData() {
        for (Record record : this.records) {
            if (!record.hasReasonableData()) continue;
            return true;
        }
        return false;
    }

    public double getRealMax() {
        double result = 0.0;
        for (int i = 0; i < this.records.length; ++i) {
            Record record = this.records[i];
            double translatedValue = this.analyzer.getActiveDevice().translateValue(record, (double)record.getRealMaxValue() / 1000.0);
            result = this.calculateAggregate(result, i, translatedValue);
        }
        return result;
    }

    public double getRealMin() {
        double result = 0.0;
        for (int i = 0; i < this.records.length; ++i) {
            Record record = this.records[i];
            double translatedValue = this.analyzer.getActiveDevice().translateValue(record, (double)record.getRealMinValue() / 1000.0);
            result = this.calculateAggregate(result, i, translatedValue);
        }
        return result;
    }

    public Double getReal(int index) {
        Double result = 0.0;
        for (int i = 0; i < this.records.length; ++i) {
            Record record = this.records[i];
            if (record.elementAt(index) == null) {
                result = null;
                break;
            }
            double translatedValue = this.analyzer.getActiveDevice().translateValue(record, (double)((Integer)record.elementAt(index)).intValue() / 1000.0);
            result = this.calculateAggregate(result, i, translatedValue);
        }
        return result;
    }

    private double calculateAggregate(double tmpResult, int aggregationStepIndex, double translatedValue) {
        double recurrentResult = tmpResult;
        if (this.referenceGroupType.getReferenceRule() == ReferenceRuleTypes.AVG) {
            recurrentResult += (translatedValue - recurrentResult) / (double)(aggregationStepIndex + 1);
        } else if (this.referenceGroupType.getReferenceRule() == ReferenceRuleTypes.MAX) {
            recurrentResult = aggregationStepIndex != 0 ? Math.max(recurrentResult, translatedValue) : translatedValue;
        } else if (this.referenceGroupType.getReferenceRule() == ReferenceRuleTypes.MIN) {
            recurrentResult = aggregationStepIndex == 0 ? translatedValue : Math.max(recurrentResult, translatedValue);
        } else if (this.referenceGroupType.getReferenceRule() == ReferenceRuleTypes.PRODUCT) {
            recurrentResult = aggregationStepIndex == 0 ? translatedValue : (recurrentResult *= translatedValue);
        } else if (this.referenceGroupType.getReferenceRule() == ReferenceRuleTypes.QUOTIENT) {
            recurrentResult = aggregationStepIndex == 0 ? translatedValue : (recurrentResult /= translatedValue);
        } else if (this.referenceGroupType.getReferenceRule() == ReferenceRuleTypes.SPREAD) {
            recurrentResult = aggregationStepIndex == 0 ? translatedValue : (recurrentResult -= translatedValue);
        } else if (this.referenceGroupType.getReferenceRule() == ReferenceRuleTypes.SUM) {
            recurrentResult += translatedValue;
        } else {
            throw new UnsupportedOperationException();
        }
        return recurrentResult;
    }

    public List<Spot<Double>> getSubPoints(int fromIndex, int toIndex) {
        int recordSize = toIndex - fromIndex;
        ArrayList<Spot<Double>> result = new ArrayList<Spot<Double>>(recordSize);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (this.getReal(i) == null) continue;
            result.add(new Spot<Double>(this.settlementRecord.getParent().getTime_ms(i), this.getReal(i)));
        }
        log.finer(() -> Arrays.toString(result.toArray()));
        return result;
    }

    public String getComment() {
        return this.referenceGroupType.getComment();
    }

    public int getSize() {
        return this.records.length;
    }
}

