/*
 * Decompiled with CFR 0.152.
 */
package gde.config;

import gde.config.Settings;
import gde.log.Level;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import java.util.logging.Logger;

public class GraphicsTemplate
extends Properties {
    static final long serialVersionUID = 260357L;
    static final Logger log = Logger.getLogger(GraphicsTemplate.class.getName());
    boolean isAvailable = false;
    boolean isSaved = false;
    String defaultFileName;
    String selectedFileName;
    String currentFileFilePath;
    String templateFilePath;

    public GraphicsTemplate(String deviceSignature) {
        this.templateFilePath = this.defaultFileName = deviceSignature + "*.xml".substring("*.xml".length() - 4);
        log.log(Level.FINE, "graphics template file is " + this.templateFilePath);
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public void load() {
        try {
            this.currentFileFilePath = Settings.getGraphicsTemplatePath() + "/" + (this.selectedFileName == null ? this.defaultFileName : this.selectedFileName);
            log.log(Level.FINE, "opening template file " + this.currentFileFilePath);
            this.loadFromXML(new FileInputStream(new File(this.currentFileFilePath)));
            this.isAvailable = true;
            log.log(Level.FINE, "template file successful loaded " + this.currentFileFilePath);
        }
        catch (InvalidPropertiesFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
    }

    public void store() {
        try {
            File tmpPath = new File(Settings.getGraphicsTemplatePath());
            if (!tmpPath.exists() && !tmpPath.mkdir()) {
                log.log(Level.WARNING, "failed to create " + tmpPath);
            }
            this.currentFileFilePath = Settings.getGraphicsTemplatePath() + "/" + (this.selectedFileName != null && this.selectedFileName.equals("") || this.selectedFileName == null ? this.defaultFileName : this.selectedFileName);
            this.storeToXML(new FileOutputStream(new File(this.currentFileFilePath)), "-- DataExplorer GraphicsTemplate --");
            this.isSaved = true;
            this.selectedFileName = null;
        }
        catch (InvalidPropertiesFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void setSaved(boolean newValue) {
        this.isSaved = newValue;
    }

    public String getNewFileName() {
        return this.selectedFileName;
    }

    public void setNewFileName(String newFileName) {
        this.selectedFileName = newFileName;
    }

    public String getCurrentFilePath() {
        return this.currentFileFilePath;
    }

    public String getDefaultFileName() {
        return this.defaultFileName;
    }
}

