/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractMultivariateRealDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class MultivariateNormalDistribution
extends AbstractMultivariateRealDistribution {
    private final double[] means;
    private final RealMatrix covarianceMatrix;
    private final RealMatrix covarianceMatrixInverse;
    private final double covarianceMatrixDeterminant;
    private final RealMatrix samplingMatrix;

    public MultivariateNormalDistribution(double[] means, double[][] covariances) throws SingularMatrixException, DimensionMismatchException, NonPositiveDefiniteMatrixException {
        this(new Well19937c(), means, covariances);
    }

    public MultivariateNormalDistribution(RandomGenerator rng, double[] means, double[][] covariances) throws SingularMatrixException, DimensionMismatchException, NonPositiveDefiniteMatrixException {
        super(rng, means.length);
        int dim = means.length;
        if (covariances.length != dim) {
            throw new DimensionMismatchException(covariances.length, dim);
        }
        for (int i2 = 0; i2 < dim; ++i2) {
            if (dim == covariances[i2].length) continue;
            throw new DimensionMismatchException(covariances[i2].length, dim);
        }
        this.means = MathArrays.copyOf(means);
        this.covarianceMatrix = new Array2DRowRealMatrix(covariances);
        EigenDecomposition covMatDec = new EigenDecomposition(this.covarianceMatrix);
        this.covarianceMatrixInverse = covMatDec.getSolver().getInverse();
        this.covarianceMatrixDeterminant = covMatDec.getDeterminant();
        double[] covMatEigenvalues = covMatDec.getRealEigenvalues();
        for (int i3 = 0; i3 < covMatEigenvalues.length; ++i3) {
            if (!(covMatEigenvalues[i3] < 0.0)) continue;
            throw new NonPositiveDefiniteMatrixException(covMatEigenvalues[i3], i3, 0.0);
        }
        Array2DRowRealMatrix covMatEigenvectors = new Array2DRowRealMatrix(dim, dim);
        for (int v = 0; v < dim; ++v) {
            double[] evec = covMatDec.getEigenvector(v).toArray();
            covMatEigenvectors.setColumn(v, evec);
        }
        RealMatrix tmpMatrix = covMatEigenvectors.transpose();
        for (int row2 = 0; row2 < dim; ++row2) {
            double factor = FastMath.sqrt(covMatEigenvalues[row2]);
            for (int col = 0; col < dim; ++col) {
                tmpMatrix.multiplyEntry(row2, col, factor);
            }
        }
        this.samplingMatrix = covMatEigenvectors.multiply(tmpMatrix);
    }

    public double[] getMeans() {
        return MathArrays.copyOf(this.means);
    }

    public RealMatrix getCovariances() {
        return this.covarianceMatrix.copy();
    }

    public double density(double[] vals) throws DimensionMismatchException {
        int dim = this.getDimension();
        if (vals.length != dim) {
            throw new DimensionMismatchException(vals.length, dim);
        }
        return FastMath.pow(Math.PI * 2, -0.5 * (double)dim) * FastMath.pow(this.covarianceMatrixDeterminant, -0.5) * this.getExponentTerm(vals);
    }

    public double[] getStandardDeviations() {
        int dim = this.getDimension();
        double[] std = new double[dim];
        double[][] s = this.covarianceMatrix.getData();
        for (int i2 = 0; i2 < dim; ++i2) {
            std[i2] = FastMath.sqrt(s[i2][i2]);
        }
        return std;
    }

    public double[] sample() {
        int dim = this.getDimension();
        double[] normalVals = new double[dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            normalVals[i2] = this.random.nextGaussian();
        }
        double[] vals = this.samplingMatrix.operate(normalVals);
        for (int i3 = 0; i3 < dim; ++i3) {
            int n = i3;
            vals[n] = vals[n] + this.means[i3];
        }
        return vals;
    }

    private double getExponentTerm(double[] values2) {
        double[] centered = new double[values2.length];
        for (int i2 = 0; i2 < centered.length; ++i2) {
            centered[i2] = values2[i2] - this.getMeans()[i2];
        }
        double[] preMultiplied = this.covarianceMatrixInverse.preMultiply(centered);
        double sum = 0.0;
        for (int i3 = 0; i3 < preMultiplied.length; ++i3) {
            sum += preMultiplied[i3] * centered[i3];
        }
        return FastMath.exp(-0.5 * sum);
    }
}

