/*
 * Decompiled with CFR 0.152.
 */
package gde.device.renschler;

import gde.GDE;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.PropertyType;
import gde.device.renschler.Picolario;
import gde.device.renschler.Picolario2Dialog;
import gde.device.renschler.Picolario2LogReader;
import gde.exception.DataInconsitsentException;
import gde.io.FileHandler;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.CalculationThread;
import gde.utils.FileUtils;
import gde.utils.LinearRegression;
import gde.utils.QuasiLinearRegression;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class Picolario2
extends Picolario {
    public Picolario2(String iniFile) throws FileNotFoundException, JAXBException {
        super(iniFile);
        this.dialog = new Picolario2Dialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT1253"), Messages.getString((String)"GDE_MSGT1253"));
            this.updateFileMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
    }

    public Picolario2(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        this.dialog = new Picolario2Dialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT1253"), Messages.getString((String)"GDE_MSGT1253"));
            this.updateFileMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
    }

    @Override
    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    @Override
    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    @Override
    public int getLovDataByteSize() {
        return 0;
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        int timeStampBufferSize = 0;
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        if (!recordSet.isTimeStepConstant()) {
            timeStampBufferSize = 4 * recordDataSize;
            byte[] timeStampBuffer = new byte[timeStampBufferSize];
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (int i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
            }
        }
        log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (int i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            int k = 0;
            block5: for (int j = 0; j < points.length; ++j) {
                switch (j) {
                    case 3: 
                    case 6: 
                    case 7: {
                        continue block5;
                    }
                    default: {
                        points[j] = ((convertBuffer[0 + k * 4] & 0xFF) << 24) + ((convertBuffer[1 + k * 4] & 0xFF) << 16) + ((convertBuffer[2 + k * 4] & 0xFF) << 8) + ((convertBuffer[3 + k * 4] & 0xFF) << 0);
                        ++k;
                    }
                }
            }
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        this.makeInActiveDisplayable(recordSet);
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double reduction = record.getReduction();
                double factor = record.getFactor();
                switch (record.getOrdinal()) {
                    case 0: {
                        boolean subtractLast;
                        PropertyType property = record.getProperty(Picolario.DO_SUBTRACT_FIRST);
                        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
                        property = record.getProperty(Picolario.DO_SUBTRACT_LAST);
                        boolean bl = subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
                        if (subtractFirst) {
                            reduction = (double)record.getFirst().intValue() / 1000.0;
                            break;
                        }
                        if (subtractLast) {
                            reduction = (double)record.getLast().intValue() / 1000.0;
                            break;
                        }
                        reduction = 0.0;
                        break;
                    }
                    case 3: {
                        factor = recordSet.get(3).getFactor();
                    }
                }
                dataTableRow[index + 1] = record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    @Override
    public double translateValue(Record record, double value) {
        String $METHOD_NAME = "translateValue()";
        log.log(Level.FINEST, String.format("input value for %s - %f", record.getName(), value));
        String recordKey = "?";
        double newValue = 0.0;
        try {
            recordKey = record.getName();
            double offset = record.getOffset();
            double reduction = record.getReduction();
            double factor = record.getFactor();
            switch (record.getOrdinal()) {
                case 0: {
                    PropertyType property = record.getProperty(Picolario.DO_SUBTRACT_FIRST);
                    boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
                    property = record.getProperty(Picolario.DO_SUBTRACT_LAST);
                    boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
                    try {
                        if (subtractFirst) {
                            reduction = (double)record.getFirst().intValue() / 1000.0;
                            break;
                        }
                        if (!subtractLast) break;
                        reduction = (double)record.getLast().intValue() / 1000.0;
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, record.getAbstractParent().getName() + " " + record.getName() + " " + e.getMessage() + " " + $CLASS_NAME + "." + "translateValue()");
                    }
                    break;
                }
                case 3: {
                    factor = this.getMeasurementFactor(record.getParent().getChannelConfigNumber(), 0);
                }
            }
            newValue = offset + (value - reduction) * factor;
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        log.log(Level.FINER, String.format("value calculated for %s - inValue %f - outValue %f", recordKey, value, newValue));
        return newValue;
    }

    @Override
    public double reverseTranslateValue(Record record, double value) {
        log.log(Level.FINEST, String.format("input value for %s - %f", record.getName(), value));
        String $METHOD_NAME = "reverseTranslateValue()";
        String recordKey = record.getName();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double factor = record.getFactor();
        switch (record.getOrdinal()) {
            case 0: {
                PropertyType property = record.getProperty(Picolario.DO_SUBTRACT_FIRST);
                boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
                property = record.getProperty(Picolario.DO_SUBTRACT_LAST);
                boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
                try {
                    if (subtractFirst) {
                        reduction = (double)record.getFirst().intValue() / 1000.0;
                        break;
                    }
                    if (!subtractLast) break;
                    reduction = (double)record.getLast().intValue() / 1000.0;
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, record.getAbstractParent().getName() + " " + record.getName() + " " + e.getMessage() + " " + $CLASS_NAME + "." + "reverseTranslateValue()");
                }
                break;
            }
            case 3: {
                factor = this.getMeasurementFactor(record.getParent().getChannelConfigNumber(), 0);
            }
        }
        double newValue = (value - offset) / factor + reduction;
        log.log(Level.FINER, String.format("new value calculated for %s - inValue %f - outValue %f", recordKey, value, newValue));
        return newValue;
    }

    @Override
    public void makeInActiveDisplayable(RecordSet recordSet) {
        if (recordSet.isRaw() && recordSet.isRecalculation()) {
            Record slopeRecord = recordSet.get(3);
            slopeRecord.setDisplayable(false);
            PropertyType property = slopeRecord.getProperty(CalculationThread.REGRESSION_INTERVAL_SEC);
            int regressionInterval = property != null ? Integer.valueOf(property.getValue()) : 10;
            property = slopeRecord.getProperty(CalculationThread.REGRESSION_TYPE);
            this.calculationThread = property == null || property.getValue().equals(CalculationThread.REGRESSION_TYPE_CURVE) ? new QuasiLinearRegression(recordSet, recordSet.get(0).getName(), slopeRecord.getName(), regressionInterval) : new LinearRegression(recordSet, recordSet.get(0).getName(), slopeRecord.getName(), regressionInterval);
            try {
                this.calculationThread.start();
            }
            catch (RuntimeException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        this.updateVisibilityStatus(recordSet, true);
    }

    public void updateFileMenu(Menu exportMenue) {
        if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
            new MenuItem(exportMenue, 2);
            MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
            convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGT1254"));
            convertKMZ3DRelativeItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Picolario.log.log(java.util.logging.Level.FINEST, "convertKLM3DRelativeItem action performed! " + e);
                    Picolario2.this.export2KMZ3D(0);
                }
            });
            MenuItem convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT1255"));
            convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Picolario.log.log(java.util.logging.Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + e);
                    Picolario2.this.export2KMZ3D(1);
                }
            });
            convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT1256"));
            convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Picolario.log.log(java.util.logging.Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + e);
                    Picolario2.this.export2KMZ3D(2);
                }
            });
        }
    }

    public void export2KMZ3D(int type) {
        new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGT1252"), 11, 10, 12, 13, 3, -1, -1, type == 0, type == 2);
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT1257", (Object[])GDE.MOD1));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT1257"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Picolario.log.log(java.util.logging.Level.FINEST, "importDeviceLogItem action performed! " + e);
                    Picolario2.this.open_closeCommPort();
                }
            });
        }
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        return -1;
    }

    @Override
    public void open_closeCommPort() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT1251"));
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Picolario2.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        log.log(java.util.logging.Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        try {
                            Integer channelConfigNumber = Picolario2.this.dialog != null && !Picolario2.this.dialog.isDisposed() ? Integer.valueOf(((Picolario2Dialog)Picolario2.this.dialog).getTabFolderSelectionIndex() + 1) : null;
                            String recordNameExtend = selectedImportFile.substring(selectedImportFile.lastIndexOf(46) - 4, selectedImportFile.lastIndexOf(46));
                            Picolario2LogReader.read(selectedImportFile, Picolario2.this, recordNameExtend, channelConfigNumber);
                        }
                        catch (Throwable e) {
                            log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    Picolario2.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    @Override
    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int displayableCounter = 0;
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            log.log(java.util.logging.Level.FINE, record.getName() + " = " + this.getMeasurementNameReplacement(recordSet.getChannelConfigNumber(), i));
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData());
                log.log(java.util.logging.Level.FINE, record.getName() + " hasReasonableData = " + record.hasReasonableData());
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            log.log(java.util.logging.Level.FINE, "add to displayable counter: " + record.getName());
            ++displayableCounter;
        }
        log.log(Level.FINER, "displayableCounter = " + displayableCounter);
        recordSet.setConfiguredDisplayable(displayableCounter);
    }
}

