/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog.edit;

import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import gde.ui.dialog.edit.DevicePropertiesEditor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class ContextMenu {
    static final Logger log = Logger.getLogger(ContextMenu.class.getName());
    final Menu menu;
    final CTabFolder parentTabFolder;
    MenuItem addSerialPortTypeMenuItem;
    MenuItem addDataBlockTypeMenuItem;
    MenuItem addStateTypeMenuItem;

    public ContextMenu(Menu useMenu, CTabFolder parent) {
        this.menu = useMenu;
        this.parentTabFolder = parent;
    }

    public void create() {
        SWTResourceManager.registerResourceUser((Widget)this.menu);
        this.menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                log.log(Level.FINEST, "menuShown action performed! " + e);
                ContextMenu.this.addSerialPortTypeMenuItem.setEnabled(true);
                ContextMenu.this.addDataBlockTypeMenuItem.setEnabled(true);
                ContextMenu.this.addStateTypeMenuItem.setEnabled(true);
                for (CTabItem tabItem : ContextMenu.this.parentTabFolder.getItems()) {
                    if (tabItem.getText().equals(Messages.getString("GDE_MSGT0510"))) {
                        ContextMenu.this.addSerialPortTypeMenuItem.setEnabled(false);
                        continue;
                    }
                    if (tabItem.getText().equals(Messages.getString("GDE_MSGT0515"))) {
                        ContextMenu.this.addDataBlockTypeMenuItem.setEnabled(false);
                        continue;
                    }
                    if (!tabItem.getText().equals(Messages.getString("GDE_MSGT0470"))) continue;
                    ContextMenu.this.addStateTypeMenuItem.setEnabled(false);
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        this.addSerialPortTypeMenuItem = new MenuItem(this.menu, 8);
        this.addSerialPortTypeMenuItem.setText(Messages.getString("GDE_MSGT0512"));
        this.addSerialPortTypeMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "addSerialPortTypeMenuItem action performed! " + e);
                DevicePropertiesEditor.getInstance().createSerialPortTabItem();
            }
        });
        new MenuItem(this.menu, 2);
        this.addDataBlockTypeMenuItem = new MenuItem(this.menu, 8);
        this.addDataBlockTypeMenuItem.setText(Messages.getString("GDE_MSGT0513"));
        this.addDataBlockTypeMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "addSerialPortTypeMenuItem action performed! " + e);
                DevicePropertiesEditor.getInstance().createDataBlockType();
            }
        });
        new MenuItem(this.menu, 2);
        this.addStateTypeMenuItem = new MenuItem(this.menu, 8);
        this.addStateTypeMenuItem.setText(Messages.getString("GDE_MSGT0514"));
        this.addStateTypeMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "addStateTypeMenuItem action performed! " + e);
                DevicePropertiesEditor.getInstance().createStateTabItem();
            }
        });
    }
}

