/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog;

import gde.GDE;
import gde.config.Settings;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class HelpInfoDialog
extends Dialog {
    static final Logger log = Logger.getLogger(HelpInfoDialog.class.getName());
    Shell dialogShell;
    Browser textBrowser;
    final Rectangle primaryMonitorBounds;
    final Settings settings;

    public HelpInfoDialog(Shell parent, int style) {
        super(parent, style);
        this.primaryMonitorBounds = parent.getDisplay().getPrimaryMonitor().getBounds();
        this.settings = Settings.getInstance();
    }

    public void open(String deviceName, String fileName, int style, boolean extractBase) {
        log.log(Level.FINE, "dialogShell.isDisposed() " + (this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
        if (this.dialogShell == null || this.dialogShell.isDisposed()) {
            this.dialogShell = new Shell(new Shell(Display.getDefault()), 1264);
            FillLayout dialogShellLayout = new FillLayout(256);
            this.dialogShell.setLayout((Layout)dialogShellLayout);
            this.dialogShell.setText("DataExplorer" + Messages.getString("GDE_MSGT0192"));
            this.dialogShell.setImage(SWTResourceManager.getImage("gde/resource/DataExplorer.png"));
            this.textBrowser = new Browser((Composite)this.dialogShell, style);
            this.openURL(deviceName, fileName, extractBase);
            this.dialogShell.layout();
            this.dialogShell.pack();
            int width = this.primaryMonitorBounds.width / 4 * 3;
            this.dialogShell.setSize(width, this.primaryMonitorBounds.height * 95 / 100);
            this.dialogShell.setLocation(this.primaryMonitorBounds.width - width, 0);
            this.dialogShell.open();
        } else {
            this.textBrowser = this.textBrowser == null ? new Browser((Composite)this.dialogShell, style) : this.textBrowser;
            this.openURL(deviceName, fileName, extractBase);
            int width = this.primaryMonitorBounds.width / 4 * 3;
            this.dialogShell.setSize(width, this.primaryMonitorBounds.height * 95 / 100);
            this.dialogShell.setLocation(this.primaryMonitorBounds.width - width, 0);
            this.dialogShell.setMinimized(false);
            this.dialogShell.setVisible(true);
            this.dialogShell.forceActive();
        }
        this.dialogShell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        HelpInfoDialog.this.dialogShell.close();
                        event.detail = 0;
                        event.doit = false;
                    }
                }
            }
        });
        Display display = this.dialogShell.getDisplay();
        while (!this.dialogShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void openURL(String deviceName, String fileName, boolean extractBase) {
        String jarBasePath = FileUtils.getJarBasePath() + "/";
        String jarName = "DataExplorer.jar";
        String lang = this.settings.getLocale().getLanguage().contains("de") || this.settings.getLocale().getLanguage().contains("en") ? this.settings.getLocale().getLanguage() : "en";
        String helpDir = extractBase ? "help" + GDE.FILE_SEPARATOR : "help" + GDE.FILE_SEPARATOR + lang + GDE.FILE_SEPARATOR;
        String helpFileDir = "help" + GDE.FILE_SEPARATOR + lang + GDE.FILE_SEPARATOR;
        String targetDir = GDE.JAVA_IO_TMPDIR + (GDE.IS_WINDOWS ? "" : "/") + "GDE" + "/";
        try {
            if (!new File(targetDir).exists()) {
                log.log(Level.FINE, "jarBasePath = " + jarBasePath + " jarName = " + jarName + " helpDir = " + helpDir);
                FileUtils.extractDir(new JarFile(jarBasePath + jarName), helpDir, targetDir, "555");
            }
            if (deviceName.length() >= 1) {
                jarBasePath = jarBasePath + "devices" + "/";
                jarName = deviceName + ".jar";
                targetDir = targetDir + deviceName + "/";
                FileUtils.extractDir(new JarFile(jarBasePath + jarName), helpDir, targetDir, "555");
            }
            String stringUrl = (targetDir + helpFileDir + fileName).replace('\\', '/');
            log.log(Level.FINE, "stringUrl = file:///" + stringUrl);
            this.textBrowser.setUrl("file:///" + stringUrl);
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            DataExplorer.getInstance().openMessageDialog(this.dialogShell, Messages.getString("GDE_MSGE0018", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public boolean isDisposed() {
        return this.dialogShell != null ? this.dialogShell.isDisposed() : true;
    }

    public void dispose() {
        if (this.dialogShell != null) {
            this.dialogShell.dispose();
        }
    }
}

