/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.data.Channel;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTAdapter2;
import gde.device.graupner.HoTTbinReader;
import gde.device.graupner.PackageLoss;
import gde.exception.DataInconsitsentException;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.menu.MenuToolBar;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;

public class HoTTbinReader2
extends HoTTbinReader {
    static final Logger log = Logger.getLogger(HoTTbinReader2.class.getName());
    static int[] points;
    static RecordSet recordSet;

    public static synchronized void read(String filePath, HoTTAdapter.PickerParameters newPickerParameters) throws Exception {
        pickerParameters = newPickerParameters;
        HashMap<String, String> header = HoTTbinReader2.getFileInfo(new File(filePath), newPickerParameters);
        detectedSensors = HoTTAdapter.Sensor.getSetFromDetected(header.get("DETECTED SENSOR"));
        HoTTbinReader2.setAltitudeClimbPickeParameter(pickerParameters, detectedSensors);
        if (detectedSensors.size() <= 2) {
            isReceiverOnly = detectedSensors.size() == 1;
            HoTTbinReader2.readSingle(new File(header.get("FilePath")), header);
        } else {
            HoTTbinReader2.readMultiple(new File(header.get("FilePath")), header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readSingle(File file, HashMap<String, String> header) throws IOException, DataInconsitsentException {
        long startTime = System.nanoTime() / 1000000L;
        FileInputStream file_input = new FileInputStream(file);
        DataInputStream data_in = new DataInputStream(file_input);
        long fileSize = file.length();
        IDevice device = application.getActiveDevice();
        int recordSetNumber = ((Channel)channels.get((Object)1)).maxSize() + 1;
        String recordSetName = "";
        String recordSetNameExtend = HoTTbinReader2.getRecordSetExtend(file);
        Channel channel = null;
        int channelNumber = HoTTbinReader2.pickerParameters.analyzer.getActiveChannel().getNumber();
        device.getMeasurementFactor(channelNumber, 12);
        boolean isReceiverData = false;
        boolean isSensorData = false;
        boolean isVarioDetected = false;
        boolean isGPSdetected = false;
        boolean isESCdetected = false;
        boolean[] isResetMinMax = new boolean[]{false, false, false, false, false};
        recordSet = null;
        points = new int[device.getNumberOfMeasurements(channelNumber)];
        pointsGPS = points;
        pointsVario = points;
        pointsESC = pointsVario;
        pointsEAM = pointsVario;
        pointsGAM = pointsVario;
        dataBlockSize = 64;
        buf = new byte[dataBlockSize];
        buf0 = new byte[30];
        buf1 = new byte[30];
        buf2 = new byte[30];
        buf3 = new byte[30];
        buf4 = new byte[30];
        HoTTbinReader.BufCopier bufCopier = new HoTTbinReader.BufCopier(buf, buf0, buf1, buf2, buf3, buf4);
        long[] timeSteps_ms = new long[]{0L};
        rcvBinParser = HoTTAdapter.Sensor.RECEIVER.createBinParser2(pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        chnBinParser = HoTTAdapter.Sensor.CHANNEL.createBinParser2(pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        varBinParser = HoTTAdapter.Sensor.VARIO.createBinParser2(pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        gpsBinParser = HoTTAdapter.Sensor.GPS.createBinParser2(pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        gamBinParser = HoTTAdapter.Sensor.GAM.createBinParser2(pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        eamBinParser = HoTTAdapter.Sensor.EAM.createBinParser2(pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        escBinParser = HoTTAdapter.Sensor.ESC.createBinParser2(pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        isTextModusSignaled = false;
        boolean isSdLogFormat = Boolean.parseBoolean(header.get("SD_FORMAT"));
        long numberDatablocks = isSdLogFormat ? fileSize - 27L - 323L : fileSize / (long)dataBlockSize;
        long startTimeStamp_ms = HoTTbinReader2.getStartTimeStamp(file.getName(), file.lastModified(), numberDatablocks);
        numberDatablocks = isReceiverOnly && channelNumber != 4 ? numberDatablocks / 10L : numberDatablocks;
        String date = new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp_ms);
        String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp_ms);
        MenuToolBar menuToolBar = application.getMenuToolBar();
        int progressIndicator = (int)(numberDatablocks / 30L);
        GDE.getUiNotification().setProgress(0);
        if (isSdLogFormat) {
            data_in.skip(27L);
        }
        try {
            String packageLossPercentage;
            String newFileDescription;
            channel = (Channel)channels.get((Object)channelNumber);
            String string = newFileDescription = application.isObjectoriented() ? date + " " + application.getObjectKey() : date;
            if (channel.getFileDescription().length() <= newFileDescription.length() || application.isObjectoriented() && !channel.getFileDescription().contains(application.getObjectKey())) {
                channel.setFileDescription(newFileDescription);
            }
            recordSetName = recordSetNumber + device.getRecordSetStemNameReplacement() + recordSetNameExtend;
            recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)channelNumber, (boolean)true, (boolean)true, (boolean)true);
            channel.put((Object)recordSetName, (Object)recordSet);
            RecordSet tmpRecordSet = (RecordSet)channel.get((Object)recordSetName);
            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
            int i = 0;
            while ((long)i < numberDatablocks) {
                data_in.read(buf);
                if (log.isLoggable(Level.FINE) && i % 10 == 0) {
                    log.log(Level.FINE, StringHelper.fourDigitsRunningNumber((int)buf.length));
                    log.log(Level.FINE, StringHelper.byte2Hex4CharString((byte[])buf, (int)buf.length));
                }
                if (!HoTTbinReader2.pickerParameters.isFilterTextModus || (buf[6] & 1) == 0) {
                    if (buf[33] >= 0 && buf[33] <= 4 && buf[3] != 0 && buf[4] != 0) {
                        int j;
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, String.format("Sensor %x Blocknummer : %d", buf[7], buf[33]));
                        }
                        ((RcvBinParser)rcvBinParser).trackPackageLoss(true);
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, StringHelper.byte2Hex2CharString((byte[])new byte[]{buf[7]}, (int)1) + " - " + StringHelper.printBinary((byte)buf[7], (boolean)false));
                        }
                        if (buf[33] == 0 && (buf[38] & 0x80) != 128 && DataParser.parse2Short((byte[])buf, (int)40) >= 0) {
                            rcvBinParser.parse();
                            isReceiverData = true;
                        }
                        if (channelNumber == 4) {
                            chnBinParser.parse();
                        }
                        if (buf[33] == 0) {
                            bufCopier.copyToBuffer();
                        }
                        if (isReceiverOnly && channelNumber != 4) {
                            for (j = 0; j < 9; ++j) {
                                data_in.read(buf);
                                timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                            }
                            isSensorData = true;
                        }
                        switch ((byte)(buf[7] & 0xFF)) {
                            case -119: 
                            case 55: {
                                if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO)) break;
                                bufCopier.copyToVarioBuffer();
                                if (!bufCopier.is4BuffersFull()) break;
                                varBinParser.parse();
                                if (!isVarioDetected) {
                                    HoTTAdapter2.updateVarioTypeDependent(buf4[9] & 0xFF, device, recordSet);
                                    isVarioDetected = true;
                                }
                                bufCopier.clearBuffers();
                                isSensorData = true;
                                break;
                            }
                            case -118: 
                            case 56: {
                                if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS)) break;
                                bufCopier.copyToFreeBuffer();
                                if (!bufCopier.is4BuffersFull()) break;
                                gpsBinParser.parse();
                                if (!isGPSdetected && HoTTbinReader2.isReasonableData(buf4) && recordSet.get(33).size() > 0 && recordSet.get(33).get(recordSet.get(33).size() - 1) != 0) {
                                    HoTTAdapter2.updateGpsTypeDependent(buf4[9] & 0xFF, device, recordSet, (recordSet.get(33).size() - 1) * 5);
                                    isGPSdetected = true;
                                }
                                bufCopier.clearBuffers();
                                isSensorData = true;
                                if (isResetMinMax[3] || points[27] != 3000 || points[20] == 0 || points[21] == 0) break;
                                for (j = 20; j < 38; ++j) {
                                    tmpRecordSet.get(j).setMinMax(points[j], points[j]);
                                }
                                isResetMinMax[3] = true;
                                break;
                            }
                            case -115: 
                            case 53: {
                                if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM)) break;
                                bufCopier.copyToFreeBuffer();
                                if (!bufCopier.is4BuffersFull()) break;
                                gamBinParser.parse();
                                bufCopier.clearBuffers();
                                isSensorData = true;
                                if (isResetMinMax[2] || points[38] == 0) break;
                                for (j = 38; j < 60; ++j) {
                                    tmpRecordSet.get(j).setMinMax(points[j], points[j]);
                                }
                                isResetMinMax[2] = true;
                                break;
                            }
                            case -114: 
                            case 54: {
                                if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM)) break;
                                bufCopier.copyToFreeBuffer();
                                if (!bufCopier.is4BuffersFull()) break;
                                eamBinParser.parse();
                                bufCopier.clearBuffers();
                                isSensorData = true;
                                if (isResetMinMax[1] || points[60] == 0) break;
                                for (j = 60; j < 87; ++j) {
                                    tmpRecordSet.get(j).setMinMax(points[j], points[j]);
                                }
                                isResetMinMax[1] = true;
                                break;
                            }
                            case -116: 
                            case 57: {
                                if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC)) break;
                                bufCopier.copyToFreeBuffer();
                                if (!bufCopier.is4BuffersFull()) break;
                                escBinParser.parse();
                                if (!isESCdetected) {
                                    HoTTAdapter2.updateEscTypeDependent(buf4[9] & 0xFF, device, recordSet, 1);
                                    isESCdetected = true;
                                }
                                bufCopier.clearBuffers();
                                isSensorData = true;
                                if (((EscBinParser)escBinParser).isChannelsChannel()) {
                                    if (isResetMinMax[0] || points[107] == 0) break;
                                    for (j = 107; j < 136; ++j) {
                                        tmpRecordSet.get(j).setMinMax(points[j], points[j]);
                                    }
                                    isResetMinMax[0] = true;
                                    break;
                                }
                                if (isResetMinMax[0] || points[87] == 0) break;
                                for (j = 87; j < 116; ++j) {
                                    tmpRecordSet.get(j).setMinMax(points[j], points[j]);
                                }
                                isResetMinMax[0] = true;
                            }
                        }
                        if (isSensorData) {
                            ((RcvBinParser)rcvBinParser).updateLossStatistics();
                        }
                        if (isSensorData || isReceiverData && tmpRecordSet.get(0).realSize() > 0) {
                            tmpRecordSet.addPoints(points, (double)timeSteps_ms[0]);
                            isReceiverData = false;
                            isSensorData = false;
                        } else if (channelNumber == 4) {
                            tmpRecordSet.addPoints(points, (double)timeSteps_ms[0]);
                        }
                        timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                        if (i % progressIndicator == 0) {
                            GDE.getUiNotification().setProgress((int)((long)(i * 100) / numberDatablocks));
                        }
                    } else {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "-->> Found tx=rx=0 dBm");
                        }
                        ((RcvBinParser)rcvBinParser).trackPackageLoss(false);
                        if (channelNumber == 4) {
                            chnBinParser.parse();
                            tmpRecordSet.addPoints(points, (double)timeSteps_ms[0]);
                        }
                        timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                    }
                } else if (!isTextModusSignaled) {
                    isTextModusSignaled = true;
                    application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW2404"));
                }
                ++i;
            }
            ((RcvBinParser)rcvBinParser).finalUpdateLossStatistics();
            String string2 = packageLossPercentage = tmpRecordSet.getRecordDataSize(true) > 0 ? String.format("%.1f", ((RcvBinParser)HoTTbinReader2.rcvBinParser).getLostPackages().percentage) : "100";
            if (channelNumber == 4) {
                detectedSensors.add(HoTTAdapter.Sensor.CHANNEL);
            }
            tmpRecordSet.setRecordSetDescription(tmpRecordSet.getRecordSetDescription() + Messages.getString((String)"GDE_MSGI2404", (Object[])new Object[]{((RcvBinParser)rcvBinParser).getLossTotal(), ((RcvBinParser)HoTTbinReader2.rcvBinParser).getLostPackages().lossTotal, packageLossPercentage, ((RcvBinParser)rcvBinParser).getLostPackages().getStatistics()}) + String.format(" - Sensor: %s", detectedSensors.toString()) + (HoTTAdapter2.isAltClimbSensor(detectedSensors) ? String.format(" - %s = %s", Messages.getString((String)"GDE_MSGT2419"), HoTTAdapter.Sensor.fromOrdinal(HoTTbinReader2.pickerParameters.altitudeClimbSensorSelection).name()) : ""));
            log.log(Level.WARNING, "skipped number receiver data due to package loss = " + ((RcvBinParser)HoTTbinReader2.rcvBinParser).getLostPackages().lossTotal);
            log.log(Level.TIME, "read time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
            if (GDE.isWithUi()) {
                GDE.getUiNotification().setProgress(99);
                device.updateVisibilityStatus(tmpRecordSet, true);
                channel.applyTemplate(recordSetName, false);
                tmpRecordSet.descriptionAppendFilename(file.getName());
                menuToolBar.updateChannelSelector();
                menuToolBar.updateRecordSetSelectCombo();
                GDE.getUiNotification().setProgress(100);
            }
        }
        finally {
            data_in.close();
            data_in = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readMultiple(File file, HashMap<String, String> header) throws IOException, DataInconsitsentException {
        long startTime = System.nanoTime() / 1000000L;
        FileInputStream file_input = new FileInputStream(file);
        DataInputStream data_in = new DataInputStream(file_input);
        long fileSize = file.length();
        IDevice device = application.getActiveDevice();
        int recordSetNumber = ((Channel)channels.get((Object)1)).maxSize() + 1;
        String recordSetName = "";
        String recordSetNameExtend = HoTTbinReader2.getRecordSetExtend(file);
        Channel channel = null;
        int channelNumber = HoTTbinReader2.pickerParameters.analyzer.getActiveChannel().getNumber();
        boolean isReceiverData = false;
        recordSet = null;
        boolean isJustMigrated = false;
        boolean isVarioDetected = false;
        boolean isGPSdetected = false;
        boolean isESCdetected = false;
        boolean[] isResetMinMax = new boolean[]{false, false, false, false, false};
        points = new int[device.getNumberOfMeasurements(channelNumber)];
        pointsGAM = new int[points.length];
        pointsEAM = new int[points.length];
        pointsESC = new int[points.length];
        pointsVario = new int[points.length];
        HoTTbinReader2.pointsVario[2] = 100000;
        pointsGPS = new int[points.length];
        dataBlockSize = 64;
        buf = new byte[dataBlockSize];
        buf0 = new byte[30];
        buf1 = new byte[30];
        buf2 = new byte[30];
        buf3 = new byte[30];
        buf4 = new byte[30];
        HoTTbinReader.BufCopier bufCopier = new HoTTbinReader.BufCopier(buf, buf0, buf1, buf2, buf3, buf4);
        long[] timeSteps_ms = new long[]{0L};
        rcvBinParser = HoTTAdapter.Sensor.RECEIVER.createBinParser2(pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        chnBinParser = HoTTAdapter.Sensor.CHANNEL.createBinParser2(pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        varBinParser = HoTTAdapter.Sensor.VARIO.createBinParser2(pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        gpsBinParser = HoTTAdapter.Sensor.GPS.createBinParser2(pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        gamBinParser = HoTTAdapter.Sensor.GAM.createBinParser2(pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        eamBinParser = HoTTAdapter.Sensor.EAM.createBinParser2(pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        escBinParser = HoTTAdapter.Sensor.ESC.createBinParser2(pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        int actualSensor = -1;
        int lastSensor = -1;
        int logCountVario = 0;
        int logCountGPS = 0;
        int logCountGAM = 0;
        int logCountEAM = 0;
        int logCountESC = 0;
        EnumSet<HoTTAdapter.Sensor> migrationJobs = EnumSet.noneOf(HoTTAdapter.Sensor.class);
        boolean isSdLogFormat = Boolean.parseBoolean(header.get("SD_FORMAT"));
        long numberDatablocks = isSdLogFormat ? fileSize - 27L - 323L : fileSize / (long)dataBlockSize;
        long startTimeStamp_ms = HoTTbinReader2.getStartTimeStamp(file.getName(), file.lastModified(), numberDatablocks);
        String date = new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp_ms);
        String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp_ms);
        MenuToolBar menuToolBar = application.getMenuToolBar();
        int progressIndicator = (int)(numberDatablocks / 30L);
        GDE.getUiNotification().setProgress(0);
        if (isSdLogFormat) {
            data_in.skip(27L);
        }
        try {
            String packageLossPercentage;
            String newFileDescription;
            channel = (Channel)channels.get((Object)channelNumber);
            String string = newFileDescription = application.isObjectoriented() ? date + " " + application.getObjectKey() : date;
            if (channel.getFileDescription().length() <= newFileDescription.length() || application.isObjectoriented() && !channel.getFileDescription().contains(application.getObjectKey())) {
                channel.setFileDescription(newFileDescription);
            }
            recordSetName = recordSetNumber + device.getRecordSetStemNameReplacement() + recordSetNameExtend;
            recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)channelNumber, (boolean)true, (boolean)true, (boolean)true);
            channel.put((Object)recordSetName, (Object)recordSet);
            RecordSet tmpRecordSet = (RecordSet)channel.get((Object)recordSetName);
            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
            int i = 0;
            while ((long)i < numberDatablocks) {
                data_in.read(buf);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, StringHelper.byte2Hex4CharString((byte[])buf, (int)buf.length));
                }
                if (!HoTTbinReader2.pickerParameters.isFilterTextModus || (buf[6] & 1) == 0) {
                    if (buf[33] >= 0 && buf[33] <= 4 && buf[3] != 0 && buf[4] != 0) {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, String.format("Sensor %x Blocknummer : %d", buf[7], buf[33]));
                        }
                        ((RcvBinParser)rcvBinParser).trackPackageLoss(true);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, StringHelper.byte2Hex2CharString((byte[])new byte[]{buf[7]}, (int)1) + " - " + StringHelper.printBinary((byte)buf[7], (boolean)false));
                        }
                        if (buf[33] == 0 && (buf[38] & 0x80) != 128 && DataParser.parse2Short((byte[])buf, (int)40) >= 0) {
                            rcvBinParser.parse();
                            isReceiverData = true;
                        }
                        if (channelNumber == 4) {
                            chnBinParser.parse();
                        }
                        if (actualSensor == -1) {
                            byte by = (byte)(buf[7] & 0xFF);
                            actualSensor = by;
                            lastSensor = by;
                        } else {
                            actualSensor = (byte)(buf[7] & 0xFF);
                        }
                        if (actualSensor != lastSensor) {
                            if (logCountVario >= 5 || logCountGPS >= 5 || logCountGAM >= 5 || logCountEAM >= 5 || logCountESC >= 5) {
                                switch (lastSensor) {
                                    case -119: 
                                    case 55: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO)) break;
                                        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.VARIO) && isReceiverData) {
                                            HoTTbinReader2.migrateAddPoints(tmpRecordSet, migrationJobs, timeSteps_ms[0], isResetMinMax);
                                            isJustMigrated = true;
                                            isReceiverData = false;
                                        }
                                        varBinParser.parse();
                                        migrationJobs.add(HoTTAdapter.Sensor.VARIO);
                                        if (isVarioDetected) break;
                                        HoTTAdapter2.updateVarioTypeDependent(buf4[9] & 0xFF, device, recordSet);
                                        isVarioDetected = true;
                                        break;
                                    }
                                    case -118: 
                                    case 56: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS)) break;
                                        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.GPS) && isReceiverData) {
                                            HoTTbinReader2.migrateAddPoints(tmpRecordSet, migrationJobs, timeSteps_ms[0], isResetMinMax);
                                            isJustMigrated = true;
                                            isReceiverData = false;
                                        }
                                        gpsBinParser.parse();
                                        migrationJobs.add(HoTTAdapter.Sensor.GPS);
                                        if (isGPSdetected || !HoTTbinReader2.isReasonableData(buf4) || recordSet.get(33).size() <= 0 || recordSet.get(33).get(recordSet.get(33).size() - 1) == 0) break;
                                        HoTTAdapter2.updateGpsTypeDependent(buf4[9] & 0xFF, device, recordSet, (recordSet.get(33).size() - 1) * 5);
                                        isGPSdetected = true;
                                        break;
                                    }
                                    case -115: 
                                    case 53: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM)) break;
                                        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.GAM) && isReceiverData) {
                                            HoTTbinReader2.migrateAddPoints(tmpRecordSet, migrationJobs, timeSteps_ms[0], isResetMinMax);
                                            isJustMigrated = true;
                                            isReceiverData = false;
                                        }
                                        gamBinParser.parse();
                                        migrationJobs.add(HoTTAdapter.Sensor.GAM);
                                        break;
                                    }
                                    case -114: 
                                    case 54: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM)) break;
                                        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.EAM) && isReceiverData) {
                                            HoTTbinReader2.migrateAddPoints(tmpRecordSet, migrationJobs, timeSteps_ms[0], isResetMinMax);
                                            isJustMigrated = true;
                                            isReceiverData = false;
                                        }
                                        eamBinParser.parse();
                                        migrationJobs.add(HoTTAdapter.Sensor.EAM);
                                        break;
                                    }
                                    case -116: 
                                    case 57: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC)) break;
                                        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.ESC) && isReceiverData) {
                                            HoTTbinReader2.migrateAddPoints(tmpRecordSet, migrationJobs, timeSteps_ms[0], isResetMinMax);
                                            isJustMigrated = true;
                                            isReceiverData = false;
                                        }
                                        escBinParser.parse();
                                        migrationJobs.add(HoTTAdapter.Sensor.ESC);
                                        if (isESCdetected) break;
                                        HoTTAdapter2.updateEscTypeDependent(buf4[9] & 0xFF, device, recordSet, 1);
                                        isESCdetected = true;
                                    }
                                }
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "isReceiverData " + isReceiverData + " migrationJobs " + migrationJobs);
                                }
                            }
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "logCountVario = " + logCountVario + " logCountGPS = " + logCountGPS + " logCountGeneral = " + logCountGAM + " logCountElectric = " + logCountEAM);
                            }
                            lastSensor = actualSensor;
                            logCountESC = 0;
                            logCountEAM = 0;
                            logCountGAM = 0;
                            logCountGPS = 0;
                            logCountVario = 0;
                        }
                        switch (lastSensor) {
                            case -119: 
                            case 55: {
                                ++logCountVario;
                                break;
                            }
                            case -118: 
                            case 56: {
                                ++logCountGPS;
                                break;
                            }
                            case -115: 
                            case 53: {
                                ++logCountGAM;
                                break;
                            }
                            case -114: 
                            case 54: {
                                ++logCountEAM;
                                break;
                            }
                            case -116: 
                            case 57: {
                                ++logCountESC;
                            }
                        }
                        if (isJustMigrated) {
                            ((RcvBinParser)rcvBinParser).updateLossStatistics();
                        }
                        if (isReceiverData && (logCountVario > 0 || logCountGPS > 0 || logCountGAM > 0 || logCountEAM > 0 || logCountESC > 0)) {
                            tmpRecordSet.addPoints(points, (double)timeSteps_ms[0]);
                            isReceiverData = false;
                        } else if (channelNumber == 4 && !isJustMigrated) {
                            tmpRecordSet.addPoints(points, (double)timeSteps_ms[0]);
                        }
                        isJustMigrated = false;
                        bufCopier.copyToBuffer();
                        timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                        if (i % progressIndicator == 0) {
                            GDE.getUiNotification().setProgress((int)((long)(i * 100) / numberDatablocks));
                        }
                    } else {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "-->> Found tx=rx=0 dBm");
                        }
                        ((RcvBinParser)rcvBinParser).trackPackageLoss(false);
                        if (channelNumber == 4) {
                            chnBinParser.parse();
                            tmpRecordSet.addPoints(points, (double)timeSteps_ms[0]);
                        }
                        timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                    }
                } else if (!isTextModusSignaled) {
                    isTextModusSignaled = true;
                    application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW2404"));
                }
                ++i;
            }
            ((RcvBinParser)rcvBinParser).finalUpdateLossStatistics();
            String string2 = packageLossPercentage = tmpRecordSet.getRecordDataSize(true) > 0 ? String.format("%.1f", ((RcvBinParser)HoTTbinReader2.rcvBinParser).getLostPackages().percentage) : "100";
            if (channelNumber == 4) {
                detectedSensors.add(HoTTAdapter.Sensor.CHANNEL);
            }
            tmpRecordSet.setRecordSetDescription(tmpRecordSet.getRecordSetDescription() + Messages.getString((String)"GDE_MSGI2404", (Object[])new Object[]{((RcvBinParser)rcvBinParser).getLossTotal(), ((RcvBinParser)HoTTbinReader2.rcvBinParser).getLostPackages().lossTotal, packageLossPercentage, ((RcvBinParser)rcvBinParser).getLostPackages().getStatistics()}) + String.format(" - Sensor: %s", detectedSensors.toString()) + (HoTTAdapter2.isAltClimbSensor(detectedSensors) ? String.format(" - %s = %s", Messages.getString((String)"GDE_MSGT2419"), HoTTAdapter.Sensor.fromOrdinal(HoTTbinReader2.pickerParameters.altitudeClimbSensorSelection).name()) : ""));
            log.log(Level.WARNING, "skipped number receiver data due to package loss = " + ((RcvBinParser)rcvBinParser).getLossTotal());
            log.log(Level.TIME, "read time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
            if (menuToolBar != null) {
                GDE.getUiNotification().setProgress(99);
                device.makeInActiveDisplayable(tmpRecordSet);
                device.updateVisibilityStatus(tmpRecordSet, true);
                channel.applyTemplate(recordSetName, false);
                tmpRecordSet.descriptionAppendFilename(file.getName());
                menuToolBar.updateChannelSelector();
                menuToolBar.updateRecordSetSelectCombo();
                GDE.getUiNotification().setProgress(100);
            }
        }
        finally {
            data_in.close();
            data_in = null;
        }
    }

    public static void migrateAddPoints(RecordSet tmpRecordSet, EnumSet<HoTTAdapter.Sensor> migrationJobs, long timeStep_ms, boolean[] isResetMinMax) throws DataInconsitsentException {
        int i;
        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.EAM)) {
            eamBinParser.migratePoints(points);
            if (!isResetMinMax[1] && points[60] != 0) {
                for (i = 60; i < 87; ++i) {
                    tmpRecordSet.get(i).setMinMax(points[i], points[i]);
                }
                isResetMinMax[1] = true;
            }
        }
        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.GAM)) {
            gamBinParser.migratePoints(points);
            if (!isResetMinMax[2] && points[38] != 0) {
                for (i = 38; i < 59; ++i) {
                    tmpRecordSet.get(i).setMinMax(points[i], points[i]);
                }
                isResetMinMax[2] = true;
            }
        }
        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.GPS)) {
            gpsBinParser.migratePoints(points);
            if (!isResetMinMax[3] && points[27] >= 3000 && points[20] != 0 && points[21] != 0) {
                for (i = 20; i < 38; ++i) {
                    tmpRecordSet.get(i).setMinMax(points[i], points[i]);
                }
                isResetMinMax[3] = true;
            }
        }
        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.VARIO)) {
            varBinParser.migratePoints(points);
        }
        if (migrationJobs.contains((Object)HoTTAdapter.Sensor.ESC)) {
            escBinParser.migratePoints(points);
            if (((EscBinParser)escBinParser).isChannelsChannel()) {
                if (!isResetMinMax[0] && points[123] != 0) {
                    for (i = 123; i < 152; ++i) {
                        tmpRecordSet.get(i).setMinMax(points[i], points[i]);
                    }
                    isResetMinMax[0] = true;
                }
            } else if (!isResetMinMax[0] && points[87] != 0) {
                for (i = 87; i < 114; ++i) {
                    tmpRecordSet.get(i).setMinMax(points[i], points[i]);
                }
                isResetMinMax[0] = true;
            }
        }
        migrationJobs.clear();
        recordSet.addPoints(points, (double)timeStep_ms);
    }

    public static class RcvBinParser
    extends HoTTbinReader.BinParser {
        private int tmpVoltageRx = 0;
        private int tmpTemperatureRx = 0;
        private int consecutiveLossCounter = 0;
        private PackageLoss lostPackages = new PackageLoss();
        protected final byte[] _buf;

        protected RcvBinParser(HoTTAdapter.PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
            this(pickerParameters, new int[pickerParameters.analyzer.getActiveDevice().getNumberOfMeasurements(pickerParameters.analyzer.getActiveChannel().getNumber())], timeSteps_ms, buffers);
            throw new UnsupportedOperationException("use in situ parsing");
        }

        protected RcvBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.RECEIVER);
            this._buf = buffers[0];
            if (buffers.length != 1) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
        }

        @Override
        protected boolean parse() {
            this.tmpVoltageRx = this._buf[35] & 0xFF;
            this.tmpTemperatureRx = this._buf[36] & 0xFF;
            this.points[1] = (this._buf[38] & 0xFF) * 1000;
            this.points[3] = DataParser.parse2Short((byte[])this._buf, (int)40) * 1000;
            if (this.isPointsValid()) {
                this.points[2] = HoTTbinReader.convertRxDbm2Strength(this._buf[4] & 0xFF) * 1000;
                this.points[4] = (this._buf[3] & 0xFF) * -1000;
                this.points[5] = (this._buf[4] & 0xFF) * -1000;
                this.points[6] = this.tmpVoltageRx * 1000;
                this.points[7] = (this.tmpTemperatureRx - 20) * 1000;
                this.points[8] = (this._buf[39] & 0xFF) * 1000;
                this.points[9] = (this._buf[32] & 0x40) > 0 || (this._buf[32] & 0x25) > 0 && this.tmpTemperatureRx >= 70 ? (this._buf[32] & 0x65) * 1000 : 0;
                return true;
            }
            this.points[9] = (this._buf[32] & 0x40) > 0 || (this._buf[32] & 0x25) > 0 && this.tmpTemperatureRx >= 70 ? (this._buf[32] & 0x65) * 1000 : 0;
            return false;
        }

        public void trackPackageLoss(boolean isAvailable) {
            if (isAvailable) {
                this.pickerParameters.reverseChannelPackageLossCounter.add(1);
                this.points[0] = this.pickerParameters.reverseChannelPackageLossCounter.getPercentage() * 1000;
            } else {
                this.pickerParameters.reverseChannelPackageLossCounter.add(0);
                this.points[0] = this.pickerParameters.reverseChannelPackageLossCounter.getPercentage() * 1000;
                ++this.consecutiveLossCounter;
            }
            ++this.lostPackages.numberTrackedSamples;
        }

        public boolean updateLossStatistics() {
            if (this.consecutiveLossCounter > 0) {
                this.lostPackages.add(this.consecutiveLossCounter);
                this.consecutiveLossCounter = 0;
                return true;
            }
            return false;
        }

        public void finalUpdateLossStatistics() {
            this.lostPackages.percentage = (double)this.lostPackages.lossTotal * 100.0 / (double)(this.lostPackages.numberTrackedSamples - this.consecutiveLossCounter);
            log.log(Level.INFO, String.format("lostPackages = (%d) %d of %d percentage = %3.1f", this.lostPackages.lossTotal + this.consecutiveLossCounter, this.lostPackages.lossTotal, this.lostPackages.numberTrackedSamples, this.lostPackages.percentage));
        }

        public int getLossTotal() {
            return this.lostPackages.lossTotal + this.consecutiveLossCounter;
        }

        public PackageLoss getLostPackages() {
            return this.lostPackages;
        }

        private boolean isPointsValid() {
            return !this.pickerParameters.isFilterEnabled || this.tmpVoltageRx > -1 && this.tmpVoltageRx < 100 && this.tmpTemperatureRx < 100;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            for (int j = 0; j < 10; ++j) {
                targetPoints[j] = this.points[j];
            }
            throw new UnsupportedOperationException("use in situ parsing");
        }

        @Override
        public String toString() {
            return super.toString() + "  [countPackageLoss=" + this.lostPackages.lossTotal + ", consecutiveLossCounter=" + this.consecutiveLossCounter + "]";
        }
    }

    public static class EscBinParser
    extends HoTTbinReader.BinParser {
        private final boolean isChannelsChannel;
        private int tmpTemperatureFet = 0;
        private int tmpVoltage = 0;
        private int tmpCurrent = 0;
        private int tmpRevolution = 0;
        private int tmpCapacity = 0;
        private int parseCount = 0;

        protected boolean isChannelsChannel() {
            return this.isChannelsChannel;
        }

        protected EscBinParser(HoTTAdapter.PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
            this(pickerParameters, new int[pickerParameters.analyzer.getActiveDevice().getNumberOfMeasurements(pickerParameters.analyzer.getActiveChannel().getNumber())], timeSteps_ms, buffers);
        }

        protected EscBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.ESC);
            if (buffers.length != 5) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
            this.isChannelsChannel = this.pickerParameters.analyzer.getActiveChannel().getNumber() == 4;
        }

        @Override
        protected boolean parse() {
            this.tmpVoltage = DataParser.parse2Short((byte[])this._buf1, (int)3);
            this.tmpCurrent = DataParser.parse2Short((byte[])this._buf2, (int)1);
            this.tmpCapacity = DataParser.parse2Short((byte[])this._buf1, (int)7);
            this.tmpRevolution = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)5);
            this.tmpTemperatureFet = (this._buf1[9] & 0xFF) - 20;
            if (this.isChannelsChannel) {
                if (this.isPointsValid()) {
                    this.points[123] = this.tmpVoltage * 1000;
                    this.points[124] = this.tmpCurrent * 1000;
                    this.points[126] = Double.valueOf((double)this.points[107] / 1000.0 * (double)this.points[108]).intValue();
                    if (!this.pickerParameters.isFilterEnabled || this.parseCount <= 20 || this.tmpCapacity != 0 && Math.abs(this.tmpCapacity) <= this.points[109] / 1000 + this.tmpVoltage * this.tmpCurrent / 2500 + 2) {
                        this.points[125] = this.tmpCapacity * 1000;
                    } else if (this.tmpCapacity != 0 && log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, StringHelper.getFormatedTime((String)"mm:ss.SSS", (long)this.getTimeStep_ms()) + " - " + this.tmpCapacity + " - " + this.points[104] / 1000 + " + " + (this.tmpVoltage * this.tmpCurrent / 2500 + 2));
                    }
                    this.points[127] = this.tmpRevolution * 1000;
                    this.points[128] = this.tmpTemperatureFet * 1000;
                    this.points[129] = ((this._buf2[9] & 0xFF) - 20) * 1000;
                    this.points[130] = DataParser.parse2Short((byte[])this._buf1, (int)5) * 1000;
                    this.points[131] = DataParser.parse2Short((byte[])this._buf2, (int)3) * 1000;
                    this.points[132] = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)7) * 1000;
                    this.points[133] = ((this._buf2[0] & 0xFF) - 20) * 1000;
                    this.points[134] = ((this._buf3[0] & 0xFF) - 20) * 1000;
                    this.points[135] = (this._buf1[1] & 0xFF) * 1000;
                    if ((this._buf4[9] & 0xFF) == 3) {
                        this.points[136] = DataParser.parse2Short((byte[])this._buf3, (int)1) * 1000;
                        this.points[137] = DataParser.parse2Short((byte[])this._buf3, (int)3) * 1000;
                        this.points[138] = (this._buf3[5] & 0xFF) * 1000;
                        this.points[139] = (this._buf3[6] & 0xFF) * 1000;
                        this.points[140] = (this._buf3[7] & 0xFF) * 1000;
                        this.points[141] = (this._buf3[8] & 0xFF) * 1000;
                        this.points[142] = DataParser.parse2UnsignedShort((byte)this._buf3[9], (byte)this._buf4[0]) * 1000;
                        this.points[143] = ((this._buf4[1] & 0xFF) - 20) * 1000;
                        this.points[144] = ((this._buf4[2] & 0xFF) - 20) * 1000;
                        this.points[145] = (this._buf4[3] & 0xFF) * 1000;
                        this.points[146] = ((this._buf4[4] & 0xFF) - 20) * 1000;
                        this.points[147] = DataParser.parse2Short((byte[])this._buf4, (int)5) * 1000;
                        this.points[146] = (this._buf4[7] & 0xFF) * 1000;
                        this.points[149] = (this._buf4[8] & 0xFF) * 1000;
                        this.points[150] = 0;
                        this.points[151] = (this._buf4[9] & 0xFF) * 1000;
                    } else if ((this._buf4[9] & 0xFF) >= 128) {
                        this.points[136] = DataParser.parse2Short((byte[])this._buf3, (int)1) * 1000;
                        this.points[137] = DataParser.parse2Short((byte[])this._buf3, (int)3) * 1000;
                        this.points[138] = (this._buf3[5] & 0xFF) * 1000;
                        this.points[139] = (this._buf3[6] & 0xFF) * 1000;
                        this.points[140] = (this._buf3[7] & 0xFF) * 1000;
                        this.points[141] = (this._buf3[8] & 0xFF) * 1000;
                        this.points[142] = DataParser.parse2UnsignedShort((byte)this._buf3[9], (byte)this._buf4[0]) * 1000;
                        this.points[143] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)1) * 1000;
                        this.points[144] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)3) * 1000;
                        this.points[145] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)5) * 1000;
                        this.points[146] = ((this._buf4[7] & 0xFF) - 20) * 1000;
                        this.points[147] = (this._buf4[8] & 0xFF) * 1000;
                        this.points[148] = 0;
                        this.points[149] = 0;
                        this.points[150] = 0;
                        this.points[151] = (this._buf4[9] & 0xFF) * 1000;
                    }
                    return true;
                }
                this.points[135] = (this._buf1[1] & 0xFF) * 1000;
                return false;
            }
            if (this.isPointsValid()) {
                this.points[87] = this.tmpVoltage * 1000;
                this.points[88] = this.tmpCurrent * 1000;
                this.points[90] = Double.valueOf((double)this.points[87] / 1000.0 * (double)this.points[88]).intValue();
                if (!this.pickerParameters.isFilterEnabled || this.parseCount <= 20 || this.tmpCapacity != 0 && Math.abs(this.tmpCapacity) <= this.points[89] / 1000 + this.tmpVoltage * this.tmpCurrent / 2500 + 2) {
                    this.points[89] = this.tmpCapacity * 1000;
                } else if (this.tmpCapacity != 0 && log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, StringHelper.getFormatedTime((String)"mm:ss.SSS", (long)this.getTimeStep_ms()) + " - " + this.tmpCapacity + " - " + this.points[84] / 1000 + " + " + (this.tmpVoltage * this.tmpCurrent / 2500 + 2));
                }
                this.points[91] = this.tmpRevolution * 1000;
                this.points[92] = this.tmpTemperatureFet * 1000;
                this.points[93] = ((this._buf2[9] & 0xFF) - 20) * 1000;
                this.points[94] = DataParser.parse2Short((byte[])this._buf1, (int)5) * 1000;
                this.points[95] = DataParser.parse2Short((byte[])this._buf2, (int)3) * 1000;
                this.points[96] = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)7) * 1000;
                this.points[97] = ((this._buf2[0] & 0xFF) - 20) * 1000;
                this.points[98] = ((this._buf3[0] & 0xFF) - 20) * 1000;
                this.points[99] = (this._buf1[1] & 0xFF) * 1000;
                if ((this._buf4[9] & 0xFF) == 3) {
                    this.points[100] = DataParser.parse2Short((byte[])this._buf3, (int)1) * 1000;
                    this.points[101] = DataParser.parse2Short((byte[])this._buf3, (int)3) * 1000;
                    this.points[102] = (this._buf3[5] & 0xFF) * 1000;
                    this.points[103] = (this._buf3[6] & 0xFF) * 1000;
                    this.points[104] = (this._buf3[7] & 0xFF) * 1000;
                    this.points[105] = (this._buf3[8] & 0xFF) * 1000;
                    this.points[106] = DataParser.parse2UnsignedShort((byte)this._buf3[9], (byte)this._buf4[0]) * 1000;
                    this.points[107] = ((this._buf4[1] & 0xFF) - 20) * 1000;
                    this.points[108] = ((this._buf4[2] & 0xFF) - 20) * 1000;
                    this.points[109] = (this._buf4[3] & 0xFF) * 1000;
                    this.points[110] = ((this._buf4[4] & 0xFF) - 20) * 1000;
                    this.points[111] = DataParser.parse2Short((byte[])this._buf4, (int)5) * 1000;
                    this.points[112] = (this._buf4[7] & 0xFF) * 1000;
                    this.points[113] = (this._buf4[8] & 0xFF) * 1000;
                    this.points[114] = 0;
                    this.points[115] = (this._buf4[9] & 0xFF) * 1000;
                } else if ((this._buf4[9] & 0xFF) >= 128) {
                    this.points[100] = DataParser.parse2Short((byte[])this._buf3, (int)1) * 1000;
                    this.points[101] = DataParser.parse2Short((byte[])this._buf3, (int)3) * 1000;
                    this.points[102] = (this._buf3[5] & 0xFF) * 1000;
                    this.points[103] = (this._buf3[6] & 0xFF) * 1000;
                    this.points[104] = (this._buf3[7] & 0xFF) * 1000;
                    this.points[105] = (this._buf3[8] & 0xFF) * 1000;
                    this.points[106] = DataParser.parse2UnsignedShort((byte)this._buf3[9], (byte)this._buf4[0]) * 1000;
                    this.points[107] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)1) * 1000;
                    this.points[108] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)3) * 1000;
                    this.points[109] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)5) * 1000;
                    this.points[110] = ((this._buf4[7] & 0xFF) - 20) * 1000;
                    this.points[111] = (this._buf4[8] & 0xFF) * 1000;
                    this.points[112] = 0;
                    this.points[113] = 0;
                    this.points[114] = 0;
                    this.points[115] = (this._buf4[9] & 0xFF) * 1000;
                }
                ++this.parseCount;
                return true;
            }
            this.points[99] = (this._buf1[1] & 0xFF) * 1000;
            ++this.parseCount;
            return false;
        }

        private boolean isPointsValid() {
            if (this.isChannelsChannel) {
                return !this.pickerParameters.isFilterEnabled || this.tmpVoltage > 0 && this.tmpVoltage < 1000 && this.tmpCurrent < 4000 && this.tmpCurrent > -10 && this.tmpRevolution > -1 && this.tmpRevolution < 20000 && (this.points[112] == 0 || this.points[112] / 1000 - this.tmpTemperatureFet <= 20);
            }
            return !this.pickerParameters.isFilterEnabled || this.tmpVoltage > 0 && this.tmpVoltage < 1000 && this.tmpCurrent < 4000 && this.tmpCurrent > -10 && this.tmpRevolution > -1 && this.tmpRevolution < 20000 && (this.points[92] == 0 || this.points[92] / 1000 - this.tmpTemperatureFet <= 20);
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            if (this.isChannelsChannel) {
                for (int j = 123; j < 152; ++j) {
                    targetPoints[j] = this.points[j];
                }
            } else {
                for (int j = 87; j < 116; ++j) {
                    targetPoints[j] = this.points[j];
                }
            }
        }
    }

    public static class ChnBinParser
    extends HoTTbinReader.BinParser {
        protected final byte[] _buf;

        protected ChnBinParser(HoTTAdapter.PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
            this(pickerParameters, new int[pickerParameters.analyzer.getActiveDevice().getNumberOfMeasurements(pickerParameters.analyzer.getActiveChannel().getNumber())], timeSteps_ms, buffers);
            throw new UnsupportedOperationException("use in situ parsing");
        }

        protected ChnBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.CHANNEL);
            this._buf = buffers[0];
            if (buffers.length != 1) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
        }

        @Override
        protected boolean parse() {
            this.points[4] = (this._buf[3] & 0xFF) * -1000;
            this.points[5] = (this._buf[4] & 0xFF) * -1000;
            this.points[87] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)8) / 2 * 1000;
            this.points[88] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)10) / 2 * 1000;
            this.points[89] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)12) / 2 * 1000;
            this.points[90] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)14) / 2 * 1000;
            this.points[91] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)16) / 2 * 1000;
            this.points[92] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)18) / 2 * 1000;
            this.points[93] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)20) / 2 * 1000;
            this.points[94] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)22) / 2 * 1000;
            if (this._buf[5] == 0) {
                this.points[95] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)24) / 2 * 1000;
                this.points[96] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)26) / 2 * 1000;
                this.points[97] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)28) / 2 * 1000;
                this.points[98] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)30) / 2 * 1000;
                if (this.points[99] == 0) {
                    this.points[99] = 1500000;
                    this.points[100] = 1500000;
                    this.points[101] = 1500000;
                    this.points[102] = 1500000;
                }
            } else {
                this.points[99] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)24) / 2 * 1000;
                this.points[100] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)26) / 2 * 1000;
                this.points[101] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)28) / 2 * 1000;
                this.points[102] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)30) / 2 * 1000;
                if (this.points[95] == 0) {
                    this.points[95] = 1500000;
                    this.points[96] = 1500000;
                    this.points[97] = 1500000;
                    this.points[98] = 1500000;
                }
            }
            this.points[119] = (this._buf[50] & 1) * 100000;
            this.points[120] = (this._buf[50] & 2) * 50000;
            this.points[121] = (this._buf[50] & 4) * 25000;
            this.points[122] = this._buf[37] > 0 && this._buf[37] < 27 ? this._buf[32] * 1000 : 0;
            return true;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            int j;
            for (j = 4; j < 7; ++j) {
                targetPoints[j] = this.points[j];
            }
            for (j = 87; j < 103; ++j) {
                targetPoints[j] = this.points[j];
            }
            throw new UnsupportedOperationException("use in situ parsing");
        }
    }

    public static class EamBinParser
    extends HoTTbinReader.BinParser {
        private int tmpHeight = 0;
        private int tmpClimb3 = 0;
        private int tmpVoltage1 = 0;
        private int tmpVoltage2 = 0;
        private int tmpCapacity = 0;
        private int parseCount = 0;

        protected EamBinParser(HoTTAdapter.PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
            this(pickerParameters, new int[pickerParameters.analyzer.getActiveDevice().getNumberOfMeasurements(pickerParameters.analyzer.getActiveChannel().getNumber())], timeSteps_ms, buffers);
        }

        protected EamBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.EAM);
            if (buffers.length != 5) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
        }

        @Override
        protected boolean parse() {
            this.tmpHeight = DataParser.parse2Short((byte[])this._buf3, (int)3) - 500;
            this.tmpClimb3 = (this._buf4[3] & 0xFF) - 120;
            this.tmpVoltage1 = DataParser.parse2Short((byte[])this._buf2, (int)7);
            this.tmpVoltage2 = DataParser.parse2Short((byte)this._buf2[9], (byte)this._buf3[0]);
            this.tmpCapacity = DataParser.parse2Short((byte)this._buf3[9], (byte)this._buf4[0]);
            if (this.isPointsValid()) {
                if (this.pickerParameters.altitudeClimbSensorSelection == 4) {
                    this.points[10] = this.tmpHeight * 1000;
                    this.points[11] = (DataParser.parse2UnsignedShort((byte[])this._buf4, (int)1) - 30000) * 10;
                    this.points[12] = this.tmpClimb3 * 1000;
                }
                this.points[60] = DataParser.parse2Short((byte[])this._buf3, (int)7) * 1000;
                this.points[61] = DataParser.parse2Short((byte[])this._buf3, (int)5) * 1000;
                if ((this._buf4[7] & 0xFF) != 64) {
                    int j;
                    if (!this.pickerParameters.isFilterEnabled || this.parseCount <= 20 || Math.abs(this.tmpCapacity) <= this.points[62] / 1000 + this.points[60] / 1000 * this.points[61] / 1000 / 2500 + 2) {
                        this.points[62] = this.tmpCapacity * 1000;
                    } else if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, StringHelper.getFormatedTime((String)"mm:ss.SSS", (long)this.getTimeStep_ms()) + " - " + this.tmpCapacity + " - " + this.points[48] / 1000 + " + " + (this.points[46] / 1000 * this.points[47] / 1000 / 2500 + 2));
                    }
                    this.points[63] = Double.valueOf((double)this.points[60] / 1000.0 * (double)this.points[61]).intValue();
                    int maxVotage = Integer.MIN_VALUE;
                    int minVotage = Integer.MAX_VALUE;
                    for (j = 0; j < 7; ++j) {
                        this.points[j + 65] = (this._buf1[3 + j] & 0xFF) * 1000;
                        if (this.points[j + 65] <= 0) continue;
                        maxVotage = this.points[j + 65] > maxVotage ? this.points[j + 65] : maxVotage;
                        minVotage = this.points[j + 65] < minVotage ? this.points[j + 65] : minVotage;
                    }
                    for (j = 0; j < 7; ++j) {
                        this.points[j + 72] = (this._buf2[j] & 0xFF) * 1000;
                        if (this.points[j + 72] <= 0) continue;
                        maxVotage = this.points[j + 72] > maxVotage ? this.points[j + 72] : maxVotage;
                        minVotage = this.points[j + 72] < minVotage ? this.points[j + 72] : minVotage;
                    }
                    this.points[64] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? (maxVotage - minVotage) * 10 : 0;
                    this.points[79] = this.tmpVoltage1 * 100;
                    this.points[80] = this.tmpVoltage2 * 100;
                    this.points[81] = ((this._buf3[1] & 0xFF) - 20) * 1000;
                    this.points[82] = ((this._buf3[2] & 0xFF) - 20) * 1000;
                    this.points[83] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)4) * 1000;
                    this.points[84] = ((this._buf4[6] & 0xFF) * 60 + (this._buf4[7] & 0xFF)) * 1000;
                    this.points[85] = DataParser.parse2Short((byte[])this._buf4, (int)8) * 1000;
                    this.points[86] = ((this._buf1[1] & 0xFF) + ((this._buf1[2] & 0x7F) << 8)) * 1000;
                    ++this.parseCount;
                    return true;
                }
            }
            this.points[86] = ((this._buf1[1] & 0xFF) + ((this._buf1[2] & 0x7F) << 8)) * 1000;
            return false;
        }

        private boolean isPointsValid() {
            return !this.pickerParameters.isFilterEnabled || this.tmpClimb3 > -90 && this.tmpHeight >= -490 && this.tmpHeight < 5000 && Math.abs(this.tmpVoltage1) < 600 && Math.abs(this.tmpVoltage2) < 600;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            if (targetPoints[10] != 0 && this.points[10] != 0 || this.points[10] != 0) {
                for (int j = 10; j < 13; ++j) {
                    targetPoints[j] = this.points[j];
                }
            }
            for (int k = 60; k < 87; ++k) {
                targetPoints[k] = this.points[k];
            }
        }
    }

    public static class GamBinParser
    extends HoTTbinReader.BinParser {
        private int tmpHeight = 0;
        private int tmpClimb3 = 0;
        private int tmpVoltage1 = 0;
        private int tmpVoltage2 = 0;
        private int tmpCapacity = 0;
        private int parseCount = 0;

        protected GamBinParser(HoTTAdapter.PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
            this(pickerParameters, new int[pickerParameters.analyzer.getActiveDevice().getNumberOfMeasurements(pickerParameters.analyzer.getActiveChannel().getNumber())], timeSteps_ms, buffers);
        }

        protected GamBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.GAM);
            if (buffers.length != 5) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
        }

        @Override
        protected boolean parse() {
            this.tmpHeight = DataParser.parse2Short((byte[])this._buf3, (int)0) - 500;
            this.tmpClimb3 = (this._buf3[4] & 0xFF) - 120;
            this.tmpVoltage1 = DataParser.parse2Short((byte)this._buf1[9], (byte)this._buf2[0]);
            this.tmpVoltage2 = DataParser.parse2Short((byte[])this._buf2, (int)1);
            this.tmpCapacity = DataParser.parse2Short((byte)this._buf3[9], (byte)this._buf4[0]);
            if (this.isPointsValid()) {
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                this.points[38] = DataParser.parse2Short((byte[])this._buf3, (int)7) * 1000;
                this.points[39] = DataParser.parse2Short((byte[])this._buf3, (int)5) * 1000;
                if (!this.pickerParameters.isFilterEnabled || this.parseCount <= 20 || this.tmpCapacity != 0 && Math.abs(this.tmpCapacity) <= this.points[40] / 1000 + this.points[38] / 1000 * this.points[39] / 1000 / 2500 + 2) {
                    this.points[40] = this.tmpCapacity * 1000;
                } else if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, StringHelper.getFormatedTime((String)"mm:ss.SSS", (long)this.getTimeStep_ms()) + " - " + this.tmpCapacity + " - " + this.points[26] / 1000 + " + " + (this.points[24] / 1000 * this.points[25] / 1000 / 2500 + 2));
                }
                this.points[41] = Double.valueOf((double)this.points[38] / 1000.0 * (double)this.points[39]).intValue();
                for (int j = 0; j < 6; ++j) {
                    this.points[j + 43] = (this._buf1[3 + j] & 0xFF) * 1000;
                    if (this.points[j + 43] <= 0) continue;
                    maxVotage = this.points[j + 43] > maxVotage ? this.points[j + 43] : maxVotage;
                    minVotage = this.points[j + 43] < minVotage ? this.points[j + 43] : minVotage;
                }
                this.points[42] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? (maxVotage - minVotage) * 10 : 0;
                this.points[49] = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)8) * 1000;
                this.points[50] = DataParser.parse2Short((byte[])this._buf2, (int)6) * 1000;
                if (this.pickerParameters.altitudeClimbSensorSelection == 3) {
                    this.points[10] = this.tmpHeight * 1000;
                    this.points[11] = (DataParser.parse2UnsignedShort((byte[])this._buf3, (int)2) - 30000) * 10;
                    this.points[12] = this.tmpClimb3 * 1000;
                }
                this.points[51] = this.tmpVoltage1 * 100;
                this.points[52] = this.tmpVoltage2 * 100;
                this.points[53] = ((this._buf2[3] & 0xFF) - 20) * 1000;
                this.points[54] = ((this._buf2[4] & 0xFF) - 20) * 1000;
                this.points[55] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)1) * 1000;
                this.points[56] = (this._buf4[3] & 0xFF) * 1000;
                this.points[57] = (this._buf4[4] & 0xFF) * 1000;
                this.points[58] = (this._buf4[8] & 0xFF) * 1000;
                this.points[59] = ((this._buf1[1] & 0xFF) + ((this._buf1[2] & 0x7F) << 8)) * 1000;
                ++this.parseCount;
                return true;
            }
            this.points[59] = ((this._buf1[1] & 0xFF) + ((this._buf1[2] & 0x7F) << 8)) * 1000;
            ++this.parseCount;
            return false;
        }

        private boolean isPointsValid() {
            return !this.pickerParameters.isFilterEnabled || this.tmpClimb3 > -90 && this.tmpHeight >= -490 && this.tmpHeight < 5000 && Math.abs(this.tmpVoltage1) < 600 && Math.abs(this.tmpVoltage2) < 600;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            if (targetPoints[10] != 0 && this.points[10] != 0 || this.points[10] != 0) {
                for (int j = 10; j < 13; ++j) {
                    targetPoints[j] = this.points[j];
                }
            }
            for (int k = 38; k < 60; ++k) {
                targetPoints[k] = this.points[k];
            }
        }
    }

    public static class GpsBinParser
    extends HoTTbinReader.BinParser {
        private int tmpDate = 0;
        private int tmpTime = 0;
        private int tmpHeight = 0;
        private int tmpClimb1 = 0;
        private int tmpClimb3 = 0;
        private int tmpVelocity = 0;
        private int tmpLatitude = 0;
        private int tmpLatitudeDelta = 0;
        private int tmpLongitude = 0;
        private int tmpLongitudeDelta = 0;
        private double latitudeTolerance = 1.0;
        private long lastLatitudeTimeStep = 0L;
        private double longitudeTolerance = 1.0;
        private long lastLongitudeTimeStep = 0L;

        protected GpsBinParser(HoTTAdapter.PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
            this(pickerParameters, new int[pickerParameters.analyzer.getActiveDevice().getNumberOfMeasurements(pickerParameters.analyzer.getActiveChannel().getNumber())], timeSteps_ms, buffers);
        }

        protected GpsBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.GPS);
            if (buffers.length != 5) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
        }

        @Override
        protected boolean parse() {
            this.tmpHeight = DataParser.parse2Short((byte[])this._buf2, (int)8) - 500;
            this.tmpClimb1 = DataParser.parse2UnsignedShort((byte[])this._buf3, (int)0) - 30000;
            this.tmpClimb3 = (this._buf3[2] & 0xFF) - 120;
            this.tmpVelocity = DataParser.parse2UnsignedShort((byte[])this._buf1, (int)4) * 1000;
            if (this.isPointsValid()) {
                this.points[22] = this.pickerParameters.isFilterEnabled && this.tmpVelocity > 500000 ? this.points[22] : this.tmpVelocity;
                this.tmpLatitude = DataParser.parse2UnsignedShort((byte[])this._buf1, (int)7) * 10000 + DataParser.parse2UnsignedShort((byte)this._buf1[9], (byte)this._buf2[0]);
                this.tmpLatitude = this._buf1[6] == 1 ? -1 * this.tmpLatitude : this.tmpLatitude;
                this.tmpLatitudeDelta = Math.abs(this.tmpLatitude - this.points[20]);
                this.tmpLatitudeDelta = this.tmpLatitudeDelta > 400000 ? this.tmpLatitudeDelta - 400000 : this.tmpLatitudeDelta;
                this.latitudeTolerance = (double)this.points[22] / 1000.0 * (double)(this.getTimeStep_ms() - this.lastLatitudeTimeStep) / this.pickerParameters.latitudeToleranceFactor;
                double d = this.latitudeTolerance = this.latitudeTolerance > 0.0 ? this.latitudeTolerance : 25.0;
                if (!this.pickerParameters.isFilterEnabled || this.points[20] == 0 || (double)this.tmpLatitudeDelta <= this.latitudeTolerance) {
                    this.lastLatitudeTimeStep = this.getTimeStep_ms();
                    this.points[20] = this.tmpLatitude;
                } else if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, StringHelper.getFormatedTime((String)"HH:mm:ss:SSS", (long)(this.getTimeStep_ms() - 3600000L)) + " Lat " + this.tmpLatitude + " - " + this.tmpLatitudeDelta + " - " + this.latitudeTolerance);
                }
                this.tmpLongitude = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)2) * 10000 + DataParser.parse2UnsignedShort((byte[])this._buf2, (int)4);
                this.tmpLongitude = this._buf2[1] == 1 ? -1 * this.tmpLongitude : this.tmpLongitude;
                this.tmpLongitudeDelta = Math.abs(this.tmpLongitude - this.points[21]);
                this.tmpLongitudeDelta = this.tmpLongitudeDelta > 400000 ? this.tmpLongitudeDelta - 400000 : this.tmpLongitudeDelta;
                this.longitudeTolerance = (double)this.points[22] / 1000.0 * (double)(this.getTimeStep_ms() - this.lastLongitudeTimeStep) / this.pickerParameters.longitudeToleranceFactor;
                double d2 = this.longitudeTolerance = this.longitudeTolerance > 0.0 ? this.longitudeTolerance : 45.0;
                if (!this.pickerParameters.isFilterEnabled || this.points[21] == 0 || (double)this.tmpLongitudeDelta <= this.longitudeTolerance) {
                    this.lastLongitudeTimeStep = this.getTimeStep_ms();
                    this.points[21] = this.tmpLongitude;
                } else if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, StringHelper.getFormatedTime((String)"HH:mm:ss:SSS", (long)(this.getTimeStep_ms() - 3600000L)) + " Long " + this.tmpLongitude + " - " + this.tmpLongitudeDelta + " - " + this.longitudeTolerance);
                }
                if (this.pickerParameters.altitudeClimbSensorSelection == 2) {
                    this.points[10] = this.tmpHeight * 1000;
                    this.points[11] = this.tmpClimb1 * 10;
                    this.points[12] = this.tmpClimb3 * 1000;
                }
                this.points[23] = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)6) * 1000;
                this.points[24] = (this._buf1[3] & 0xFF) * 1000;
                this.points[25] = 0;
                this.points[26] = (this._buf3[3] & 0xFF) * 1000;
                switch (this._buf3[4]) {
                    case 45: {
                        this.points[27] = 0;
                        break;
                    }
                    case 50: {
                        this.points[27] = 2000;
                        break;
                    }
                    case 51: {
                        this.points[27] = 3000;
                        break;
                    }
                    case 68: {
                        this.points[27] = 4000;
                        break;
                    }
                    default: {
                        try {
                            this.points[27] = Integer.valueOf(String.format("%c", 0xFF & this._buf3[4])) * 1000;
                            break;
                        }
                        catch (NumberFormatException e1) {
                            this.points[27] = 1000;
                        }
                    }
                }
                this.points[28] = (this._buf1[1] & 0xF) * 1000;
                this.points[29] = (this._buf3[5] & 0xFF) * 1000;
                if ((this._buf4[9] & 0xFF) > 100) {
                    this.points[30] = this._buf3[6] * 1000;
                    this.points[31] = DataParser.parse2UnsignedShort((byte[])this._buf3, (int)7) * 1000;
                    this.points[33] = DataParser.parse2Short((byte)this._buf3[9], (byte)this._buf4[0]) * 1000;
                    this.points[34] = DataParser.parse2Short((byte[])this._buf4, (int)1) * 1000;
                    this.points[35] = DataParser.parse2Short((byte[])this._buf4, (int)3) * 1000;
                    this.points[36] = (this._buf4[5] & 0xFF) * 1000;
                } else if ((this._buf4[9] & 0xFF) == 4) {
                    this.points[30] = this._buf4[4] * 1000;
                    this.points[31] = 0;
                    this.points[32] = this._buf3[8] * 100;
                    if (this.points[27] > 0) {
                        this.tmpTime = this._buf3[9] * 10000000 + this._buf4[0] * 100000 + this._buf4[1] * 1000 + this._buf4[2] * 10;
                        if (this.tmpTime < this.points[33]) {
                            log.log(Level.WARNING, String.format("near time: %s %s", StringHelper.getFormatedTime((String)"HH:mm:ss.SSS", (long)(this.timeSteps_ms[0] - 3600000L)), HoTTAdapter.getFormattedTime(this.tmpTime)));
                        }
                        this.points[33] = this.tmpTime;
                        this.tmpDate = ((this._buf4[5] - 48) * 1000000 + (this._buf4[7] - 48) * 10000 + (this._buf4[6] - 48) * 100) * 10;
                        if (this.tmpDate < this.points[34]) {
                            log.log(Level.WARNING, String.format("near time: %s Sat-Fix %d #Sats %d %s - %c %c %c", StringHelper.getFormatedTime((String)"HH:mm:ss.SSS", (long)(this.timeSteps_ms[0] - 3600000L)), this.points[27] / 1000, this.points[26] / 1000, HoTTAdapter.getFormattedTime(this.points[33]), this._buf4[5] & 0xFF, this._buf4[7] & 0xFF, this._buf4[6] & 0xFF));
                        }
                        this.points[34] = this.tmpDate;
                        this.points[35] = (DataParser.parse2Short((byte[])this._buf3, (int)6) - 500) * 1000;
                    } else {
                        this.points[35] = 0;
                        this.points[34] = 0;
                        this.points[33] = 0;
                    }
                    this.points[36] = (this._buf4[3] & 0xFF) * 1000;
                } else if ((this._buf4[9] & 0xFF) == 0 || (this._buf4[9] & 0xFF) == 1) {
                    boolean version;
                    boolean bl = version = this.points[37] == 1000 || this._buf3[6] != 0 && this._buf3[7] != 0 && this._buf3[8] != 0;
                    if (!version) {
                        this.points[30] = this._buf3[6] * 1000;
                        this.points[31] = this._buf3[7] * 1000;
                        this.points[32] = this._buf3[8] * 1000;
                        this.points[33] = this._buf3[9] * 10000000 + this._buf4[0] * 100000 + this._buf4[1] * 1000 + this._buf4[2] * 10;
                        this.points[34] = 0;
                        this.points[35] = DataParser.parse2Short((byte[])this._buf4, (int)3) * 1000;
                        this.points[36] = (this._buf4[5] & 0xFF) * 1000;
                    } else {
                        this.points[30] = DataParser.parse2Short((byte[])this._buf3, (int)6) * 1000;
                        this.points[31] = 0;
                        this.points[32] = this._buf3[8] * 1000;
                        this.points[33] = this._buf3[9] * 10000000 + this._buf4[0] * 100000 + this._buf4[1] * 1000 + this._buf4[2] * 10;
                        this.points[34] = 0;
                        this.points[35] = DataParser.parse2Short((byte[])this._buf4, (int)3) * 1000;
                        this.points[36] = (this._buf4[5] & 0xFF) * 1000;
                    }
                } else {
                    this.points[30] = this._buf3[6] * 1000;
                    this.points[31] = this._buf3[7] * 1000;
                    this.points[32] = this._buf3[8] * 1000;
                    this.points[33] = DataParser.parse2Short((byte)this._buf3[9], (byte)this._buf4[0]) * 1000;
                    this.points[34] = DataParser.parse2Short((byte[])this._buf4, (int)1) * 1000;
                    this.points[35] = DataParser.parse2Short((byte[])this._buf4, (int)3) * 1000;
                    this.points[36] = (this._buf4[5] & 0xFF) * 1000;
                }
                this.points[37] = (this._buf4[9] & 0xFF) * 1000;
                return true;
            }
            this.points[28] = (this._buf1[1] & 0xF) * 1000;
            return false;
        }

        private boolean isPointsValid() {
            return !this.pickerParameters.isFilterEnabled || this.tmpClimb1 > -20000 && this.tmpClimb3 > -90 && this.tmpHeight >= -490 && this.tmpHeight < 4500;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            if (targetPoints[10] != 0 && this.points[10] != 0 || this.points[10] != 0) {
                for (int j = 10; j < 13; ++j) {
                    targetPoints[j] = this.points[j];
                }
            }
            for (int k = 20; k < 38; ++k) {
                targetPoints[k] = this.points[k];
            }
        }
    }

    public static class VarBinParser
    extends HoTTbinReader.BinParser {
        private int tmpHeight = 0;
        private int tmpClimb10 = 0;

        protected VarBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers, HoTTAdapter.Sensor sensor) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.VARIO);
        }

        protected VarBinParser(HoTTAdapter.PickerParameters pickerParameters, long[] timeSteps_ms, byte[][] buffers) {
            this(pickerParameters, new int[pickerParameters.analyzer.getActiveDevice().getNumberOfMeasurements(pickerParameters.analyzer.getActiveChannel().getNumber())], timeSteps_ms, buffers);
        }

        protected VarBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.VARIO);
            if (buffers.length != 5) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
            points[2] = 100000;
        }

        @Override
        protected boolean parse() {
            this.tmpHeight = DataParser.parse2Short((byte[])this._buf1, (int)2) - 500;
            this.tmpClimb10 = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)2) - 30000;
            if (this.isPointsValid()) {
                if (this.pickerParameters.altitudeClimbSensorSelection == 1) {
                    this.points[10] = this.tmpHeight * 1000;
                    this.points[11] = (DataParser.parse2UnsignedShort((byte[])this._buf1, (int)8) - 30000) * 10;
                    this.points[12] = (DataParser.parse2UnsignedShort((byte[])this._buf2, (int)0) - 30000) * 10;
                    this.points[13] = this.tmpClimb10 * 10;
                }
                this.points[14] = (this._buf1[1] & 0x3F) * 1000;
                if ((this._buf4[9] & 0xFF) > 100 && (this._buf4[9] & 0xFF) < 120) {
                    try {
                        this.points[15] = Integer.parseInt(String.format(Locale.ENGLISH, "%c%c%c%c%c0", this._buf2[4], this._buf2[5], this._buf2[6], this._buf2[8], this._buf2[9]).trim());
                        this.points[16] = Integer.parseInt(String.format(Locale.ENGLISH, "%c%c%c%c%c0", this._buf3[1], this._buf3[2], this._buf3[3], this._buf3[5], this._buf3[6]).trim());
                        this.points[17] = Integer.parseInt(String.format(Locale.ENGLISH, "%c%c%c%c%c0", this._buf3[8], this._buf3[9], this._buf4[0], this._buf4[2], this._buf4[3]).trim());
                    }
                    catch (NumberFormatException e) {
                        byte[] tmpArray = new byte[21];
                        System.arraycopy(this._buf2, 4, tmpArray, 0, 6);
                        System.arraycopy(this._buf3, 0, tmpArray, 6, 10);
                        System.arraycopy(this._buf4, 0, tmpArray, 16, 5);
                        log.log(Level.WARNING, "'" + new String(tmpArray) + "'");
                    }
                    this.points[18] = (this._buf4[8] & 0xFF) * 1000;
                    this.points[19] = (this._buf4[9] & 0xFF) * 1000;
                }
                return true;
            }
            System.out.println();
            this.points[14] = (this._buf1[1] & 0x3F) * 1000;
            return this.isPointsValid();
        }

        private boolean isPointsValid() {
            return !this.pickerParameters.isFilterEnabled || this.tmpHeight >= -490 && this.tmpHeight < 5000;
        }

        @Override
        public void migratePoints(int[] targetPoints) {
            if (this.points[10] != 0 || this.points[11] != 0 || this.points[12] != 0 || this.points[13] != 0) {
                for (int j = 10; j < 20; ++j) {
                    targetPoints[j] = this.points[j];
                }
            }
        }
    }
}

