/*
 * Decompiled with CFR 0.152.
 */
package gde.device.wstech;

import gde.GDE;
import gde.comm.DeviceCommPort;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.wstech.ContextMenu;
import gde.device.wstech.VarioDialog;
import gde.device.wstech.VarioToolTabItem;
import gde.exception.DataInconsitsentException;
import gde.io.CSVSerialDataReaderWriter;
import gde.io.DataParser;
import gde.io.FileHandler;
import gde.io.IDataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import gde.utils.GPSHelper;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class DataVario
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(DataVario.class.getName());
    final DataExplorer application;
    final Channels channels;
    final VarioDialog dialog;

    public DataVario(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.wstech.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.dialog = new VarioDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT1858"), Messages.getString((String)"GDE_MSGT1858"));
            this.updateFileMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
    }

    public DataVario(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.wstech.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.dialog = new VarioDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT1858"), Messages.getString((String)"GDE_MSGT1858"));
            this.updateFileMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
    }

    public VarioDialog getDialog() {
        return this.dialog;
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 0;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        int displayableCounter = 0;
        String[] measurementNames = this.getMeasurementNames(channelConfigNumber);
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            MeasurementType measurement = this.getMeasurement(channelConfigNumber, i);
            log.log(Level.FINE, record.getName() + " = " + measurementNames[i]);
            if (record.isActive() != measurement.isActive()) {
                record.setActive(Boolean.valueOf(measurement.isActive()));
                record.setVisible(measurement.isActive());
                record.setDisplayable(measurement.isActive());
                log.log(Level.FINE, "switch " + record.getName() + " to " + measurement.isActive());
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData() && measurement.isActive());
                log.log(Level.FINE, record.getName() + " ! hasReasonableData ");
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            log.log(Level.FINE, "add to displayable counter: " + record.getName());
            ++displayableCounter;
        }
        log.log(Level.TIME, "displayableCounter = " + displayableCounter);
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        Record recordLatitude = recordSet.get(8);
        Record recordLongitude = recordSet.get(7);
        Record recordAlitude = recordSet.get(9);
        if (recordLatitude.hasReasonableData() && recordLongitude.hasReasonableData() && recordAlitude.hasReasonableData()) {
            int recordSize = recordLatitude.realSize();
            int startAltitude = recordAlitude.get(0);
            int indexGPS = 0;
            for (int i = 0; i < recordSize; ++i) {
                if (recordLatitude.get(i) == 0 || recordLongitude.get(i) == 0) continue;
                indexGPS = i++;
                break;
            }
            startAltitude = recordAlitude.get(indexGPS);
            GPSHelper.calculateValues((IDevice)this, (RecordSet)recordSet, (int)8, (int)7, (int)9, (int)startAltitude, (int)13, (int)14, (int)15, (int)16);
            this.application.updateStatisticsData();
            this.updateVisibilityStatus(recordSet, true);
        }
    }

    public DeviceCommPort getSerialPort() {
        return null;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    public void open_closeCommPort() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT1800"));
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DataVario.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        if (!selectedImportFile.toLowerCase().endsWith(".csv")) {
                            if (selectedImportFile.contains(".")) {
                                selectedImportFile = selectedImportFile.substring(0, selectedImportFile.indexOf(46));
                            }
                            selectedImportFile = selectedImportFile + ".csv";
                        }
                        log.log(Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        try {
                            Integer channelConfigNumber = DataVario.this.dialog != null && !DataVario.this.dialog.isDisposed() ? Integer.valueOf(DataVario.this.dialog.getTabFolderSelectionIndex() + 1) : null;
                            String recordNameExtend = selectedImportFile.substring(selectedImportFile.lastIndexOf(47) + 4, selectedImportFile.lastIndexOf(46));
                            CSVSerialDataReaderWriter.read((String)selectedImportFile, (IDevice)DataVario.this, (String)recordNameExtend, (Integer)channelConfigNumber, (IDataParser)new DataParser(DataVario.this.getDataBlockTimeUnitFactor(), DataVario.this.getDataBlockLeader(), DataVario.this.getDataBlockSeparator().value(), DataVario.this.getDataBlockCheckSumType(), DataVario.this.getDataBlockSize(InputTypes.FILE_IO)));
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    DataVario.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public int[] getCellVoltageOrdinals() {
        return new int[]{0, 3};
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        block5: {
            DataParser data = new DataParser(this.getDataBlockTimeUnitFactor(), this.getDataBlockLeader(), this.getDataBlockSeparator().value(), this.getDataBlockCheckSumType(), Math.abs(this.getDataBlockSize(InputTypes.FILE_IO)));
            int[] startLength = new int[]{0, 0};
            byte[] lineBuffer = null;
            String sThreadId = String.format("%06d", Thread.currentThread().getId());
            int progressCycle = 0;
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            try {
                for (int i = 0; i < recordDataSize; ++i) {
                    this.setDataLineStartAndLength(dataBuffer, startLength);
                    lineBuffer = new byte[startLength[1]];
                    System.arraycopy(dataBuffer, startLength[0], lineBuffer, 0, startLength[1]);
                    data.parse(new String(lineBuffer), i);
                    recordSet.addNoneCalculationRecordsPoints(data.getValues(), (double)data.getTime_ms());
                    if (!doUpdateProgressBar || i % 50 != 0) continue;
                    this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
                }
                this.updateVisibilityStatus(recordSet, true);
                if (doUpdateProgressBar) {
                    this.application.setProgress(100, sThreadId);
                }
            }
            catch (Exception e) {
                String msg = e.getMessage() + Messages.getString((String)"GDE_MSGW0543");
                log.log(Level.WARNING, msg, e);
                this.application.openMessageDialog(msg);
                if (!doUpdateProgressBar) break block5;
                this.application.setProgress(0, sThreadId);
            }
        }
    }

    private void setDataLineStartAndLength(byte[] dataBuffer, int[] refStartLength) {
        int crlfPos;
        int startPos;
        for (startPos = refStartLength[0] + refStartLength[1]; startPos < dataBuffer.length && (dataBuffer[startPos] != 36 || dataBuffer[startPos + 2] != 49 && dataBuffer[startPos + 3] != 49); ++startPos) {
        }
        for (crlfPos = refStartLength[0] = startPos; crlfPos < dataBuffer.length && (dataBuffer[crlfPos] != 13 || dataBuffer[crlfPos + 1] != 10); ++crlfPos) {
        }
        refStartLength[1] = crlfPos - startPos;
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int i;
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[Math.abs(this.getDataBlockSize(InputTypes.FILE_IO))];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        byte[] timeStampBuffer = new byte[timeStampBufferSize];
        if (!recordSet.isTimeStepConstant()) {
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
            }
        }
        log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((convertBuffer[0 + j * 4] & 0xFF) << 24) + ((convertBuffer[1 + j * 4] & 0xFF) << 16) + ((convertBuffer[2 + j * 4] & 0xFF) << 8) + ((convertBuffer[3 + j * 4] & 0xFF) << 0);
            }
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addNoneCalculationRecordsPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public boolean isGPSCoordinates(Record record) {
        return record.getOrdinal() == 7 || record.getOrdinal() == 8;
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double reduction = record.getReduction();
                double factor = record.getFactor();
                int ordinal = record.getOrdinal();
                if (ordinal != 7 && ordinal != 8) {
                    dataTableRow[index + 1] = record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                } else {
                    double value = (double)record.realGet(rowIndex).intValue() / 1000000.0;
                    int grad = (int)value;
                    double minuten = (value - (double)grad) * 100.0;
                    dataTableRow[index + 1] = String.format("%.6f", (double)grad + minuten / 60.0);
                }
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    /*
     * Unable to fully structure code
     */
    public double translateValue(Record record, double value) {
        block5: {
            factor = record.getFactor();
            offset = record.getOffset();
            reduction = record.getReduction();
            if (record.getOrdinal() != 1) break block5;
            property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
            subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
            property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
            subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
            try {
                if (subtractFirst) {
                    reduction = (double)record.getFirst().intValue() / 1000.0;
                }
                if (subtractLast) {
                    reduction = (double)record.getLast().intValue() / 1000.0;
                }
                ** break block6
            }
            finally {
                newValue = 0.0;
            }
        }
lbl-1000:
        // 1 sources

        {
        }
    }

    /*
     * Unable to fully structure code
     */
    public double reverseTranslateValue(Record record, double value) {
        block5: {
            factor = record.getFactor();
            offset = record.getOffset();
            reduction = record.getReduction();
            if (record.getOrdinal() != 1) break block5;
            property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
            subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
            property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
            subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
            try {
                if (subtractFirst) {
                    reduction = (double)record.getFirst().intValue() / 1000.0;
                }
                if (subtractLast) {
                    reduction = (double)record.getLast().intValue() / 1000.0;
                }
                ** break block6
            }
            finally {
                newValue = 0.0;
            }
        }
lbl-1000:
        // 1 sources

        {
        }
    }

    public CTabItem getUtilityDeviceTabItem() {
        return new VarioToolTabItem(this.application.getTabFolder(), 0, this.application.getTabFolder().getItemCount(), this, true);
    }

    public void updateFileMenu(Menu exportMenue) {
        if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
            new MenuItem(exportMenue, 2);
            MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
            convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGT1895"));
            convertKMZ3DRelativeItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ContextMenu.log.log(Level.FINEST, "convertKLM3DRelativeItem action performed! " + e);
                    DataVario.this.export2KML3D(0);
                }
            });
            MenuItem convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT1896"));
            convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ContextMenu.log.log(Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + e);
                    DataVario.this.export2KML3D(1);
                }
            });
            convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT1897"));
            convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ContextMenu.log.log(Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + e);
                    DataVario.this.export2KML3D(2);
                }
            });
        }
    }

    public void export2KML3D(int type) {
        new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGT1859"), 7, 8, 9, 10, 11, 13, 15, type == 0, type == 2);
    }

    public boolean isActualRecordSetWithGpsData() {
        RecordSet activeRecordSet;
        boolean containsGPSdata = false;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            containsGPSdata = activeRecordSet.get(7).hasReasonableData() && activeRecordSet.get(8).hasReasonableData() && activeRecordSet.get(9).hasReasonableData();
        }
        return containsGPSdata;
    }

    public String exportFile(String fileEndingType, boolean isExportTmpDir) {
        RecordSet activeRecordSet;
        String exportFileName = "";
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && fileEndingType.contains("kmz")) {
            int additionalMeasurementOrdinal = this.getGPS2KMZMeasurementOrdinal();
            exportFileName = new FileHandler().exportFileKMZ(7, 8, 9, additionalMeasurementOrdinal, 11, 13, 15, true, isExportTmpDir);
        }
        return exportFileName;
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        if (this.kmzMeasurementOrdinal == null) {
            return 10;
        }
        return this.kmzMeasurementOrdinal;
    }

    public String translateGPS2IGC(RecordSet recordSet, int index, char fixValidity, int startAltitude, int offsetAltitude) {
        Record recordLatitude = recordSet.get(8);
        Record recordLongitude = recordSet.get(7);
        Record baroAlitude = recordSet.get(1);
        Record gpsAlitude = recordSet.get(9);
        return String.format("%02d%05d%s%03d%05d%s%c%05d%05d", recordLatitude.get(index) / 1000000, Double.valueOf((double)(recordLatitude.get(index) % 1000000) / 10.0 + 0.5).intValue(), recordLatitude.get(index) > 0 ? "N" : "S", recordLongitude.get(index) / 1000000, Double.valueOf((double)(recordLongitude.get(index) % 1000000) / 10.0 + 0.5).intValue(), recordLongitude.get(index) > 0 ? "E" : "W", Character.valueOf(fixValidity), Double.valueOf((double)baroAlitude.get(index).intValue() / 10000.0 + (double)startAltitude + (double)offsetAltitude).intValue(), Double.valueOf((double)gpsAlitude.get(index).intValue() / 1000.0 + (double)offsetAltitude).intValue());
    }

    public String[] crossCheckMeasurements(String[] fileRecordsProperties, RecordSet recordSet) {
        String[] recordKeys = recordSet.getRecordNames();
        Vector<String> cleanedRecordNames = new Vector<String>();
        if (recordKeys.length > fileRecordsProperties.length) {
            for (int i = 0; i < Math.abs(this.getDataBlockSize(InputTypes.FILE_IO)); ++i) {
                cleanedRecordNames.add(recordKeys[i]);
            }
            recordKeys = cleanedRecordNames.toArray(new String[1]);
        }
        return recordKeys;
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT1877", (Object[])GDE.MOD1));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT1877"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "importDeviceLogItem action performed! " + e);
                    DataVario.this.open_closeCommPort();
                }
            });
        }
    }
}

