/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog;

import gde.GDE;
import gde.data.Channel;
import gde.data.RecordSet;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.StringHelper;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TimeSetDialog
extends Dialog {
    static final Logger log = Logger.getLogger(TimeSetDialog.class.getName());
    private DataExplorer application;
    private Shell dialogShell;
    private Composite compositeYear;
    private Composite compositeMonth;
    private Composite compositeDay;
    private Composite compositeHour;
    private Composite compositeMinute;
    private Composite compositeSecond;
    private CCombo cComboYear;
    private CCombo cComboMonth;
    private CCombo cComboDay;
    private CCombo cComboHour;
    private CCombo cComboMinute;
    private CCombo cComboSecond;
    private Composite compositeButton;
    private Button buttonOK;
    private Composite compositeDataTime;
    private CLabel cLabelYear;
    private CLabel cLabelMonth;
    private CLabel cLabelDay;
    private CLabel cLabelHour;
    private CLabel cLabelMinute;
    private CLabel cLabelSecond;
    private GregorianCalendar calendar;

    public static void main(String[] args) {
        try {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            TimeSetDialog inst = new TimeSetDialog(shell, 0);
            inst.open(new Date().getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TimeSetDialog(Shell parent, int style) {
        super(parent, style);
    }

    public void open(long millis) {
        try {
            this.application = DataExplorer.getInstance();
            Shell parent = this.getParent();
            this.dialogShell = new Shell(parent, 67680);
            FillLayout dialogShellLayout = new FillLayout(512);
            this.dialogShell.setLayout((Layout)dialogShellLayout);
            this.dialogShell.setText(Messages.getString("GDE_MSGT0712"));
            this.dialogShell.layout();
            this.dialogShell.pack();
            this.dialogShell.setSize(GDE.IS_LINUX ? 410 : 340, 115);
            this.dialogShell.setImage(SWTResourceManager.getImage("gde/resource/TimeHot.gif"));
            this.dialogShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent evt) {
                    log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + evt);
                    RecordSet activeRecordSet = TimeSetDialog.this.application.getActiveRecordSet();
                    long timeStamp = TimeSetDialog.this.calendar.getTimeInMillis();
                    log.log(Level.FINEST, StringHelper.getFormatedTime("yyyy-MM-dd, HH:mm:ss", timeStamp));
                    if (activeRecordSet != null) {
                        String description = activeRecordSet.getRecordSetDescription();
                        description = description.substring(0, description.indexOf(58) + 2) + StringHelper.getFormatedTime("yyyy-MM-dd, HH:mm:ss ", timeStamp) + description.substring(description.indexOf(32, description.indexOf(58) + 12) + 1);
                        activeRecordSet.setRecordSetDescription(description);
                        activeRecordSet.setStartTimeStamp(timeStamp);
                        Channel activeChannel = TimeSetDialog.this.application.getActiveChannel();
                        if (activeChannel != null) {
                            description = activeChannel.getFileDescription();
                            description = description.contains(" - ") ? String.format("%s %s", StringHelper.getFormatedTime("yyyy-MM-dd", activeRecordSet.getStartTimeStamp()), description.substring(11)) : String.format("%s", StringHelper.getFormatedTime("yyyy-MM-dd", activeRecordSet.getStartTimeStamp()));
                            activeChannel.setFileDescription(description);
                        }
                        TimeSetDialog.this.application.updateAllTabs(true, true);
                        TimeSetDialog.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                    }
                }
            });
            this.compositeDataTime = new Composite((Composite)this.dialogShell, 0);
            RowLayout compositeDataTimeLayout = new RowLayout(256);
            this.compositeDataTime.setLayout((Layout)compositeDataTimeLayout);
            this.compositeYear = new Composite(this.compositeDataTime, 0);
            FillLayout compositeYearLayout = new FillLayout(512);
            RowData compositeYearLData = new RowData(GDE.IS_LINUX ? 75 : 60, 40);
            this.compositeYear.setLayoutData((Object)compositeYearLData);
            this.compositeYear.setLayout((Layout)compositeYearLayout);
            this.cLabelYear = new CLabel(this.compositeYear, 0x1000000);
            this.cLabelYear.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cLabelYear.setText(Messages.getString("GDE_MSGT0706"));
            this.cComboYear = new CCombo(this.compositeYear, 2048);
            this.cComboYear.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cComboYear.setSize(GDE.IS_LINUX ? 75 : 60, 30);
            this.cComboYear.setEditable(false);
            this.cComboYear.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "cComboYear.widgetSelected, event=" + evt);
                    TimeSetDialog.this.calendar.set(1, Integer.parseInt(TimeSetDialog.this.cComboYear.getText()));
                    TimeSetDialog.this.calendar.set(2, Integer.parseInt(TimeSetDialog.this.cComboMonth.getText()) - 1);
                    TimeSetDialog.this.calendar.set(5, Integer.parseInt(TimeSetDialog.this.cComboDay.getText()));
                    TimeSetDialog.this.calendar.set(11, Integer.parseInt(TimeSetDialog.this.cComboHour.getText()));
                    TimeSetDialog.this.calendar.set(12, Integer.parseInt(TimeSetDialog.this.cComboMinute.getText()));
                    TimeSetDialog.this.calendar.set(13, Integer.parseInt(TimeSetDialog.this.cComboSecond.getText()));
                }
            });
            this.compositeMonth = new Composite(this.compositeDataTime, 0);
            FillLayout compositeMonthLayout = new FillLayout(512);
            RowData compositeMonth1LData = new RowData(GDE.IS_LINUX ? 60 : 50, 40);
            this.compositeMonth.setLayoutData((Object)compositeMonth1LData);
            this.compositeMonth.setLayout((Layout)compositeMonthLayout);
            this.cLabelMonth = new CLabel(this.compositeMonth, 0x1000000);
            this.cLabelMonth.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cLabelMonth.setText(Messages.getString("GDE_MSGT0707"));
            this.cComboMonth = new CCombo(this.compositeMonth, 2048);
            this.cComboMonth.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cComboMonth.setItems(new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"});
            this.cComboMonth.setSize(GDE.IS_LINUX ? 60 : 50, 30);
            this.cComboMonth.setEditable(false);
            this.cComboMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "cComboMonth.widgetSelected, event=" + evt);
                    TimeSetDialog.this.calendar.set(1, Integer.parseInt(TimeSetDialog.this.cComboYear.getText()));
                    TimeSetDialog.this.calendar.set(2, Integer.parseInt(TimeSetDialog.this.cComboMonth.getText()) - 1);
                    TimeSetDialog.this.calendar.set(5, Integer.parseInt(TimeSetDialog.this.cComboDay.getText()));
                    TimeSetDialog.this.calendar.set(11, Integer.parseInt(TimeSetDialog.this.cComboHour.getText()));
                    TimeSetDialog.this.calendar.set(12, Integer.parseInt(TimeSetDialog.this.cComboMinute.getText()));
                    TimeSetDialog.this.calendar.set(13, Integer.parseInt(TimeSetDialog.this.cComboSecond.getText()));
                }
            });
            this.compositeDay = new Composite(this.compositeDataTime, 0);
            FillLayout compositeDayLayout = new FillLayout(512);
            RowData compositeDay2LData = new RowData(GDE.IS_LINUX ? 60 : 50, 40);
            this.compositeDay.setLayoutData((Object)compositeDay2LData);
            this.compositeDay.setLayout((Layout)compositeDayLayout);
            this.cLabelDay = new CLabel(this.compositeDay, 0x1000000);
            this.cLabelDay.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cLabelDay.setText(Messages.getString("GDE_MSGT0708"));
            this.cComboDay = new CCombo(this.compositeDay, 2048);
            this.cComboDay.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cComboDay.setItems(new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"});
            this.cComboDay.setSize(GDE.IS_LINUX ? 60 : 50, 30);
            this.cComboDay.setEditable(false);
            this.cComboDay.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "cComboDay.widgetSelected, event=" + evt);
                    TimeSetDialog.this.calendar.set(1, Integer.parseInt(TimeSetDialog.this.cComboYear.getText()));
                    TimeSetDialog.this.calendar.set(2, Integer.parseInt(TimeSetDialog.this.cComboMonth.getText()) - 1);
                    TimeSetDialog.this.calendar.set(5, Integer.parseInt(TimeSetDialog.this.cComboDay.getText()));
                    TimeSetDialog.this.calendar.set(11, Integer.parseInt(TimeSetDialog.this.cComboHour.getText()));
                    TimeSetDialog.this.calendar.set(12, Integer.parseInt(TimeSetDialog.this.cComboMinute.getText()));
                    TimeSetDialog.this.calendar.set(13, Integer.parseInt(TimeSetDialog.this.cComboSecond.getText()));
                }
            });
            this.compositeHour = new Composite(this.compositeDataTime, 0);
            FillLayout compositeHourLayout = new FillLayout(512);
            RowData compositeHour3LData = new RowData(GDE.IS_LINUX ? 60 : 50, 40);
            this.compositeHour.setLayoutData((Object)compositeHour3LData);
            this.compositeHour.setLayout((Layout)compositeHourLayout);
            this.cLabelHour = new CLabel(this.compositeHour, 0x1000000);
            this.cLabelHour.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cLabelHour.setText(Messages.getString("GDE_MSGT0709"));
            this.cComboHour = new CCombo(this.compositeHour, 2048);
            this.cComboHour.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cComboHour.setItems(new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"});
            this.cComboHour.select(14);
            this.cComboHour.setSize(GDE.IS_LINUX ? 60 : 50, 30);
            this.cComboHour.setEditable(false);
            this.cComboHour.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "cComboHour.widgetSelected, event=" + evt);
                    TimeSetDialog.this.calendar.set(1, Integer.parseInt(TimeSetDialog.this.cComboYear.getText()));
                    TimeSetDialog.this.calendar.set(2, Integer.parseInt(TimeSetDialog.this.cComboMonth.getText()) - 1);
                    TimeSetDialog.this.calendar.set(5, Integer.parseInt(TimeSetDialog.this.cComboDay.getText()));
                    TimeSetDialog.this.calendar.set(11, Integer.parseInt(TimeSetDialog.this.cComboHour.getText()));
                    TimeSetDialog.this.calendar.set(12, Integer.parseInt(TimeSetDialog.this.cComboMinute.getText()));
                    TimeSetDialog.this.calendar.set(13, Integer.parseInt(TimeSetDialog.this.cComboSecond.getText()));
                }
            });
            Vector<String> tmp60 = new Vector<String>();
            for (int i = 0; i < 60; ++i) {
                tmp60.add(String.format("%02d", i));
            }
            this.compositeMinute = new Composite(this.compositeDataTime, 0);
            FillLayout compositeMinuteLayout = new FillLayout(512);
            RowData compositeMinute4LData = new RowData(GDE.IS_LINUX ? 60 : 50, 40);
            this.compositeMinute.setLayoutData((Object)compositeMinute4LData);
            this.compositeMinute.setLayout((Layout)compositeMinuteLayout);
            this.cLabelMinute = new CLabel(this.compositeMinute, 0x1000000);
            this.cLabelMinute.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cLabelMinute.setText(Messages.getString("GDE_MSGT0710"));
            this.cComboMinute = new CCombo(this.compositeMinute, 2048);
            this.cComboMinute.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cComboMinute.setItems(tmp60.toArray(new String[0]));
            this.cComboMinute.select(32);
            this.cComboMinute.setSize(GDE.IS_LINUX ? 60 : 50, 30);
            this.cComboMinute.setEditable(false);
            this.cComboMinute.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "cComboMinute.widgetSelected, event=" + evt);
                    TimeSetDialog.this.calendar.set(1, Integer.parseInt(TimeSetDialog.this.cComboYear.getText()));
                    TimeSetDialog.this.calendar.set(2, Integer.parseInt(TimeSetDialog.this.cComboMonth.getText()) - 1);
                    TimeSetDialog.this.calendar.set(5, Integer.parseInt(TimeSetDialog.this.cComboDay.getText()));
                    TimeSetDialog.this.calendar.set(11, Integer.parseInt(TimeSetDialog.this.cComboHour.getText()));
                    TimeSetDialog.this.calendar.set(12, Integer.parseInt(TimeSetDialog.this.cComboMinute.getText()));
                    TimeSetDialog.this.calendar.set(13, Integer.parseInt(TimeSetDialog.this.cComboSecond.getText()));
                }
            });
            this.compositeSecond = new Composite(this.compositeDataTime, 0);
            FillLayout compositeSecondLayout = new FillLayout(512);
            RowData compositeSecondLData = new RowData(GDE.IS_LINUX ? 60 : 50, 40);
            this.compositeSecond.setLayoutData((Object)compositeSecondLData);
            this.compositeSecond.setLayout((Layout)compositeSecondLayout);
            this.cLabelSecond = new CLabel(this.compositeSecond, 0x1000000);
            this.cLabelSecond.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cLabelSecond.setText(Messages.getString("GDE_MSGT0711"));
            this.cComboSecond = new CCombo(this.compositeSecond, 2048);
            this.cComboSecond.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.cComboSecond.setItems(tmp60.toArray(new String[0]));
            this.cComboSecond.select(0);
            this.cComboSecond.setSize(GDE.IS_LINUX ? 60 : 50, 30);
            this.cComboSecond.setEditable(false);
            this.cComboSecond.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "cComboSecond.widgetSelected, event=" + evt);
                    TimeSetDialog.this.calendar.set(1, Integer.parseInt(TimeSetDialog.this.cComboYear.getText()));
                    TimeSetDialog.this.calendar.set(2, Integer.parseInt(TimeSetDialog.this.cComboMonth.getText()) - 1);
                    TimeSetDialog.this.calendar.set(5, Integer.parseInt(TimeSetDialog.this.cComboDay.getText()));
                    TimeSetDialog.this.calendar.set(11, Integer.parseInt(TimeSetDialog.this.cComboHour.getText()));
                    TimeSetDialog.this.calendar.set(12, Integer.parseInt(TimeSetDialog.this.cComboMinute.getText()));
                    TimeSetDialog.this.calendar.set(13, Integer.parseInt(TimeSetDialog.this.cComboSecond.getText()));
                }
            });
            this.compositeButton = new Composite((Composite)this.dialogShell, 0);
            GridLayout compositeButtonLayout = new GridLayout();
            compositeButtonLayout.makeColumnsEqualWidth = true;
            this.compositeButton.setLayout((Layout)compositeButtonLayout);
            this.buttonOK = new Button(this.compositeButton, 0x1000008);
            GridData buttonOKLData = new GridData();
            buttonOKLData.horizontalAlignment = 2;
            buttonOKLData.grabExcessHorizontalSpace = true;
            buttonOKLData.verticalAlignment = 4;
            buttonOKLData.widthHint = 48;
            buttonOKLData.grabExcessVerticalSpace = true;
            this.buttonOK.setLayoutData((Object)buttonOKLData);
            this.buttonOK.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.buttonOK.setText("OK");
            this.buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "buttonOK.widgetSelected, event=" + evt);
                    TimeSetDialog.this.dialogShell.dispose();
                }
            });
            this.calendar = new GregorianCalendar();
            this.calendar.setTimeInMillis(millis);
            Vector<String> tmpYears = new Vector<String>();
            for (int i = 0; i <= this.calendar.get(1) - 2000; ++i) {
                tmpYears.add(String.format("%s", i + 2000));
            }
            this.cComboYear.setItems(tmpYears.toArray(new String[0]));
            this.cComboYear.select(this.calendar.get(1) - 2000);
            this.cComboMonth.select(this.calendar.get(2));
            this.cComboDay.select(this.calendar.get(5) - 1);
            this.cComboHour.select(this.calendar.get(11));
            this.cComboMinute.select(this.calendar.get(12));
            this.dialogShell.setLocation(this.getParent().toDisplay(100, 100));
            this.dialogShell.open();
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

