/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.datasources;

import com.sun.istack.Nullable;
import gde.Analyzer;
import gde.config.DeviceConfigurations;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.VaultCollector;
import gde.histo.datasources.SourceFolders;
import gde.histo.datasources.VaultChecker;
import gde.histo.device.IHistoDevice;
import gde.histo.io.HistoOsdReaderWriter;
import gde.histo.utils.PathUtils;
import gde.io.FileHandler;
import gde.log.Logger;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Stream;

public abstract class SourceDataSet {
    private static final String $CLASS_NAME = SourceDataSet.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    protected final Path filePath;
    protected final Analyzer analyzer;

    public boolean isWorkableFile(Set<SourceFolders.DirectoryType> directoryTypes, SourceFolders sourceFolders) {
        return new VaultChecker(this.analyzer).isWorkableDataSet(this.filePath, directoryTypes, sourceFolders);
    }

    protected SourceDataSet(Path filePath, Analyzer analyzer) {
        this.filePath = filePath;
        this.analyzer = analyzer;
    }

    public abstract boolean providesReaderSettings();

    public abstract Path getActualFile();

    public abstract void loadFile(Path var1, String var2);

    public abstract String getLinkPath();

    protected String getObjectKey() {
        String dirName = this.filePath.getParent().getFileName().toString();
        DeviceConfigurations deviceConfigurations = this.analyzer.getDeviceConfigurations();
        return !deviceConfigurations.contains(dirName) ? dirName : "";
    }

    public abstract Stream<VaultCollector> getSelectedTrusses(VaultChecker var1);

    public abstract void readVaults4Ui(Path var1, List<VaultCollector> var2);

    public boolean load(String desiredRecordSetName) {
        if (!this.analyzer.getDataAccess().existsSourceFile(this.filePath)) {
            return false;
        }
        this.loadFile(this.filePath, desiredRecordSetName);
        return true;
    }

    public Path getPath() {
        return this.filePath;
    }

    protected String getRecordSetExtend() {
        String recordSetNameExtend;
        block6: {
            String fileName = this.filePath.getFileName().toString();
            recordSetNameExtend = "";
            if (fileName.contains("_")) {
                try {
                    Integer.parseInt(fileName.substring(0, fileName.lastIndexOf(95)));
                    recordSetNameExtend = " [" + fileName.substring(0, fileName.lastIndexOf(95)) + "]";
                }
                catch (Exception e) {
                    if (fileName.substring(0, fileName.lastIndexOf(95)).length() <= 8) {
                        recordSetNameExtend = " [" + fileName.substring(0, fileName.lastIndexOf(95)) + "]";
                    }
                    break block6;
                }
            }
            try {
                Integer.parseInt(fileName.substring(0, 4));
                recordSetNameExtend = " [" + fileName.substring(0, 4) + "]";
            }
            catch (Exception e) {
                if (fileName.substring(0, fileName.length()).length() > 12) break block6;
                recordSetNameExtend = " [" + fileName.substring(0, fileName.length() - 4) + "]";
            }
        }
        return recordSetNameExtend;
    }

    public String toString() {
        return this.filePath.toString();
    }

    @Nullable
    public static SourceDataSet createSourceDataSet(Path filePath, Analyzer analyzer) {
        List<String> importExtentions;
        log.log(Level.FINE, "started");
        String extention = PathUtils.getFileExtention(filePath);
        if (extention.equals(".osd")) {
            return new OsdDataSet(filePath, analyzer);
        }
        if (analyzer.getActiveDevice() instanceof IHistoDevice && (importExtentions = ((IHistoDevice)((Object)analyzer.getActiveDevice())).getSupportedImportExtentions()).contains(extention)) {
            return new ImportDataSet(filePath, analyzer);
        }
        return null;
    }

    private static final class OsdDataSet
    extends SourceDataSet {
        private static final Logger log = Logger.getLogger(OsdDataSet.class.getName());
        protected Path actualFile = null;
        private boolean isActualFileVerified = false;

        protected OsdDataSet(Path filePath, Analyzer analyzer) {
            super(filePath, analyzer);
        }

        @Override
        public Stream<VaultCollector> getSelectedTrusses(VaultChecker vaultChecker) {
            return this.getTrusses().stream().filter(t -> vaultChecker.matchDeviceChannelObjectAndStart(t.getVault()));
        }

        private List<VaultCollector> getTrusses() {
            List<VaultCollector> trusses = new ArrayList<VaultCollector>();
            if (this.getActualFile() != null) {
                String objectDirectory = this.getObjectKey();
                try (InputStream sourceInputStream = this.analyzer.getDataAccess().getSourceInputStream(this.getActualFile());){
                    trusses = HistoOsdReaderWriter.readTrusses(sourceInputStream, this.getActualFile(), objectDirectory, this.analyzer);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, this.getActualFile() + " - " + e.getMessage(), e);
                }
                for (VaultCollector truss : trusses) {
                    truss.getVault().setLoadLinkPath(Paths.get(this.getLinkPath(), new String[0]));
                    truss.getVault().setLogLinkPath(this.getLinkPath());
                    truss.setSourceDataSet(this);
                }
            }
            return trusses;
        }

        @Override
        public void readVaults4Ui(Path sourcePath, List<VaultCollector> trusses) {
            try (InputStream sourceInputStream = this.analyzer.getDataAccess().getSourceInputStream(sourcePath);){
                HistoOsdReaderWriter.readVaults(sourceInputStream, trusses, this.analyzer);
            }
            catch (Exception e) {
                log.log(Level.WARNING, String.format("invalid file format: %s  channelNumber=%d  %s", this.analyzer.getActiveDevice().getName(), this.analyzer.getActiveChannel().getNumber(), sourcePath));
            }
        }

        @Override
        public boolean providesReaderSettings() {
            return false;
        }

        @Override
        @Nullable
        public Path getActualFile() {
            if (this.actualFile == null && !this.isActualFileVerified) {
                this.setActualFile();
            }
            return this.actualFile;
        }

        protected void setActualFile() {
            this.actualFile = this.analyzer.getDataAccess().getActualSourceFile(this.filePath);
            this.isActualFileVerified = true;
        }

        @Override
        public String getLinkPath() {
            String linkPath = !this.filePath.toAbsolutePath().equals(this.getActualFile().toAbsolutePath()) ? this.filePath.toString() : "";
            return linkPath;
        }

        @Override
        public void loadFile(Path tmpPath, String desiredRecordSetName) {
            new FileHandler().openOsdFile(tmpPath.toString(), desiredRecordSetName);
        }
    }

    private static final class ImportDataSet
    extends SourceDataSet {
        private static final Logger log = Logger.getLogger(ImportDataSet.class.getName());

        protected ImportDataSet(Path filePath, Analyzer analyzer) {
            super(filePath, analyzer);
        }

        @Override
        public Stream<VaultCollector> getSelectedTrusses(VaultChecker vaultChecker) {
            return this.getTrusses().stream().filter(t -> vaultChecker.matchObjectAndStart(t.getVault()));
        }

        private List<VaultCollector> getTrusses() {
            String objectDirectory = this.getObjectKey();
            String recordSetBaseName = this.analyzer.getActiveChannel().getChannelConfigKey() + this.getRecordSetExtend();
            VaultCollector truss = new VaultCollector(objectDirectory, this.filePath, 0, this.analyzer.getChannels().size(), recordSetBaseName, this.analyzer, this.providesReaderSettings());
            truss.setSourceDataSet(this);
            return new ArrayList<VaultCollector>(Arrays.asList(truss));
        }

        @Override
        public void readVaults4Ui(Path sourcePath, List<VaultCollector> trusses) {
            if (trusses.isEmpty()) {
                throw new IllegalArgumentException("at least one trusses entry is required");
            }
            ArrayList<ExtendedVault> histoVaults = new ArrayList<ExtendedVault>();
            String loadFilePath = trusses.get(0).getVault().getLoadFilePath();
            for (VaultCollector truss : trusses) {
                if (truss.getVault().getLoadFilePath().equals(loadFilePath)) {
                    Supplier<InputStream> inputStream = () -> this.analyzer.getDataAccess().getSourceInputStream(sourcePath);
                    try {
                        ((IHistoDevice)((Object)this.analyzer.getActiveDevice())).getRecordSetFromImportFile(inputStream, truss, this.analyzer);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, String.format("invalid file format: %s  channelNumber=%d  %s", this.analyzer.getActiveDevice().getName(), this.analyzer.getActiveChannel().getNumber(), sourcePath));
                    }
                    histoVaults.add(truss.getVault());
                    continue;
                }
                throw new UnsupportedOperationException("all trusses must carry the same logFilePath");
            }
        }

        @Override
        public boolean providesReaderSettings() {
            return true;
        }

        @Override
        public Path getActualFile() {
            return this.filePath;
        }

        @Override
        public String getLinkPath() {
            return "";
        }

        @Override
        public void loadFile(Path tmpPath, String desiredRecordSetName) {
            ((IHistoDevice)((Object)this.analyzer.getActiveDevice())).importDeviceData(tmpPath);
        }
    }
}

