/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.mdlviewer.swt;

import de.treichels.hott.mdlviewer.swt.MdlTabItemComposite;
import de.treichels.hott.mdlviewer.swt.SWTResourceManager;
import de.treichels.hott.util.Util;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class SwtMdlBrowser
extends Composite {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("windows");
    private static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase().startsWith("linux");
    private static final boolean IS_MAC = System.getProperty("os.name").toLowerCase().startsWith("mac");
    static final int WIDGET_FONT_SIZE = IS_MAC ? 12 : (IS_LINUX ? 8 : 9) * 96 / Display.getDefault().getDPI().y;
    static final String WIDGET_FONT_NAME = IS_WINDOWS ? "Microsoft Sans Serif" : "Sans Serif";

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        SwtMdlBrowser inst = new SwtMdlBrowser(shell);
        Point size = inst.getSize();
        shell.setLayout(new FillLayout());
        shell.setText("Graupner/SJ - MDL Browser");
        shell.layout();
        if (size.x == 0 && size.y == 0) {
            inst.pack();
            shell.pack();
        } else {
            Rectangle shellBounds = shell.computeTrim(0, 0, size.x, size.y);
            shell.setSize(shellBounds.width, shellBounds.height);
        }
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private SwtMdlBrowser(Composite parent) {
        super(parent, 0);
        SWTResourceManager.registerResourceUser(this);
        this.initGUI();
    }

    private void initGUI() {
        block2: {
            try {
                this.setSize(650, 480);
                this.setBackground(SWTResourceManager.getColor(192, 192, 192));
                this.setFont(SWTResourceManager.getFont(WIDGET_FONT_SIZE + 2));
                FillLayout thisLayout = new FillLayout(256);
                this.setLayout(thisLayout);
                new MdlTabItemComposite(this);
                this.layout();
            }
            catch (Exception e) {
                if (!Util.INSTANCE.getDEBUG()) break block2;
                e.printStackTrace();
            }
        }
    }
}

