/*
 * Decompiled with CFR 0.152.
 */
package gde.device.bantam;

import gde.comm.DeviceCommPort;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.exception.TimeOutException;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import gde.utils.StringHelper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EStationSerialPort
extends DeviceCommPort {
    static final String $CLASS_NAME = EStationSerialPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    boolean isInSync = false;

    public EStationSerialPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
    }

    public synchronized byte[] getData() throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO))];
        byte[] answer = new byte[]{0};
        try {
            answer = new byte[data.length];
            answer = this.read(data, 5000);
            while (answer.length > 0 && answer[0] != 123) {
                this.isInSync = false;
                for (int i = 1; i < answer.length; ++i) {
                    if (answer[i] != 123) continue;
                    System.arraycopy(answer, i, data, 0, data.length - i);
                    answer = new byte[i];
                    answer = this.read(answer, 3000);
                    System.arraycopy(answer, 0, data, data.length - i, i);
                    this.isInSync = true;
                    if (!log.isLoggable(gde.log.Level.FINE)) break;
                    log.logp(Level.FINE, $CLASS_NAME, "getData", "----> receive sync finished");
                    break;
                }
                if (this.isInSync) break;
                answer = new byte[data.length];
                answer = this.read(answer, 3000);
            }
            if (log.isLoggable(gde.log.Level.FINE)) {
                StringBuilder sb = new StringBuilder();
                for (byte b : data) {
                    sb.append(String.format("0x%02x, ", b));
                }
                log.logp(gde.log.Level.FINE, $CLASS_NAME, "getData", sb.toString());
            }
            if (data.length > 0 && !this.isChecksumOK(data)) {
                this.addXferError();
                log.logp(gde.log.Level.WARNING, $CLASS_NAME, "getData", "=====> checksum error occured, number of errors = " + this.getXferErrors());
                data = this.getData();
            }
            if (log.isLoggable(gde.log.Level.FINE)) {
                log.logp(gde.log.Level.FINE, $CLASS_NAME, "getData", StringHelper.byte2FourDigitsIntegerString((byte[])data, (byte)-128, (int)1, (int)(data.length - 4)));
            }
        }
        catch (Exception e) {
            if (!(e instanceof TimeOutException)) {
                log.logp(gde.log.Level.SEVERE, $CLASS_NAME, "getData", e.getMessage(), e);
            }
            throw e;
        }
        return data;
    }

    private boolean isChecksumOK(byte[] buffer) {
        String $METHOD_NAME = "isChecksumOK";
        boolean isOK = false;
        switch (buffer.length) {
            default: {
                int check_sum = Checksum.ADD((byte[])buffer, (int)1, (int)72);
                if (((check_sum & 0xF0) >> 4) + 48 != (buffer[73] & 0x17F) || (check_sum & 0xF) + 48 != (buffer[74] & 0xFF)) break;
                isOK = true;
                break;
            }
            case 112: {
                int check_sum = Checksum.ADD((byte[])buffer, (int)1, (int)(buffer.length - 4));
                if (((check_sum & 0xF0) >> 4) + 48 != (buffer[buffer.length - 3] & 0x17F) || (check_sum & 0xF) + 48 != (buffer[buffer.length - 2] & 0xFF)) break;
                isOK = true;
            }
        }
        log.logp(gde.log.Level.FINER, $CLASS_NAME, "isChecksumOK", "Check_sum = " + isOK);
        return isOK;
    }
}

