/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui.datasources;

import gde.Analyzer;
import gde.DataAccess;
import gde.config.Settings;
import gde.histo.datasources.SourceDataSet;
import gde.log.Logger;
import gde.messages.Messages;
import gde.utils.FileUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SupplementObjectFolder {
    private static final String $CLASS_NAME = SupplementObjectFolder.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final String SUPPLEMENT_DIR_NAME = "_SupplementObjectDirs";
    private static final String README_NAME = "README.TXT";
    private static final String REPORT_NAME = "report.txt";
    private static final int PATHS_MESSAGE_LINES = 22;
    private static final long MIRROR_CYCLE_MS = 60000L;
    private static long mirrorUpdate_ms = System.currentTimeMillis() - 60000L;
    private final Analyzer analyzer;
    private final Path supplementFolder = SupplementObjectFolder.getSupplementObjectsPath();
    private final Set<String> logFileExtentions;

    public static void checkAndCreate() {
        Path objectsPath = SupplementObjectFolder.getSupplementObjectsPath();
        FileUtils.checkDirectoryAndCreate(objectsPath.toString());
        FileUtils.extract(SupplementObjectFolder.class, README_NAME, "resource/", objectsPath.toString(), "555");
    }

    public static Path getSupplementObjectsPath() {
        return Paths.get(Settings.getInstance().getDataFilePath(), SUPPLEMENT_DIR_NAME);
    }

    static Path getTargetBasePath(Path externalPath) {
        if (externalPath.toString().isEmpty()) {
            throw new IllegalArgumentException("empty mirror property string");
        }
        String finalPath = externalPath.toString().replace('/', '_').replaceAll(Matcher.quoteReplacement("\\"), "_").replace(':', '_');
        if (finalPath.substring(0, 1) != "_") {
            finalPath = "_" + finalPath;
        }
        if (finalPath.substring(1, 2) != "_") {
            finalPath = "_" + finalPath;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "finalPath=" + finalPath + "  from " + externalPath.toString());
        }
        return Paths.get(finalPath, new String[0]);
    }

    private static Stream<Path> getMirrorSourceFolders() {
        String sourceFoldersCsv = Settings.getInstance().getMirrorSourceFoldersCsv();
        if (sourceFoldersCsv.isEmpty()) {
            return Stream.empty();
        }
        try {
            return Arrays.stream(sourceFoldersCsv.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0]));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return Stream.empty();
        }
    }

    public static void updateLogMirror() {
        if (mirrorUpdate_ms + 60000L > System.currentTimeMillis()) {
            return;
        }
        mirrorUpdate_ms = System.currentTimeMillis();
        SupplementObjectFolder instance = new SupplementObjectFolder(Analyzer.getInstance());
        Thread rebuildThread = new Thread(() -> instance.rebuildLogMirror(), "rebuildLogMirror");
        try {
            rebuildThread.start();
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    static void updateLogMirrorSync() {
        SupplementObjectFolder instance = new SupplementObjectFolder(Analyzer.getInstance());
        instance.rebuildLogMirror();
    }

    public static String resetFolders() {
        String message = "";
        Path objectsPath = SupplementObjectFolder.getSupplementObjectsPath();
        int initialSize_MiB = (int)(FileUtils.size(objectsPath) / 1024L / 1024L);
        Stream<String> realObjectKeys = Settings.getInstance().getRealObjectKeys();
        StringBuilder sb = new StringBuilder("  in ").append(objectsPath.toString()).append(" : ");
        try (Stream<Path> stream = DataAccess.getInstance().getSourceFolders(objectsPath, realObjectKeys);){
            int[] i = new int[]{0};
            stream.sorted(Comparator.reverseOrder()).forEach(p -> {
                FileUtils.deleteDirectory(p.toString());
                i[0] = i[0] + 1;
                if (i[0] < 22) {
                    sb.append("\n").append(" ").append(objectsPath.relativize((Path)p));
                } else if (i[0] == 22) {
                    sb.append("\n").append(" ").append(objectsPath.relativize((Path)p)).append("\n").append("...");
                }
            });
            Thread.sleep(11L);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return "File access error";
        }
        int deletedSize_MiB = (int)(FileUtils.size(objectsPath) / 1024L / 1024L);
        message = Messages.getString("GDE_MSGT0924", new Object[]{initialSize_MiB, deletedSize_MiB, sb.toString()});
        log.log(Level.FINE, message);
        return message;
    }

    private static void writeReportFile(Path sourceDir, Path targetDir, long millis, long fileCounterPriorCopy, int copyCounter, long freeSpacePriorCopy_MiB) {
        long fileCounterPostCopy;
        try (Stream<Path> stream = Files.list(targetDir);){
            fileCounterPostCopy = stream.count();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        long freeSpaceAfterCopy_MiB = targetDir.toFile().getFreeSpace() / 1024L / 1024L;
        String result = String.format("sourceDir=%s\ntargetDir=%s\nnumberOfFiles   : prior=%,d post=%,d copyAttempts=%,d\nfreeSpace [MiB] : prior=%,d post=%,d\nduration [ms]   : elapsed=%,d\nupdated=%s", sourceDir, targetDir, fileCounterPriorCopy, fileCounterPostCopy, copyCounter, freeSpacePriorCopy_MiB, freeSpaceAfterCopy_MiB, millis, Instant.now().toString());
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(targetDir.resolve(REPORT_NAME).toFile()), "UTF-8");){
            out.write(result);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static void appendReportFile(Path targetDir) {
        String result = String.format("\nchecked=%s", Instant.now().toString());
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(targetDir.resolve(REPORT_NAME).toFile(), true), "UTF-8");){
            out.write(result);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private SupplementObjectFolder(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.logFileExtentions = analyzer.getDeviceConfigurations().getValidLogExtentions();
        FileUtils.checkDirectoryAndCreate(this.supplementFolder.toString());
    }

    private void rebuildLogMirror() {
        log.log(Level.FINEST, "start rebuildLogMirror");
        long startNanoTime = System.nanoTime();
        SupplementObjectFolder.getMirrorSourceFolders().forEach(f -> {
            log.log(Level.INFO, "externalBaseDir=", f);
            this.rebuildLogMirror((Path)f);
        });
        log.time(() -> String.format("  %3d mirror paths scanned          time=%,6d [ms]", SupplementObjectFolder.getMirrorSourceFolders().count(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanoTime + 500000L)));
    }

    private void rebuildLogMirror(Path externalBaseDir) {
        Path targetBaseDir = this.supplementFolder.resolve(SupplementObjectFolder.getTargetBasePath(externalBaseDir));
        List<Object> result = new ArrayList();
        try (Stream<Path> objectPaths = this.analyzer.getDataAccess().getSourceFolders(externalBaseDir, Settings.getInstance().getRealObjectKeys());){
            result = objectPaths.collect(Collectors.toList());
            for (Path path : result) {
                log.log(Level.FINER, "sourcePath=", path);
                Path relativeSubPath = externalBaseDir.relativize(path);
                this.copyDirectoryFiles(path, targetBaseDir.resolve(relativeSubPath));
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.getMessage(), " is not accessible : " + e.getClass());
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDirectoryFiles(Path srcDir, Path targetDir) throws IOException {
        long fileCounterPriorCopy;
        long startNanoTime = System.nanoTime();
        int copyCounter = 0;
        long freeSpacePriorCopy_MiB = targetDir.getRoot().toFile().getFreeSpace() / 1024L / 1024L;
        if (targetDir.toFile().exists()) {
            try (Stream<Path> stream = Files.list(targetDir);){
                fileCounterPriorCopy = stream.count();
            }
        } else {
            fileCounterPriorCopy = -1L;
        }
        CopyOption[] options = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
        try (DirectoryStream<Path> files = Files.newDirectoryStream(srcDir);){
            for (Path f : files) {
                SourceDataSet sourceDataSet;
                boolean isLogFile;
                if (f.toFile().isDirectory() || !(isLogFile = this.logFileExtentions.parallelStream().anyMatch(s -> f.getFileName().toString().toLowerCase().endsWith((String)s)))) continue;
                Path targetPath = targetDir.resolve(f.getFileName());
                FileUtils.checkDirectoryAndCreate(targetDir.toString());
                if (targetPath.toFile().exists() || (sourceDataSet = SourceDataSet.createSourceDataSet(f, this.analyzer)) == null) continue;
                try {
                    Files.copy(sourceDataSet.getActualFile(), targetPath, options);
                    ++copyCounter;
                    log.log(Level.FINE, "copy done ", targetPath);
                }
                catch (AccessDeniedException e) {
                    log.log(Level.WARNING, "File copy problem", e.getMessage() + " " + targetPath);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "OSD link file problem", e.getMessage() + " " + targetPath);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (targetDir.toFile().exists()) {
                if (copyCounter > 0) {
                    SupplementObjectFolder.writeReportFile(srcDir, targetDir, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanoTime + 500000L), fileCounterPriorCopy, copyCounter, freeSpacePriorCopy_MiB);
                } else if (fileCounterPriorCopy > 0L) {
                    try (Stream<Path> stream = Files.list(targetDir);){
                        boolean anyFiles = stream.anyMatch(p -> !p.toFile().isDirectory());
                        if (anyFiles) {
                            SupplementObjectFolder.appendReportFile(targetDir);
                        }
                    }
                }
            }
        }
    }
}

