/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    int detail;
    boolean dragSent;

    public Slider(Composite parent, int style) {
        super(parent, Slider.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Slider.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        this.gtk_widget_set_has_surface_or_window(this.fixedHandle, true);
        long hAdjustment = GTK.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 10.0);
        if (hAdjustment == 0L) {
            this.error(2);
        }
        this.handle = (this.style & 0x100) != 0 ? GTK.gtk_scrollbar_new(0, hAdjustment) : GTK.gtk_scrollbar_new(1, hAdjustment);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((this.style & 0x200) != 0) {
            GTK.gtk_widget_set_can_focus(this.handle, true);
        }
        GTK.gtk_container_add(this.fixedHandle, this.handle);
    }

    @Override
    long gtk_button_press_event(long widget, long eventPtr) {
        long result = super.gtk_button_press_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        this.detail = 0;
        this.dragSent = false;
        return result;
    }

    @Override
    boolean gtk_change_value(long widget, int scroll, double value, long user_data) {
        this.detail = scroll;
        return false;
    }

    @Override
    long gtk_value_changed(long adjustment) {
        Event event = new Event();
        this.dragSent = this.detail == 1;
        switch (this.detail) {
            case 0: {
                event.detail = 0;
                break;
            }
            case 1: {
                event.detail = 1;
                break;
            }
            case 14: {
                event.detail = 0x1000007;
                break;
            }
            case 15: {
                event.detail = 0x1000008;
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                event.detail = 0x1000006;
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                event.detail = 0x1000005;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                event.detail = 0x1000002;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                event.detail = 0x1000001;
            }
        }
        if (!this.dragSent) {
            this.detail = 0;
        }
        this.sendSelectionEvent(13, event, false);
        return 0L;
    }

    @Override
    long gtk_event_after(long widget, long gdkEvent) {
        int eventType = GDK.gdk_event_get_event_type(gdkEvent);
        eventType = Control.fixGdkEventTypeValues(eventType);
        switch (eventType) {
            case 7: {
                int[] eventButton = new int[1];
                if (GTK.GTK4) {
                    eventButton[0] = GDK.gdk_button_event_get_button(gdkEvent);
                } else {
                    GDK.gdk_event_get_button(gdkEvent, eventButton);
                }
                if (eventButton[0] == 1 && this.detail == 1) {
                    if (!this.dragSent) {
                        Event event = new Event();
                        event.detail = 1;
                        this.sendSelectionEvent(13, event, false);
                    }
                    this.sendSelectionEvent(13);
                }
                this.detail = 0;
                this.dragSent = false;
                break;
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.change_value, this.display.getClosure(7), false);
        OS.g_signal_connect_closure(this.handle, OS.value_changed, this.display.getClosure(57), false);
    }

    @Override
    void register() {
        super.register();
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        this.display.addWidget(hAdjustment, this);
    }

    @Override
    void deregister() {
        super.deregister();
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        this.display.removeWidget(hAdjustment);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        GTK.gtk_widget_realize(this.handle);
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if ((this.style & 0x100) != 0) {
            if (wHint == -1) {
                size.x = 2 * size.x;
            }
        } else if (hHint == -1) {
            size.y = 2 * size.y;
        }
        return size;
    }

    public int getIncrement() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        return (int)GTK.gtk_adjustment_get_step_increment(hAdjustment);
    }

    public int getMaximum() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        return (int)GTK.gtk_adjustment_get_upper(hAdjustment);
    }

    public int getMinimum() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        return (int)GTK.gtk_adjustment_get_lower(hAdjustment);
    }

    public int getPageIncrement() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        return (int)GTK.gtk_adjustment_get_page_increment(hAdjustment);
    }

    public int getSelection() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        return (int)GTK.gtk_adjustment_get_value(hAdjustment);
    }

    public int getThumb() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        return (int)GTK.gtk_adjustment_get_page_size(hAdjustment);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_range_set_increments(this.handle, value, this.getPageIncrement());
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        this.gtk_adjustment_get(hAdjustment, adjustment);
        int minimum = (int)adjustment.lower;
        if (value <= minimum) {
            return;
        }
        adjustment.upper = value;
        adjustment.page_size = Math.min((int)adjustment.page_size, value - minimum);
        adjustment.value = Math.min((int)adjustment.value, (int)((double)value - adjustment.page_size));
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_configure(hAdjustment, adjustment.value, adjustment.lower, adjustment.upper, adjustment.step_increment, adjustment.page_increment, adjustment.page_size);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        this.gtk_adjustment_get(hAdjustment, adjustment);
        int maximum = (int)adjustment.upper;
        if (value >= maximum) {
            return;
        }
        adjustment.lower = value;
        adjustment.page_size = Math.min((int)adjustment.page_size, maximum - value);
        adjustment.value = Math.max((int)adjustment.value, value);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_configure(hAdjustment, adjustment.value, adjustment.lower, adjustment.upper, adjustment.step_increment, adjustment.page_increment, adjustment.page_size);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if (!((this.style & 0x4000000) == 0 && create || (this.style & 0x100) == 0)) {
            GTK.gtk_range_set_inverted(this.handle, (this.style & 0x4000000) != 0);
        }
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_range_set_increments(this.handle, this.getIncrement(), value);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_range_set_value(this.handle, value);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        this.gtk_adjustment_get(hAdjustment, adjustment);
        value = Math.min(value, (int)(adjustment.upper - adjustment.lower));
        adjustment.page_size = value;
        adjustment.value = Math.min((int)adjustment.value, (int)(adjustment.upper - (double)value));
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_configure(hAdjustment, adjustment.value, adjustment.lower, adjustment.upper, adjustment.step_increment, adjustment.page_increment, adjustment.page_size);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        thumb = Math.min(thumb, maximum - minimum);
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        adjustment.value = Math.min(Math.max(selection, minimum), maximum - thumb);
        adjustment.lower = minimum;
        adjustment.upper = maximum;
        adjustment.page_size = thumb;
        adjustment.step_increment = increment;
        adjustment.page_increment = pageIncrement;
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_configure(hAdjustment, adjustment.value, adjustment.lower, adjustment.upper, adjustment.step_increment, adjustment.page_increment, adjustment.page_size);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }
}

