/*
 * Decompiled with CFR 0.152.
 */
package gde.device.elprog;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.ChannelTypes;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.exception.NotSupportedFileFormatException;
import gde.io.IDataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;

public class CSVSerialDataReaderWriter {
    static Logger log = Logger.getLogger(CSVSerialDataReaderWriter.class.getName());
    static String lineSep = GDE.LINE_SEPARATOR;
    static DecimalFormat df3 = new DecimalFormat("0.000");
    static StringBuffer sb;
    static final DataExplorer application;
    static final Channels channels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordSet read(String filePath, IDevice device, String recordNameExtend, Integer channelConfigNumber, IDataParser data) throws NotSupportedFileFormatException, IOException, DataInconsitsentException, DataTypeException {
        RecordSet channelRecordSet;
        block57: {
            String line = "*";
            Channel activeChannel = null;
            String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(new File(filePath).lastModified());
            long inputFileSize = new File(filePath).length();
            int progressLineLength = Math.abs(device.getDataBlockSize(InputTypes.FILE_IO));
            boolean isOutdated = false;
            int lineNumber = 0;
            int activeChannelConfigNumber = 1;
            String recordSetNameExtend = device.getRecordSetStemNameReplacement();
            channelRecordSet = null;
            int lastRecordSetNumberOffset = 0;
            Vector<RecordSet> createdRecordSets = new Vector<RecordSet>(1);
            boolean isCellInternalResistance = false;
            try {
                activeChannel = channelConfigNumber == null ? channels.getActiveChannel() : (Channel)channels.get((Object)channelConfigNumber);
                activeChannelConfigNumber = channels.getActiveChannelNumber();
                if (activeChannel == null) break block57;
                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0594") + filePath);
                GDE.getUiNotification().setProgress(0);
                activeChannelConfigNumber = activeChannel.getNumber();
                if (device.recordSetNumberFollowChannel() && activeChannel.size() != 0) {
                    application.getDeviceSelectionDialog().setupDataChannels(device);
                }
                String recordSetName = activeChannel.size() + 1 + recordSetNameExtend;
                int measurementSize = device.getNumberOfMeasurements(activeChannelConfigNumber);
                int dataBlockSize = device.getDataBlockSize(InputTypes.FILE_IO);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "measurementSize = " + measurementSize + "; dataBlockSize = " + dataBlockSize);
                }
                if (dataBlockSize < 0 && measurementSize > Math.abs(dataBlockSize)) {
                    throw new DevicePropertiesInconsistenceException(Messages.getString((String)"GDE_MSGE0041", (Object[])new String[]{filePath}));
                }
                DataInputStream binReader = new DataInputStream(new FileInputStream(new File(filePath)));
                byte[] buffer = new byte[1024];
                byte[] lineEnding = device.getDataBlockEnding();
                boolean lineEndingOcurred = false;
                int chars = binReader.read(buffer);
                for (int i = 0; i < chars; ++i) {
                    if (buffer[i] != lineEnding[0] || i >= chars - lineEnding.length - 1 || buffer[i + lineEnding.length + 1] == 35 || lineEnding.length > 1 && buffer[i + 1] != lineEnding[1]) continue;
                    lineEndingOcurred = true;
                }
                binReader.close();
                if (!lineEndingOcurred) {
                    throw new DevicePropertiesInconsistenceException(Messages.getString((String)"GDE_MSGE0042", (Object[])new Object[]{chars, filePath}));
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
                String line1 = reader.readLine();
                String line2 = reader.readLine();
                if (line1.startsWith("#") && line2.startsWith("!") || line2.startsWith("#") && line1.startsWith("!")) {
                    isCellInternalResistance = true;
                }
                reader.close();
                long lastTimeStamp = 0L;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
                if (device.getStateType() == null) {
                    throw new DevicePropertiesInconsistenceException(Messages.getString((String)"GDE_MSGE0043", (Object[])new Object[]{device.getPropertiesFileName()}));
                }
                while ((line = reader.readLine()) != null) {
                    int progress;
                    ++lineNumber;
                    if (line.startsWith("!")) {
                        data.parse(line, lineNumber);
                    } else {
                        data.parse(line, lineNumber);
                        if (isCellInternalResistance) continue;
                    }
                    try {
                        if (data.getChannelConfigNumber() > device.getChannelCount()) continue;
                        activeChannelConfigNumber = device.recordSetNumberFollowChannel() ? data.getChannelConfigNumber() : activeChannelConfigNumber;
                        activeChannel = (Channel)channels.get((Object)activeChannelConfigNumber);
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, device.getChannelCount() + " - data for channel = " + activeChannelConfigNumber + " state = " + data.getState());
                        }
                        recordSetNameExtend = device.getRecordSetStateNameReplacement(data.getState());
                        if (recordNameExtend.length() > 0) {
                            recordSetNameExtend = recordSetNameExtend + " " + "[" + recordNameExtend + "]";
                        }
                        channelRecordSet = (RecordSet)activeChannel.get((Object)(device.recordSetNumberFollowChannel() && activeChannel.getType() == ChannelTypes.TYPE_CONFIG ? activeChannel.getLastActiveRecordSetName() : recordSetName));
                    }
                    catch (Exception e) {
                        throw new DevicePropertiesInconsistenceException(Messages.getString((String)"GDE_MSGE0044", (Object[])new Object[]{data.getState(), filePath, device.getPropertiesFileName()}));
                    }
                    if (activeChannel.size() == 0 || channelRecordSet == null || !recordSetName.endsWith(" " + recordSetNameExtend) || lastRecordSetNumberOffset != data.getRecordSetNumberOffset()) {
                        if (lastRecordSetNumberOffset != data.getRecordSetNumberOffset() && channelRecordSet != null) {
                            if (channelRecordSet.get(0).size() < 3) {
                                channelRecordSet = (RecordSet)activeChannel.get((Object)recordSetName);
                                activeChannel.remove(recordSetName);
                                createdRecordSets.remove(channelRecordSet);
                                log.log(Level.WARNING, filePath + " - remove record set with < 3 data points, last line number = " + (lineNumber - 1));
                                activeChannel.put((Object)recordSetName, (Object)RecordSet.createRecordSet((String)recordSetName, (IDevice)application.getActiveDevice(), (int)activeChannelConfigNumber, (boolean)true, (boolean)false, (boolean)true));
                                createdRecordSets.add((RecordSet)activeChannel.get((Object)recordSetName));
                                recordSetName = channelRecordSet.getName();
                                if (activeChannel.getType() == ChannelTypes.TYPE_CONFIG) {
                                    activeChannel.applyTemplate(recordSetName, false);
                                } else {
                                    activeChannel.applyTemplateBasics(recordSetName);
                                }
                            } else {
                                channelRecordSet.checkAllDisplayable();
                                if (activeChannel.getType() == ChannelTypes.TYPE_CONFIG) {
                                    activeChannel.applyTemplate(recordSetName, false);
                                } else {
                                    activeChannel.applyTemplateBasics(recordSetName);
                                }
                                device.updateVisibilityStatus((RecordSet)activeChannel.get((Object)recordSetName), true);
                            }
                        } else {
                            int recordNumber = device.recordSetNumberFollowChannel() && activeChannel.getType() == ChannelTypes.TYPE_CONFIG ? activeChannel.getNextRecordSetNumber(activeChannelConfigNumber) : activeChannel.getNextRecordSetNumber();
                            recordSetName = recordNumber + ") " + recordSetNameExtend;
                            activeChannel.put((Object)recordSetName, (Object)RecordSet.createRecordSet((String)recordSetName, (IDevice)application.getActiveDevice(), (int)activeChannelConfigNumber, (boolean)true, (boolean)false, (boolean)true));
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, recordSetName + " created for channel " + activeChannel.getName());
                            }
                            if (activeChannel.getType() == ChannelTypes.TYPE_CONFIG) {
                                activeChannel.applyTemplate(recordSetName, false);
                            } else {
                                activeChannel.applyTemplateBasics(recordSetName);
                            }
                            activeChannel.setActiveRecordSet(recordSetName);
                            channelRecordSet = (RecordSet)activeChannel.get((Object)recordSetName);
                            createdRecordSets.add(channelRecordSet);
                            recordSetName = channelRecordSet.getName();
                        }
                        try {
                            isOutdated = Integer.parseInt(dateTime.split("-")[0]) <= 2000;
                        }
                        catch (Exception recordNumber) {
                            // empty catch block
                        }
                        for (String recordKey : device.getMeasurementNamesReplacements(activeChannelConfigNumber)) {
                            channelRecordSet.get((Object)recordKey).setDisplayable(true);
                        }
                        lastRecordSetNumberOffset = data.getRecordSetNumberOffset();
                    }
                    if (data.getTime_ms() - lastTimeStamp >= 0L) {
                        channelRecordSet.addNoneCalculationRecordsPoints(data.getValues(), (double)data.getTime_ms());
                        data.setTimeResetEnabled(true);
                        lastTimeStamp = data.getTime_ms();
                    }
                    if ((progress = (int)((long)(lineNumber * 100) / (inputFileSize / (long)(progressLineLength = progressLineLength > line.length() ? progressLineLength : line.length())))) > 90 || progress <= GDE.getUiNotification().getProgressPercentage() || progress % 10 != 0) continue;
                    GDE.getUiNotification().setProgress(progress);
                    try {
                        Thread.sleep(2L);
                    }
                    catch (Exception exception) {}
                }
                GDE.getUiNotification().setProgress(100);
                Iterator iterator = createdRecordSets.iterator();
                while (iterator.hasNext()) {
                    RecordSet tmpRecordSet = (RecordSet)iterator.next();
                    if (tmpRecordSet.get(0).realSize() < 3) {
                        ((Channel)channels.get((Object)tmpRecordSet.getChannelConfigNumber())).remove(recordSetName);
                        log.log(Level.WARNING, filePath + " - remove record set " + tmpRecordSet.getName() + " with < 3 data points, last line number = " + (lineNumber - 1));
                        iterator.remove();
                    } else {
                        if (!isOutdated) {
                            long startTimeStamp = (long)((double)new File(filePath).lastModified() - tmpRecordSet.getMaxTime_ms());
                            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp));
                            tmpRecordSet.setStartTimeStamp(startTimeStamp);
                        } else {
                            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(new Date()));
                        }
                        tmpRecordSet.checkAllDisplayable();
                        device.updateVisibilityStatus(tmpRecordSet, true);
                    }
                    tmpRecordSet.descriptionAppendFilename(filePath.substring(filePath.lastIndexOf(47) + 1));
                }
                if (GDE.isWithUi()) {
                    if (createdRecordSets.size() == 1) {
                        channels.switchChannel(activeChannelConfigNumber, ((RecordSet)createdRecordSets.firstElement()).getName());
                    } else if (createdRecordSets.size() > 1 && !device.recordSetNumberFollowChannel()) {
                        channels.switchChannel(activeChannelConfigNumber, ((RecordSet)createdRecordSets.lastElement()).getName());
                    } else {
                        channels.switchChannel(1, "");
                    }
                }
                reader.close();
                reader = null;
            }
            catch (FileNotFoundException e) {
                log.log(Level.WARNING, e.getMessage(), e);
                application.openMessageDialog(e.getMessage());
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.getMessage(), e);
                application.openMessageDialog(e.getMessage());
            }
            catch (Exception e) {
                if (activeChannel != null && activeChannel.size() > 0) {
                    String recordSetName = activeChannel.getFirstRecordSetName();
                    activeChannel.setActiveRecordSet(recordSetName);
                    device.updateVisibilityStatus((RecordSet)activeChannel.get((Object)recordSetName), true);
                    ((RecordSet)activeChannel.get((Object)recordSetName)).checkAllDisplayable();
                    if (GDE.isWithUi()) {
                        if (createdRecordSets.size() == 0) {
                            channels.switchChannel(1, "");
                        } else if (createdRecordSets.size() == 1) {
                            channels.switchChannel(activeChannelConfigNumber, ((RecordSet)createdRecordSets.firstElement()).getName());
                        } else {
                            channels.switchChannel(activeChannelConfigNumber, ((RecordSet)createdRecordSets.lastElement()).getName());
                        }
                    }
                }
                String msg = filePath + " - " + Messages.getString((String)"GDE_MSGE0045", (Object[])new Object[]{e.getMessage(), lineNumber});
                log.log(Level.WARNING, msg, e);
                application.openMessageDialog(msg);
            }
            finally {
                GDE.getUiNotification().setStatusMessage("");
                GDE.getUiNotification().setProgress(100);
            }
        }
        return channelRecordSet;
    }

    static {
        application = DataExplorer.getInstance();
        channels = Channels.getInstance();
    }
}

