/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import java.util.Arrays;
import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.MathArrays;

public class BicubicInterpolatingFunction
implements BivariateFunction {
    private static final int NUM_COEFF = 16;
    private static final double[][] AINV = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0}, {-3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, -3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0}, {9.0, -9.0, -9.0, 9.0, 6.0, 3.0, -6.0, -3.0, 6.0, -6.0, 3.0, -3.0, 4.0, 2.0, 2.0, 1.0}, {-6.0, 6.0, 6.0, -6.0, -3.0, -3.0, 3.0, 3.0, -4.0, 4.0, -2.0, 2.0, -2.0, -2.0, -1.0, -1.0}, {2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0}, {-6.0, 6.0, 6.0, -6.0, -4.0, -2.0, 4.0, 2.0, -3.0, 3.0, -3.0, 3.0, -2.0, -1.0, -2.0, -1.0}, {4.0, -4.0, -4.0, 4.0, 2.0, 2.0, -2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 1.0, 1.0, 1.0, 1.0}};
    private final double[] xval;
    private final double[] yval;
    private final BicubicFunction[][] splines;

    public BicubicInterpolatingFunction(double[] x, double[] y, double[][] f, double[][] dFdX, double[][] dFdY, double[][] d2FdXdY) throws DimensionMismatchException, NoDataException, NonMonotonicSequenceException {
        int xLen = x.length;
        int yLen = y.length;
        if (xLen == 0 || yLen == 0 || f.length == 0 || f[0].length == 0) {
            throw new NoDataException();
        }
        if (xLen != f.length) {
            throw new DimensionMismatchException(xLen, f.length);
        }
        if (xLen != dFdX.length) {
            throw new DimensionMismatchException(xLen, dFdX.length);
        }
        if (xLen != dFdY.length) {
            throw new DimensionMismatchException(xLen, dFdY.length);
        }
        if (xLen != d2FdXdY.length) {
            throw new DimensionMismatchException(xLen, d2FdXdY.length);
        }
        MathArrays.checkOrder(x);
        MathArrays.checkOrder(y);
        this.xval = (double[])x.clone();
        this.yval = (double[])y.clone();
        int lastI = xLen - 1;
        int lastJ = yLen - 1;
        this.splines = new BicubicFunction[lastI][lastJ];
        for (int i2 = 0; i2 < lastI; ++i2) {
            if (f[i2].length != yLen) {
                throw new DimensionMismatchException(f[i2].length, yLen);
            }
            if (dFdX[i2].length != yLen) {
                throw new DimensionMismatchException(dFdX[i2].length, yLen);
            }
            if (dFdY[i2].length != yLen) {
                throw new DimensionMismatchException(dFdY[i2].length, yLen);
            }
            if (d2FdXdY[i2].length != yLen) {
                throw new DimensionMismatchException(d2FdXdY[i2].length, yLen);
            }
            int ip1 = i2 + 1;
            double xR = this.xval[ip1] - this.xval[i2];
            for (int j = 0; j < lastJ; ++j) {
                int jp1 = j + 1;
                double yR = this.yval[jp1] - this.yval[j];
                double xRyR = xR * yR;
                double[] beta = new double[]{f[i2][j], f[ip1][j], f[i2][jp1], f[ip1][jp1], dFdX[i2][j] * xR, dFdX[ip1][j] * xR, dFdX[i2][jp1] * xR, dFdX[ip1][jp1] * xR, dFdY[i2][j] * yR, dFdY[ip1][j] * yR, dFdY[i2][jp1] * yR, dFdY[ip1][jp1] * yR, d2FdXdY[i2][j] * xRyR, d2FdXdY[ip1][j] * xRyR, d2FdXdY[i2][jp1] * xRyR, d2FdXdY[ip1][jp1] * xRyR};
                this.splines[i2][j] = new BicubicFunction(this.computeSplineCoefficients(beta));
            }
        }
    }

    public double value(double x, double y) throws OutOfRangeException {
        int i2 = this.searchIndex(x, this.xval);
        int j = this.searchIndex(y, this.yval);
        double xN = (x - this.xval[i2]) / (this.xval[i2 + 1] - this.xval[i2]);
        double yN = (y - this.yval[j]) / (this.yval[j + 1] - this.yval[j]);
        return this.splines[i2][j].value(xN, yN);
    }

    public boolean isValidPoint(double x, double y) {
        return !(x < this.xval[0] || x > this.xval[this.xval.length - 1] || y < this.yval[0]) && !(y > this.yval[this.yval.length - 1]);
    }

    private int searchIndex(double c, double[] val) {
        int r = Arrays.binarySearch(val, c);
        if (r == -1 || r == -val.length - 1) {
            throw new OutOfRangeException(c, (Number)val[0], val[val.length - 1]);
        }
        if (r < 0) {
            return -r - 2;
        }
        int last = val.length - 1;
        if (r == last) {
            return last - 1;
        }
        return r;
    }

    private double[] computeSplineCoefficients(double[] beta) {
        double[] a = new double[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            double result2 = 0.0;
            double[] row2 = AINV[i2];
            for (int j = 0; j < 16; ++j) {
                result2 += row2[j] * beta[j];
            }
            a[i2] = result2;
        }
        return a;
    }
}

