/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.core._MessageUtil;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateHashModelEx2;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;

public final class TemplateModelUtils {
    private TemplateModelUtils() {
    }

    public static final TemplateHashModelEx2.KeyValuePairIterator getKeyValuePairIterator(TemplateHashModelEx hash) throws TemplateModelException {
        return hash instanceof TemplateHashModelEx2 ? ((TemplateHashModelEx2)hash).keyValuePairIterator() : new TemplateHashModelExKeyValuePairIterator(hash);
    }

    private static class TemplateHashModelExKeyValuePairIterator
    implements TemplateHashModelEx2.KeyValuePairIterator {
        private final TemplateHashModelEx hash;
        private final TemplateModelIterator keyIter;

        private TemplateHashModelExKeyValuePairIterator(TemplateHashModelEx hash) throws TemplateModelException {
            this.hash = hash;
            this.keyIter = hash.keys().iterator();
        }

        public boolean hasNext() throws TemplateModelException {
            return this.keyIter.hasNext();
        }

        public TemplateHashModelEx2.KeyValuePair next() throws TemplateModelException {
            final TemplateModel key2 = this.keyIter.next();
            if (!(key2 instanceof TemplateScalarModel)) {
                throw _MessageUtil.newKeyValuePairListingNonStringKeyExceptionMessage(key2, this.hash);
            }
            return new TemplateHashModelEx2.KeyValuePair(){

                public TemplateModel getKey() throws TemplateModelException {
                    return key2;
                }

                public TemplateModel getValue() throws TemplateModelException {
                    return TemplateHashModelExKeyValuePairIterator.this.hash.get(((TemplateScalarModel)key2).getAsString());
                }
            };
        }
    }
}

