/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.serial;

import de.treichels.hott.serial.FileType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 &2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001&B/\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB7\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0003H\u0096\u0002J\u0013\u0010\"\u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u0007H\u0016J\b\u0010%\u001a\u00020\u0003H\u0016R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lde/treichels/hott/serial/FileInfo;", "Ljava/io/Serializable;", "", "", "path", "shortName", "size", "", "modifyDate", "Ljava/util/Date;", "type", "Lde/treichels/hott/serial/FileType;", "(Ljava/lang/String;Ljava/lang/String;ILjava/util/Date;Lde/treichels/hott/serial/FileType;)V", "dir", "name", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Date;Lde/treichels/hott/serial/FileType;)V", "getDir", "()Ljava/lang/String;", "isDir", "", "()Z", "isFile", "isRoot", "getModifyDate", "()Ljava/util/Date;", "getName", "getPath", "getShortName", "getSize", "()I", "getType", "()Lde/treichels/hott/serial/FileType;", "compareTo", "other", "equals", "", "hashCode", "toString", "Companion", "HoTT-Serial"})
public final class FileInfo
implements Serializable,
Comparable<String> {
    @NotNull
    private final String dir;
    @NotNull
    private final String name;
    @NotNull
    private final String shortName;
    private final int size;
    @NotNull
    private final Date modifyDate;
    @NotNull
    private final FileType type;
    private static final String EMPTY_STRING = "";
    private static final String FORWARD_SLASH = "/";
    private static final long serialVersionUID = 1L;
    @NotNull
    private static final FileInfo root;
    public static final Companion Companion;

    @NotNull
    public final String getDir() {
        return this.dir;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getShortName() {
        return this.shortName;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final Date getModifyDate() {
        return this.modifyDate;
    }

    @NotNull
    public final FileType getType() {
        return this.type;
    }

    @NotNull
    public final String getPath() {
        return this.dir + (StringsKt.endsWith$default(this.dir, FORWARD_SLASH, false, 2, null) ? EMPTY_STRING : FORWARD_SLASH) + this.name;
    }

    @Override
    public int compareTo(@NotNull String other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return this.name.compareTo(other);
    }

    @NotNull
    public String toString() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "FileInfo [name=%s, shortName=%s, size=%s, modifyDate=%s, type=%s]";
        Object[] objectArray = new Object[]{this.name, this.shortName, this.size, this.modifyDate, this.type};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
        return string3;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileInfo)) {
            return false;
        }
        if (Intrinsics.areEqual(this.dir, ((FileInfo)other).dir) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.name, ((FileInfo)other).name) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.shortName, ((FileInfo)other).shortName) ^ true) {
            return false;
        }
        if (this.size != ((FileInfo)other).size) {
            return false;
        }
        if (Intrinsics.areEqual(this.modifyDate, ((FileInfo)other).modifyDate) ^ true) {
            return false;
        }
        return this.type == ((FileInfo)other).type;
    }

    public int hashCode() {
        int result2 = this.dir.hashCode();
        result2 = 31 * result2 + this.name.hashCode();
        result2 = 31 * result2 + this.shortName.hashCode();
        result2 = 31 * result2 + this.size;
        result2 = 31 * result2 + this.modifyDate.hashCode();
        result2 = 31 * result2 + this.type.hashCode();
        return result2;
    }

    public final boolean isRoot() {
        return Intrinsics.areEqual(this, root);
    }

    public final boolean isDir() {
        return this.type == FileType.Dir;
    }

    public final boolean isFile() {
        return this.type == FileType.File;
    }

    public FileInfo(@NotNull String path2, @NotNull String shortName, int size, @NotNull Date modifyDate, @NotNull FileType type2) {
        Intrinsics.checkParameterIsNotNull(path2, "path");
        Intrinsics.checkParameterIsNotNull(shortName, "shortName");
        Intrinsics.checkParameterIsNotNull(modifyDate, "modifyDate");
        Intrinsics.checkParameterIsNotNull((Object)type2, "type");
        int pos = StringsKt.lastIndexOf$default((CharSequence)path2, FORWARD_SLASH, 0, false, 6, null);
        if (pos == -1) {
            this.dir = FORWARD_SLASH;
            this.name = path2;
            this.shortName = shortName;
            this.size = size;
            this.modifyDate = modifyDate;
            this.type = type2;
        } else {
            String string2;
            String string3 = path2;
            int n = 0;
            FileInfo fileInfo = this;
            String string4 = string3.substring(n, pos);
            Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            fileInfo.dir = string2 = string4;
            string3 = path2;
            n = pos + 1;
            fileInfo = this;
            String string5 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull(string5, "(this as java.lang.String).substring(startIndex)");
            fileInfo.name = string2 = string5;
            this.shortName = shortName;
            this.size = size;
            this.modifyDate = modifyDate;
            this.type = type2;
        }
    }

    public FileInfo(@NotNull String dir, @NotNull String name, @NotNull String shortName, int size, @NotNull Date modifyDate, @NotNull FileType type2) {
        Intrinsics.checkParameterIsNotNull(dir, "dir");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(shortName, "shortName");
        Intrinsics.checkParameterIsNotNull(modifyDate, "modifyDate");
        Intrinsics.checkParameterIsNotNull((Object)type2, "type");
        this.dir = dir;
        this.name = name;
        this.shortName = shortName;
        this.size = size;
        this.modifyDate = modifyDate;
        this.type = type2;
    }

    static {
        Companion = new Companion(null);
        EMPTY_STRING = EMPTY_STRING;
        FORWARD_SLASH = FORWARD_SLASH;
        root = new FileInfo(EMPTY_STRING, EMPTY_STRING, EMPTY_STRING, 0, new Date(0L), FileType.Dir);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/treichels/hott/serial/FileInfo$Companion;", "", "()V", "EMPTY_STRING", "", "FORWARD_SLASH", "root", "Lde/treichels/hott/serial/FileInfo;", "getRoot", "()Lde/treichels/hott/serial/FileInfo;", "serialVersionUID", "", "HoTT-Serial"})
    public static final class Companion {
        @NotNull
        public final FileInfo getRoot() {
            return root;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

