/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.Analyzer;
import gde.GDE;
import gde.data.Channel;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.ChannelPropertyTypes;
import gde.device.DataTypes;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.StatisticsType;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTAdapter2M;
import gde.device.graupner.HoTTbinHistoReader2;
import gde.device.graupner.HoTTbinReader;
import gde.device.graupner.HoTTbinReader2;
import gde.device.graupner.HoTTlogHistoReader2;
import gde.device.graupner.HoTTlogReader2;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.histo.cache.VaultCollector;
import gde.histo.device.IHistoDevice;
import gde.histo.device.UniversalSampler;
import gde.histo.utils.PathUtils;
import gde.io.DataParser;
import gde.io.FileHandler;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.FileUtils;
import gde.utils.GPSHelper;
import gde.utils.ObjectKeyCompliance;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Vector;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class HoTTAdapter2
extends HoTTAdapter
implements IDevice,
IHistoDevice {
    static final Logger log = Logger.getLogger(HoTTAdapter2.class.getName());
    public static final int CHANNELS_CHANNEL_NUMBER = 4;

    public HoTTAdapter2(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        if (this.application.getMenuToolBar() != null) {
            String toolTipText = HoTTAdapter.getImportToolTip();
            this.configureSerialPortMenu(2, toolTipText, toolTipText);
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
        this.setPickerParameters();
    }

    public HoTTAdapter2(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        if (this.application.getMenuToolBar() != null) {
            String toolTipText = HoTTAdapter.getImportToolTip();
            this.configureSerialPortMenu(2, toolTipText, toolTipText);
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
        this.setPickerParameters();
    }

    public void setPickerParameters() {
        this.pickerParameters.isChannelsChannelEnabled = this.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL) != null && this.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL).getValue() != "" ? Boolean.parseBoolean(this.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL).getValue()) : false;
        this.pickerParameters.isFilterEnabled = this.getChannelProperty(ChannelPropertyTypes.ENABLE_FILTER) != null && this.getChannelProperty(ChannelPropertyTypes.ENABLE_FILTER).getValue() != "" ? Boolean.parseBoolean(this.getChannelProperty(ChannelPropertyTypes.ENABLE_FILTER).getValue()) : true;
        this.pickerParameters.isFilterTextModus = this.getChannelProperty(ChannelPropertyTypes.TEXT_MODE) != null && this.getChannelProperty(ChannelPropertyTypes.TEXT_MODE).getValue() != "" ? Boolean.parseBoolean(this.getChannelProperty(ChannelPropertyTypes.TEXT_MODE).getValue()) : false;
        this.pickerParameters.latitudeToleranceFactor = this.getMeasurementPropertyValue(this.application.getActiveChannelNumber(), 20, MeasurementPropertyTypes.FILTER_FACTOR.value()).toString().length() > 0 ? Double.parseDouble(this.getMeasurementPropertyValue(this.application.getActiveChannelNumber(), 20, MeasurementPropertyTypes.FILTER_FACTOR.value()).toString()) : 50.0;
        this.pickerParameters.longitudeToleranceFactor = this.getMeasurementPropertyValue(this.application.getActiveChannelNumber(), 21, MeasurementPropertyTypes.FILTER_FACTOR.value()).toString().length() > 0 ? Double.parseDouble(this.getMeasurementPropertyValue(this.application.getActiveChannelNumber(), 21, MeasurementPropertyTypes.FILTER_FACTOR.value()).toString()) : 15.0;
        try {
            this.pickerParameters.altitudeClimbSensorSelection = this.getChannelProperty(ChannelPropertyTypes.SENSOR_ALT_CLIMB) != null && this.getChannelProperty(ChannelPropertyTypes.SENSOR_ALT_CLIMB).getValue() != null ? Integer.parseInt(this.getChannelProperty(ChannelPropertyTypes.SENSOR_ALT_CLIMB).getValue()) : 0;
        }
        catch (NumberFormatException e) {
            this.pickerParameters.altitudeClimbSensorSelection = 0;
        }
        try {
            this.pickerParameters.isChannelPercentEnabled = this.getChannelProperty(ChannelPropertyTypes.CHANNEL_PERCENTAGE) != null && this.getChannelProperty(ChannelPropertyTypes.CHANNEL_PERCENTAGE).getValue() != null ? Boolean.parseBoolean(this.getChannelProperty(ChannelPropertyTypes.CHANNEL_PERCENTAGE).getValue()) : true;
        }
        catch (NumberFormatException e) {
            this.pickerParameters.isChannelPercentEnabled = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        block85: {
            int maxVotage = Integer.MIN_VALUE;
            int minVotage = Integer.MAX_VALUE;
            block2 : switch (this.serialPort.protocolType) {
                case TYPE_19200_V3: {
                    switch (dataBuffer[1]) {
                        case -128: {
                            if (dataBuffer.length != 17) break;
                            points[0] = 0;
                            points[1] = (dataBuffer[9] & 0xFF) * 1000;
                            points[2] = (dataBuffer[5] & 0xFF) * 1000;
                            points[3] = DataParser.parse2Short((byte[])dataBuffer, (int)11) * 1000;
                            points[4] = (dataBuffer[13] & 0xFF) * -1000;
                            points[5] = (dataBuffer[9] & 0xFF) * -1000;
                            points[6] = (dataBuffer[6] & 0xFF) * 1000;
                            points[7] = ((dataBuffer[7] & 0xFF) - 20) * 1000;
                            return points;
                        }
                        case -119: {
                            if (dataBuffer.length != 31) break;
                            points[10] = (DataParser.parse2Short((byte[])dataBuffer, (int)16) - 500) * 1000;
                            points[11] = (DataParser.parse2Short((byte[])dataBuffer, (int)22) - 30000) * 10;
                            points[12] = (DataParser.parse2Short((byte[])dataBuffer, (int)24) - 30000) * 10;
                            points[13] = (DataParser.parse2Short((byte[])dataBuffer, (int)26) - 30000) * 10;
                            return points;
                        }
                        case -118: {
                            if (dataBuffer.length != 40) break;
                            points[20] = DataParser.parse2Short((byte[])dataBuffer, (int)20) * 10000 + DataParser.parse2Short((byte[])dataBuffer, (int)22);
                            points[20] = dataBuffer[19] == 1 ? -1 * points[15] : points[15];
                            points[21] = DataParser.parse2Short((byte[])dataBuffer, (int)25) * 10000 + DataParser.parse2Short((byte[])dataBuffer, (int)27);
                            points[21] = dataBuffer[24] == 1 ? -1 * points[16] : points[16];
                            points[10] = (DataParser.parse2Short((byte[])dataBuffer, (int)31) - 500) * 1000;
                            points[11] = (DataParser.parse2Short((byte[])dataBuffer, (int)33) - 30000) * 10;
                            points[12] = ((dataBuffer[35] & 0xFF) - 120) * 1000;
                            points[22] = DataParser.parse2Short((byte[])dataBuffer, (int)17) * 1000;
                            points[23] = DataParser.parse2Short((byte[])dataBuffer, (int)29) * 1000;
                            points[24] = (dataBuffer[16] & 0xFF) * 1000;
                            points[25] = 0;
                            return points;
                        }
                        case -115: {
                            if (dataBuffer.length != 48) break;
                            points[38] = DataParser.parse2Short((byte[])dataBuffer, (int)40) * 1000;
                            points[39] = DataParser.parse2Short((byte[])dataBuffer, (int)38) * 1000;
                            points[40] = DataParser.parse2Short((byte[])dataBuffer, (int)42) * 1000;
                            points[41] = Double.valueOf((double)points[38] / 1000.0 * (double)points[39]).intValue();
                            for (int j = 0; j < 6; ++j) {
                                points[j + 43] = (dataBuffer[23 + j] & 0xFF) * 1000;
                                if (points[j + 43] <= 0) continue;
                                maxVotage = points[j + 43] > maxVotage ? points[j + 43] : maxVotage;
                                minVotage = points[j + 43] < minVotage ? points[j + 43] : minVotage;
                            }
                            points[42] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                            points[49] = DataParser.parse2Short((byte[])dataBuffer, (int)31) * 1000;
                            points[10] = (DataParser.parse2Short((byte[])dataBuffer, (int)33) - 500) * 1000;
                            points[11] = (DataParser.parse2Short((byte[])dataBuffer, (int)35) - 30000) * 10;
                            points[12] = ((dataBuffer[37] & 0xFF) - 120) * 1000;
                            points[50] = DataParser.parse2Short((byte[])dataBuffer, (int)29) * 1000;
                            points[51] = DataParser.parse2Short((byte[])dataBuffer, (int)22) * 1000;
                            points[52] = DataParser.parse2Short((byte[])dataBuffer, (int)24) * 1000;
                            points[53] = ((dataBuffer[26] & 0xFF) - 20) * 1000;
                            points[54] = ((dataBuffer[27] & 0xFF) - 20) * 1000;
                            return points;
                        }
                        case -114: {
                            if (dataBuffer.length != 51) break;
                            points[60] = DataParser.parse2Short((byte[])dataBuffer, (int)40) * 1000;
                            points[61] = DataParser.parse2Short((byte[])dataBuffer, (int)38) * 1000;
                            points[62] = DataParser.parse2Short((byte[])dataBuffer, (int)42) * 1000;
                            points[63] = Double.valueOf((double)points[60] / 1000.0 * (double)points[61]).intValue();
                            for (int j = 0; j < 14; ++j) {
                                points[j + 65] = (dataBuffer[40 + j] & 0xFF) * 1000;
                                if (points[j + 65] <= 0) continue;
                                maxVotage = points[j + 65] > maxVotage ? points[j + 65] : maxVotage;
                                minVotage = points[j + 65] < minVotage ? points[j + 65] : minVotage;
                            }
                            points[64] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                            points[10] = (DataParser.parse2Short((byte[])dataBuffer, (int)36) - 500) * 1000;
                            points[11] = (DataParser.parse2Short((byte[])dataBuffer, (int)44) - 30000) * 10;
                            points[12] = ((dataBuffer[46] & 0xFF) - 120) * 1000;
                            points[79] = DataParser.parse2Short((byte[])dataBuffer, (int)30) * 1000;
                            points[80] = DataParser.parse2Short((byte[])dataBuffer, (int)32) * 1000;
                            points[81] = ((dataBuffer[34] & 0xFF) - 20) * 1000;
                            points[82] = ((dataBuffer[35] & 0xFF) - 20) * 1000;
                        }
                    }
                    return points;
                }
                case TYPE_19200_V4: {
                    short tmpPackageLoss = DataParser.parse2Short((byte[])dataBuffer, (int)11);
                    int tmpVoltageRx = dataBuffer[6] & 0xFF;
                    int tmpTemperatureRx = (dataBuffer[7] & 0xFF) - 20;
                    if (!this.pickerParameters.isFilterEnabled || tmpPackageLoss > -1 && tmpVoltageRx > -1 && tmpVoltageRx < 100 && tmpTemperatureRx < 120) {
                        points[0] = 0;
                        points[1] = (dataBuffer[9] & 0xFF) * 1000;
                        points[2] = (dataBuffer[5] & 0xFF) * 1000;
                        points[3] = tmpPackageLoss * 1000;
                        points[4] = (dataBuffer[13] & 0xFF) * -1000;
                        points[5] = (dataBuffer[8] & 0xFF) * -1000;
                        points[6] = tmpVoltageRx * 1000;
                        points[7] = tmpTemperatureRx * 1000;
                        points[8] = (dataBuffer[10] & 0xFF) * 1000;
                    }
                    switch (dataBuffer[1]) {
                        case -119: {
                            if (dataBuffer.length != 57 || this.pickerParameters.altitudeClimbSensorSelection != 1) break;
                            int tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)16) - 500;
                            if (tmpHeight > -490 && tmpHeight < 5000) {
                                points[10] = tmpHeight * 1000;
                                points[11] = (DataParser.parse2Short((byte[])dataBuffer, (int)22) - 30000) * 10;
                            }
                            int tmpClimb3 = DataParser.parse2Short((byte[])dataBuffer, (int)24) - 30000;
                            int tmpClimb10 = DataParser.parse2Short((byte[])dataBuffer, (int)26) - 30000;
                            if (tmpClimb3 <= -10000 || tmpClimb10 <= -10000 || tmpClimb3 >= 10000 || tmpClimb10 >= 10000) break;
                            points[12] = tmpClimb3 * 10;
                            points[13] = tmpClimb10 * 10;
                            return points;
                        }
                        case -118: {
                            if (dataBuffer.length != 57) break;
                            short tmpLatitudeGrad = DataParser.parse2Short((byte[])dataBuffer, (int)20);
                            short tmpLongitudeGrad = DataParser.parse2Short((byte[])dataBuffer, (int)25);
                            int tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)31) - 500;
                            int tmpClimb3 = (dataBuffer[35] & 0xFF) - 120;
                            if (tmpLatitudeGrad != tmpLongitudeGrad && tmpLatitudeGrad <= 0 || tmpHeight <= -490 || tmpHeight >= 5000 || tmpClimb3 <= -50) break;
                            points[20] = tmpLatitudeGrad * 10000 + DataParser.parse2Short((byte[])dataBuffer, (int)22);
                            points[20] = dataBuffer[19] == 1 ? -1 * points[15] : points[15];
                            points[21] = tmpLongitudeGrad * 10000 + DataParser.parse2Short((byte[])dataBuffer, (int)27);
                            int n = points[21] = dataBuffer[24] == 1 ? -1 * points[16] : points[16];
                            if (this.pickerParameters.altitudeClimbSensorSelection == 2) {
                                points[10] = tmpHeight * 1000;
                                points[11] = (DataParser.parse2Short((byte[])dataBuffer, (int)33) - 30000) * 10;
                                points[12] = tmpClimb3 * 1000;
                            }
                            points[22] = DataParser.parse2Short((byte[])dataBuffer, (int)17) * 1000;
                            points[23] = DataParser.parse2Short((byte[])dataBuffer, (int)29) * 1000;
                            points[24] = (dataBuffer[38] & 0xFF) * 1000;
                            points[25] = 0;
                            points[26] = (dataBuffer[36] & 0xFF) * 1000;
                            switch (dataBuffer[37]) {
                                case 45: {
                                    points[27] = 0;
                                    break;
                                }
                                case 50: {
                                    points[27] = 2000;
                                    break;
                                }
                                case 51: {
                                    points[27] = 3000;
                                    break;
                                }
                                case 68: {
                                    points[27] = 4000;
                                    break;
                                }
                                default: {
                                    try {
                                        points[27] = Integer.valueOf(String.format("%c", dataBuffer[37])) * 1000;
                                        break;
                                    }
                                    catch (NumberFormatException e1) {
                                        points[27] = 1000;
                                    }
                                }
                            }
                            points[28] = (dataBuffer[14] & 0xFF) * 1000;
                            points[29] = (dataBuffer[38] & 0xFF) * 1000;
                            if (log.isLoggable(Level.INFO)) {
                                log.log(Level.INFO, StringHelper.byte2Hex2CharString((byte[])dataBuffer, (int)39, (int)dataBuffer.length));
                                if (dataBuffer[41] > 40 && dataBuffer[41] <= 100 && dataBuffer[47] > 0 && dataBuffer[47] <= 100) {
                                    log.log(Level.INFO, String.format("Sparrow: Voltage GU = %d; servo pulse = %d", dataBuffer[41], dataBuffer[47]));
                                }
                                if (dataBuffer[41] == 0 && dataBuffer[39] > -120 && dataBuffer[39] <= 120) {
                                    log.log(Level.INFO, String.format("SM GPS-Logger: servo pulse = %d; not used = %d", dataBuffer[39], dataBuffer[41]));
                                }
                            }
                            if (dataBuffer[41] > 40 && dataBuffer[41] <= 100 && dataBuffer[47] > 0 && dataBuffer[47] <= 100) {
                                points[30] = dataBuffer[47] * 1000;
                                points[31] = 0;
                                points[32] = dataBuffer[41] * 100;
                                points[33] = dataBuffer[42] * 10000000 + dataBuffer[43] * 100000 + dataBuffer[44] * 1000 + dataBuffer[45] * 10;
                                points[34] = ((dataBuffer[48] - 48) * 1000000 + (dataBuffer[50] - 48) * 10000 + (dataBuffer[49] - 48) * 100) * 10;
                                points[35] = DataParser.parse2Short((byte[])dataBuffer, (int)39) * 1000;
                                points[36] = (dataBuffer[46] & 0xFF) * 1000;
                                points[37] = 4000;
                                return points;
                            }
                            if (dataBuffer[41] != 0 || dataBuffer[39] <= -120 || dataBuffer[39] > 120) break;
                            points[30] = dataBuffer[39] * 1000;
                            points[31] = dataBuffer[40] * 1000;
                            points[32] = dataBuffer[41] * 1000;
                            points[33] = DataParser.parse2Short((byte[])dataBuffer, (int)42) * 1000;
                            points[34] = DataParser.parse2Short((byte[])dataBuffer, (int)44) * 1000;
                            points[35] = DataParser.parse2Short((byte[])dataBuffer, (int)46) * 1000;
                            points[36] = (dataBuffer[48] & 0xFF) * 1000;
                            points[37] = 125000;
                            return points;
                        }
                        case -115: {
                            if (dataBuffer.length != 57) break;
                            short tmpVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)40);
                            short tmpCapacity = DataParser.parse2Short((byte[])dataBuffer, (int)42);
                            int tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)33) - 500;
                            int tmpClimb3 = (dataBuffer[37] & 0xFF) - 120;
                            short tmpVoltage1 = DataParser.parse2Short((byte[])dataBuffer, (int)22);
                            short tmpVoltage2 = DataParser.parse2Short((byte[])dataBuffer, (int)24);
                            if (this.pickerParameters.isFilterEnabled && (tmpClimb3 <= -90 || tmpHeight < -490 || tmpHeight >= 5000 || Math.abs(tmpVoltage1) >= 600 || Math.abs(tmpVoltage2) >= 600)) break;
                            points[38] = tmpVoltage * 1000;
                            points[39] = DataParser.parse2Short((byte[])dataBuffer, (int)38) * 1000;
                            points[40] = tmpCapacity * 1000;
                            points[41] = Double.valueOf((double)points[38] / 1000.0 * (double)points[39]).intValue();
                            if (tmpVoltage > 0) {
                                for (int j = 0; j < 6; ++j) {
                                    int tmpCellVoltage = dataBuffer[16 + j] & 0xFF;
                                    int n = points[j + 43] = tmpCellVoltage > 0 ? tmpCellVoltage * 1000 : points[j + 43];
                                    if (points[j + 43] <= 0) continue;
                                    maxVotage = points[j + 43] > maxVotage ? points[j + 43] : maxVotage;
                                    minVotage = points[j + 43] < minVotage ? points[j + 43] : minVotage;
                                }
                                points[42] = (maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0) * 10;
                            }
                            points[49] = DataParser.parse2Short((byte[])dataBuffer, (int)31) * 1000;
                            if (this.pickerParameters.altitudeClimbSensorSelection == 3) {
                                points[10] = tmpHeight * 1000;
                                points[11] = (DataParser.parse2Short((byte[])dataBuffer, (int)35) - 30000) * 10;
                                points[12] = tmpClimb3 * 1000;
                            }
                            points[50] = DataParser.parse2Short((byte[])dataBuffer, (int)29) * 1000;
                            points[51] = tmpVoltage1 * 100;
                            points[52] = tmpVoltage2 * 100;
                            points[53] = ((dataBuffer[26] & 0xFF) - 20) * 1000;
                            points[54] = ((dataBuffer[27] & 0xFF) - 20) * 1000;
                            points[55] = 0;
                            points[56] = 0;
                            points[57] = 0;
                            points[58] = 0;
                            points[59] = 0;
                            return points;
                        }
                        case -114: {
                            if (dataBuffer.length != 57) break;
                            short tmpVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)40);
                            short tmpCapacity = DataParser.parse2Short((byte[])dataBuffer, (int)42);
                            int tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)36) - 500;
                            int tmpClimb3 = (dataBuffer[46] & 0xFF) - 120;
                            short tmpVoltage1 = DataParser.parse2Short((byte[])dataBuffer, (int)30);
                            short tmpVoltage2 = DataParser.parse2Short((byte[])dataBuffer, (int)32);
                            if (this.pickerParameters.isFilterEnabled && (tmpClimb3 <= -90 || tmpHeight < -490 || tmpHeight >= 5000 || Math.abs(tmpVoltage1) >= 600 || Math.abs(tmpVoltage2) >= 600)) break;
                            points[60] = tmpVoltage * 1000;
                            points[61] = DataParser.parse2Short((byte[])dataBuffer, (int)38) * 1000;
                            points[62] = tmpCapacity * 1000;
                            points[63] = Double.valueOf((double)points[60] / 1000.0 * (double)points[61]).intValue();
                            if (tmpVoltage > 0) {
                                for (int j = 0; j < 14; ++j) {
                                    int tmpCellVoltage = dataBuffer[16 + j] & 0xFF;
                                    int n = points[j + 65] = tmpCellVoltage > 0 ? tmpCellVoltage * 1000 : points[j + 65];
                                    if (points[j + 65] <= 0) continue;
                                    maxVotage = points[j + 65] > maxVotage ? points[j + 65] : maxVotage;
                                    minVotage = points[j + 65] < minVotage ? points[j + 65] : minVotage;
                                }
                                points[64] = (maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0) * 10;
                            }
                            if (this.pickerParameters.altitudeClimbSensorSelection == 4) {
                                points[10] = tmpHeight * 1000;
                                points[11] = (DataParser.parse2Short((byte[])dataBuffer, (int)44) - 30000) * 10;
                                points[12] = tmpClimb3 * 1000;
                            }
                            points[79] = tmpVoltage1 * 100;
                            points[80] = tmpVoltage2 * 100;
                            points[81] = ((dataBuffer[34] & 0xFF) - 20) * 1000;
                            points[82] = ((dataBuffer[35] & 0xFF) - 20) * 1000;
                            points[83] = DataParser.parse2Short((byte[])dataBuffer, (int)47) * 1000;
                            points[84] = 0;
                            points[85] = 0;
                            points[86] = 0;
                            return points;
                        }
                        case -116: {
                            if (dataBuffer.length != 57) break;
                            short tmpVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)16);
                            short tmpCurrent = DataParser.parse2Short((byte[])dataBuffer, (int)24);
                            short tmpCapacity = DataParser.parse2Short((byte[])dataBuffer, (int)20);
                            short tmpRevolution = DataParser.parse2Short((byte[])dataBuffer, (int)28);
                            int tmpTemperatureFet = (dataBuffer[35] & 0xFF) + 20;
                            if (this.application.getActiveChannelNumber() == 4 || this.getName().equals("HoTTAdapterD")) {
                                if (this.pickerParameters.isFilterEnabled && (tmpVoltage <= 0 || tmpVoltage >= 1000 || tmpCurrent >= 4000 || tmpCurrent <= -10 || tmpRevolution <= -1 || tmpRevolution >= 20000 || points[112] != 0 && points[112] / 1000 - tmpTemperatureFet > 20)) break;
                                points[107] = tmpVoltage * 1000;
                                points[108] = tmpCurrent * 1000;
                                points[109] = tmpCapacity * 1000;
                                points[110] = Double.valueOf((double)points[107] / 1000.0 * (double)points[108]).intValue();
                                points[111] = tmpRevolution * 1000;
                                points[112] = tmpTemperatureFet * 1000;
                                return points;
                            }
                            if (this.pickerParameters.isFilterEnabled && (tmpVoltage <= 0 || tmpVoltage >= 1000 || tmpCurrent >= 4000 || tmpCurrent <= -10 || tmpRevolution <= -1 || tmpRevolution >= 20000 || points[92] != 0 && points[92] / 1000 - tmpTemperatureFet > 20)) break;
                            points[87] = tmpVoltage * 1000;
                            points[88] = tmpCurrent * 1000;
                            points[89] = tmpCapacity * 1000;
                            points[90] = Double.valueOf((double)points[87] / 1000.0 * (double)points[88]).intValue();
                            points[91] = tmpRevolution * 1000;
                            points[92] = tmpTemperatureFet * 1000;
                        }
                    }
                    return points;
                }
                case TYPE_115200: {
                    switch (dataBuffer[0]) {
                        case 52: {
                            if (dataBuffer.length < 21) return points;
                            short tmpPackageLoss = DataParser.parse2Short((byte[])dataBuffer, (int)12);
                            int tmpVoltageRx = dataBuffer[15] & 0xFF;
                            short tmpTemperatureRx = DataParser.parse2Short((byte[])dataBuffer, (int)10);
                            if (this.pickerParameters.isFilterEnabled && (tmpPackageLoss <= -1 || tmpVoltageRx <= -1 || tmpVoltageRx >= 100 || tmpTemperatureRx >= 100)) return points;
                            this.pickerParameters.reverseChannelPackageLossCounter.add((dataBuffer[5] & 0xFF) == 0 && (dataBuffer[4] & 0xFF) == 0 ? 0 : 1);
                            points[0] = this.pickerParameters.reverseChannelPackageLossCounter.getPercentage() * 1000;
                            points[1] = (dataBuffer[17] & 0xFF) * 1000;
                            points[2] = (dataBuffer[14] & 0xFF) * 1000;
                            points[3] = tmpPackageLoss * 1000;
                            points[4] = (dataBuffer[5] & 0xFF) * -1000;
                            points[5] = (dataBuffer[4] & 0xFF) * -1000;
                            points[6] = tmpVoltageRx * 1000;
                            points[7] = tmpTemperatureRx * 1000;
                            points[8] = (dataBuffer[18] & 0xFF) * 1000;
                            break block85;
                        }
                        case 55: {
                            if (dataBuffer.length < 25 || this.pickerParameters.altitudeClimbSensorSelection != 1) return points;
                            short tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)10);
                            if (tmpHeight > -490 && tmpHeight < 5000) {
                                points[10] = tmpHeight * 1000;
                                points[11] = DataParser.parse2Short((byte[])dataBuffer, (int)16) * 10;
                            }
                            short tmpClimb3 = DataParser.parse2Short((byte[])dataBuffer, (int)18);
                            short tmpClimb10 = DataParser.parse2Short((byte[])dataBuffer, (int)20);
                            if (tmpClimb3 <= -10000 || tmpClimb10 <= -10000 || tmpClimb3 >= 10000 || tmpClimb10 >= 10000) return points;
                            points[12] = tmpClimb3 * 10;
                            points[13] = tmpClimb10 * 10;
                            break block85;
                        }
                        case 56: {
                            if (dataBuffer.length < 46) return points;
                            log.log(Level.INFO, StringHelper.byte2Hex2CharString((byte[])dataBuffer, (int)dataBuffer.length));
                            short tmpLatitudeGrad = DataParser.parse2Short((byte[])dataBuffer, (int)16);
                            short tmpLongitudeGrad = DataParser.parse2Short((byte[])dataBuffer, (int)20);
                            short tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)14);
                            byte tmpClimb3 = dataBuffer[30];
                            if (tmpLatitudeGrad != tmpLongitudeGrad && tmpLatitudeGrad <= 0 || tmpHeight <= -490 || tmpHeight >= 4500 || tmpClimb3 <= -90) return points;
                            points[20] = tmpLatitudeGrad * 10000 + DataParser.parse2Short((byte[])dataBuffer, (int)18);
                            points[20] = dataBuffer[26] == 1 ? -1 * points[15] : points[15];
                            points[21] = tmpLongitudeGrad * 10000 + DataParser.parse2Short((byte[])dataBuffer, (int)22);
                            int n = points[21] = dataBuffer[27] == 1 ? -1 * points[16] : points[16];
                            if (this.pickerParameters.altitudeClimbSensorSelection == 2) {
                                points[10] = tmpHeight * 1000;
                                points[11] = DataParser.parse2Short((byte[])dataBuffer, (int)28) * 10;
                                points[12] = tmpClimb3 * 1000;
                            }
                            points[22] = DataParser.parse2Short((byte[])dataBuffer, (int)10) * 1000;
                            points[23] = DataParser.parse2Short((byte[])dataBuffer, (int)12) * 1000;
                            points[24] = DataParser.parse2Short((byte[])dataBuffer, (int)24) * 500;
                            points[25] = 0;
                            points[26] = (dataBuffer[32] & 0xFF) * 1000;
                            switch (dataBuffer[33]) {
                                case 45: {
                                    points[27] = 0;
                                    break;
                                }
                                case 50: {
                                    points[27] = 2000;
                                    break;
                                }
                                case 51: {
                                    points[27] = 3000;
                                    break;
                                }
                                case 68: {
                                    points[27] = 4000;
                                    break;
                                }
                                default: {
                                    try {
                                        points[27] = Integer.valueOf(String.format("%c", dataBuffer[33])) * 1000;
                                        break;
                                    }
                                    catch (NumberFormatException e1) {
                                        points[27] = 1000;
                                    }
                                }
                            }
                            points[28] = (dataBuffer[1] & 0xF) * 1000;
                            points[29] = DataParser.parse2Short((byte[])dataBuffer, (int)34) * 1000;
                            if (log.isLoggable(Level.INFO)) {
                                log.log(Level.INFO, StringHelper.byte2Hex2CharString((byte[])dataBuffer, (int)36, (int)dataBuffer.length));
                                if (dataBuffer[38] > 40 && dataBuffer[38] <= 100 && dataBuffer[45] > 0 && dataBuffer[45] <= 100) {
                                    log.log(Level.INFO, String.format("Sparrow: Voltage GU = %d; servo pulse = %d", dataBuffer[38], dataBuffer[45]));
                                }
                                if (dataBuffer[38] == 0 && dataBuffer[36] > -120 && dataBuffer[36] <= 120) {
                                    log.log(Level.INFO, String.format("SM GPS-Logger: servo pulse = %d; not used = %d", dataBuffer[36], dataBuffer[38]));
                                }
                            }
                            if (dataBuffer[38] > 40 && dataBuffer[38] <= 100 && dataBuffer[45] > 0 && dataBuffer[45] <= 100) {
                                points[30] = dataBuffer[45] * 1000;
                                points[31] = 0;
                                points[32] = dataBuffer[38] * 100;
                                points[33] = dataBuffer[40] * 10000000 + dataBuffer[41] * 100000 + dataBuffer[42] * 1000 + dataBuffer[43] * 10;
                                points[34] = ((dataBuffer[46] - 48) * 1000000 + (dataBuffer[48] - 48) * 10000 + (dataBuffer[47] - 48) * 100) * 10;
                                points[35] = DataParser.parse2Short((byte[])dataBuffer, (int)39) * 1000;
                                points[36] = (dataBuffer[44] & 0xFF) * 1000;
                                points[37] = 4000;
                                break block2;
                            }
                            if (dataBuffer[38] != 0 || dataBuffer[36] <= -120 || dataBuffer[36] > 120) return points;
                            points[30] = dataBuffer[36] * 1000;
                            points[31] = dataBuffer[37] * 1000;
                            points[32] = dataBuffer[38] * 1000;
                            points[33] = DataParser.parse2Short((byte[])dataBuffer, (int)40) * 1000;
                            points[34] = DataParser.parse2Short((byte[])dataBuffer, (int)42) * 1000;
                            points[35] = DataParser.parse2Short((byte[])dataBuffer, (int)44) * 1000;
                            points[36] = (dataBuffer[46] & 0xFF) * 1000;
                            points[37] = 125000;
                            break block85;
                        }
                        case 53: {
                            if (dataBuffer.length < 49) return points;
                            short tmpVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)36);
                            short tmpCapacity = DataParser.parse2Short((byte[])dataBuffer, (int)38);
                            short tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)32);
                            byte tmpClimb3 = dataBuffer[44];
                            short tmpVoltage1 = DataParser.parse2Short((byte[])dataBuffer, (int)22);
                            short tmpVoltage2 = DataParser.parse2Short((byte[])dataBuffer, (int)24);
                            if (this.pickerParameters.isFilterEnabled && (tmpClimb3 <= -90 || tmpHeight < -490 || tmpHeight >= 5000 || Math.abs(tmpVoltage1) >= 600 || Math.abs(tmpVoltage2) >= 600)) return points;
                            points[38] = tmpVoltage * 1000;
                            points[39] = DataParser.parse2Short((byte[])dataBuffer, (int)34) * 1000;
                            points[40] = tmpCapacity * 1000;
                            points[41] = Double.valueOf((double)points[38] / 1000.0 * (double)points[39]).intValue();
                            if (tmpVoltage > 0) {
                                int i = 0;
                                int j = 0;
                                while (i < 6) {
                                    short tmpCellVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 10));
                                    int n = points[i + 43] = tmpCellVoltage > 0 ? tmpCellVoltage * 500 : points[i + 43];
                                    if (points[i + 43] > 0) {
                                        maxVotage = points[i + 43] > maxVotage ? points[i + 43] : maxVotage;
                                        minVotage = points[i + 43] < minVotage ? points[i + 43] : minVotage;
                                    }
                                    ++i;
                                    j += 2;
                                }
                                points[42] = (maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0) * 10;
                            }
                            points[49] = DataParser.parse2Short((byte[])dataBuffer, (int)30) * 1000;
                            if (this.pickerParameters.altitudeClimbSensorSelection == 3) {
                                points[10] = tmpHeight * 1000;
                                points[11] = DataParser.parse2Short((byte[])dataBuffer, (int)42) * 10;
                                points[12] = tmpClimb3 * 1000;
                            }
                            points[50] = DataParser.parse2Short((byte[])dataBuffer, (int)40) * 1000;
                            points[51] = tmpVoltage1 * 100;
                            points[52] = tmpVoltage2 * 100;
                            points[53] = DataParser.parse2Short((byte[])dataBuffer, (int)26) * 1000;
                            points[54] = DataParser.parse2Short((byte[])dataBuffer, (int)28) * 1000;
                            points[55] = 0;
                            points[56] = 0;
                            points[57] = 0;
                            points[58] = 0;
                            points[59] = 0;
                            break block85;
                        }
                        case 54: {
                            if (dataBuffer.length < 60) return points;
                            short tmpVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)50);
                            short tmpCapacity = DataParser.parse2Short((byte[])dataBuffer, (int)52);
                            short tmpHeight = DataParser.parse2Short((byte[])dataBuffer, (int)46);
                            byte tmpClimb3 = dataBuffer[56];
                            short tmpVoltage1 = DataParser.parse2Short((byte[])dataBuffer, (int)38);
                            short tmpVoltage2 = DataParser.parse2Short((byte[])dataBuffer, (int)40);
                            if (this.pickerParameters.isFilterEnabled && (tmpClimb3 <= -90 || tmpHeight < -490 || tmpHeight >= 5000 || Math.abs(tmpVoltage1) >= 600 || Math.abs(tmpVoltage2) >= 600)) return points;
                            points[60] = DataParser.parse2Short((byte[])dataBuffer, (int)50) * 1000;
                            points[61] = DataParser.parse2Short((byte[])dataBuffer, (int)48) * 1000;
                            points[62] = tmpCapacity * 1000;
                            points[63] = Double.valueOf((double)points[60] / 1000.0 * (double)points[61]).intValue();
                            if (tmpVoltage > 0) {
                                int i = 0;
                                int j = 0;
                                while (i < 14) {
                                    short tmpCellVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 10));
                                    int n = points[i + 65] = tmpCellVoltage > 0 ? tmpCellVoltage * 500 : points[i + 65];
                                    if (points[i + 65] > 0) {
                                        maxVotage = points[i + 65] > maxVotage ? points[i + 65] : maxVotage;
                                        minVotage = points[i + 65] < minVotage ? points[i + 65] : minVotage;
                                    }
                                    ++i;
                                    j += 2;
                                }
                                points[64] = (maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0) * 10;
                            }
                            if (this.pickerParameters.altitudeClimbSensorSelection == 4) {
                                points[10] = tmpHeight * 1000;
                                points[11] = DataParser.parse2Short((byte[])dataBuffer, (int)54) * 10;
                                points[12] = dataBuffer[46] * 1000;
                            }
                            points[79] = tmpVoltage1 * 100;
                            points[80] = tmpVoltage2 * 100;
                            points[81] = DataParser.parse2Short((byte[])dataBuffer, (int)42) * 1000;
                            points[82] = DataParser.parse2Short((byte[])dataBuffer, (int)44) * 1000;
                            points[83] = DataParser.parse2Short((byte[])dataBuffer, (int)58) * 1000;
                            break block85;
                        }
                        case 57: {
                            if (dataBuffer.length < 34) return points;
                            short tmpVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)10);
                            short tmpCurrent = DataParser.parse2Short((byte[])dataBuffer, (int)14);
                            short tmpRevolution = DataParser.parse2Short((byte[])dataBuffer, (int)18);
                            short tmpTemperatureFet = DataParser.parse2Short((byte[])dataBuffer, (int)24);
                            if (this.application.getActiveChannelNumber() == 4 || this.getName().equals("HoTTAdapterD")) {
                                if (this.pickerParameters.isFilterEnabled && (tmpVoltage <= 0 || tmpVoltage >= 1000 || tmpCurrent >= 4000 || tmpCurrent <= -10 || tmpRevolution <= -1 || tmpRevolution >= 20000 || points[112] != 0 && points[112] / 1000 - tmpTemperatureFet > 20)) return points;
                                points[107] = tmpVoltage * 1000;
                                points[108] = tmpCurrent * 1000;
                                points[109] = DataParser.parse2Short((byte[])dataBuffer, (int)22) * 1000;
                                points[110] = Double.valueOf((double)points[107] / 1000.0 * (double)points[108]).intValue();
                                points[111] = tmpRevolution * 1000;
                                points[112] = tmpTemperatureFet * 1000;
                                break block2;
                            } else {
                                if (this.pickerParameters.isFilterEnabled && (tmpVoltage <= 0 || tmpVoltage >= 1000 || tmpCurrent >= 4000 || tmpCurrent <= -10 || tmpRevolution <= -1 || tmpRevolution >= 20000 || points[92] != 0 && points[92] / 1000 - tmpTemperatureFet > 20)) return points;
                                points[87] = tmpVoltage * 1000;
                                points[88] = tmpCurrent * 1000;
                                points[89] = DataParser.parse2Short((byte[])dataBuffer, (int)22) * 1000;
                                points[90] = Double.valueOf((double)points[87] / 1000.0 * (double)points[88]).intValue();
                                points[91] = tmpRevolution * 1000;
                                points[92] = tmpTemperatureFet * 1000;
                                break block2;
                            }
                        }
                        case 64: {
                            if (dataBuffer.length < 74) return points;
                            int i = 0;
                            int j = 0;
                            while (i < 16) {
                                points[87 + i] = (DataParser.parse2Short((byte[])dataBuffer, (int)(8 + j)) / 2 + 1500) * 1000;
                                ++i;
                                j += 2;
                            }
                            break block2;
                        }
                    }
                }
            }
        }
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        int[] points = new int[recordSet.getNoneCalculationRecordNames().length];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 1;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        int index = 0;
        for (int i = 0; i < recordDataSize; ++i) {
            index = i * dataBufferSize + timeStampBufferSize;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + index);
            }
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((dataBuffer[0 + j * 4 + index] & 0xFF) << 24) + ((dataBuffer[1 + j * 4 + index] & 0xFF) << 16) + ((dataBuffer[2 + j * 4 + index] & 0xFF) << 8) + ((dataBuffer[3 + j * 4 + index] & 0xFF) << 0);
            }
            recordSet.addNoneCalculationRecordsPoints(points, (double)(((dataBuffer[0 + i * 4] & 0xFF) << 24) + ((dataBuffer[1 + i * 4] & 0xFF) << 16) + ((dataBuffer[2 + i * 4] & 0xFF) << 8) + ((dataBuffer[3 + i * 4] & 0xFF) << 0)) / 10.0);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, int[] maxPoints, int[] minPoints, Analyzer analyzer) throws DataInconsitsentException {
        if (maxPoints.length != minPoints.length || maxPoints.length == 0) {
            throw new DataInconsitsentException("number of max/min points differs: " + maxPoints.length + "/" + minPoints.length);
        }
        int recordTimespan_ms = 10;
        UniversalSampler histoRandomSample = UniversalSampler.createSampler((int)recordSet.getChannelConfigNumber(), (int[])maxPoints, (int[])minPoints, (int)recordTimespan_ms, (Analyzer)analyzer);
        int[] points = histoRandomSample.getPoints();
        IntBuffer intBuffer = ByteBuffer.wrap(dataBuffer).asIntBuffer();
        int pointsLength = points.length;
        for (int i = 0; i < recordDataSize; ++i) {
            int iOffset = i * pointsLength + recordDataSize;
            for (int j = 0; j < pointsLength; ++j) {
                points[j] = intBuffer.get(j + iOffset);
            }
            int timeStep_ms = intBuffer.get(i) / 10;
            if (!histoRandomSample.capturePoints((long)timeStep_ms)) continue;
            recordSet.addNoneCalculationRecordsPoints(points, (double)timeStep_ms);
        }
        recordSet.syncScaleOfSyncableRecords();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.INFO, String.format("%s processed: %,9d", recordSet.getChannelConfigName(), recordDataSize));
        }
    }

    @Override
    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                boolean isChannelData;
                int ordinal = record.getOrdinal();
                boolean bl = isChannelData = recordSet.getChannelConfigNumber() == 4;
                dataTableRow[index + 1] = ordinal >= 0 && ordinal <= 5 ? String.format("%.0f", (double)record.realGet(rowIndex).intValue() / 1000.0) : (isChannelData && ordinal == 106 && record.getUnit().equals("") ? (record.realGet(rowIndex) == 0 ? "" : String.format("'%c'", record.realGet(rowIndex) / 1000 + 64)) : (ordinal == 33 && record.getUnit().endsWith("HH:mm:ss.SSS") ? HoTTAdapter.getFormattedTime(record.realGet(rowIndex)) : (ordinal == 34 && record.getUnit().endsWith("yy-MM-dd") ? HoTTAdapter.getFormattedDate(record.realGet(rowIndex) / 10) : record.getFormattedTableValue(rowIndex))));
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    @Override
    public boolean isGPSCoordinates(Record record) {
        int latOrdinal = 20;
        int lonOrdinal = 21;
        return record.getOrdinal() == 20 || record.getOrdinal() == 21;
    }

    @Override
    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = 0.0;
        int latOrdinal = 20;
        int lonOrdinal = 21;
        if (record.getOrdinal() == 20 || record.getOrdinal() == 21) {
            int grad = (int)(value / 1000.0);
            double minuten = (value - (double)grad * 1000.0) / 10.0;
            newValue = (double)grad + minuten / 60.0;
        } else if (record.getAbstractParent().getChannelConfigNumber() == 4 && record.getOrdinal() >= 87 && record.getOrdinal() <= 102 && value != 0.0) {
            if (this.pickerParameters.isChannelPercentEnabled) {
                if (!record.getUnit().equals("%")) {
                    record.setUnit("%");
                }
                factor = 0.25;
                reduction = 1500.0;
                newValue = (value - reduction) * factor + 0.001;
            } else {
                if (!record.getUnit().equals("\u00b5sec")) {
                    record.setUnit("\u00b5sec");
                }
                newValue = (value - reduction) * factor;
            }
        } else {
            newValue = (value - reduction) * factor + offset;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    @Override
    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = 0.0;
        int latOrdinal = 20;
        int lonOrdinal = 21;
        if (record.getOrdinal() == 20 || record.getOrdinal() == 21) {
            int grad = (int)value;
            double minuten = (value - (double)grad * 1.0) * 60.0;
            newValue = ((double)grad + minuten / 100.0) * 1000.0;
        } else if (record.getAbstractParent().getChannelConfigNumber() == 4 && record.getOrdinal() >= 87 && record.getOrdinal() <= 102 && value != 0.0) {
            if (this.pickerParameters.isChannelPercentEnabled) {
                if (!record.getUnit().equals("%")) {
                    record.setUnit("%");
                }
                factor = 0.25;
                reduction = 1500.0;
                newValue = value / factor + reduction - 0.001;
            } else {
                if (!record.getUnit().equals("\u00b5sec")) {
                    record.setUnit("\u00b5sec");
                }
                newValue = (value - reduction) * factor;
            }
        } else {
            newValue = (value - offset) / factor + reduction;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    @Override
    public void makeInActiveDisplayable(RecordSet recordSet) {
        if (recordSet != null) {
            this.calculateInactiveRecords(recordSet);
            recordSet.syncScaleOfSyncableRecords();
            this.updateVisibilityStatus(recordSet, true);
            this.application.updateStatisticsData();
        }
    }

    @Override
    public void calculateInactiveRecords(RecordSet recordSet) {
        int latOrdinal = 20;
        int lonOrdinal = 21;
        int altOrdinal = 10;
        int tripOrdinal = 25;
        Record recordLatitude = recordSet.get(20);
        Record recordLongitude = recordSet.get(21);
        Record recordAlitude = recordSet.get(10);
        if (recordLatitude.hasReasonableData() && recordLongitude.hasReasonableData() && recordAlitude.hasReasonableData()) {
            int recordSize = recordLatitude.realSize();
            int startAltitude = recordAlitude.get(8);
            int indexGPS = 0;
            for (int i = 0; i < recordSize; ++i) {
                if (recordLatitude.get(i) == 0 || recordLongitude.get(i) == 0) continue;
                indexGPS = i++;
                break;
            }
            startAltitude = recordAlitude.get(indexGPS);
            GPSHelper.calculateTripLength((IDevice)this, (RecordSet)recordSet, (int)20, (int)21, (int)10, (int)startAltitude, (int)25);
        }
    }

    @Override
    protected void importDeviceData() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT2400"), (String)"LogData");
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean isInitialSwitched = false;
                    HoTTAdapter2.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        if (!selectedImportFile.toLowerCase().endsWith(".bin") && !selectedImportFile.toLowerCase().endsWith(".log")) {
                            log.log(Level.WARNING, String.format("skip selectedImportFile %s since it has not a supported file ending", selectedImportFile));
                        }
                        log.log(java.util.logging.Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        String directoryName = ObjectKeyCompliance.getUpcomingObjectKey((Path)Paths.get(selectedImportFile, new String[0]));
                        if (!directoryName.isEmpty()) {
                            ObjectKeyCompliance.createObjectKey((String)directoryName);
                        }
                        try {
                            if (selectedImportFile.toLowerCase().endsWith(".bin")) {
                                HoTTbinReader2.read(selectedImportFile, new HoTTAdapter.PickerParameters(HoTTAdapter2.this.pickerParameters));
                            } else if (selectedImportFile.toLowerCase().endsWith(".log")) {
                                HoTTlogReader2.read(selectedImportFile, new HoTTAdapter.PickerParameters(HoTTAdapter2.this.pickerParameters));
                            }
                            if (!isInitialSwitched) {
                                Channel activeChannel = HoTTAdapter2.this.application.getActiveChannel();
                                HoTTbinReader2.channels.switchChannel(activeChannel.getName());
                                if (selectedImportFile.toLowerCase().endsWith(".bin")) {
                                    activeChannel.switchRecordSet(HoTTbinReader2.recordSet.getName());
                                } else if (selectedImportFile.toLowerCase().endsWith(".log")) {
                                    activeChannel.switchRecordSet(HoTTlogReader2.recordSet.getName());
                                }
                                isInitialSwitched = true;
                            } else {
                                HoTTAdapter2.this.makeInActiveDisplayable(HoTTbinReader2.recordSet);
                            }
                            WaitTimer.delay((long)500L);
                        }
                        catch (Exception e) {
                            log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    HoTTAdapter2.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    @Override
    public void updateFileExportMenu(Menu exportMenue) {
        if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
            new MenuItem(exportMenue, 2);
            MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
            convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGT2405"));
            convertKMZ3DRelativeItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKMZ3DRelativeItem action performed! " + e);
                    HoTTAdapter2.this.export2KMZ3D(0);
                }
            });
            MenuItem convertKMZDAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZDAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT2406"));
            convertKMZDAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKMZDAbsoluteItem action performed! " + e);
                    HoTTAdapter2.this.export2KMZ3D(1);
                }
            });
            convertKMZDAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZDAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT2407"));
            convertKMZDAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKMZDAbsoluteItem action performed! " + e);
                    HoTTAdapter2.this.export2KMZ3D(2);
                }
            });
        }
    }

    @Override
    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            Object[] messageParams = new String[GDE.MOD1.length + 1];
            System.arraycopy(GDE.MOD1, 0, messageParams, 1, GDE.MOD1.length);
            messageParams[0] = this.getDeviceConfiguration().getDataBlockPreferredFileExtention();
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT2416", (Object[])messageParams));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT2416"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "importDeviceLogItem action performed! " + e);
                    HoTTAdapter2.this.importDeviceData();
                }
            });
        }
    }

    @Override
    public void export2KMZ3D(int type) {
        int latOrdinal = 20;
        int lonOrdinal = 21;
        int altOrdinal = 10;
        int climbOrdinal = 11;
        int speedOrdinal = 22;
        int tripOrdinal = 25;
        new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGT2403"), 21, 20, 10, 22, 11, 25, -1, type == 0, type == 2);
    }

    @Override
    public void export2GPX(boolean isGarminExtension) {
        if (isGarminExtension) {
            new FileHandler().exportFileGPX(Messages.getString((String)"GDE_MSGT0730"), 20, 21, 10, 22, -1, -1, -1, -1, new int[]{-1, -1, -1});
        } else {
            new FileHandler().exportFileGPX(Messages.getString((String)"GDE_MSGT0730"), 20, 21, 10, 22, -1, -1, -1, -1, new int[0]);
        }
    }

    @Override
    public String translateGPS2IGC(RecordSet recordSet, int index, char fixValidity, int startAltitude, int offsetAltitude) {
        int latOrdinal = 20;
        int lonOrdinal = 21;
        int altOrdinal = 10;
        Record recordLatitude = recordSet.get(20);
        Record recordLongitude = recordSet.get(21);
        Record gpsAlitude = recordSet.get(10);
        return String.format("%02d%05d%s%03d%05d%s%c%05.0f%05.0f", recordLatitude.get(index) / 1000000, Double.valueOf((double)(recordLatitude.get(index) % 1000000) / 10.0 + 0.5).intValue(), recordLatitude.get(index) > 0 ? "N" : "S", recordLongitude.get(index) / 1000000, Double.valueOf((double)(recordLongitude.get(index) % 1000000) / 10.0 + 0.5).intValue(), recordLongitude.get(index) > 0 ? "E" : "W", Character.valueOf(fixValidity), this.translateValue(gpsAlitude, (double)gpsAlitude.get(index).intValue() / 1000.0) + (double)offsetAltitude, this.translateValue(gpsAlitude, (double)gpsAlitude.get(index).intValue() / 1000.0) + (double)offsetAltitude);
    }

    @Override
    public boolean isActualRecordSetWithGpsData() {
        RecordSet activeRecordSet;
        boolean containsGPSdata = false;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            int latOrdinal = 20;
            int lonOrdinal = 21;
            containsGPSdata = activeRecordSet.get(20).hasReasonableData() && activeRecordSet.get(21).hasReasonableData();
        }
        return containsGPSdata;
    }

    @Override
    public String exportFile(String fileEndingType, boolean isExport2TmpDir) {
        RecordSet activeRecordSet;
        String exportFileName = "";
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && fileEndingType.contains("kmz")) {
            int latOrdinal = 20;
            int lonOrdinal = 21;
            int altOrdinal = 10;
            int climbOrdinal = 11;
            int tripOrdinal = 25;
            int additionalMeasurementOrdinal = this.getGPS2KMZMeasurementOrdinal();
            exportFileName = new FileHandler().exportFileKMZ(21, 20, 10, additionalMeasurementOrdinal, 11, 25, -1, true, isExport2TmpDir);
        }
        return exportFileName;
    }

    @Override
    public Integer getGPS2KMZMeasurementOrdinal() {
        if (this.kmzMeasurementOrdinal == null) {
            return 22;
        }
        return this.kmzMeasurementOrdinal;
    }

    public String[] crossCheckMeasurements(String[] fileRecordsProperties, RecordSet recordSet) {
        StringBuilder sb = new StringBuilder().append(GDE.LINE_SEPARATOR);
        String[] recordKeys = recordSet.getRecordNames();
        Vector<String> cleanedRecordNames = new Vector<String>();
        Vector<String> noneCalculationRecordNames = new Vector<String>();
        Vector<String> fileRecordsPropertiesVector = new Vector<String>();
        fileRecordsPropertiesVector.addAll(Arrays.asList(fileRecordsProperties));
        try {
            switch (fileRecordsProperties.length) {
                case 44: {
                    HashMap recordProps;
                    int i;
                    int j = 0;
                    block73: for (i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 8: 
                            case 9: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 26: 
                            case 27: 
                            case 28: 
                            case 29: 
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 94: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: {
                                sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block73;
                            }
                            default: {
                                recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    recordSet.get(i).setActive(Boolean.valueOf(false));
                                }
                                ++j;
                            }
                        }
                    }
                    break;
                }
                case 58: {
                    HashMap recordProps;
                    int i;
                    int j = 0;
                    block74: for (i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 8: 
                            case 9: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 26: 
                            case 27: 
                            case 28: 
                            case 29: 
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: {
                                sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block74;
                            }
                            default: {
                                recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    recordSet.get(i).setActive(Boolean.valueOf(false));
                                }
                                ++j;
                            }
                        }
                    }
                    break;
                }
                case 74: {
                    HashMap recordProps;
                    int i;
                    int j = 0;
                    block75: for (i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 8: 
                            case 9: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 26: 
                            case 27: 
                            case 28: 
                            case 29: 
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 127: 
                            case 128: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 133: 
                            case 134: 
                            case 135: {
                                sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block75;
                            }
                            default: {
                                recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    recordSet.get(i).setActive(Boolean.valueOf(false));
                                }
                                ++j;
                            }
                        }
                    }
                    break;
                }
                case 64: {
                    HashMap recordProps;
                    int i;
                    int j = 0;
                    block76: for (i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 8: 
                            case 9: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 26: 
                            case 27: 
                            case 28: 
                            case 29: 
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 93: 
                            case 94: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: {
                                sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block76;
                            }
                            default: {
                                recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    recordSet.get(i).setActive(Boolean.valueOf(false));
                                }
                                ++j;
                            }
                        }
                    }
                    break;
                }
                case 84: {
                    HashMap recordProps;
                    int i;
                    int j = 0;
                    block77: for (i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 8: 
                            case 9: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 26: 
                            case 27: 
                            case 28: 
                            case 29: 
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 127: 
                            case 128: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 133: 
                            case 134: 
                            case 135: {
                                sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block77;
                            }
                            default: {
                                recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    recordSet.get(i).setActive(Boolean.valueOf(false));
                                }
                                ++j;
                            }
                        }
                    }
                    break;
                }
                case 66: {
                    HashMap recordProps;
                    int i;
                    int j = 0;
                    block78: for (i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 9: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 26: 
                            case 27: 
                            case 28: 
                            case 29: 
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 93: 
                            case 94: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: {
                                sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block78;
                            }
                            default: {
                                recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    switch (i) {
                                        case 8: 
                                        case 83: {
                                            sb.append(String.format("previous added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                            cleanedRecordNames.remove(recordKeys[i]);
                                            noneCalculationRecordNames.remove(recordProps.get("_name"));
                                            fileRecordsPropertiesVector.remove(fileRecordsProperties[j]);
                                            recordSet.get(i).setActive(null);
                                            break;
                                        }
                                        default: {
                                            recordSet.get(i).setActive(Boolean.valueOf(false));
                                        }
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                    break;
                }
                case 86: {
                    HashMap recordProps;
                    int i;
                    if (recordSet.getChannelConfigNumber() == 4) {
                        int j = 0;
                        block79: for (i = 0; i < recordKeys.length; ++i) {
                            switch (i) {
                                case 9: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 26: 
                                case 27: 
                                case 28: 
                                case 29: 
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 58: 
                                case 59: 
                                case 84: 
                                case 85: 
                                case 86: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 117: 
                                case 118: 
                                case 119: 
                                case 120: 
                                case 121: 
                                case 122: 
                                case 123: 
                                case 124: 
                                case 125: 
                                case 126: 
                                case 127: 
                                case 128: 
                                case 129: 
                                case 130: 
                                case 131: 
                                case 132: 
                                case 133: 
                                case 134: 
                                case 135: {
                                    sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                    recordSet.get(i).setActive(null);
                                    continue block79;
                                }
                                default: {
                                    recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                    sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                    cleanedRecordNames.add(recordKeys[i]);
                                    noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                    if (fileRecordsProperties[j].contains("_isActive=false")) {
                                        switch (i) {
                                            case 8: 
                                            case 83: {
                                                sb.append(String.format("previous added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                                cleanedRecordNames.remove(recordKeys[i]);
                                                noneCalculationRecordNames.remove(recordProps.get("_name"));
                                                fileRecordsPropertiesVector.remove(fileRecordsProperties[j]);
                                                recordSet.get(i).setActive(null);
                                                break;
                                            }
                                            default: {
                                                recordSet.get(i).setActive(Boolean.valueOf(false));
                                            }
                                        }
                                    }
                                    ++j;
                                }
                            }
                        }
                    } else {
                        int j = 0;
                        block80: for (i = 0; i < recordKeys.length; ++i) {
                            switch (i) {
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 29: 
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 100: 
                                case 101: 
                                case 102: 
                                case 103: 
                                case 104: 
                                case 105: 
                                case 106: 
                                case 107: 
                                case 108: 
                                case 109: 
                                case 110: 
                                case 111: 
                                case 112: 
                                case 113: 
                                case 114: 
                                case 115: {
                                    sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                    recordSet.get(i).setActive(null);
                                    continue block80;
                                }
                                default: {
                                    recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                    sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                    cleanedRecordNames.add(recordKeys[i]);
                                    noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                    if (fileRecordsProperties[j].contains("_isActive=false")) {
                                        recordSet.get(i).setActive(Boolean.valueOf(false));
                                    }
                                    ++j;
                                }
                            }
                        }
                    }
                    break;
                }
                case 72: 
                case 77: {
                    HashMap recordProps;
                    int i;
                    int j = 0;
                    block81: for (i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 9: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 26: 
                            case 27: 
                            case 28: 
                            case 29: 
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 83: 
                            case 85: 
                            case 86: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: {
                                sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block81;
                            }
                            default: {
                                recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    recordSet.get(i).setActive(Boolean.valueOf(false));
                                }
                                ++j;
                            }
                        }
                    }
                    break;
                }
                case 92: {
                    HashMap recordProps;
                    int i;
                    int j = 0;
                    block82: for (i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 9: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 26: 
                            case 27: 
                            case 28: 
                            case 29: 
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 127: 
                            case 128: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 133: 
                            case 134: 
                            case 135: {
                                sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block82;
                            }
                            default: {
                                recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    recordSet.get(i).setActive(Boolean.valueOf(false));
                                }
                                ++j;
                            }
                        }
                    }
                    break;
                }
                case 106: {
                    HashMap recordProps;
                    int i;
                    int j = 0;
                    block83: for (i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 29: 
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 127: 
                            case 128: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 133: 
                            case 134: 
                            case 135: {
                                sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block83;
                            }
                            default: {
                                recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    recordSet.get(i).setActive(Boolean.valueOf(false));
                                }
                                ++j;
                            }
                        }
                    }
                    break;
                }
                case 91: {
                    HashMap recordProps;
                    int i;
                    int j = 0;
                    block84: for (i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 29: 
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: {
                                sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block84;
                            }
                            default: {
                                recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    recordSet.get(i).setActive(Boolean.valueOf(false));
                                }
                                ++j;
                            }
                        }
                    }
                    break;
                }
                case 95: {
                    HashMap recordProps;
                    int i;
                    int j = 0;
                    block85: for (i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: {
                                sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block85;
                            }
                            default: {
                                recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    recordSet.get(i).setActive(Boolean.valueOf(false));
                                }
                                ++j;
                            }
                        }
                    }
                    break;
                }
                case 115: {
                    HashMap recordProps;
                    int i;
                    int j = 0;
                    block86: for (i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 127: 
                            case 128: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 133: 
                            case 134: 
                            case 135: {
                                sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block86;
                            }
                            default: {
                                recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    recordSet.get(i).setActive(Boolean.valueOf(false));
                                }
                                ++j;
                            }
                        }
                    }
                    break;
                }
                case 100: {
                    HashMap recordProps;
                    int i;
                    int j = 0;
                    block87: for (i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: {
                                sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block87;
                            }
                            default: {
                                recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    recordSet.get(i).setActive(Boolean.valueOf(false));
                                }
                                ++j;
                            }
                        }
                    }
                    break;
                }
                case 120: {
                    HashMap recordProps;
                    int i;
                    int j = 0;
                    block88: for (i = 0; i < recordKeys.length; ++i) {
                        switch (i) {
                            case 120: 
                            case 121: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 127: 
                            case 128: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 133: 
                            case 134: 
                            case 135: {
                                sb.append(String.format("added measurement set to isCalculation=true -> %s\n", recordKeys[i]));
                                recordSet.get(i).setActive(null);
                                continue block88;
                            }
                            default: {
                                recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%19s match %19s isAvtive = %s\n", recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    recordSet.get(i).setActive(Boolean.valueOf(false));
                                }
                                ++j;
                            }
                        }
                    }
                    break;
                }
                default: {
                    int i;
                    cleanedRecordNames.addAll(Arrays.asList(recordKeys));
                    for (i = 0; i < fileRecordsProperties.length; ++i) {
                        HashMap recordProps = StringHelper.splitString((String)fileRecordsProperties[i], (String)"|-|", (String[])Record.propertyKeys);
                        if (fileRecordsProperties[i].contains("_isActive=true")) {
                            noneCalculationRecordNames.add((String)recordProps.get("_name"));
                            continue;
                        }
                        if (fileRecordsProperties[i].contains("_isActive=false")) {
                            recordSet.get(i).setActive(Boolean.valueOf(false));
                            noneCalculationRecordNames.add((String)recordProps.get("_name"));
                            continue;
                        }
                        recordSet.get(i).setActive(null);
                    }
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, String.format("recordKey to fileRecordsProperties mismatch, check:\n %s \nfileRecordsProperties.length = %d recordKeys.length = %d %s", e.getMessage(), fileRecordsProperties.length, recordKeys.length, sb.toString()));
        }
        recordKeys = cleanedRecordNames.toArray(new String[1]);
        recordSet.setNoneCalculationRecordNames(noneCalculationRecordNames.toArray(new String[1]));
        if (fileRecordsProperties.length != fileRecordsPropertiesVector.size()) {
            for (int i = 0; i < fileRecordsPropertiesVector.size(); ++i) {
                fileRecordsProperties[i] = (String)fileRecordsPropertiesVector.get(i);
            }
        }
        if ((recordKeys.length < 116 || recordKeys.length < 136 && recordSet.getChannelConfigNumber() == 4) && noneCalculationRecordNames.size() < fileRecordsPropertiesVector.size()) {
            sb.append(String.format("recordKeys.length = %d\n", recordKeys.length));
            sb.append(String.format("noneCalculationRecords.length = %d\n", noneCalculationRecordNames.size()));
            sb.append(String.format("fileRecordsProperties.length = %d\n", fileRecordsProperties.length));
            sb.append(String.format("recordSet.getNoneCalculationMeasurementNames.length = %d\n", this.getNoneCalculationMeasurementNames(recordSet.getChannelConfigNumber(), recordSet.getRecordNames()).length));
            sb.append(String.format("recordSet.getRecordNames.length = %d\n", recordSet.getRecordNames().length));
            log.log(Level.SEVERE, sb.toString());
            if (GDE.isWithUi()) {
                this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGE2402"));
            }
        }
        return recordKeys;
    }

    @Override
    public boolean isHistoImportSupported() {
        return ((Object)((Object)this)).getClass().equals(HoTTAdapter2.class) && !((Object)((Object)this)).getClass().equals(HoTTAdapter2M.class);
    }

    @Override
    public void getRecordSetFromImportFile(Supplier<InputStream> inputStream, VaultCollector truss, Analyzer analyzer) throws DataInconsitsentException, IOException, DataTypeException {
        String fileEnding = PathUtils.getFileExtention((String)truss.getVault().getLoadFilePath());
        if (".bin".equals(fileEnding)) {
            new HoTTbinHistoReader2(new HoTTAdapter.PickerParameters(analyzer)).read(inputStream, truss);
        } else if (".log".equals(fileEnding)) {
            HashMap<String, String> infoHeader = null;
            try (BufferedInputStream info_in = new BufferedInputStream(inputStream.get());){
                infoHeader = new HoTTbinReader.InfoParser(s -> {}).getFileInfo(info_in, truss.getVault().getLoadFilePath(), truss.getVault().getLogFileLength());
                if (infoHeader == null || infoHeader.isEmpty()) {
                    return;
                }
                if (Integer.parseInt(infoHeader.get("LogCount")) <= 1400) {
                    return;
                }
                HoTTlogHistoReader2 histoReader = new HoTTlogHistoReader2(new HoTTAdapter.PickerParameters(analyzer), infoHeader);
                histoReader.read(inputStream, truss);
            }
        } else {
            throw new UnsupportedOperationException(truss.getVault().getLoadFilePath());
        }
    }

    @Override
    public int[] getAtlitudeTripSpeedOrdinals() {
        RecordSet activeRecordSet = this.application.getActiveChannel().getActiveRecordSet();
        if (activeRecordSet.get(10).hasReasonableData() && activeRecordSet.get(20).hasReasonableData() && activeRecordSet.get(21).hasReasonableData()) {
            return new int[]{10, 20, 21};
        }
        return new int[0];
    }

    @Override
    public void applyMeasurementSpecialties(String[] fileRecordsProperties, RecordSet recordSet) {
        int endIndex;
        int startIndex;
        Record record;
        int i;
        for (i = 15; i < 19; ++i) {
            record = recordSet.get(i);
            if (record == null || record.getName().startsWith("vari")) continue;
            if (fileRecordsProperties[i].contains("factor_DOUBLE=")) {
                startIndex = fileRecordsProperties[i].indexOf("factor_DOUBLE=") + "factor_DOUBLE=".length();
                endIndex = fileRecordsProperties[i].indexOf("|-|", startIndex);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, record.getName() + " set - factor_DOUBLE " + fileRecordsProperties[i].substring(startIndex, endIndex));
                }
                record.setFactor(Double.parseDouble(fileRecordsProperties[i].substring(startIndex, endIndex)));
            }
            if (!fileRecordsProperties[i].contains("scale_sync_ref_ordinal_INTEGER=")) continue;
            startIndex = fileRecordsProperties[i].indexOf("scale_sync_ref_ordinal_INTEGER=") + "scale_sync_ref_ordinal_INTEGER=".length();
            endIndex = fileRecordsProperties[i].indexOf("|-|", startIndex);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, record.getName() + " set - scale_sync_ref_ordinal_INTEGER " + fileRecordsProperties[i].substring(startIndex, endIndex));
            }
            record.createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)Integer.parseInt(fileRecordsProperties[i].substring(startIndex, endIndex)));
        }
        for (i = 33; i < 36; ++i) {
            record = recordSet.get(i);
            if (record == null || record.getName().startsWith("vari")) continue;
            if (fileRecordsProperties[i].contains("factor_DOUBLE=")) {
                startIndex = fileRecordsProperties[i].indexOf("factor_DOUBLE=") + "factor_DOUBLE=".length();
                endIndex = fileRecordsProperties[i].indexOf("|-|", startIndex);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, record.getName() + " set - factor_DOUBLE " + fileRecordsProperties[i].substring(startIndex, endIndex));
                }
                record.setFactor(Double.parseDouble(fileRecordsProperties[i].substring(startIndex, endIndex)));
            }
            if (!fileRecordsProperties[i].contains("scale_sync_ref_ordinal_INTEGER=")) continue;
            startIndex = fileRecordsProperties[i].indexOf("scale_sync_ref_ordinal_INTEGER=") + "scale_sync_ref_ordinal_INTEGER=".length();
            endIndex = fileRecordsProperties[i].indexOf("|-|", startIndex);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, record.getName() + " set - scale_sync_ref_ordinal_INTEGER " + fileRecordsProperties[i].substring(startIndex, endIndex));
            }
            record.createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)Integer.parseInt(fileRecordsProperties[i].substring(startIndex, endIndex)));
        }
        if (recordSet.getChannelConfigNumber() == 4) {
            for (i = 120; i < 135 && i < fileRecordsProperties.length; ++i) {
                record = recordSet.get(i);
                if (record == null || record.getName().startsWith("vari")) continue;
                if (fileRecordsProperties[i].contains("factor_DOUBLE=")) {
                    startIndex = fileRecordsProperties[i].indexOf("factor_DOUBLE=") + "factor_DOUBLE=".length();
                    endIndex = fileRecordsProperties[i].indexOf("|-|", startIndex);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, record.getName() + " set - factor_DOUBLE " + fileRecordsProperties[i].substring(startIndex, endIndex));
                    }
                    record.setFactor(Double.parseDouble(fileRecordsProperties[i].substring(startIndex, endIndex)));
                }
                if (!fileRecordsProperties[i].contains("scale_sync_ref_ordinal_INTEGER=")) continue;
                startIndex = fileRecordsProperties[i].indexOf("scale_sync_ref_ordinal_INTEGER=") + "scale_sync_ref_ordinal_INTEGER=".length();
                endIndex = fileRecordsProperties[i].indexOf("|-|", startIndex);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, record.getName() + " set - scale_sync_ref_ordinal_INTEGER " + fileRecordsProperties[i].substring(startIndex, endIndex));
                }
                record.createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)Integer.parseInt(fileRecordsProperties[i].substring(startIndex, endIndex)));
            }
        } else {
            for (i = 100; i < 115 && i < fileRecordsProperties.length; ++i) {
                record = recordSet.get(i);
                if (record == null || record.getName().startsWith("vari")) continue;
                if (fileRecordsProperties[i].contains("factor_DOUBLE=")) {
                    startIndex = fileRecordsProperties[i].indexOf("factor_DOUBLE=") + "factor_DOUBLE=".length();
                    endIndex = fileRecordsProperties[i].indexOf("|-|", startIndex);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, record.getName() + " set - factor_DOUBLE " + fileRecordsProperties[i].substring(startIndex, endIndex));
                    }
                    record.setFactor(Double.parseDouble(fileRecordsProperties[i].substring(startIndex, endIndex)));
                }
                if (!fileRecordsProperties[i].contains("scale_sync_ref_ordinal_INTEGER=")) continue;
                startIndex = fileRecordsProperties[i].indexOf("scale_sync_ref_ordinal_INTEGER=") + "scale_sync_ref_ordinal_INTEGER=".length();
                endIndex = fileRecordsProperties[i].indexOf("|-|", startIndex);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, record.getName() + " set - scale_sync_ref_ordinal_INTEGER " + fileRecordsProperties[i].substring(startIndex, endIndex));
                }
                record.createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)Integer.parseInt(fileRecordsProperties[i].substring(startIndex, endIndex)));
            }
        }
    }

    protected static void updateVarioTypeDependent(int version, IDevice device, RecordSet tmpRecordSet) {
        if (version > 100 && version < 120) {
            tmpRecordSet.get(15).setName(device.getMeasurementReplacement("acceleration") + " X Vario");
            tmpRecordSet.get(15).setUnit("g");
            tmpRecordSet.get(16).setName(device.getMeasurementReplacement("acceleration") + " Y Vario");
            tmpRecordSet.get(16).setUnit("g");
            tmpRecordSet.get(16).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)15);
            tmpRecordSet.get(17).setName(device.getMeasurementReplacement("acceleration") + " Z Vario");
            tmpRecordSet.get(17).setUnit("g");
            tmpRecordSet.get(17).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)15);
            tmpRecordSet.get(18).setName(device.getMeasurementReplacement("air_speed") + " Vario");
            tmpRecordSet.get(18).setUnit("km/h");
            tmpRecordSet.get(18).setFactor(2.0);
            tmpRecordSet.get(19).setName("Version Vario");
            tmpRecordSet.get(19).setUnit("#");
        }
    }

    protected static void updateGpsTypeDependent(int version, IDevice device, RecordSet tmpRecordSet, int numberLogEntriesProcessed) {
        if (version > 100) {
            tmpRecordSet.get(30).setName(device.getMeasurementReplacement("servo_impulse") + " GPS");
            tmpRecordSet.get(30).setUnit("%");
            tmpRecordSet.get(31).setName(device.getMeasurementReplacement("air_speed") + " GPS");
            tmpRecordSet.get(31).setUnit("km/h");
            tmpRecordSet.get(31).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)22);
            tmpRecordSet.get(33).setName(device.getMeasurementReplacement("acceleration") + " X GPS");
            tmpRecordSet.get(33).setUnit("g");
            tmpRecordSet.get(33).setFactor(0.01);
            tmpRecordSet.get(34).setName(device.getMeasurementReplacement("acceleration") + " Y GPS");
            tmpRecordSet.get(34).setUnit("g");
            tmpRecordSet.get(34).setFactor(0.01);
            tmpRecordSet.get(34).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)33);
            tmpRecordSet.get(35).setName(device.getMeasurementReplacement("acceleration") + " Z GPS");
            tmpRecordSet.get(35).setUnit("g");
            tmpRecordSet.get(35).setFactor(0.01);
            tmpRecordSet.get(35).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)33);
            tmpRecordSet.get(36).setName("ENL");
            tmpRecordSet.get(36).setUnit("");
        } else if (version == 4) {
            tmpRecordSet.get(30).setName(device.getMeasurementReplacement("servo_impulse") + " GPS");
            tmpRecordSet.get(30).setUnit("%");
            tmpRecordSet.get(32).setName(device.getMeasurementReplacement("voltage") + " GPS");
            tmpRecordSet.get(32).setUnit("V");
            tmpRecordSet.get(33).setName(device.getMeasurementReplacement("time") + " GPS");
            tmpRecordSet.get(33).setUnit("HH:mm:ss.SSS");
            tmpRecordSet.get(33).setFactor(1.0);
            tmpRecordSet.get(34).setName(device.getMeasurementReplacement("date") + " GPS");
            tmpRecordSet.get(34).setUnit("yy-MM-dd");
            tmpRecordSet.get(34).setFactor(1.0);
            tmpRecordSet.get(35).setName(device.getMeasurementReplacement("altitude") + " MSL");
            tmpRecordSet.get(35).setUnit("m");
            tmpRecordSet.get(35).setFactor(1.0);
            tmpRecordSet.get(36).setName("ENL");
            tmpRecordSet.get(36).setUnit("%");
            if (numberLogEntriesProcessed >= 0) {
                tmpRecordSet.setStartTimeStamp(HoTTbinReader.getStartTimeStamp(tmpRecordSet.getStartTimeStamp(), (Integer)tmpRecordSet.get(33).lastElement(), numberLogEntriesProcessed));
            }
        } else if (version == 1) {
            tmpRecordSet.get(30).setName("velNorth");
            tmpRecordSet.get(30).setUnit("mm/s");
            tmpRecordSet.get(32).setName("speedAcc");
            tmpRecordSet.get(32).setUnit("cm/s");
            tmpRecordSet.get(33).setName(device.getMeasurementReplacement("time") + " GPS");
            tmpRecordSet.get(33).setUnit("HH:mm:ss.SSS");
            tmpRecordSet.get(33).setFactor(1.0);
            tmpRecordSet.get(35).setName("velEast");
            tmpRecordSet.get(35).setUnit("mm/s");
            tmpRecordSet.get(35).setFactor(1.0);
            tmpRecordSet.get(36).setName("HDOP");
            tmpRecordSet.get(36).setUnit("dm");
            if (numberLogEntriesProcessed >= 0) {
                tmpRecordSet.setStartTimeStamp(HoTTbinReader.getStartTimeStamp(tmpRecordSet.getStartTimeStamp(), (Integer)tmpRecordSet.get(33).lastElement(), numberLogEntriesProcessed - 1));
            }
        } else if (version == 0) {
            tmpRecordSet.get(33).setName(device.getMeasurementReplacement("time") + " GPS");
            tmpRecordSet.get(33).setUnit("HH:mm:ss.SSS");
            tmpRecordSet.get(33).setFactor(1.0);
            tmpRecordSet.get(35).setName(device.getMeasurementReplacement("altitude") + " MSL");
            tmpRecordSet.get(35).setUnit("m");
            tmpRecordSet.get(35).setFactor(1.0);
            if (numberLogEntriesProcessed >= 0) {
                tmpRecordSet.setStartTimeStamp(HoTTbinReader.getStartTimeStamp(tmpRecordSet.getStartTimeStamp(), (Integer)tmpRecordSet.get(33).lastElement(), numberLogEntriesProcessed - 1));
            }
        } else {
            tmpRecordSet.get(30).setName("Byte GPS_1");
            tmpRecordSet.get(31).setName("Byte GPS_2");
            tmpRecordSet.get(32).setName("Byte GPS_3");
            tmpRecordSet.get(33).setName("Short GPS_4");
            tmpRecordSet.get(34).setName("Short GPS_5");
            tmpRecordSet.get(35).setName("Short GPS_6");
            tmpRecordSet.get(36).setName("Byte GPS_7");
        }
    }

    protected static void updateEscTypeDependent(int version, IDevice device, RecordSet tmpRecordSet) {
        if (version == 3) {
            int channelConfigNumber = tmpRecordSet.getChannelConfigNumber();
            int channelOffset = channelConfigNumber == 4 ? 20 : 0;
            tmpRecordSet.get(100 + channelOffset).setName(device.getMeasurementReplacement("speed") + " M");
            tmpRecordSet.get(100 + channelOffset).setUnit("km/h");
            device.getMeasurement(channelConfigNumber, 100 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(101 + channelOffset).setName(device.getMeasurementReplacement("speed") + " M_max");
            tmpRecordSet.get(101 + channelOffset).setUnit("km/h");
            tmpRecordSet.get(102 + channelOffset).setName("PWM M");
            tmpRecordSet.get(102 + channelOffset).setUnit("%");
            tmpRecordSet.get(103 + channelOffset).setName(device.getMeasurementReplacement("throttle") + " M");
            tmpRecordSet.get(103 + channelOffset).setUnit("%");
            tmpRecordSet.get(104 + channelOffset).setName(device.getMeasurementReplacement("voltage_bec") + " M");
            tmpRecordSet.get(104 + channelOffset).setUnit("V");
            tmpRecordSet.get(104 + channelOffset).setFactor(0.1);
            device.getMeasurement(channelConfigNumber, 104 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(104 + channelOffset).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)6);
            tmpRecordSet.get(105 + channelOffset).setName(device.getMeasurementReplacement("voltage_bec") + " M_min");
            tmpRecordSet.get(105 + channelOffset).setUnit("V");
            tmpRecordSet.get(105 + channelOffset).setFactor(0.1);
            tmpRecordSet.get(105 + channelOffset).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)6);
            tmpRecordSet.get(106 + channelOffset).setName(device.getMeasurementReplacement("current_bec") + " M");
            tmpRecordSet.get(106 + channelOffset).setUnit("A");
            tmpRecordSet.get(106 + channelOffset).setFactor(0.1);
            device.getMeasurement(channelConfigNumber, 106 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(107 + channelOffset).setName(device.getMeasurementReplacement("temperature_bec") + " M");
            tmpRecordSet.get(107 + channelOffset).setUnit("\u00b0C");
            tmpRecordSet.get(107 + channelOffset).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)7);
            device.getMeasurement(channelConfigNumber, 107 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(108 + channelOffset).setName(device.getMeasurementReplacement("temperature_capacitor") + " M");
            tmpRecordSet.get(108 + channelOffset).setUnit("\u00b0C");
            tmpRecordSet.get(108 + channelOffset).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)7);
            device.getMeasurement(channelConfigNumber, 108 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(109 + channelOffset).setName(device.getMeasurementReplacement("timing") + " M");
            tmpRecordSet.get(109 + channelOffset).setUnit("\u00b0");
            tmpRecordSet.get(110 + channelOffset).setName(device.getMeasurementReplacement("temperature") + " M_3");
            tmpRecordSet.get(110 + channelOffset).setUnit("\u00b0C");
            tmpRecordSet.get(110 + channelOffset).createProperty(IDevice.SYNC_ORDINAL, DataTypes.INTEGER, (Object)7);
            device.getMeasurement(channelConfigNumber, 110 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(111 + channelOffset).setName(device.getMeasurementReplacement("gear") + " M");
            tmpRecordSet.get(111 + channelOffset).setUnit("");
            tmpRecordSet.get(112 + channelOffset).setName("YGEGenExt M");
            tmpRecordSet.get(112 + channelOffset).setUnit("");
            tmpRecordSet.get(113 + channelOffset).setName("MotStatEscNr M");
            tmpRecordSet.get(113 + channelOffset).setUnit("#");
        } else if (version >= 128) {
            int channelConfigNumber = tmpRecordSet.getChannelConfigNumber();
            int channelOffset = channelConfigNumber == 4 ? 20 : 0;
            tmpRecordSet.get(87 + channelOffset).setName(device.getMeasurementReplacement("voltage") + " ECU");
            tmpRecordSet.get(88 + channelOffset).setName(device.getMeasurementReplacement("current") + " ECU");
            tmpRecordSet.get(92 + channelOffset).setName(device.getMeasurementReplacement("temperature") + " EGT 1");
            tmpRecordSet.get(93 + channelOffset).setName(device.getMeasurementReplacement("temperature") + " EGT 2");
            tmpRecordSet.get(94 + channelOffset).setName(device.getMeasurementReplacement("voltage") + " ECU_min");
            tmpRecordSet.get(95 + channelOffset).setName(device.getMeasurementReplacement("current") + " ECU_max");
            tmpRecordSet.get(97 + channelOffset).setName(device.getMeasurementReplacement("temperature") + " EGT 1_max");
            tmpRecordSet.get(98 + channelOffset).setName(device.getMeasurementReplacement("temperature") + " EGT 2_max");
            tmpRecordSet.get(100 + channelOffset).setName(device.getMeasurementReplacement("air_speed") + " M");
            tmpRecordSet.get(100 + channelOffset).setUnit("km/h");
            device.getMeasurement(channelConfigNumber, 100 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(101 + channelOffset).setName(device.getMeasurementReplacement("air_speed") + " M_max");
            tmpRecordSet.get(101 + channelOffset).setUnit("km/h");
            tmpRecordSet.get(102 + channelOffset).setName("PWM M");
            tmpRecordSet.get(102 + channelOffset).setUnit("%");
            tmpRecordSet.get(103 + channelOffset).setName(device.getMeasurementReplacement("throttle") + " M");
            tmpRecordSet.get(103 + channelOffset).setUnit("%");
            tmpRecordSet.get(104 + channelOffset).setName(device.getMeasurementReplacement("voltage_pump") + " M");
            tmpRecordSet.get(104 + channelOffset).setUnit("V");
            tmpRecordSet.get(104 + channelOffset).setFactor(0.1);
            device.getMeasurement(channelConfigNumber, 104 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(105 + channelOffset).setName(device.getMeasurementReplacement("voltage_pump") + " M_min");
            tmpRecordSet.get(105 + channelOffset).setUnit("V");
            tmpRecordSet.get(105 + channelOffset).setFactor(0.1);
            tmpRecordSet.get(106 + channelOffset).setName(device.getMeasurementReplacement("flow") + " M");
            tmpRecordSet.get(106 + channelOffset).setUnit("ml/min");
            device.getMeasurement(channelConfigNumber, 106 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(107 + channelOffset).setName(device.getMeasurementReplacement("fuel") + " M");
            tmpRecordSet.get(107 + channelOffset).setUnit("ml");
            device.getMeasurement(channelConfigNumber, 107 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(108 + channelOffset).setName(device.getMeasurementReplacement("power") + " M");
            tmpRecordSet.get(108 + channelOffset).setUnit("W");
            device.getMeasurement(channelConfigNumber, 108 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(109 + channelOffset).setName(device.getMeasurementReplacement("thrust") + " M");
            tmpRecordSet.get(109 + channelOffset).setUnit("N");
            tmpRecordSet.get(110 + channelOffset).setName(device.getMeasurementReplacement("temperature_pump") + " M");
            tmpRecordSet.get(110 + channelOffset).setUnit("\u00b0C");
            device.getMeasurement(channelConfigNumber, 110 + channelOffset).setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
            tmpRecordSet.get(111 + channelOffset).setName(device.getMeasurementReplacement("engine") + " M");
            tmpRecordSet.get(111 + channelOffset).setUnit("");
        }
    }

    public static boolean isAltClimbSensor(EnumSet<HoTTAdapter.Sensor> detectedSensors) {
        return detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO) || detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS) || detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM) || detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM);
    }
}

