/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.Analyzer;
import gde.device.IChannelItem;
import gde.device.MeasurementType;
import gde.device.StatisticsType;
import gde.device.TrailDisplayType;
import gde.device.TrailTypes;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailSelector;
import gde.log.Level;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;

public final class MeasurementTrailSelector
extends TrailSelector {
    private String triggerScaleRawText = "";
    private String triggerScaleUnit = "";

    public MeasurementTrailSelector(TrailRecord trailRecord) {
        super(trailRecord);
    }

    public MeasurementTrailSelector(Analyzer analyzer, IChannelItem channelItem, String recordName, boolean smartStatistics) {
        super(analyzer, channelItem, recordName, smartStatistics);
    }

    @Override
    protected void setApplicableTrails() {
        BitSet applicablePrimitiveTrails = this.getApplicablePrimitiveTrails();
        this.applicableTrailsOrdinals = new ArrayList();
        this.applicableTrailsTexts = new ArrayList();
        applicablePrimitiveTrails.stream().forEach(i -> {
            this.applicableTrailsOrdinals.add(i);
            this.applicableTrailsTexts.add(TrailTypes.VALUES[i].getDisplayNameWithTriggerText(this.channelItem));
        });
        this.setApplicableSuiteTrails();
        log.finer(() -> this.recordName + " texts " + this.applicableTrailsTexts);
        log.finer(() -> this.recordName + " ordinals " + this.applicableTrailsOrdinals);
    }

    private BitSet getApplicablePrimitiveTrails() {
        Optional<TrailDisplayType> trailDisplay = this.channelItem.getTrailDisplay();
        if (trailDisplay.map(TrailDisplayType::getDefaultTrail).map(TrailTypes::isSuite).orElse(false).booleanValue()) {
            throw new UnsupportedOperationException("suite trail must not be a devices's channel item default");
        }
        BitSet trails = new BitSet();
        TrailTypes.getPrimitives().stream().filter(t -> !t.isTriggered()).filter(t -> !TrailTypes.OPTIONAL_TRAILS.contains(t)).filter(t -> t.isSmartStatistics() == this.smartStatistics).map(Enum::ordinal).forEach(idx -> trails.set((int)idx));
        trails.or(this.getApplicablePrimitiveTriggeredTrails());
        trailDisplay.ifPresent(d -> this.adaptTrailsToDisplayType(trails, (TrailDisplayType)d));
        if (trails.isEmpty()) {
            trails.set(TrailTypes.getSubstitute(this.smartStatistics).ordinal());
        }
        log.finer(() -> this.recordName + " data " + trails.toString());
        return trails;
    }

    private BitSet getApplicablePrimitiveTriggeredTrails() {
        BitSet trails = new BitSet();
        if (((MeasurementType)this.channelItem).getStatistics() != null && !this.smartStatistics) {
            StatisticsType stats = ((MeasurementType)this.channelItem).getStatistics();
            if (stats.getSumByTriggerRefOrdinal() != null && stats.getSumTriggerText() != null && stats.getSumTriggerText().length() > 1) {
                trails.set(TrailTypes.REAL_SUM_TRIGGERED.ordinal());
            }
            if (stats.getRatioRefOrdinal() != null && stats.getRatioText() != null && stats.getRatioText().length() > 1) {
                trails.set(TrailTypes.REAL_MAX_RATIO_TRIGGERED.ordinal());
            }
            if (stats.getTrigger() != null && stats.getSumTriggerTimeText() != null && stats.getSumTriggerTimeText().length() > 1) {
                trails.set(TrailTypes.REAL_TIME_SUM_TRIGGERED.ordinal());
            }
            if (stats.isCountByTrigger() != null) {
                trails.set(TrailTypes.REAL_COUNT_TRIGGERED.ordinal());
            }
        }
        return trails;
    }

    @Override
    public void setTrailTextSelectedIndex(int value) {
        this.trailTextSelectedIndex = value;
        this.setTriggerScaleTexts(this.getTrailType());
    }

    private TrailTypes getTrailType() {
        if (this.trailTextSelectedIndex < 0) {
            log.log(Level.SEVERE, "index not defined yet ", this.trailTextSelectedIndex);
            throw new UnsupportedOperationException();
        }
        return TrailTypes.fromOrdinal((Integer)this.applicableTrailsOrdinals.get(this.trailTextSelectedIndex));
    }

    @Override
    public boolean isTrailSuite() {
        return this.getTrailType().isSuite();
    }

    @Override
    public boolean isRangePlotSuite() {
        return this.getTrailType().isRangePlot();
    }

    @Override
    public boolean isBoxPlotSuite() {
        return this.getTrailType().isBoxPlot();
    }

    @Override
    public boolean isOddRangeTrail() {
        return TrailTypes.ODD_RANGE_TRAILS.contains((Object)this.getTrailType());
    }

    @Override
    public int getSuiteMasterIndex() {
        return this.getTrailType().getSuiteMasterIndex();
    }

    @Override
    public List<TrailTypes> getSuiteMembers() {
        return this.getTrailType().getSuiteMembers();
    }

    public boolean isTriggerTrail() {
        return this.getTrailType().isTriggered();
    }

    protected void setTriggerScaleTexts(TrailTypes trailType) {
        if (!this.smartStatistics || ((MeasurementType)this.channelItem).getStatistics() == null) {
            StatisticsType measurementStatistics = ((MeasurementType)this.channelItem).getStatistics();
            if (trailType == TrailTypes.REAL_SUM_TRIGGERED && measurementStatistics.getSumTriggerText() != null && measurementStatistics.getSumTriggerText().length() > 1 && measurementStatistics.getSumByTriggerRefOrdinal() != null) {
                this.triggerScaleRawText = measurementStatistics.getSumTriggerText();
                this.triggerScaleUnit = this.channelItem.getUnit();
            } else if (trailType == TrailTypes.REAL_MAX_RATIO_TRIGGERED && measurementStatistics.getRatioText() != null && measurementStatistics.getRatioText().length() > 1 && measurementStatistics.getRatioRefOrdinal() != null) {
                this.triggerScaleRawText = measurementStatistics.getRatioText();
                this.triggerScaleUnit = "/" + this.channelItem.getUnit();
            } else if (trailType == TrailTypes.REAL_TIME_SUM_TRIGGERED && measurementStatistics.getTrigger() != null && measurementStatistics.getSumTriggerTimeText() != null && measurementStatistics.getSumTriggerTimeText().length() > 1) {
                this.triggerScaleRawText = measurementStatistics.getSumTriggerTimeText();
                this.triggerScaleUnit = "sec";
            } else if (trailType == TrailTypes.REAL_COUNT_TRIGGERED && measurementStatistics.isCountByTrigger() != null) {
                this.triggerScaleRawText = measurementStatistics.getCountTriggerText();
                this.triggerScaleUnit = "1";
            }
        } else {
            this.triggerScaleRawText = "";
            this.triggerScaleUnit = "";
        }
    }

    public String getTriggerScaleRawText() {
        return this.triggerScaleRawText;
    }

    public String getTriggerScaleUnit() {
        return this.triggerScaleUnit;
    }
}

