/*
 * Decompiled with CFR 0.152.
 */
package gde.config;

import gde.Analyzer;
import gde.DataAccess;
import gde.GDE;
import gde.config.DeviceSerialization;
import gde.config.ExportService;
import gde.log.Level;
import gde.log.LogFormatter;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.FileUtils;
import gde.utils.RecordSetNameComparator;
import gde.utils.StringHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.xml.sax.SAXException;

public final class Settings
extends Properties {
    private static final long serialVersionUID = 26031957L;
    private static final Logger log = Logger.getLogger(Settings.class.getName());
    private static final String $CLASS_NAME = Settings.class.getName();
    private static volatile Settings instance = null;
    public static final String EMPTY = "---";
    public static final String EMPTY_SIGNATURE = "---;---;---";
    static final String UNIX_PORT_DEV_TTY = "/dev/tty";
    static final String WINDOWS_PORT_COM = "COM";
    public static final String PERMISSION_555 = "555";
    public static final String PATH_RESOURCE = "resource/";
    public static final String PATH_RESOURCE_TEMPLATE = "resource/template/";
    static final String HEADER_TEXT = "# -- DataExplorer Settings File -- ";
    static final String DEVICE_BLOCK = "#[Actual-Device-Port-Settings]";
    static final String WINDOW_BLOCK = "#[Window-Settings]";
    static final String WINDOW_MAXIMIZED = "window_maximized";
    static final String WINDOW_LEFT = "window_left";
    static final String WINDOW_TOP = "window_top";
    static final String WINDOW_WIDTH = "window_width";
    static final String WINDOW_HEIGHT = "window_height";
    static final String COOLBAR_ORDER = "coolbar_order";
    static final String COOLBAR_WRAPS = "coolbar_wraps";
    static final String COOLBAR_SIZES = "coolbar_sizes";
    static final String RECORD_COMMENT_VISIBLE = "record_comment_visible";
    static final String GRAPHICS_HEADER_VISIBLE = "graphics_header_visible";
    static final String GRAPHICS_AREA_BACKGROUND = "graphics_area_background";
    static final String GRAPHICS_SURROUND_BACKGRD = "graphics_surround_backgrd";
    static final String GRAPHICS_BORDER_COLOR = "graphics_border_color";
    static final String IS_GRAPHICS_SCALE_COLOR = "is_graphics_scale_color";
    static final String IS_GRAPHICS_NUMBERS_COLOR = "is_graphics_number_color";
    static final String IS_GRAPHICS_NAME_COLOR = "is_graphics_text_color";
    static final String IS_GRAPHICS_TICKS_10 = "is_graphics_ticks_bound_10";
    static final String COMPARE_AREA_BACKGROUND = "compare_area_background";
    static final String COMPARE_SURROUND_BACKGRD = "compare_surround_backgrd";
    static final String COMPARE_BORDER_COLOR = "compare_border_color";
    static final String IS_COMPARE_CHANNELCONFIG = "is_compare_channel_config_name";
    static final String UTILITY_AREA_BACKGROUND = "utility_area_background";
    static final String UTILITY_SURROUND_BACKGRD = "utility_surround_backgrd";
    static final String UTILITY_BORDER_COLOR = "utility_border_color";
    static final String STATISTICS_INNER_BACKGROUND = "statistics_inner_background";
    static final String STATISTICS_SURROUND_BACKGRD = "statistics_surround_backgrd";
    static final String ANALOG_INNER_BACKGROUND = "analog_inner_background";
    static final String ANALOG_SURROUND_BACKGRD = "analog_surround_backgrd";
    static final String DIGITAL_INNER_BACKGROUND = "digital_inner_background";
    static final String DIGITAL_SURROUND_BACKGRD = "digital_surround_backgrd";
    static final String CELL_VOLTAGE_INNER_BACKGROUND = "cell_voltage_inner_background";
    static final String CELL_VOLTAGE_SURROUND_BACKGRD = "cell_voltage_surround_backgrd";
    static final String FILE_COMMENT_INNER_BACKGROUND = "file_comment_inner_background";
    static final String FILE_COMMENT_SURROUND_BACKGRD = "file_comment_surround_backgrd";
    static final String OBJECT_DESC_INNER_BACKGROUND = "object_desciption_inner_background";
    static final String OBJECT_DESC_SURROUND_BACKGRD = "object_desciption_surround_backgrd";
    static final String DISPLAY_DENSITY_FONT_CORRECT = "display_density_font_correction";
    static final String KMZ_EXPORT_TIME_STEP_MS = "kmz_export_time_step_ms";
    public static final String SKIN_COLOR_SCHEMA = "skin_color_schema";
    public static final String COLOR_SCHEMA_SYSTEM = "color_schema_system";
    public static final String COLOR_SCHEMA_LIGHT = "color_schema_light";
    public static final String COLOR_SCHEMA_DARK = "color_schema_dark";
    static final String IS_HISTO_ACTIVE = "is_histo_active";
    static final String BOXPLOT_SCALE_ORDINAL = "boxplot_scale_ordinal";
    static final String BOXPLOT_SIZE_ADAPTATION_ORDINAL = "boxplot_size_adaptation_ordinal";
    static final String X_SPREAD_GRADE_ORDINAL = "x_spread_grade_ordinal";
    static final String IS_X_LOGARITHMIC_DISTANCE = "is_x_logarithmic_distance";
    static final String IS_X_REVERSED = "is_x_reversed";
    static final String SEARCH_DATAPATH_IMPORTS = "search_datapath_imports";
    static final String IS_CHANNEL_MIX = "is_channel_mix";
    static final String SAMPLING_TIMESPAN_ORDINAL = "sampling_timespan_ordinal";
    static final String IGNORE_LOG_OBJECT_KEY = "ignore_log_object_key";
    static final String RETROSPECT_MONTHS = "retrospect_months";
    static final String IS_ZIPPED_CACHE = "zipped_cache";
    static final String IS_XML_CACHE = "xml_cache";
    static final String MINMAX_QUANTILE_DISTANCE = "minmax_quantile_distance";
    static final String ABSOLUTE_TRANSITION_LEVEL = "absolute_transition_level";
    static final String IS_DATETIME_UTC = "is_datetime_utc";
    static final String IS_DISPLAY_SETTLEMENTS = "is_display_settlements";
    static final String IS_DISPLAY_SCORES = "is_display_scores";
    static final String IS_DISPLAY_TAGS = "is_display_tags";
    static final String IS_SUPPRESS_MODE = "is_suppress_mode";
    static final String IS_CURVE_SURVEY = "is_curve_survey";
    static final String GPS_LOCATION_RADIUS = "gps_location_radius";
    static final String GPS_ADDRESS_TYPE = "gps_address_type";
    static final String SUBDIRECTORY_LEVEL_MAX = "subdirectory_level_max";
    static final String IS_DATA_TABLE_TRANSITIONS = "is_data_table_transitions";
    static final String IS_FIRST_RECORDSET_CHOICE = "is_first_recordset_choice";
    static final String REMINDER_COUNT_CSV = "reminder_count_csv";
    static final String REMINDER_COUNT_INDEX = "reminder_count_index";
    static final String REMINDER_LEVEL = "reminder_level";
    static final String IS_CANONICAL_QUANTILES = "is_canonical_quantiles";
    static final String IS_SYMMETRIC_TOLERANCE_INTERVAL = "is_symmetric_tolerance_interval";
    static final String OUTLIER_TOLERANCE_SPREAD = "outlier_tolerance_spread";
    static final String SUMMARY_SCALE_SPREAD = "summary_scale_spread";
    static final String IS_SUMMARY_BOX_VISIBLE = "is_summary_box_visible";
    static final String IS_SUMMARY_SPREAD_VISIBLE = "is_summary_spread_visible";
    static final String IS_SUMMARY_SPOTS_VISIBLE = "is_summary_spots_visible";
    static final String DATA_FOLDERS_CSV = "data_folders_csv";
    static final String IMPORT_FOLDERS_CSV = "import_folders_csv";
    static final String MIRROR_SOURCE_FOLDERS_CSV = "mirror_source_folders_csv";
    static final String IS_SOURCE_FILE_LISTENER_ACTIVE = "is_source_file_listener_active";
    static final String IS_OBJECT_QUERY_ACTIVE = "is_object_query_active";
    static final String FILE_HISTORY_BLOCK = "#[File-History-List]";
    static final String FILE_HISTORY_BEGIN = "history_file_";
    List<String> fileHistory = new ArrayList<String>();
    static final String APPL_BLOCK = "#[Program-Settings]";
    static final String TABLE_BLOCK = "#[Table-Settings]";
    static final String LOGGING_BLOCK = "#[Logging-Settings]";
    static final String HISTO_BLOCK = "#[Histo-Settings]";
    public static final String LOG_PATH = "Logs";
    static final String LOG_FILE = "trace.log";
    static final String SERIAL_LOG_FILE = "serial.log";
    public static final String[] LOGGING_LEVEL = new String[]{"SEVERE", "WARNING", "TIME", "INFO", "FINE", "FINER", "FINEST"};
    public static final String MAPPINGS_DIR_NAME = "Mapping";
    public static final String MEASUREMENT_DISPLAY_FILE = "MeasurementDisplayProperties.xml";
    public static final String ACTIVE_DEVICE = "active_device";
    public static final String DEVICE_USE = "device_use";
    public static final String OBJECT_LIST = "object_list";
    public static final String ACTIVE_OBJECT = "active_object";
    public static final String DATA_FILE_PATH = "data_file_path";
    public static final String OBJECT_IMAGE_FILE_PATH = "object_image_file_path";
    public static final String LIST_SEPARATOR = "list_separator";
    public static final String DECIMAL_SEPARATOR = "decimal_separator";
    public static final String USE_DATA_FILE_NAME_LEADER = "use_date_file_name_leader";
    public static final String USE_OBJECT_KEY_IN_FILE_NAME = "use_object_key_in_file_name";
    public static final String WRITE_TMP_FILES = "write_tmp_files";
    public static final String ALPHA_BLENDING_VALUE = "alpha_blending_value";
    public static final String APLHA_BLENDING_ENABLED = "aplha_blending_enabled";
    public static final String KEEP_IMPORT_DIR_OBJECT_RELATED = "keep_import_dir_object_related";
    public static final String SKIP_BLUETOOTH_DEVICES = "skip_bluetooth_devices";
    public static final String DO_PORT_AVAILABLE_TEST = "do_port_available_test";
    public static final String IS_PORT_BLACKLIST = "is_port_black_list";
    public static final String PORT_BLACKLIST = "port_black_list";
    public static final String IS_PORT_WHITELIST = "is_port_white_list";
    public static final String PORT_WHITELIST = "port_white_list";
    public static final String DEVICE_DIALOG_USE_MODAL = "device_dialogs_modal";
    public static final String DEVICE_DIALOG_ON_TOP = "device_dialogs_on_top";
    public static final String IS_GLOBAL_LOG_LEVEL = "is_global_log_level";
    public static final String IS_REDUCE_CHARGE_DISCHARGE = "is_reduce_charge_discharge";
    public static final String IS_ALL_IN_ONE_RECORDSET = "is_all_in_one_record_set";
    public static final String IS_PARTIAL_DATA_TABLE = "is_partial_data_table";
    public static final String IS_DATA_TABLE_EDITABLE = "is_data_table_editable";
    public static final String IS_RXTX_COMM_TO_BE_USED = "is_rxtx_comm_to_be_used";
    public static final String IS_START_DEV_COMM_AFTER_START = "is_start_device_comm_after_startup";
    public static final String IS_MAC_TOUCHBAR = "is_mac_touchbar";
    public static final String GLOBAL_LOG_LEVEL = "global_log_level";
    public static final String UI_LOG_LEVEL = "ui_log_level";
    public static final String DEVICE_LOG_LEVEL = "device_log_level";
    public static final String DATA_LOG_LEVEL = "data_log_level";
    public static final String CONFIG_LOG_LEVEL = "config_log_level";
    public static final String UTILS_LOG_LEVEL = "utils_log_level";
    public static final String FILE_IO_LOG_LEVEL = "file_IO_log_level";
    public static final String SERIAL_IO_LOG_LEVEL = "serial_IO_log_level";
    public static final Properties classbasedLogger = new Properties();
    public static final String LOCALE_IN_USE = "locale_in_use";
    public static final String LOCALE_CHANGED = "locale_changed";
    public static final String TIME_FORMAT_IN_USE = "time_format_in_use";
    public static final String IS_DESKTOP_SHORTCUT_CREATED = "is_desktop_shotcut_created";
    public static final String IS_APPL_REGISTERED = "is_GDE_registered";
    public static final String IS_LOCK_UUCP_HINTED = "is_lock_uucp_hinted";
    public static final String LAST_UPDATE_CHECK = "last_update_check";
    public static final String IS_OBJECT_TEMPLATES_ACTIVE = "is_object_templates_active";
    public static final String GRID_DASH_STYLE = "grid_dash_style";
    public static final String GRID_COMPARE_WINDOW_HOR_TYPE = "grid_compare_horizontal_type";
    public static final String GRID_COMPARE_WINDOW_HOR_COLOR = "grid_compare_horizontal_color";
    public static final String GRID_COMPARE_WINDOW_VER_TYPE = "grid_compare_vertical_type";
    public static final String GRID_COMPARE_WINDOW_VER_COLOR = "grid_compare_vertical_color";
    public static final String DEVICE_PROPERTIES_DIR_NAME = "Devices";
    public static final String DEVICE_PROPERTIES_XSD_NAME = "DeviceProperties_V47.xsd";
    public static final String GRAPHICS_TEMPLATES_DIR_NAME = "GraphicsTemplates";
    public static final String GRAPHICS_TEMPLATES_XSD_NAME = "GraphicsTemplates_V08.xsd";
    public static final String GRAPHICS_TEMPLATES_EXTENSION = "*.xml";
    public static final String HISTO_CACHE_ENTRIES_DIR_NAME = "Cache";
    public static final String HISTO_CACHE_ENTRIES_XSD_NAME = "HistoVault_V04.xsd";
    public static final String HISTO_EXCLUSIONS_FILE_NAME = ".gdeignore";
    public static final String HISTO_EXCLUSIONS_DIR_NAME = ".gdeignore";
    public static final String GPS_LOCATIONS_DIR_NAME = "Locations";
    public static final String GPS_API_URL = "https://maps.googleapis.com/maps/api/geocode/xml?latlng=";
    public static final String HISTO_INCLUSIONS_FILE_NAME = ".gdeinclude";
    public static final String HISTO_INCLUSIONS_DIR_NAME = ".gdeinclude";
    public static final String HISTO_OBJECTS_DIR_NAME = "Fleet";
    private static double[] SAMPLING_TIMESPANS = new double[]{10.0, 5.0, 1.0, 0.5, 0.1, 0.05, 0.001};
    private static String[] REMINDER_COUNT_VALUES = new String[]{"2", "3", "5", "8"};
    private final TreeMap<String, ExportService> deviceServices;
    private final DeviceSerialization deviceSerialization;
    private final Thread xsdThread;
    private Thread migrationThread;
    boolean isDevicePropertiesUpdated = false;
    boolean isGraphicsTemplateUpdated = false;
    boolean isHistocacheTemplateUpdated = false;
    Rectangle window;
    boolean isWindowMaximized = false;
    String cbOrder;
    private String cbWraps;
    String cbSizes;
    Comparator<String> comparator = new RecordSetNameComparator();
    Properties measurementProperties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Settings getInstance() {
        if (instance == null) {
            Settings settings = instance = new Settings();
            synchronized (settings) {
                try {
                    instance.initialize();
                    log.log(Level.TIME, "init time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - GDE.StartTime));
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return instance;
    }

    private Settings() {
        if (GDE.APPL_HOME_PATH.isEmpty()) {
            log.log(Level.SEVERE, Messages.getString("GDE_MSGW0001"));
        }
        this.deviceServices = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.deviceSerialization = new DeviceSerialization();
        this.xsdThread = this.deviceSerialization.createXsdThread();
    }

    private void initialize() throws SAXException, JAXBException {
        this.load();
        if (Analyzer.isWithBuilders()) {
            this.readMeasurementDiplayProperties();
        } else {
            String templateDirectory;
            String lang = this.getLocale().getLanguage().contains("de") || this.getLocale().getLanguage().contains("en") ? this.getLocale().getLanguage() : "en";
            FileUtils.checkDirectoryAndCreate(GDE.APPL_HOME_PATH);
            String devicePropertiesTargetpath = Settings.getDevicesPath();
            if (!FileUtils.checkDirectoryAndCreate(devicePropertiesTargetpath, DEVICE_PROPERTIES_XSD_NAME)) {
                FileUtils.extract(this.getClass(), DEVICE_PROPERTIES_XSD_NAME, PATH_RESOURCE, devicePropertiesTargetpath, PERMISSION_555);
                this.checkDeviceProperties(String.format("%s%s", devicePropertiesTargetpath, "/"), true);
                this.isDevicePropertiesUpdated = true;
                this.checkMeasurementDisplayMappings(true, lang);
            } else {
                if (!FileUtils.checkFileExist(String.format("%s%s", devicePropertiesTargetpath, DEVICE_PROPERTIES_XSD_NAME))) {
                    FileUtils.extract(this.getClass(), DEVICE_PROPERTIES_XSD_NAME, PATH_RESOURCE, devicePropertiesTargetpath, PERMISSION_555);
                }
                this.checkDeviceProperties(String.format("%s%s", devicePropertiesTargetpath, "/"), true);
                this.checkMeasurementDisplayMappings(true, lang);
            }
            if (this.getLocaleChanged()) {
                this.checkMeasurementDisplayMappings(false, lang);
            }
            this.readMeasurementDiplayProperties();
            if (this.isDevicePropertiesUpdated) {
                this.migrationThread = DeviceSerialization.createMigrationThread();
            }
            if (!FileUtils.checkDirectoryAndCreate(templateDirectory = Settings.getGraphicsTemplatePath(), GRAPHICS_TEMPLATES_XSD_NAME)) {
                FileUtils.extract(this.getClass(), GRAPHICS_TEMPLATES_XSD_NAME, PATH_RESOURCE, templateDirectory, PERMISSION_555);
                this.isGraphicsTemplateUpdated = true;
            }
            this.checkDeviceTemplates(String.format("%s%s", templateDirectory, "/"));
            String histoCacheDirectory = String.format("%s%s%s", GDE.APPL_HOME_PATH, "/", HISTO_CACHE_ENTRIES_DIR_NAME);
            if (!FileUtils.checkDirectoryAndCreate(histoCacheDirectory, HISTO_CACHE_ENTRIES_XSD_NAME)) {
                FileUtils.extract(Settings.class, HISTO_CACHE_ENTRIES_XSD_NAME, PATH_RESOURCE, histoCacheDirectory, PERMISSION_555);
                this.isHistocacheTemplateUpdated = true;
            }
            FileUtils.checkDirectoryAndCreate(String.format("%s%s%s", GDE.APPL_HOME_PATH, "/", LOG_PATH));
            this.isWindowMaximized = Boolean.parseBoolean(this.getProperty(WINDOW_MAXIMIZED, "false"));
            this.window = this.getProperty(WINDOW_LEFT) != null && this.getProperty(WINDOW_TOP) != null && this.getProperty(WINDOW_WIDTH) != null && this.getProperty(WINDOW_HEIGHT) != null ? new Rectangle(Integer.valueOf(this.getProperty(WINDOW_LEFT).trim()).intValue(), Integer.parseInt(this.getProperty(WINDOW_TOP).trim()), Integer.parseInt(this.getProperty(WINDOW_WIDTH).trim()), Integer.parseInt(this.getProperty(WINDOW_HEIGHT).trim())) : new Rectangle(50, 50, 950, 600);
        }
        this.setProperty(LOCALE_CHANGED, "false");
        this.xsdThread.start();
    }

    public TreeMap<String, ExportService> getDeviceServices() {
        return this.deviceServices;
    }

    public boolean isOneOfActiveDevices(String deviceName) {
        return Arrays.stream(this.getDeviceUseCsv().split(",")).filter(s -> s.startsWith(deviceName + "*")).count() > 0L;
    }

    private void checkDeviceProperties(String devicePropertiesTargetpath, boolean replaceDeviceXmlFiles) {
        String $METHOD_NAME = "updateDeviceProperties";
        if (replaceDeviceXmlFiles) {
            String deviceJarBasePath = FileUtils.getDevicePluginJarBasePath();
            log.logp(java.util.logging.Level.CONFIG, $CLASS_NAME, "updateDeviceProperties", String.format("deviceJarBasePath = %s", deviceJarBasePath));
            String[] files = new File(deviceJarBasePath).list();
            if (files == null) {
                log.log(Level.SEVERE, String.format("check if %s is an existing directory", deviceJarBasePath));
                throw new NullPointerException(String.format("directory %s does not exist", deviceJarBasePath));
            }
            for (String jarFileName : files) {
                if (!jarFileName.endsWith(".jar")) continue;
                JarFile jarFile = null;
                List<Object> services = new ArrayList();
                try {
                    jarFile = new JarFile(String.format("%s%s%s", deviceJarBasePath, "/", jarFileName));
                    services = FileUtils.getDeviceJarServices(jarFile);
                    for (ExportService exportService : services) {
                        String serviceName = exportService.getName();
                        if (this.getDeviceUseCsv().isEmpty() || this.isOneOfActiveDevices(serviceName)) {
                            this.extractDeviceProperties(jarFile, serviceName, devicePropertiesTargetpath);
                            continue;
                        }
                        File obsoleteFile = new File(String.format("%s%s%s", devicePropertiesTargetpath, serviceName, ".xml"));
                        if (!obsoleteFile.exists() || obsoleteFile.delete()) continue;
                        log.log(Level.WARNING, String.format("could not delete %s%s%s", devicePropertiesTargetpath, serviceName, ".xml"));
                    }
                }
                catch (Throwable e) {
                    log.logp(java.util.logging.Level.SEVERE, $CLASS_NAME, "updateDeviceProperties", e.getMessage(), e);
                }
                for (ExportService exportService : services) {
                    this.deviceServices.put(exportService.getName(), exportService);
                }
            }
        }
    }

    public void extractDeviceProperties(JarFile jarFile, String serviceName, String devicePropertiesTargetpath) {
        if (!FileUtils.checkFileExist(String.format("%s%s%s", devicePropertiesTargetpath, serviceName, ".xml"))) {
            FileUtils.extract(jarFile, String.format("%s%s", serviceName, ".xml"), PATH_RESOURCE, devicePropertiesTargetpath, PERMISSION_555);
        }
    }

    private void checkMeasurementDisplayMappings(boolean existCheck, String lang) {
        File path = new File(String.format("%s%s%s", GDE.APPL_HOME_PATH, "/", MAPPINGS_DIR_NAME));
        String propertyFilePath = String.format("%s%s%s", path.toString(), "/", MEASUREMENT_DISPLAY_FILE);
        if (existCheck) {
            if (!FileUtils.checkFileExist(propertyFilePath)) {
                FileUtils.extract(this.getClass(), MEASUREMENT_DISPLAY_FILE, String.format("%s%s%s", PATH_RESOURCE, lang, "/"), path.getAbsolutePath(), PERMISSION_555);
            }
        } else {
            if (FileUtils.checkFileExist(propertyFilePath)) {
                new File(propertyFilePath).delete();
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            FileUtils.extract(this.getClass(), MEASUREMENT_DISPLAY_FILE, String.format("%s%s%s", PATH_RESOURCE, lang, "/"), path.getAbsolutePath(), PERMISSION_555);
        }
    }

    public Settings(Settings that) {
        for (Map.Entry<Object, Object> entry : that.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        this.xsdThread = that.xsdThread;
        this.deviceSerialization = that.deviceSerialization;
        this.deviceServices = that.deviceServices;
        this.migrationThread = that.migrationThread;
        this.isDevicePropertiesUpdated = that.isDevicePropertiesUpdated;
        this.isGraphicsTemplateUpdated = that.isGraphicsTemplateUpdated;
        this.isHistocacheTemplateUpdated = that.isHistocacheTemplateUpdated;
        this.fileHistory = new ArrayList<String>(that.fileHistory);
        this.window = that.window;
        this.isWindowMaximized = that.isWindowMaximized;
        this.cbOrder = that.cbOrder;
        this.cbWraps = that.cbWraps;
        this.cbSizes = that.cbSizes;
        this.comparator = that.comparator;
        this.measurementProperties = (Properties)that.measurementProperties.clone();
    }

    private void checkDeviceTemplates(String templateDirectoryTargetPath) {
        if (this.getDeviceServices().size() == 0) {
            String deviceJarBasePath = FileUtils.getDevicePluginJarBasePath();
            log.config(() -> String.format("deviceJarBasePath = %s", deviceJarBasePath));
            for (String jarFileName : new File(deviceJarBasePath).list()) {
                if (!jarFileName.endsWith(".jar")) continue;
                try {
                    for (ExportService service : FileUtils.getDeviceJarServices(new JarFile(deviceJarBasePath + "/" + jarFileName))) {
                        String serviceName = service.getName();
                        if (!this.isOneOfActiveDevices(serviceName)) continue;
                        this.extractDeviceDefaultTemplates(service.getJarFile(), serviceName, templateDirectoryTargetPath);
                    }
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        } else {
            this.checkDeviceTemplates(templateDirectoryTargetPath, this.getDeviceServices().values());
        }
    }

    private void checkDeviceTemplates(String templateDirectoryTargetPath, Collection<ExportService> services) {
        Map<String, List<Path>> templateFileMap = this.readTemplateFiles(templateDirectoryTargetPath);
        for (ExportService service : services) {
            try {
                String serviceName = service.getName();
                if (this.getDeviceUseCsv().isEmpty() || this.isOneOfActiveDevices(serviceName)) {
                    this.extractDeviceDefaultTemplates(service.getJarFile(), serviceName, templateDirectoryTargetPath);
                    continue;
                }
                if (!templateFileMap.containsKey(serviceName)) continue;
                for (Path path : templateFileMap.get(serviceName)) {
                    log.fine(() -> "delete " + path);
                    if (path.toFile().delete()) continue;
                    log.warning(() -> String.format("could not delete %s%s%s", templateDirectoryTargetPath, serviceName, ".xml"));
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private Map<String, List<Path>> readTemplateFiles(String templateDirectoryTargetPath) {
        Map<String, List<Path>> filesMap = new HashMap<String, List<Path>>();
        try (Stream<Path> files = Files.walk(Paths.get(templateDirectoryTargetPath, new String[0]), 2, new FileVisitOption[0]);){
            Stream<Path> potentialFiles = files.filter(t -> t.getFileName().toString().contains("."));
            filesMap = potentialFiles.collect(Collectors.groupingBy(this::getTemplateFilePrefix));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return filesMap;
    }

    private String getTemplateFilePrefix(Path t) {
        String fileName = t.getFileName().toString();
        int index = fileName.lastIndexOf(95);
        return index < 0 ? "" : fileName.substring(0, index);
    }

    public void extractDeviceDefaultTemplates(JarFile jarFile, String serviceName, String templateDirectoryTargetPath) {
        String serviceName_ = String.format("%s%s", serviceName, "_");
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            String entryName = e.nextElement().getName();
            if (!entryName.startsWith(PATH_RESOURCE_TEMPLATE) || !entryName.endsWith(".xml") || !entryName.contains(serviceName_)) continue;
            String defaultTemplateName = entryName.substring(PATH_RESOURCE_TEMPLATE.length());
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("jarFile = %s ; defaultTemplateName = %s", jarFile.getName(), entryName));
            }
            if (FileUtils.checkFileExist(templateDirectoryTargetPath + defaultTemplateName)) continue;
            FileUtils.extract(jarFile, defaultTemplateName, PATH_RESOURCE_TEMPLATE, templateDirectoryTargetPath, PERMISSION_555);
        }
    }

    public void extractDevicePropertiesAndTemplates(JarFile jarFile, String serviceName) {
        this.extractDeviceProperties(jarFile, serviceName, String.format("%s%s", Settings.getDevicesPath(), "/"));
        this.extractDeviceDefaultTemplates(jarFile, serviceName, String.format("%s%s", Settings.getGraphicsTemplatePath(), "/"));
    }

    private void readMeasurementDiplayProperties() {
        String $METHOD_NAME = "readMeasurementDiplayProperties";
        DataAccess.getInstance().checkMappingFileAndCreate(this.getClass(), MEASUREMENT_DISPLAY_FILE);
        try (InputStream stream = DataAccess.getInstance().getMappingInputStream(MEASUREMENT_DISPLAY_FILE);){
            this.measurementProperties.loadFromXML(stream);
        }
        catch (Exception e) {
            log.logp(java.util.logging.Level.SEVERE, $CLASS_NAME, "readMeasurementDiplayProperties", e.getMessage());
        }
    }

    public Properties getMeasurementDisplayProperties() {
        return this.measurementProperties;
    }

    void load() {
        String $METHOD_NAME = "load";
        try (Reader reader = DataAccess.getInstance().getSettingsReader();){
            String entry;
            this.load(reader);
            for (int i = 0; i < 9 && (entry = this.getProperty(FILE_HISTORY_BEGIN + i)) != null && entry.length() > 4; ++i) {
                if (this.fileHistory.contains(entry)) continue;
                this.fileHistory.add(entry);
            }
        }
        catch (Exception e) {
            log.logp(java.util.logging.Level.WARNING, $CLASS_NAME, "load", e.getMessage());
        }
    }

    public void store() {
        String $METHOS_NAME = "store()";
        try (Writer writer = DataAccess.getInstance().getSettingsWriter();){
            writer.write(String.format("%s\n", HEADER_TEXT));
            writer.write(String.format("%s\n", DEVICE_BLOCK));
            writer.write(String.format("%-40s \t=\t %s\n", ACTIVE_DEVICE, this.getActiveDevice()));
            writer.write(String.format("%-40s \t=\t %s\n", DEVICE_USE, this.getDeviceUseCsv()));
            writer.write(String.format("%-40s \t=\t %s\n", OBJECT_LIST, this.getObjectListAsString()));
            writer.write(String.format("%-40s \t=\t %s\n", ACTIVE_OBJECT, this.getActiveObject()));
            writer.write(String.format("%s\n", WINDOW_BLOCK));
            writer.write(String.format("%-40s \t=\t %s\n", WINDOW_MAXIMIZED, this.isWindowMaximized));
            writer.write(String.format("%-40s \t=\t %s\n", WINDOW_LEFT, this.window.x));
            writer.write(String.format("%-40s \t=\t %s\n", WINDOW_TOP, this.window.y));
            writer.write(String.format("%-40s \t=\t %s\n", WINDOW_WIDTH, this.window.width));
            writer.write(String.format("%-40s \t=\t %s\n", WINDOW_HEIGHT, this.window.height));
            writer.write(String.format("%-40s \t=\t %s\n", COOLBAR_ORDER, this.cbOrder));
            writer.write(String.format("%-40s \t=\t %s\n", COOLBAR_WRAPS, this.cbWraps));
            writer.write(String.format("%-40s \t=\t %s\n", COOLBAR_SIZES, this.cbSizes));
            writer.write(String.format("%-40s \t=\t %s\n", RECORD_COMMENT_VISIBLE, this.isRecordCommentVisible()));
            writer.write(String.format("%-40s \t=\t %s\n", GRAPHICS_HEADER_VISIBLE, this.isGraphicsHeaderVisible()));
            writer.write(String.format("%-40s \t=\t %s\n", DISPLAY_DENSITY_FONT_CORRECT, this.getFontDisplayDensityAdaptionFactor()));
            writer.write(String.format("%-40s \t=\t %s\n", KMZ_EXPORT_TIME_STEP_MS, this.getKmzExportTimeStep_ms()));
            writer.write(String.format("%-40s \t=\t %s\n", GRID_DASH_STYLE, this.getGridDashStyleAsString()));
            writer.write(String.format("%-40s \t=\t %s\n", GRID_COMPARE_WINDOW_HOR_TYPE, this.getGridCompareWindowHorizontalType()));
            writer.write(String.format("%-40s \t=\t %s\n", GRID_COMPARE_WINDOW_HOR_COLOR, this.getGridCompareWindowHorizontalColorStr()));
            writer.write(String.format("%-40s \t=\t %s\n", GRID_COMPARE_WINDOW_VER_TYPE, this.getGridCompareWindowVerticalType()));
            writer.write(String.format("%-40s \t=\t %s\n", GRID_COMPARE_WINDOW_VER_COLOR, this.getGridCompareWindowVerticalColorStr()));
            writer.write(String.format("%-40s \t=\t %s\n", SKIN_COLOR_SCHEMA, this.getSkinColorSchema()));
            writer.write(String.format("%-40s \t=\t %s\n", GRAPHICS_AREA_BACKGROUND, this.getGraphicsCurveAreaBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", GRAPHICS_SURROUND_BACKGRD, this.getGraphicsSurroundingBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", GRAPHICS_BORDER_COLOR, this.getGraphicsCurvesBorderColorStr()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_GRAPHICS_SCALE_COLOR, this.isDrawScaleInRecordColor()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_GRAPHICS_NAME_COLOR, this.isDrawNameInRecordColor()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_GRAPHICS_TICKS_10, this.isDraw10TicksPerRecord()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_GRAPHICS_NUMBERS_COLOR, this.isDrawNumbersInRecordColor()));
            writer.write(String.format("%-40s \t=\t %s\n", COMPARE_AREA_BACKGROUND, this.getCompareCurveAreaBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", COMPARE_SURROUND_BACKGRD, this.getCompareSurroundingBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", COMPARE_BORDER_COLOR, this.getCurveCompareBorderColorStr()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_COMPARE_CHANNELCONFIG, this.isCurveCompareChannelConfigName()));
            writer.write(String.format("%-40s \t=\t %s\n", UTILITY_AREA_BACKGROUND, this.getUtilityCurveAreaBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", UTILITY_SURROUND_BACKGRD, this.getUtilitySurroundingBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", UTILITY_BORDER_COLOR, this.getUtilityCurvesBorderColorStr()));
            writer.write(String.format("%-40s \t=\t %s\n", STATISTICS_INNER_BACKGROUND, this.getStatisticsInnerAreaBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", STATISTICS_SURROUND_BACKGRD, this.getStatisticsSurroundingAreaBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", ANALOG_INNER_BACKGROUND, this.getAnalogInnerAreaBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", ANALOG_SURROUND_BACKGRD, this.getAnalogSurroundingAreaBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", DIGITAL_INNER_BACKGROUND, this.getDigitalInnerAreaBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", DIGITAL_SURROUND_BACKGRD, this.getDigitalSurroundingAreaBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", CELL_VOLTAGE_INNER_BACKGROUND, this.getCellVoltageInnerAreaBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", CELL_VOLTAGE_SURROUND_BACKGRD, this.getCellVoltageSurroundingAreaBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", FILE_COMMENT_INNER_BACKGROUND, this.getFileCommentInnerAreaBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", FILE_COMMENT_SURROUND_BACKGRD, this.getFileCommentSurroundingAreaBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", OBJECT_DESC_INNER_BACKGROUND, this.getObjectDescriptionInnerAreaBackgroundStr()));
            writer.write(String.format("%-40s \t=\t %s\n", OBJECT_DESC_SURROUND_BACKGRD, this.getObjectDescriptionSurroundingAreaBackgroundStr()));
            writer.write(String.format("%s\n", FILE_HISTORY_BLOCK));
            for (int i = 0; i < 9 && i < this.fileHistory.size() && this.fileHistory.get(i) != null; ++i) {
                writer.write(String.format("%-40s \t=\t %s\n", FILE_HISTORY_BEGIN + i, this.fileHistory.get(i)));
            }
            writer.write(String.format("%s\n", APPL_BLOCK));
            writer.write(String.format("%-40s \t=\t %s\n", DATA_FILE_PATH, this.getDataFilePath()));
            writer.write(String.format("%-40s \t=\t %s\n", OBJECT_IMAGE_FILE_PATH, this.getObjectImageFilePath()));
            writer.write(String.format("%-40s \t=\t %s\n", USE_DATA_FILE_NAME_LEADER, this.getUsageDateAsFileNameLeader()));
            writer.write(String.format("%-40s \t=\t %s\n", USE_OBJECT_KEY_IN_FILE_NAME, this.getUsageObjectKeyInFileName()));
            writer.write(String.format("%-40s \t=\t %s\n", WRITE_TMP_FILES, this.getUsageWritingTmpFiles()));
            writer.write(String.format("%-40s \t=\t %s\n", ALPHA_BLENDING_VALUE, this.getDialogAlphaValue()));
            writer.write(String.format("%-40s \t=\t %s\n", APLHA_BLENDING_ENABLED, this.isDeviceDialogAlphaEnabled()));
            writer.write(String.format("%-40s \t=\t %s\n", KEEP_IMPORT_DIR_OBJECT_RELATED, this.isDeviceImportDirectoryObjectRelated()));
            writer.write(String.format("%-40s \t=\t %s\n", SKIP_BLUETOOTH_DEVICES, this.isSkipBluetoothDevices()));
            writer.write(String.format("%-40s \t=\t %s\n", DO_PORT_AVAILABLE_TEST, this.doPortAvailabilityCheck()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_PORT_BLACKLIST, this.isSerialPortBlackListEnabled()));
            writer.write(String.format("%-40s \t=\t %s\n", PORT_BLACKLIST, this.getSerialPortBlackList()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_PORT_WHITELIST, this.isSerialPortWhiteListEnabled()));
            writer.write(String.format("%-40s \t=\t %s\n", PORT_WHITELIST, this.getSerialPortWhiteListString()));
            writer.write(String.format("%-40s \t=\t %s\n", DEVICE_DIALOG_USE_MODAL, this.isDeviceDialogsModal()));
            writer.write(String.format("%-40s \t=\t %s\n", DEVICE_DIALOG_ON_TOP, this.isDeviceDialogsOnTop()));
            writer.write(String.format("%-40s \t=\t %s\n", LOCALE_IN_USE, this.getLocale().getLanguage()));
            writer.write(String.format("%-40s \t=\t %s\n", LOCALE_CHANGED, this.getLocaleChanged()));
            writer.write(String.format("%-40s \t=\t %s\n", TIME_FORMAT_IN_USE, this.getTimeFormat()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_DESKTOP_SHORTCUT_CREATED, this.isDesktopShortcutCreated()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_APPL_REGISTERED, this.isApplicationRegistered()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_LOCK_UUCP_HINTED, this.isLockUucpHinted()));
            writer.write(String.format("%-40s \t=\t %s\n", LAST_UPDATE_CHECK, StringHelper.getDate()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_OBJECT_TEMPLATES_ACTIVE, this.isObjectTemplatesActive()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_MAC_TOUCHBAR, this.isMacTouchbarEnabled()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_REDUCE_CHARGE_DISCHARGE, this.isReduceChargeDischarge()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_ALL_IN_ONE_RECORDSET, this.isContinuousRecordSet()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_PARTIAL_DATA_TABLE, this.isPartialDataTable()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_START_DEV_COMM_AFTER_START, this.isStartDeviceCommunicationAfterStartup()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_RXTX_COMM_TO_BE_USED, this.isRXTXcommToBeUsed()));
            writer.write(String.format("%s\n", TABLE_BLOCK));
            writer.write(String.format("%-40s \t=\t %s\n", LIST_SEPARATOR, Character.valueOf(this.getListSeparator())));
            writer.write(String.format("%-40s \t=\t %s\n", DECIMAL_SEPARATOR, Character.valueOf(this.getDecimalSeparator())));
            writer.write(String.format("%s\n", LOGGING_BLOCK));
            writer.write(String.format("%-40s \t=\t %s\n", IS_GLOBAL_LOG_LEVEL, this.isGlobalLogLevel()));
            writer.write(String.format("%-40s \t=\t %s\n", GLOBAL_LOG_LEVEL, this.getLogLevel(GLOBAL_LOG_LEVEL)));
            writer.write(String.format("%-40s \t=\t %s\n", UI_LOG_LEVEL, this.getLogLevel(UI_LOG_LEVEL)));
            writer.write(String.format("%-40s \t=\t %s\n", DEVICE_LOG_LEVEL, this.getLogLevel(DEVICE_LOG_LEVEL)));
            writer.write(String.format("%-40s \t=\t %s\n", DATA_LOG_LEVEL, this.getLogLevel(DATA_LOG_LEVEL)));
            writer.write(String.format("%-40s \t=\t %s\n", CONFIG_LOG_LEVEL, this.getLogLevel(CONFIG_LOG_LEVEL)));
            writer.write(String.format("%-40s \t=\t %s\n", UTILS_LOG_LEVEL, this.getLogLevel(UTILS_LOG_LEVEL)));
            writer.write(String.format("%-40s \t=\t %s\n", FILE_IO_LOG_LEVEL, this.getLogLevel(FILE_IO_LOG_LEVEL)));
            writer.write(String.format("%-40s \t=\t %s\n", SERIAL_IO_LOG_LEVEL, this.getLogLevel(SERIAL_IO_LOG_LEVEL)));
            writer.write(String.format("%s\n", HISTO_BLOCK));
            writer.write(String.format("%-40s \t=\t %s\n", IS_HISTO_ACTIVE, this.isHistoActive()));
            writer.write(String.format("%-40s \t=\t %s\n", BOXPLOT_SCALE_ORDINAL, this.getBoxplotScaleOrdinal()));
            writer.write(String.format("%-40s \t=\t %s\n", BOXPLOT_SIZE_ADAPTATION_ORDINAL, this.getBoxplotSizeAdaptationOrdinal()));
            writer.write(String.format("%-40s \t=\t %s\n", X_SPREAD_GRADE_ORDINAL, this.getXAxisSpreadOrdinal()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_X_LOGARITHMIC_DISTANCE, this.isXAxisLogarithmicDistance()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_X_REVERSED, this.isXAxisReversed()));
            writer.write(String.format("%-40s \t=\t %s\n", RETROSPECT_MONTHS, this.getRetrospectMonths()));
            writer.write(String.format("%-40s \t=\t %s\n", SEARCH_DATAPATH_IMPORTS, this.getSearchDataPathImports()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_CHANNEL_MIX, this.isChannelMix()));
            writer.write(String.format("%-40s \t=\t %s\n", SAMPLING_TIMESPAN_ORDINAL, this.getSamplingTimespanOrdinal()));
            writer.write(String.format("%-40s \t=\t %s\n", IGNORE_LOG_OBJECT_KEY, this.getIgnoreLogObjectKey()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_ZIPPED_CACHE, this.isZippedCache()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_XML_CACHE, this.isXmlCache()));
            writer.write(String.format("%-40s \t=\t %s\n", MINMAX_QUANTILE_DISTANCE, this.getMinmaxQuantileDistance()));
            writer.write(String.format("%-40s \t=\t %s\n", ABSOLUTE_TRANSITION_LEVEL, this.getAbsoluteTransitionLevel()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_DATETIME_UTC, this.isDateTimeUtc()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_DISPLAY_SETTLEMENTS, this.isDisplaySettlements()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_DISPLAY_SCORES, this.isDisplayScores()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_DISPLAY_TAGS, this.isDisplayTags()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_SUPPRESS_MODE, this.isSuppressMode()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_CURVE_SURVEY, this.isCurveSurvey()));
            writer.write(String.format("%-40s \t=\t %s\n", GPS_LOCATION_RADIUS, this.getGpsLocationRadius()));
            writer.write(String.format("%-40s \t=\t %s\n", SUBDIRECTORY_LEVEL_MAX, this.getSubDirectoryLevelMax()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_DATA_TABLE_TRANSITIONS, this.isDataTableTransitions()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_FIRST_RECORDSET_CHOICE, this.isFirstRecordSetChoice()));
            writer.write(String.format("%-40s \t=\t %s\n", REMINDER_COUNT_CSV, this.getReminderCountCsv()));
            writer.write(String.format("%-40s \t=\t %s\n", REMINDER_COUNT_INDEX, this.getReminderCountIndex()));
            writer.write(String.format("%-40s \t=\t %s\n", REMINDER_LEVEL, this.getReminderLevel()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_CANONICAL_QUANTILES, this.isCanonicalQuantiles()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_SYMMETRIC_TOLERANCE_INTERVAL, this.isSymmetricToleranceInterval()));
            writer.write(String.format("%-40s \t=\t %s\n", OUTLIER_TOLERANCE_SPREAD, this.getOutlierToleranceSpread()));
            writer.write(String.format("%-40s \t=\t %s\n", SUMMARY_SCALE_SPREAD, this.getSummaryScaleSpread()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_SUMMARY_BOX_VISIBLE, this.isSummaryBoxVisible()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_SUMMARY_SPREAD_VISIBLE, this.isSummarySpreadVisible()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_SUMMARY_SPOTS_VISIBLE, this.isSummarySpotsVisible()));
            writer.write(String.format("%-40s \t=\t %s\n", DATA_FOLDERS_CSV, this.getDataFoldersCsv()));
            writer.write(String.format("%-40s \t=\t %s\n", IMPORT_FOLDERS_CSV, this.getImportFoldersCsv()));
            writer.write(String.format("%-40s \t=\t %s\n", MIRROR_SOURCE_FOLDERS_CSV, this.getMirrorSourceFoldersCsv()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_SOURCE_FILE_LISTENER_ACTIVE, this.isSourceFileListenerActive()));
            writer.write(String.format("%-40s \t=\t %s\n", IS_OBJECT_QUERY_ACTIVE, this.isObjectQueryActive()));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            log.logp(java.util.logging.Level.SEVERE, $CLASS_NAME, "store()", e.getMessage(), e);
        }
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        if (val == null || val.equals("") || val.equals("null")) {
            val = defaultValue;
        }
        return val;
    }

    public Rectangle getWindow() {
        return this.window;
    }

    public void setWindow(Point location, Point size) {
        this.window = new Rectangle(location.x, location.y, size.x, size.y);
    }

    public boolean isWindowMaximized() {
        return this.isWindowMaximized;
    }

    public void setWindowMaximized(boolean isMaximized) {
        this.isWindowMaximized = isMaximized;
    }

    public void setCoolBarStates(int[] order, int[] wraps, Point[] sizes) {
        this.cbOrder = StringHelper.intArrayToString(order);
        this.cbWraps = StringHelper.intArrayToString(wraps);
        this.cbSizes = StringHelper.pointArrayToString(sizes);
    }

    public int[] getCoolBarOrder(String defaultCoolBarSizes) {
        int coolBarSize;
        int[] intOrder = StringHelper.stringToIntArray(this.getProperty(COOLBAR_ORDER, "0;1;2;3;4").trim());
        if (intOrder.length != (coolBarSize = this.getCoolBarSizes(defaultCoolBarSizes).length)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < coolBarSize; ++i) {
                sb.append(i).append(";");
            }
            intOrder = StringHelper.stringToIntArray(sb.toString());
        }
        return intOrder;
    }

    public int[] getCoolBarWraps() {
        return StringHelper.stringToIntArray(this.getProperty(COOLBAR_WRAPS, "0;3").trim());
    }

    public Point[] getCoolBarSizes(String defaultCoolBarSizes) {
        return StringHelper.stringToPointArray(this.getProperty(COOLBAR_SIZES, defaultCoolBarSizes).trim());
    }

    public List<String> getFileHistory() {
        return this.fileHistory;
    }

    public String getActiveDevice() {
        return this.getProperty(ACTIVE_DEVICE, EMPTY_SIGNATURE).split(";")[0].trim();
    }

    public void setActiveDevice(String activeDeviceString) {
        this.setProperty(ACTIVE_DEVICE, activeDeviceString.trim());
    }

    public Optional<String> getValidatedObjectKey(String objectKeyCandidate) {
        String key = objectKeyCandidate.trim();
        return Arrays.stream(this.getObjectList()).filter(s -> s.equalsIgnoreCase(key)).findFirst();
    }

    public Stream<String> getRealObjectKeys() {
        Stream<String> objectKeys = Arrays.stream(this.getProperty(OBJECT_LIST, Messages.getString("GDE_MSGT0200")).split(";"));
        String deviceOriented = Messages.getString("GDE_MSGT0200").split(";")[0];
        return objectKeys.distinct().skip(1L).filter(s -> !s.equals(deviceOriented));
    }

    public String getObjectListAsString() {
        return this.getProperty(OBJECT_LIST, Messages.getString("GDE_MSGT0200"));
    }

    public String[] getObjectList() {
        String[] objectKeys = this.getProperty(OBJECT_LIST, Messages.getString("GDE_MSGT0200")).split(";");
        objectKeys[0] = Messages.getString("GDE_MSGT0200").split(";")[0];
        return objectKeys;
    }

    public void setObjectList(String[] activeObjectList, int newActiveObjectIndex) {
        String activeObjectKey = activeObjectList[0];
        try {
            activeObjectKey = activeObjectList[newActiveObjectIndex];
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        this.setObjectList(activeObjectList, activeObjectKey);
    }

    public void setObjectList(String[] objectList, String activeObject) {
        String[] tmpObjectKeys;
        boolean startsWithDeviceOriented = objectList[0].startsWith(Messages.getString("GDE_MSGT0200").substring(0, 10));
        if (startsWithDeviceOriented) {
            tmpObjectKeys = new String[objectList.length - 1];
            System.arraycopy(objectList, 1, tmpObjectKeys, 0, objectList.length - 1);
            Arrays.sort(tmpObjectKeys, String.CASE_INSENSITIVE_ORDER);
            System.arraycopy(tmpObjectKeys, 0, objectList, 1, objectList.length - 1);
        } else {
            Arrays.sort(objectList, String.CASE_INSENSITIVE_ORDER);
            tmpObjectKeys = new String[objectList.length + 1];
            tmpObjectKeys[0] = Messages.getString("GDE_MSGT0200").split(";")[0];
            System.arraycopy(objectList, 0, tmpObjectKeys, 1, objectList.length);
            objectList = tmpObjectKeys;
        }
        Vector<String> tmpObjectVector = new Vector<String>();
        for (String objectKey : objectList) {
            boolean isDuplicateKey = tmpObjectVector.stream().anyMatch(x -> x.equalsIgnoreCase(objectKey));
            if (isDuplicateKey || objectKey.length() < 2) continue;
            tmpObjectVector.add(objectKey.trim());
        }
        StringBuffer sb = new StringBuffer();
        for (String element : tmpObjectVector) {
            sb.append(element).append(";");
        }
        this.setProperty(OBJECT_LIST, sb.toString());
        this.setProperty(ACTIVE_OBJECT, activeObject);
    }

    public int getActiveObjectIndex() {
        Vector<String> tmpObjectVector = new Vector<String>();
        for (String objectKey : this.getObjectList()) {
            if (objectKey.length() < 2) continue;
            tmpObjectVector.add(objectKey);
        }
        int index = tmpObjectVector.indexOf(this.getProperty(ACTIVE_OBJECT, Messages.getString("GDE_MSGT0200").split(";")[0]).trim());
        return index < 0 ? 0 : index;
    }

    public String getActiveObject() {
        return this.getObjectList()[this.getActiveObjectIndex()];
    }

    public String getActiveObjectKey() {
        String[] objectKeys = this.getProperty(OBJECT_LIST, Messages.getString("GDE_MSGT0200")).split(";");
        objectKeys[0] = "";
        return objectKeys[this.getActiveObjectIndex()];
    }

    public void setActiveObjectKey(String newObjectKey) {
        this.setProperty(ACTIVE_OBJECT, newObjectKey);
    }

    public static String getSettingsFilePath() {
        return GDE.SETTINGS_FILE_PATH;
    }

    public static String getApplHomePath() {
        return GDE.APPL_HOME_PATH;
    }

    public static String getDevicesPath() {
        return String.format("%s%s%s", GDE.APPL_HOME_PATH, "/", DEVICE_PROPERTIES_DIR_NAME).replace("%20", " ");
    }

    public static String getGraphicsTemplatePath() {
        return String.format("%s%s%s", GDE.APPL_HOME_PATH, "/", GRAPHICS_TEMPLATES_DIR_NAME).replace("%20", " ");
    }

    public static String getLogFilePath() {
        String $METHOD_NAME = "getLogFilePath";
        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "getLogFilePath", "applHomePath = " + GDE.APPL_HOME_PATH);
        return GDE.APPL_HOME_PATH + "/" + LOG_PATH + "/" + LOG_FILE;
    }

    public static String getSerialLogFilePath() {
        return GDE.APPL_HOME_PATH + "/" + LOG_PATH + "/" + SERIAL_LOG_FILE;
    }

    public String getDataFilePath() {
        String $METHOD_NAME = "getDataFilePath";
        String dataPath = this.getProperty(DATA_FILE_PATH, System.getProperty("user.home")).replace("\\\\", "/").replace('\\', '/');
        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "getDataFilePath", "dataFilePath = " + dataPath);
        return dataPath.trim();
    }

    public void setDataFilePath(String newDataFilePath) {
        String $METHOD_NAME = "setDataFilePath";
        String filePath = newDataFilePath.replace('\\', '/').trim();
        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "setDataFilePath", "newDataFilePath = " + filePath);
        this.setProperty(DATA_FILE_PATH, filePath);
    }

    public char getListSeparator() {
        if (this.getProperty(LIST_SEPARATOR) == null) {
            this.setProperty(LIST_SEPARATOR, ";");
        }
        return this.getProperty(LIST_SEPARATOR).trim().charAt(0);
    }

    public void setListSeparator(String newListSeparator) {
        this.setProperty(LIST_SEPARATOR, newListSeparator.trim());
    }

    public char getDecimalSeparator() {
        if (this.getProperty(DECIMAL_SEPARATOR) == null) {
            this.setProperty(DECIMAL_SEPARATOR, ".");
        }
        return this.getProperty(DECIMAL_SEPARATOR).trim().charAt(0);
    }

    public void setDecimalSeparator(String newDecimalSeparator) {
        this.setProperty(DECIMAL_SEPARATOR, newDecimalSeparator.trim());
    }

    public void setUsageDateAsFileNameLeader(boolean usage) {
        this.setProperty(USE_DATA_FILE_NAME_LEADER, "" + usage);
    }

    public void setUsageObjectKeyInFileName(boolean usage) {
        this.setProperty(USE_OBJECT_KEY_IN_FILE_NAME, "" + usage);
    }

    public void setUsageWritingTmpFiles(boolean usage) {
        this.setProperty(WRITE_TMP_FILES, "" + usage);
    }

    public boolean getUsageDateAsFileNameLeader() {
        return Boolean.valueOf(this.getProperty(USE_DATA_FILE_NAME_LEADER, "true"));
    }

    public boolean getUsageObjectKeyInFileName() {
        return Boolean.valueOf(this.getProperty(USE_OBJECT_KEY_IN_FILE_NAME, "false"));
    }

    public boolean getUsageWritingTmpFiles() {
        return Boolean.valueOf(this.getProperty(WRITE_TMP_FILES, "false"));
    }

    public boolean isSerialPortBlackListEnabled() {
        return Boolean.valueOf(this.getProperty(IS_PORT_BLACKLIST, "false").trim());
    }

    public void setSerialPortBlackListEnabled(boolean enabled) {
        this.setProperty(IS_PORT_BLACKLIST, "" + enabled);
    }

    public String getSerialPortBlackList() {
        StringBuffer blackList = new StringBuffer();
        for (String port : this.getProperty(PORT_BLACKLIST, "").trim().split(" ")) {
            if (port == null || port.length() <= 3) continue;
            blackList.append(port).append(" ");
        }
        return blackList.toString().trim();
    }

    public void setSerialPortBlackList(String newPortBlackList) {
        StringBuilder blackList = new StringBuilder();
        for (String tmpPort : newPortBlackList.split(" ")) {
            if (GDE.IS_WINDOWS && tmpPort.toUpperCase().startsWith(WINDOWS_PORT_COM)) {
                blackList.append(tmpPort.toUpperCase()).append(" ");
                continue;
            }
            if (!tmpPort.startsWith(UNIX_PORT_DEV_TTY)) continue;
            blackList.append(tmpPort).append(" ");
        }
        this.setProperty(PORT_BLACKLIST, blackList.toString());
    }

    public boolean isSerialPortWhiteListEnabled() {
        return Boolean.valueOf(this.getProperty(IS_PORT_WHITELIST, "false").trim());
    }

    public void setSerialPortWhiteListEnabled(boolean enabled) {
        this.setProperty(IS_PORT_WHITELIST, "" + enabled);
    }

    public Vector<String> getSerialPortWhiteList() {
        Vector<String> whiteList = new Vector<String>();
        for (String port : this.getProperty(PORT_WHITELIST, "").trim().split(";| ")) {
            if (port == null || port.length() <= 3) continue;
            whiteList.add(port);
        }
        return whiteList;
    }

    public String getSerialPortWhiteListString() {
        StringBuffer whiteList = new StringBuffer();
        for (String port : this.getProperty(PORT_WHITELIST, "").trim().split(";| ")) {
            if (port == null || port.length() <= 3) continue;
            whiteList.append(port).append(" ");
        }
        return whiteList.toString().trim();
    }

    public void setSerialPortWhiteList(String newPortWhiteList) {
        StringBuilder whiteList = new StringBuilder();
        for (String tmpPort : newPortWhiteList.split(" ")) {
            if (GDE.IS_WINDOWS && tmpPort.toUpperCase().startsWith(WINDOWS_PORT_COM)) {
                whiteList.append(tmpPort.toUpperCase()).append(";");
                continue;
            }
            if (!tmpPort.startsWith(UNIX_PORT_DEV_TTY)) continue;
            whiteList.append(tmpPort).append(" ");
        }
        this.setProperty(PORT_WHITELIST, whiteList.toString());
    }

    public boolean isReduceChargeDischarge() {
        return Boolean.valueOf(this.getProperty(IS_REDUCE_CHARGE_DISCHARGE, "false").trim());
    }

    public void setReduceChargeDischarge(boolean enabled) {
        this.setProperty(IS_REDUCE_CHARGE_DISCHARGE, "" + enabled);
    }

    public boolean isContinuousRecordSet() {
        return Boolean.valueOf(this.getProperty(IS_ALL_IN_ONE_RECORDSET, "false").trim());
    }

    public void setContinuousRecordSet(boolean enabled) {
        this.setProperty(IS_ALL_IN_ONE_RECORDSET, "" + enabled);
    }

    public boolean isPartialDataTable() {
        return Boolean.valueOf(this.getProperty(IS_PARTIAL_DATA_TABLE, "true").trim());
    }

    public void setPartialDataTable(boolean enabled) {
        this.setProperty(IS_PARTIAL_DATA_TABLE, "" + enabled);
    }

    public boolean isDataTableEditable() {
        return Boolean.valueOf(this.getProperty(IS_DATA_TABLE_EDITABLE, "false").trim());
    }

    public void setDataTableEditable(boolean enabled) {
        this.setProperty(IS_DATA_TABLE_EDITABLE, "" + enabled);
    }

    public boolean isGlobalLogLevel() {
        return Boolean.valueOf(this.getProperty(IS_GLOBAL_LOG_LEVEL, "true").trim());
    }

    public void setIsGlobalLogLevel(String isGlobalLogLevel) {
        this.setProperty(IS_GLOBAL_LOG_LEVEL, isGlobalLogLevel.trim());
    }

    public void setSkipBluetoothDevices(boolean enabled) {
        this.setProperty(SKIP_BLUETOOTH_DEVICES, "" + enabled);
    }

    public boolean isSkipBluetoothDevices() {
        return Boolean.valueOf(this.getProperty(SKIP_BLUETOOTH_DEVICES, "true"));
    }

    public void setPortAvailabilityCheck(boolean enabled) {
        this.setProperty(DO_PORT_AVAILABLE_TEST, "" + enabled);
    }

    public boolean doPortAvailabilityCheck() {
        return Boolean.valueOf(this.getProperty(DO_PORT_AVAILABLE_TEST, "false"));
    }

    public boolean isOK() {
        boolean ok = false;
        if (this.getProperty(DATA_FILE_PATH) != null || this.getProperty(LIST_SEPARATOR) != null || this.getProperty(DECIMAL_SEPARATOR) != null) {
            ok = true;
        }
        return ok;
    }

    public boolean isRecordCommentVisible() {
        return Boolean.valueOf(this.getProperty(RECORD_COMMENT_VISIBLE, "false").trim());
    }

    public void setRecordCommentVisible(boolean enabled) {
        this.setProperty(RECORD_COMMENT_VISIBLE, "" + enabled);
    }

    public boolean isGraphicsHeaderVisible() {
        return Boolean.valueOf(this.getProperty(GRAPHICS_HEADER_VISIBLE, "false").trim());
    }

    public void setGraphicsHeaderVisible(boolean enabled) {
        this.setProperty(GRAPHICS_HEADER_VISIBLE, "" + enabled);
    }

    public int[] getGridDashStyle() {
        String[] gridLineStyle = this.getProperty(GRID_DASH_STYLE, "10, 10").split(",");
        return new int[]{Integer.parseInt(gridLineStyle[0].trim()), Integer.parseInt(gridLineStyle[1].trim())};
    }

    private String getGridDashStyleAsString() {
        return this.getProperty(GRID_DASH_STYLE, "10, 10").trim();
    }

    public void setGridDaschStyle(int[] newGridDashStyle) {
        this.setProperty(GRID_DASH_STYLE, "" + newGridDashStyle[0] + ", " + newGridDashStyle[1]);
    }

    public int getGridCompareWindowHorizontalType() {
        return Integer.parseInt(this.getProperty(GRID_COMPARE_WINDOW_HOR_TYPE, "0").trim());
    }

    public void setGridCompareWindowHorizontalType(int newHorizontalGridType) {
        this.setProperty(GRID_COMPARE_WINDOW_HOR_TYPE, "" + newHorizontalGridType);
    }

    public Color getGridCompareWindowHorizontalColor() {
        return this.getColor(GRID_COMPARE_WINDOW_HOR_COLOR, "200,200,200");
    }

    public String getGridCompareWindowHorizontalColorStr() {
        return this.getProperty(GRID_COMPARE_WINDOW_HOR_COLOR, "200,200,200").trim();
    }

    public void setGridCompareWindowHorizontalColor(Color newColor) {
        String rgb = newColor.getRGB().red + "," + newColor.getRGB().green + "," + newColor.getRGB().blue;
        this.setProperty(GRID_COMPARE_WINDOW_HOR_COLOR, rgb);
    }

    public int getGridCompareWindowVerticalType() {
        return Integer.parseInt(this.getProperty(GRID_COMPARE_WINDOW_VER_TYPE, "0").trim());
    }

    public void setGridCompareWindowVerticalType(int newVerticalGridType) {
        this.setProperty(GRID_COMPARE_WINDOW_VER_TYPE, "" + newVerticalGridType);
    }

    public Color getGridCompareWindowVerticalColor() {
        return this.getColor(GRID_COMPARE_WINDOW_VER_COLOR, "200,200,200");
    }

    public String getGridCompareWindowVerticalColorStr() {
        return this.getProperty(GRID_COMPARE_WINDOW_VER_COLOR, "200,200,200").trim();
    }

    public void setGridCompareWindowVerticalColor(Color newColor) {
        String rgb = newColor.getRGB().red + "," + newColor.getRGB().green + "," + newColor.getRGB().blue;
        this.setProperty(GRID_COMPARE_WINDOW_VER_COLOR, rgb);
    }

    public void setGlobalLogLevel(java.util.logging.Level logLevel) {
        Logger logger = Logger.getLogger("");
        logger.setLevel(logLevel);
        logger.setUseParentHandlers(true);
    }

    public void setIndividualLogLevel(String packageName, java.util.logging.Level logLevel) {
        Logger logger = Logger.getLogger(packageName);
        logger.setLevel(logLevel);
        logger.setUseParentHandlers(true);
    }

    public void updateLogLevel() {
        if (this.isGlobalLogLevel()) {
            java.util.logging.Level globalLogLevel = java.util.logging.Level.parse(this.getProperty(GLOBAL_LOG_LEVEL, "WARNING").trim());
            this.setIndividualLogLevel("gde.ui", globalLogLevel);
            this.setIndividualLogLevel("gde.data", globalLogLevel);
            this.setIndividualLogLevel("gde.config", globalLogLevel);
            this.setIndividualLogLevel("gde.device", globalLogLevel);
            this.setIndividualLogLevel("gde.utils", globalLogLevel);
            this.setIndividualLogLevel("gde.io", globalLogLevel);
            this.setGlobalLogLevel(globalLogLevel);
            this.setLevelSerialIO(globalLogLevel);
            Enumeration<Object> e = classbasedLogger.keys();
            while (e.hasMoreElements()) {
                String loggerName = (String)e.nextElement();
                this.setIndividualLogLevel(loggerName, java.util.logging.Level.parse("SEVERE"));
            }
            classbasedLogger.clear();
        } else {
            this.setGlobalLogLevel(java.util.logging.Level.parse(this.getProperty(GLOBAL_LOG_LEVEL, "WARNING").trim()));
            this.setIndividualLogLevel("gde.ui", this.getLogLevel(UI_LOG_LEVEL));
            this.setIndividualLogLevel("gde.data", this.getLogLevel(DATA_LOG_LEVEL));
            this.setIndividualLogLevel("gde.config", this.getLogLevel(CONFIG_LOG_LEVEL));
            this.setIndividualLogLevel("gde.device", this.getLogLevel(DEVICE_LOG_LEVEL));
            this.setIndividualLogLevel("gde.utils", this.getLogLevel(UTILS_LOG_LEVEL));
            this.setIndividualLogLevel("gde.io", this.getLogLevel(FILE_IO_LOG_LEVEL));
            this.setLevelSerialIO(this.getLogLevel(SERIAL_IO_LOG_LEVEL));
            Enumeration<Object> e = classbasedLogger.keys();
            while (e.hasMoreElements()) {
                String loggerName = (String)e.nextElement();
                this.setIndividualLogLevel(loggerName, java.util.logging.Level.parse(classbasedLogger.getProperty(loggerName)));
            }
        }
    }

    java.util.logging.Level getLogLevel(String logCategorie) {
        java.util.logging.Level logLevel = java.util.logging.Level.WARNING;
        try {
            logLevel = java.util.logging.Level.parse(this.getProperty(logCategorie, "WARNING").trim());
        }
        catch (IllegalArgumentException e) {
            this.setProperty(logCategorie, "WARNING");
        }
        return logLevel;
    }

    private void setLevelSerialIO(java.util.logging.Level logLevel) {
        String $METHOD_NAME = "setLevelSerialIO";
        try {
            Logger logger = Logger.getLogger("gde.comm.DeviceSerialPortImpl");
            for (Handler handler : logger.getHandlers()) {
                logger.removeHandler(handler);
            }
            logger.setLevel(logLevel);
            if (logLevel.intValue() < java.util.logging.Level.parse("WARNING").intValue()) {
                logger.setUseParentHandlers(false);
                FileHandler fh = new FileHandler(Settings.getSerialLogFilePath(), 15000000, 3);
                fh.setFormatter(new LogFormatter());
                logger.addHandler(new MemoryHandler(fh, 5000000, logLevel));
            } else {
                logger.setUseParentHandlers(true);
            }
        }
        catch (Exception e) {
            log.logp(java.util.logging.Level.WARNING, $CLASS_NAME, "setLevelSerialIO", e.getMessage(), e);
        }
    }

    public void enabelModalDeviceDialogs(boolean enabled) {
        this.setProperty(DEVICE_DIALOG_USE_MODAL, "" + enabled);
    }

    public boolean isDeviceDialogsModal() {
        return Boolean.valueOf(this.getProperty(DEVICE_DIALOG_USE_MODAL, "false").trim());
    }

    public void enabelDeviceDialogsOnTop(boolean enabled) {
        this.setProperty(DEVICE_DIALOG_ON_TOP, "" + enabled);
    }

    public boolean isDeviceDialogsOnTop() {
        return Boolean.valueOf(this.getProperty(DEVICE_DIALOG_ON_TOP, "false").trim());
    }

    public DeviceSerialization getDeviceSerialization() {
        return this.deviceSerialization;
    }

    boolean getLocaleChanged() {
        return Boolean.valueOf(this.getProperty(LOCALE_CHANGED, "false"));
    }

    public void setLocaleLanguage(String newLanguage) {
        if (!this.getLocale().getLanguage().equals(newLanguage)) {
            this.setProperty(LOCALE_CHANGED, "true");
            this.setProperty(LOCALE_IN_USE, newLanguage);
        }
    }

    public Locale getLocale() {
        Locale locale = new Locale(this.getProperty(LOCALE_IN_USE, Locale.getDefault().getLanguage()));
        if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage()) || locale.getLanguage().equals(Locale.GERMAN.getLanguage()) || locale.getLanguage().equals(Locale.ITALIAN.getLanguage())) {
            this.setProperty(LOCALE_IN_USE, locale.getLanguage());
        } else {
            this.setProperty(LOCALE_IN_USE, Locale.ENGLISH.getLanguage());
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    public void setTimeFormat(String newTimeFormat) {
        this.setProperty(TIME_FORMAT_IN_USE, newTimeFormat);
    }

    public String getTimeFormat() {
        return this.getProperty(TIME_FORMAT_IN_USE, Messages.getString("GDE_MSGT0684"));
    }

    public boolean isTimeFormatAbsolute() {
        return this.getProperty(TIME_FORMAT_IN_USE, Messages.getString("GDE_MSGT0684")).trim().equals(Messages.getString("GDE_MSGT0359"));
    }

    public int getDialogAlphaValue() {
        return Integer.parseInt(this.getProperty(ALPHA_BLENDING_VALUE, "50").trim());
    }

    public void setDialogAlphaValue(int newAlphaValue) {
        this.setProperty(ALPHA_BLENDING_VALUE, "" + newAlphaValue);
    }

    public void setDeviceDialogAlphaEnabled(boolean enable) {
        this.setProperty(APLHA_BLENDING_ENABLED, "" + enable);
    }

    public boolean isDeviceDialogAlphaEnabled() {
        return Boolean.valueOf(this.getProperty(APLHA_BLENDING_ENABLED, "false"));
    }

    public void setDeviceImportDirectoryObjectRelated(boolean enable) {
        this.setProperty(KEEP_IMPORT_DIR_OBJECT_RELATED, "" + enable);
    }

    public boolean isDeviceImportDirectoryObjectRelated() {
        return Boolean.valueOf(this.getProperty(KEEP_IMPORT_DIR_OBJECT_RELATED, "false"));
    }

    public boolean isDevicePropertiesUpdated() {
        return this.isDevicePropertiesUpdated;
    }

    public boolean isGraphicsTemplateUpdated() {
        return this.isGraphicsTemplateUpdated;
    }

    public boolean isHistoCacheTemplateUpdated() {
        return this.isHistocacheTemplateUpdated;
    }

    public boolean isDesktopShortcutCreated() {
        return Boolean.valueOf(this.getProperty(IS_DESKTOP_SHORTCUT_CREATED, "false"));
    }

    public boolean isApplicationRegistered() {
        return Boolean.valueOf(this.getProperty(IS_APPL_REGISTERED, "false"));
    }

    public boolean isLockUucpHinted() {
        return Boolean.valueOf(this.getProperty(IS_LOCK_UUCP_HINTED, "false"));
    }

    public boolean isUpdateChecked() {
        return this.getProperty(LAST_UPDATE_CHECK, "2000-01-01").equals(StringHelper.getDate());
    }

    public void setGraphicsCurveAreaBackground(Color curveAreaBackground) {
        this.setProperty(GRAPHICS_AREA_BACKGROUND, curveAreaBackground.getRed() + "," + curveAreaBackground.getGreen() + "," + curveAreaBackground.getBlue());
    }

    public Color getGraphicsCurveAreaBackground() {
        return this.getColor(GRAPHICS_AREA_BACKGROUND, "250,249,211");
    }

    public String getGraphicsCurveAreaBackgroundStr() {
        return this.getProperty(GRAPHICS_AREA_BACKGROUND, "250,249,211").trim();
    }

    public void setCompareCurveAreaBackground(Color curveAreaBackground) {
        this.setProperty(COMPARE_AREA_BACKGROUND, curveAreaBackground.getRed() + "," + curveAreaBackground.getGreen() + "," + curveAreaBackground.getBlue());
    }

    public Color getCompareCurveAreaBackground() {
        return this.getColor(COMPARE_AREA_BACKGROUND, "250,249,211");
    }

    public String getCompareCurveAreaBackgroundStr() {
        return this.getProperty(COMPARE_AREA_BACKGROUND, "250,249,211").trim();
    }

    public void setUtilityCurveAreaBackground(Color curveAreaBackground) {
        this.setProperty(UTILITY_AREA_BACKGROUND, curveAreaBackground.getRed() + "," + curveAreaBackground.getGreen() + "," + curveAreaBackground.getBlue());
    }

    public Color getUtilityCurveAreaBackground() {
        return this.getColor(UTILITY_AREA_BACKGROUND, "250,249,211");
    }

    public String getUtilityCurveAreaBackgroundStr() {
        return this.getProperty(UTILITY_AREA_BACKGROUND, "250,249,211").trim();
    }

    public void setGraphicsSurroundingBackground(Color surroundingBackground) {
        this.setProperty(GRAPHICS_SURROUND_BACKGRD, surroundingBackground.getRed() + "," + surroundingBackground.getGreen() + "," + surroundingBackground.getBlue());
    }

    public Color getGraphicsSurroundingBackground() {
        return this.getColor(GRAPHICS_SURROUND_BACKGRD, "250,249,230");
    }

    public String getGraphicsSurroundingBackgroundStr() {
        return this.getProperty(GRAPHICS_SURROUND_BACKGRD, "250,249,230").trim();
    }

    public void setCompareSurroundingBackground(Color surroundingBackground) {
        this.setProperty(COMPARE_SURROUND_BACKGRD, surroundingBackground.getRed() + "," + surroundingBackground.getGreen() + "," + surroundingBackground.getBlue());
    }

    public Color getCompareSurroundingBackground() {
        return this.getColor(COMPARE_SURROUND_BACKGRD, "250,249,230");
    }

    public String getCompareSurroundingBackgroundStr() {
        return this.getProperty(COMPARE_SURROUND_BACKGRD, "250,249,230").trim();
    }

    public void setUtilitySurroundingBackground(Color surroundingBackground) {
        this.setProperty(UTILITY_SURROUND_BACKGRD, surroundingBackground.getRed() + "," + surroundingBackground.getGreen() + "," + surroundingBackground.getBlue());
    }

    public Color getUtilitySurroundingBackground() {
        return this.getColor(UTILITY_SURROUND_BACKGRD, "250,249,230");
    }

    public String getUtilitySurroundingBackgroundStr() {
        return this.getProperty(UTILITY_SURROUND_BACKGRD, "250,249,230").trim();
    }

    public void setCurveGraphicsBorderColor(Color borderColor) {
        this.setProperty(GRAPHICS_BORDER_COLOR, borderColor.getRed() + "," + borderColor.getGreen() + "," + borderColor.getBlue());
    }

    public Color getGraphicsCurvesBorderColor() {
        return this.getColor(GRAPHICS_BORDER_COLOR, "180,180,180");
    }

    public String getGraphicsCurvesBorderColorStr() {
        return this.getProperty(GRAPHICS_BORDER_COLOR, "180,180,180").trim();
    }

    public void setCurveCompareBorderColor(Color borderColor) {
        this.setProperty(COMPARE_BORDER_COLOR, borderColor.getRed() + "," + borderColor.getGreen() + "," + borderColor.getBlue());
    }

    public Color getCurveCompareBorderColor() {
        return this.getColor(COMPARE_BORDER_COLOR, "180,180,180");
    }

    public String getCurveCompareBorderColorStr() {
        return this.getProperty(COMPARE_BORDER_COLOR, "180,180,180").trim();
    }

    public void setUtilityCurvesBorderColor(Color borderColor) {
        this.setProperty(UTILITY_BORDER_COLOR, borderColor.getRed() + "," + borderColor.getGreen() + "," + borderColor.getBlue());
    }

    public Color getUtilityCurvesBorderColor() {
        return this.getColor(UTILITY_BORDER_COLOR, "180,180,180");
    }

    public String getUtilityCurvesBorderColorStr() {
        return this.getProperty(UTILITY_BORDER_COLOR, "180,180,180").trim();
    }

    public void setSatisticsSurroundingAreaBackground(Color surroundingBackground) {
        this.setProperty(STATISTICS_SURROUND_BACKGRD, surroundingBackground.getRed() + "," + surroundingBackground.getGreen() + "," + surroundingBackground.getBlue());
    }

    public Color getStatisticsSurroundingAreaBackground() {
        return this.getColor(STATISTICS_SURROUND_BACKGRD, "250,249,230");
    }

    public String getStatisticsSurroundingAreaBackgroundStr() {
        return this.getProperty(STATISTICS_SURROUND_BACKGRD, "250,249,230").trim();
    }

    public void setSatisticsInnerAreaBackground(Color innerAreaBackground) {
        this.setProperty(STATISTICS_INNER_BACKGROUND, innerAreaBackground.getRed() + "," + innerAreaBackground.getGreen() + "," + innerAreaBackground.getBlue());
    }

    public Color getStatisticsInnerAreaBackground() {
        return this.getColor(STATISTICS_INNER_BACKGROUND, "255,255,255");
    }

    public String getStatisticsInnerAreaBackgroundStr() {
        return this.getProperty(STATISTICS_INNER_BACKGROUND, "255,255,255").trim();
    }

    public void setAnalogSurroundingAreaBackground(Color surroundingBackground) {
        this.setProperty(ANALOG_SURROUND_BACKGRD, surroundingBackground.getRed() + "," + surroundingBackground.getGreen() + "," + surroundingBackground.getBlue());
    }

    public Color getAnalogSurroundingAreaBackground() {
        return this.getColor(ANALOG_SURROUND_BACKGRD, "250,249,230");
    }

    public String getAnalogSurroundingAreaBackgroundStr() {
        return this.getProperty(ANALOG_SURROUND_BACKGRD, "250,249,230").trim();
    }

    public void setAnalogInnerAreaBackground(Color surroundingBackground) {
        this.setProperty(ANALOG_INNER_BACKGROUND, surroundingBackground.getRed() + "," + surroundingBackground.getGreen() + "," + surroundingBackground.getBlue());
    }

    public Color getAnalogInnerAreaBackground() {
        return this.getColor(ANALOG_INNER_BACKGROUND, "250,249,211");
    }

    public String getAnalogInnerAreaBackgroundStr() {
        return this.getProperty(ANALOG_INNER_BACKGROUND, "250,249,211").trim();
    }

    public void setDigitalSurroundingAreaBackground(Color surroundingBackground) {
        this.setProperty(DIGITAL_SURROUND_BACKGRD, surroundingBackground.getRed() + "," + surroundingBackground.getGreen() + "," + surroundingBackground.getBlue());
    }

    public Color getDigitalSurroundingAreaBackground() {
        return this.getColor(DIGITAL_SURROUND_BACKGRD, "250,249,230");
    }

    public String getDigitalSurroundingAreaBackgroundStr() {
        return this.getProperty(DIGITAL_SURROUND_BACKGRD, "250,249,230").trim();
    }

    public void setDigitalInnerAreaBackground(Color innerAreaBackground) {
        this.setProperty(DIGITAL_INNER_BACKGROUND, innerAreaBackground.getRed() + "," + innerAreaBackground.getGreen() + "," + innerAreaBackground.getBlue());
    }

    public Color getDigitalInnerAreaBackground() {
        return this.getColor(DIGITAL_INNER_BACKGROUND, "250,249,211");
    }

    public String getDigitalInnerAreaBackgroundStr() {
        return this.getProperty(DIGITAL_INNER_BACKGROUND, "250,249,211").trim();
    }

    public void setCellVoltageSurroundingAreaBackground(Color surroundingBackground) {
        this.setProperty(CELL_VOLTAGE_SURROUND_BACKGRD, surroundingBackground.getRed() + "," + surroundingBackground.getGreen() + "," + surroundingBackground.getBlue());
    }

    public Color getCellVoltageSurroundingAreaBackground() {
        return this.getColor(CELL_VOLTAGE_SURROUND_BACKGRD, "250,249,230");
    }

    public String getCellVoltageSurroundingAreaBackgroundStr() {
        return this.getProperty(CELL_VOLTAGE_SURROUND_BACKGRD, "250,249,230").trim();
    }

    public void setCellVoltageInnerAreaBackground(Color innerAreaBackground) {
        this.setProperty(CELL_VOLTAGE_INNER_BACKGROUND, innerAreaBackground.getRed() + "," + innerAreaBackground.getGreen() + "," + innerAreaBackground.getBlue());
    }

    public Color getCellVoltageInnerAreaBackground() {
        return this.getColor(CELL_VOLTAGE_INNER_BACKGROUND, "250,249,211");
    }

    public String getCellVoltageInnerAreaBackgroundStr() {
        return this.getProperty(CELL_VOLTAGE_INNER_BACKGROUND, "250,249,211").trim();
    }

    public void setFileCommentSurroundingAreaBackground(Color surroundingBackground) {
        this.setProperty(FILE_COMMENT_SURROUND_BACKGRD, surroundingBackground.getRed() + "," + surroundingBackground.getGreen() + "," + surroundingBackground.getBlue());
    }

    public Color getFileCommentSurroundingAreaBackground() {
        return this.getColor(FILE_COMMENT_SURROUND_BACKGRD, "250,249,230");
    }

    public String getFileCommentSurroundingAreaBackgroundStr() {
        return this.getProperty(FILE_COMMENT_SURROUND_BACKGRD, "250,249,230").trim();
    }

    public void setFileCommentInnerAreaBackground(Color innerAreaBackground) {
        this.setProperty(FILE_COMMENT_INNER_BACKGROUND, innerAreaBackground.getRed() + "," + innerAreaBackground.getGreen() + "," + innerAreaBackground.getBlue());
    }

    public Color getFileCommentInnerAreaBackground() {
        return this.getColor(FILE_COMMENT_INNER_BACKGROUND, "255,255,255");
    }

    public String getFileCommentInnerAreaBackgroundStr() {
        return this.getProperty(FILE_COMMENT_INNER_BACKGROUND, "255,255,255").trim();
    }

    public void setObjectDescriptionSurroundingAreaBackground(Color surroundingBackground) {
        this.setProperty(OBJECT_DESC_SURROUND_BACKGRD, surroundingBackground.getRed() + "," + surroundingBackground.getGreen() + "," + surroundingBackground.getBlue());
    }

    public Color getObjectDescriptionSurroundingAreaBackground() {
        return this.getColor(OBJECT_DESC_SURROUND_BACKGRD, "250,249,230");
    }

    public String getObjectDescriptionSurroundingAreaBackgroundStr() {
        return this.getProperty(OBJECT_DESC_SURROUND_BACKGRD, "250,249,230").trim();
    }

    public void setObjectDescriptionInnerAreaBackground(Color innerAreaBackground) {
        this.setProperty(OBJECT_DESC_INNER_BACKGROUND, innerAreaBackground.getRed() + "," + innerAreaBackground.getGreen() + "," + innerAreaBackground.getBlue());
    }

    public Color getObjectDescriptionInnerAreaBackground() {
        return this.getColor(OBJECT_DESC_INNER_BACKGROUND, "255,255,255");
    }

    public String getObjectDescriptionInnerAreaBackgroundStr() {
        return this.getProperty(OBJECT_DESC_INNER_BACKGROUND, "255,255,255").trim();
    }

    private Color getColor(String colorKey, String colorDefault) {
        String color = this.getProperty(colorKey, colorDefault);
        int r = Integer.parseInt(color.split(",")[0].trim());
        int g = Integer.parseInt(color.split(",")[1].trim());
        int b = Integer.parseInt(color.split(",")[2].trim());
        return SWTResourceManager.getColor(r, g, b);
    }

    public void joinXsdThread() {
        try {
            this.xsdThread.join();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void startMigationThread() {
        if (this.migrationThread != null) {
            this.migrationThread.run();
        }
    }

    public void joinMigationThread() {
        try {
            this.migrationThread.join();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public String getObjectImageFilePath() {
        String $METHOD_NAME = "getObjectImageFilePath";
        String objectImageFilePath = this.getProperty(OBJECT_IMAGE_FILE_PATH, this.getDataFilePath()).replace("\\\\", "/").replace('\\', '/');
        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "getObjectImageFilePath", "objectImageFilePath = " + objectImageFilePath);
        return objectImageFilePath.trim();
    }

    public void setObjectImageFilePath(String newImageFilePath) {
        String $METHOD_NAME = "setObjectImageFilePath";
        String filePath = newImageFilePath.replace('\\', '/').trim();
        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "setObjectImageFilePath", "newDataFilePath = " + filePath);
        this.setProperty(OBJECT_IMAGE_FILE_PATH, filePath);
    }

    public void setDrawScaleInRecordColor(boolean isUseRecordColor) {
        this.setProperty(IS_GRAPHICS_SCALE_COLOR, "" + isUseRecordColor);
    }

    public boolean isDrawScaleInRecordColor() {
        return Boolean.valueOf(this.getProperty(IS_GRAPHICS_SCALE_COLOR, "true"));
    }

    public void setDrawNameInRecordColor(boolean isUseRecordColor) {
        this.setProperty(IS_GRAPHICS_NAME_COLOR, "" + isUseRecordColor);
    }

    public boolean isDrawNameInRecordColor() {
        return Boolean.valueOf(this.getProperty(IS_GRAPHICS_NAME_COLOR, "true"));
    }

    public void setDraw10TicksPerRecord(boolean isDraw10TicksPerRecord) {
        this.setProperty(IS_GRAPHICS_TICKS_10, "" + isDraw10TicksPerRecord);
    }

    public boolean isDraw10TicksPerRecord() {
        return Boolean.valueOf(this.getProperty(IS_GRAPHICS_TICKS_10, "false"));
    }

    public void setDrawNumbersInRecordColor(boolean isUseRecordColor) {
        this.setProperty(IS_GRAPHICS_NUMBERS_COLOR, "" + isUseRecordColor);
    }

    public boolean isDrawNumbersInRecordColor() {
        return Boolean.valueOf(this.getProperty(IS_GRAPHICS_NUMBERS_COLOR, "false"));
    }

    public void setCurveCompareChannelConfigName(boolean isUseChannelConfigName) {
        this.setProperty(IS_COMPARE_CHANNELCONFIG, "" + isUseChannelConfigName);
    }

    public boolean isCurveCompareChannelConfigName() {
        return Boolean.valueOf(this.getProperty(IS_COMPARE_CHANNELCONFIG, "false"));
    }

    public void setFontDisplayDensityAdaptionFactor(double newCorrectionValue) {
        this.setProperty(DISPLAY_DENSITY_FONT_CORRECT, "" + newCorrectionValue);
    }

    public double getFontDisplayDensityAdaptionFactor() {
        return Double.valueOf(this.getProperty(DISPLAY_DENSITY_FONT_CORRECT, "1.0"));
    }

    public void setKmzExportTimeStep_ms(int newTimeStepValue) {
        this.setProperty(KMZ_EXPORT_TIME_STEP_MS, "" + newTimeStepValue);
    }

    public int getKmzExportTimeStep_ms() {
        return Integer.valueOf(this.getProperty(KMZ_EXPORT_TIME_STEP_MS, "500"));
    }

    public void setHistoActive(boolean isActive) {
        this.setProperty(IS_HISTO_ACTIVE, String.valueOf(isActive));
    }

    public boolean isHistoActive() {
        return Boolean.valueOf(this.getProperty(IS_HISTO_ACTIVE, "false"));
    }

    public static String[] getBoxplotScaleNomenclatures() {
        return Messages.getString("GDE_MSGT0802").split(",");
    }

    public void setBoxplotScale(String scaleNomenclature) {
        this.setProperty(BOXPLOT_SCALE_ORDINAL, String.valueOf(Arrays.asList(Settings.getBoxplotScaleNomenclatures()).indexOf(scaleNomenclature)));
    }

    public String getBoxplotScale() {
        return Settings.getBoxplotScaleNomenclatures()[this.getBoxplotScaleOrdinal()];
    }

    public int getBoxplotScaleOrdinal() {
        return Integer.parseInt(this.getProperty(BOXPLOT_SCALE_ORDINAL, String.valueOf(1)));
    }

    public static String[] getBoxplotSizeAdaptationNomenclatures() {
        return Messages.getString("GDE_MSGT0803").split(",");
    }

    public void setBoxplotSizeAdaptation(String scaleNomenclature) {
        this.setProperty(BOXPLOT_SIZE_ADAPTATION_ORDINAL, String.valueOf(Arrays.asList(Settings.getBoxplotSizeAdaptationNomenclatures()).indexOf(scaleNomenclature)));
    }

    public String getBoxplotSizeAdaptation() {
        return Settings.getBoxplotSizeAdaptationNomenclatures()[this.getBoxplotSizeAdaptationOrdinal()];
    }

    public int getBoxplotSizeAdaptationOrdinal() {
        return Integer.parseInt(this.getProperty(BOXPLOT_SIZE_ADAPTATION_ORDINAL, String.valueOf(2)));
    }

    public static String[] getXAxisSpreadGradeNomenclatures() {
        return Messages.getString("GDE_MSGT0823").split(",");
    }

    public void setXAxisSpreadGrade(String gradeText) {
        this.setProperty(X_SPREAD_GRADE_ORDINAL, String.valueOf(Arrays.asList(Settings.getXAxisSpreadGradeNomenclatures()).indexOf(gradeText)));
    }

    public String getXAxisSpreadGrade() {
        return Settings.getXAxisSpreadGradeNomenclatures()[this.getXAxisSpreadOrdinal()];
    }

    public int getXAxisSpreadOrdinal() {
        return Integer.parseInt(this.getProperty(X_SPREAD_GRADE_ORDINAL, String.valueOf(2)));
    }

    public void setXAxisLogarithmicDistance(boolean isActive) {
        this.setProperty(IS_X_LOGARITHMIC_DISTANCE, String.valueOf(isActive));
    }

    public boolean isXAxisLogarithmicDistance() {
        return Boolean.valueOf(this.getProperty(IS_X_LOGARITHMIC_DISTANCE, "false"));
    }

    public void setXAxisReversed(boolean isActive) {
        this.setProperty(IS_X_REVERSED, String.valueOf(isActive));
    }

    public boolean isXAxisReversed() {
        return Boolean.valueOf(this.getProperty(IS_X_REVERSED, "true"));
    }

    public void setSearchDataPathImports(boolean isActive) {
        this.setProperty(SEARCH_DATAPATH_IMPORTS, String.valueOf(isActive));
    }

    public boolean getSearchDataPathImports() {
        return Boolean.valueOf(this.getProperty(SEARCH_DATAPATH_IMPORTS, String.valueOf(true)));
    }

    public void setChannelMix(boolean isActive) {
        this.setProperty(IS_CHANNEL_MIX, String.valueOf(isActive));
    }

    public boolean isChannelMix() {
        return Boolean.valueOf(this.getProperty(IS_CHANNEL_MIX, "true"));
    }

    public static String[] getSamplingTimespanValues() {
        String[] textValues = new String[7];
        for (int i = 0; i < SAMPLING_TIMESPANS.length; ++i) {
            textValues[i] = String.valueOf(SAMPLING_TIMESPANS[i]);
        }
        return textValues;
    }

    public void setSamplingTimespan_ms(String valueText) {
        this.setProperty(SAMPLING_TIMESPAN_ORDINAL, String.valueOf(Arrays.asList(Settings.getSamplingTimespanValues()).indexOf(valueText)));
    }

    public int getSamplingTimespan_ms() {
        double timespan_sec;
        try {
            timespan_sec = SAMPLING_TIMESPANS[this.getSamplingTimespanOrdinal()];
        }
        catch (Exception e) {
            this.setSamplingTimespan_ms(Double.toString(1.0));
            timespan_sec = SAMPLING_TIMESPANS[this.getSamplingTimespanOrdinal()];
        }
        return (int)(timespan_sec * 1000.0);
    }

    public int getSamplingTimespanOrdinal() {
        return Integer.parseInt(this.getProperty(SAMPLING_TIMESPAN_ORDINAL, String.valueOf(2)));
    }

    public void setIgnoreLogObjectKey(boolean value) {
        this.setProperty(IGNORE_LOG_OBJECT_KEY, String.valueOf(value));
    }

    public boolean getIgnoreLogObjectKey() {
        return Boolean.valueOf(this.getProperty(IGNORE_LOG_OBJECT_KEY, "true"));
    }

    public int getRetrospectMonths() {
        return Integer.valueOf(this.getProperty(RETROSPECT_MONTHS, String.valueOf(12)));
    }

    public void setRetrospectMonths(String uintValue) {
        try {
            int value = Integer.parseUnsignedInt(uintValue.trim());
            if (value < 1 || value > 240) {
                value = 12;
            }
            this.setProperty(RETROSPECT_MONTHS, String.valueOf(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isZippedCache() {
        return Boolean.valueOf(this.getProperty(IS_ZIPPED_CACHE, "false"));
    }

    public void setZippedCache(boolean value) {
        this.setProperty(IS_ZIPPED_CACHE, String.valueOf(value));
    }

    public boolean isXmlCache() {
        return Boolean.valueOf(this.getProperty(IS_XML_CACHE, "false"));
    }

    public void setXmlCache(boolean value) {
        this.setProperty(IS_XML_CACHE, String.valueOf(value));
    }

    public double getMinmaxQuantileDistance() {
        return Double.valueOf(this.getProperty(MINMAX_QUANTILE_DISTANCE, ".1"));
    }

    public void setMinMaxQuantileDistance(String doubleValue) {
        try {
            double value = Double.parseDouble(doubleValue.trim());
            if (value > 1.0 || value < 0.0) {
                value = 0.1;
            }
            this.setProperty(MINMAX_QUANTILE_DISTANCE, String.valueOf(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public double getAbsoluteTransitionLevel() {
        return Double.valueOf(this.getProperty(ABSOLUTE_TRANSITION_LEVEL, ".5"));
    }

    public void setAbsoluteTransitionLevel(String doubleValue) {
        try {
            double value = Double.parseDouble(doubleValue.trim());
            if (value >= 1.0 || value <= 0.0) {
                value = 0.5;
            }
            this.setProperty(ABSOLUTE_TRANSITION_LEVEL, String.valueOf(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDateTimeUtc(boolean isUtc) {
        this.setProperty(IS_DATETIME_UTC, String.valueOf(isUtc));
    }

    public boolean isDateTimeUtc() {
        return Boolean.valueOf(this.getProperty(IS_DATETIME_UTC, "false"));
    }

    public void setDisplayTags(boolean isDisplayActive) {
        this.setProperty(IS_DISPLAY_TAGS, String.valueOf(isDisplayActive));
    }

    public boolean isDisplayTags() {
        return Boolean.valueOf(this.getProperty(IS_DISPLAY_TAGS, "true"));
    }

    public void setDisplayScores(boolean isDisplayActive) {
        this.setProperty(IS_DISPLAY_SCORES, String.valueOf(isDisplayActive));
    }

    public boolean isDisplayScores() {
        return Boolean.valueOf(this.getProperty(IS_DISPLAY_SCORES, "true"));
    }

    public void setDisplaySettlements(boolean isDisplayActive) {
        this.setProperty(IS_DISPLAY_SETTLEMENTS, String.valueOf(isDisplayActive));
    }

    public boolean isDisplaySettlements() {
        return Boolean.valueOf(this.getProperty(IS_DISPLAY_SETTLEMENTS, "false"));
    }

    public void setSuppressMode(boolean isSuppressMode) {
        this.setProperty(IS_SUPPRESS_MODE, String.valueOf(isSuppressMode));
    }

    public boolean isSuppressMode() {
        return Boolean.valueOf(this.getProperty(IS_SUPPRESS_MODE, "false"));
    }

    public void setCurveSurvey(boolean isCurveSurvey) {
        this.setProperty(IS_CURVE_SURVEY, String.valueOf(isCurveSurvey));
    }

    public boolean isCurveSurvey() {
        return Boolean.valueOf(this.getProperty(IS_CURVE_SURVEY, "false"));
    }

    public double getGpsLocationRadius() {
        return Double.valueOf(this.getProperty(GPS_LOCATION_RADIUS, ".5"));
    }

    public void setGpsLocationRadius(double doubleValue) {
        this.setProperty(GPS_LOCATION_RADIUS, String.valueOf(doubleValue));
    }

    public int getSubDirectoryLevelMax() {
        return Integer.valueOf(this.getProperty(SUBDIRECTORY_LEVEL_MAX, String.valueOf(0)));
    }

    public void setSubDirectoryLevelMax(String uintValue) {
        try {
            int value = Integer.parseUnsignedInt(uintValue.trim());
            if (value < 0 || value > 9) {
                value = 0;
            }
            this.setProperty(SUBDIRECTORY_LEVEL_MAX, String.valueOf(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDataTableTransitions(boolean enabled) {
        this.setProperty(IS_DATA_TABLE_TRANSITIONS, String.valueOf(enabled));
    }

    public boolean isDataTableTransitions() {
        return Boolean.valueOf(this.getProperty(IS_DATA_TABLE_TRANSITIONS, "false"));
    }

    public void setFirstRecordSetChoice(boolean enabled) {
        this.setProperty(IS_FIRST_RECORDSET_CHOICE, String.valueOf(enabled));
    }

    public boolean isFirstRecordSetChoice() {
        return Boolean.valueOf(this.getProperty(IS_FIRST_RECORDSET_CHOICE, "true"));
    }

    public void setReminderCountCsv(String csvValues) {
        this.setProperty(REMINDER_COUNT_CSV, String.valueOf(csvValues));
    }

    public String getReminderCountCsv() {
        String list = String.valueOf(this.getProperty(REMINDER_COUNT_CSV, String.join((CharSequence)",", REMINDER_COUNT_VALUES)));
        return list;
    }

    private int[] getReminderCountValues() {
        Stream<String> items = Arrays.stream(this.getReminderCountCsv().split(","));
        if (items.count() != (long)REMINDER_COUNT_VALUES.length) {
            this.setReminderCountCsv(String.join((CharSequence)",", Arrays.asList(REMINDER_COUNT_VALUES)));
        }
        return Arrays.stream(this.getReminderCountCsv().split(",")).mapToInt(Integer::valueOf).toArray();
    }

    public int getReminderCountIndex() {
        return Integer.valueOf(this.getProperty(REMINDER_COUNT_INDEX, String.valueOf(0)));
    }

    public int getReminderCount() {
        return this.getReminderCount(this.getReminderCountIndex());
    }

    public int getReminderCount(int index) {
        int[] reminderCountValues = this.getReminderCountValues();
        int realIndex = index >= 0 && index < reminderCountValues.length ? index : 1;
        return reminderCountValues[realIndex];
    }

    public void setReminderCountIndex(String uintValue) {
        this.setProperty(REMINDER_COUNT_INDEX, String.valueOf(uintValue));
    }

    public int getReminderLevel() {
        return Integer.valueOf(this.getProperty(REMINDER_LEVEL, String.valueOf(0)));
    }

    public void setReminderLevel(String uintValue) {
        this.setProperty(REMINDER_LEVEL, String.valueOf(uintValue));
    }

    public void setCanonicalQuantiles(boolean enabled) {
        this.setProperty(IS_CANONICAL_QUANTILES, String.valueOf(enabled));
    }

    public boolean isCanonicalQuantiles() {
        return Boolean.valueOf(this.getProperty(IS_CANONICAL_QUANTILES, "false"));
    }

    public void setSymmetricToleranceInterval(boolean enabled) {
        this.setProperty(IS_SYMMETRIC_TOLERANCE_INTERVAL, String.valueOf(enabled));
    }

    public boolean isSymmetricToleranceInterval() {
        return Boolean.valueOf(this.getProperty(IS_SYMMETRIC_TOLERANCE_INTERVAL, "false"));
    }

    public int getOutlierToleranceSpread() {
        return Integer.valueOf(this.getProperty(OUTLIER_TOLERANCE_SPREAD, String.valueOf(99999)));
    }

    public void setOutlierToleranceSpread(String uintValue) {
        this.setProperty(OUTLIER_TOLERANCE_SPREAD, String.valueOf(uintValue));
    }

    public int getSummaryScaleSpread() {
        return Integer.valueOf(this.getProperty(SUMMARY_SCALE_SPREAD, String.valueOf(9)));
    }

    public void setSummaryScaleSpread(String uintValue) {
        this.setProperty(SUMMARY_SCALE_SPREAD, String.valueOf(uintValue));
    }

    public void setSummaryBoxVisible(boolean enabled) {
        this.setProperty(IS_SUMMARY_BOX_VISIBLE, String.valueOf(enabled));
    }

    public boolean isSummaryBoxVisible() {
        return Boolean.valueOf(this.getProperty(IS_SUMMARY_BOX_VISIBLE, "true"));
    }

    public void setSummarySpreadVisible(boolean enabled) {
        this.setProperty(IS_SUMMARY_SPREAD_VISIBLE, String.valueOf(enabled));
    }

    public boolean isSummarySpreadVisible() {
        return Boolean.valueOf(this.getProperty(IS_SUMMARY_SPREAD_VISIBLE, "false"));
    }

    public void setSummarySpotsVisible(boolean enabled) {
        this.setProperty(IS_SUMMARY_SPOTS_VISIBLE, String.valueOf(enabled));
    }

    public boolean isSummarySpotsVisible() {
        return Boolean.valueOf(this.getProperty(IS_SUMMARY_SPOTS_VISIBLE, "true"));
    }

    public void setObjectTemplatesActive(boolean enabled) {
        this.setProperty(IS_OBJECT_TEMPLATES_ACTIVE, String.valueOf(enabled));
    }

    public boolean isObjectTemplatesActive() {
        return Boolean.valueOf(this.getProperty(IS_OBJECT_TEMPLATES_ACTIVE, "true"));
    }

    public void setMacTouchbarEnabled(boolean enabled) {
        this.setProperty(IS_MAC_TOUCHBAR, String.valueOf(enabled));
    }

    public boolean isMacTouchbarEnabled() {
        return Boolean.valueOf(this.getProperty(IS_MAC_TOUCHBAR, "false"));
    }

    public void setDataFoldersCsv(String csvValues) {
        this.setProperty(DATA_FOLDERS_CSV, String.valueOf(csvValues));
    }

    public String getDataFoldersCsv() {
        String list = String.valueOf(this.getProperty(DATA_FOLDERS_CSV, ""));
        return list;
    }

    public void setImportFoldersCsv(String csvValues) {
        this.setProperty(IMPORT_FOLDERS_CSV, String.valueOf(csvValues));
    }

    public String getImportFoldersCsv() {
        String list = String.valueOf(this.getProperty(IMPORT_FOLDERS_CSV, ""));
        return list;
    }

    public void setMirrorSourceFoldersCsv(String csvValues) {
        this.setProperty(MIRROR_SOURCE_FOLDERS_CSV, String.valueOf(csvValues));
    }

    public String getMirrorSourceFoldersCsv() {
        String list = String.valueOf(this.getProperty(MIRROR_SOURCE_FOLDERS_CSV, ""));
        return list;
    }

    public void setSourceFileListenerActive(boolean enabled) {
        this.setProperty(IS_SOURCE_FILE_LISTENER_ACTIVE, String.valueOf(enabled));
    }

    public boolean isSourceFileListenerActive() {
        return Boolean.valueOf(this.getProperty(IS_SOURCE_FILE_LISTENER_ACTIVE, "false"));
    }

    public void setObjectQueryActive(boolean enabled) {
        this.setProperty(IS_OBJECT_QUERY_ACTIVE, String.valueOf(enabled));
    }

    public boolean isObjectQueryActive() {
        return Boolean.valueOf(this.getProperty(IS_OBJECT_QUERY_ACTIVE, "false"));
    }

    public String getDeviceUseCsv() {
        return String.valueOf(this.getProperty(DEVICE_USE, ""));
    }

    public void setDeviceUseCsv(String csvValues) {
        log.log(Level.FINE, csvValues);
        this.setProperty(DEVICE_USE, String.valueOf(csvValues));
    }

    public void addDeviceUse(String deviceName, int channelNumber) {
        String entry = deviceName + "*" + (channelNumber - 1);
        Stream<String> remainingEntries = Arrays.stream(this.getDeviceUseCsv().split(",")).filter(s -> !s.startsWith(deviceName + "*")).filter(s -> !s.isEmpty());
        this.setDeviceUseCsv(Stream.concat(Stream.of(entry), remainingEntries).collect(Collectors.joining(",")));
    }

    public void removeDeviceUse(String deviceName) {
        Stream<String> remainingEntries = Arrays.stream(this.getDeviceUseCsv().split(",")).filter(s -> !s.startsWith(deviceName + "*"));
        this.setDeviceUseCsv(remainingEntries.collect(Collectors.joining(",")));
    }

    public int getLastUseChannelNumber(String deviceName) {
        Optional<String> lastUseEntry = Arrays.stream(this.getDeviceUseCsv().split(",")).filter(s -> s.startsWith(deviceName + "*")).findFirst();
        return lastUseEntry.map(s -> s.substring((deviceName + "*").length())).map(Integer::parseInt).orElse(0) + 1;
    }

    public String getSkinColorSchema() {
        return this.getProperty(SKIN_COLOR_SCHEMA, COLOR_SCHEMA_SYSTEM);
    }

    public void setSkinColorSchema(String colorSchema) {
        this.setProperty(SKIN_COLOR_SCHEMA, colorSchema);
        DataExplorer.getInstance().setColorSchemaColors(this.getSkinColorSchema());
    }

    public String getColorSchemaType() {
        return DataExplorer.getInstance().COLOR_BACKGROUND.getRed() + DataExplorer.getInstance().COLOR_BACKGROUND.getGreen() + DataExplorer.getInstance().COLOR_BACKGROUND.getBlue() > 500 ? "light/" : "dark/";
    }

    public boolean isRXTXcommToBeUsed() {
        return Boolean.valueOf(this.getProperty(IS_RXTX_COMM_TO_BE_USED, "false"));
    }

    public boolean isStartDeviceCommunicationAfterStartup() {
        return Boolean.valueOf(this.getProperty(IS_START_DEV_COMM_AFTER_START, "false"));
    }

    public void setStartDeviceCommunicationAfterStartup(boolean enabled) {
        this.setProperty(IS_START_DEV_COMM_AFTER_START, String.valueOf(enabled));
    }

    public static enum GeoCodeGoogle {
        STREET_ADDRESS,
        ROUTE,
        POLITICAL,
        ADMINISTRATIVE_AREA_LEVEL_3,
        ADMINISTRATIVE_AREA_LEVEL_2;

        public static final GeoCodeGoogle[] VALUES;

        static {
            VALUES = GeoCodeGoogle.values();
        }
    }
}

