/*
 * Decompiled with CFR 0.152.
 */
package gde.config;

import gde.Analyzer;
import gde.DataAccess;
import gde.GDE;
import gde.device.DeviceConfiguration;
import gde.device.DevicePropertiesType;
import gde.exception.ThrowableUtils;
import gde.log.Level;
import gde.log.Logger;
import gde.utils.StringHelper;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public class DeviceSerialization {
    private static final String $CLASS_NAME = DeviceSerialization.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private JAXBContext jc;
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;

    public Thread createXsdThread() {
        Thread xsdThread = new Thread("xsdValidation"){

            @Override
            public void run() {
                log.log(Level.INFO, "xsdThread.run()");
                try (InputStream inputStream = DataAccess.getInstance().getDeviceXsdInputStream();){
                    Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(inputStream));
                    DeviceSerialization.this.jc = JAXBContext.newInstance("gde.device");
                    DeviceSerialization.this.unmarshaller = DeviceSerialization.this.jc.createUnmarshaller();
                    DeviceSerialization.this.unmarshaller.setSchema(schema);
                    DeviceSerialization.this.marshaller = DeviceSerialization.this.jc.createMarshaller();
                    DeviceSerialization.this.marshaller.setProperty("jaxb.formatted.output", true);
                    DeviceSerialization.this.marshaller.setProperty("jaxb.noNamespaceSchemaLocation", "DeviceProperties_V47.xsd");
                    log.log(Level.TIME, "schema factory setup time = ", StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - GDE.StartTime));
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "xsdThread.run()" + e.getMessage(), e);
                }
            }
        };
        return xsdThread;
    }

    public static Thread createMigrationThread() {
        Thread migrationThread = new Thread("migration"){

            @Override
            public void run() {
                int lastVersion;
                log.log(Level.INFO, "start migration thread");
                Analyzer analyzer = Analyzer.getInstance();
                DataAccess.LocalAccess localAccess = (DataAccess.LocalAccess)analyzer.getDataAccess();
                for (int i = lastVersion = Integer.valueOf("_V47".substring("_V47".lastIndexOf("_V") + 2)) - 1; i >= 10; --i) {
                    if (!localAccess.existsDeviceMigrationFolder(i)) continue;
                    log.log(Level.INFO, "previous devices exist, migrate from version " + i);
                    try (InputStream inputStream = localAccess.getDeviceXsdMigrationStream(i);){
                        Unmarshaller tmpUnmarshaller = JAXBContext.newInstance("gde.device").createUnmarshaller();
                        tmpUnmarshaller.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(inputStream)));
                        for (Path xmlFileSubPath : localAccess.getDeviceXmlSubPaths(i)) {
                            DeviceConfiguration oldConfig = new DeviceConfiguration(xmlFileSubPath, tmpUnmarshaller, analyzer);
                            DeviceConfiguration newConfig = analyzer.getDeviceConfigurations().get(oldConfig.getName());
                            if (oldConfig.isUsed() && newConfig != null) {
                                newConfig.setUsed(true);
                                if (oldConfig.getPort().length() > 1 && !oldConfig.getPort().startsWith("USB")) {
                                    newConfig.setPort(oldConfig.getPort());
                                }
                                if (oldConfig.getDataBlockPreferredDataLocation().length() > 1) {
                                    newConfig.setDataBlockPreferredDataLocation(oldConfig.getDataBlockPreferredDataLocation());
                                }
                                newConfig.storeDeviceProperties();
                                log.log(Level.INFO, "migrated device configuration " + newConfig.getName());
                                continue;
                            }
                            if (oldConfig.isUsed()) continue;
                            localAccess.deleteDeviceHistoTemplates(oldConfig.getName());
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "xsdThread.run()" + e.getMessage(), e);
                    }
                    break;
                }
                log.log(Level.TIME, "finished migration thread");
            }
        };
        return migrationThread;
    }

    public JAXBElement<DevicePropertiesType> getTopElement(String xmlFilePath, Unmarshaller tmpUnmarshaller, DataAccess.LocalAccess localAccess) throws JAXBException {
        JAXBElement jAXBElement;
        block8: {
            InputStream stream = localAccess.getDeviceXmlInputStream(xmlFilePath);
            try {
                jAXBElement = (JAXBElement)tmpUnmarshaller.unmarshal(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ThrowableUtils.rethrow(e);
                }
            }
            stream.close();
        }
        return jAXBElement;
    }

    public JAXBElement<DevicePropertiesType> getTopElement(String xmlFilePath, DataAccess.LocalAccess localAccess) throws JAXBException {
        return this.getTopElement(xmlFilePath, this.unmarshaller, localAccess);
    }

    public JAXBElement<DevicePropertiesType> getTopElement(Path fileSubPath, Unmarshaller tmpUnmarshaller, DataAccess dataAccess) throws JAXBException {
        JAXBElement jAXBElement;
        block8: {
            InputStream stream = dataAccess.getDeviceXmlInputStream(fileSubPath);
            try {
                jAXBElement = (JAXBElement)tmpUnmarshaller.unmarshal(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ThrowableUtils.rethrow(e);
                }
            }
            stream.close();
        }
        return jAXBElement;
    }

    public JAXBElement<DevicePropertiesType> getTopElement(Path fileSubPath, DataAccess dataAccess) throws JAXBException {
        return this.getTopElement(fileSubPath, this.unmarshaller, dataAccess);
    }

    public void marshall(JAXBElement<DevicePropertiesType> element, String xmlFile, DataAccess.LocalAccess localAccess) throws JAXBException {
        try (FileOutputStream stream = localAccess.getDeviceXmlOutputStream(xmlFile);){
            this.marshaller.marshal(element, stream);
        }
        catch (Exception e) {
            throw ThrowableUtils.rethrow(e);
        }
    }
}

