/*
 * Decompiled with CFR 0.152.
 */
package gde.io;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.ChannelTypes;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.exception.NotSupportedFileFormatException;
import gde.io.IDataParser;
import gde.io.NMEAParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;

public class CSVSerialDataReaderWriter {
    static Logger log = Logger.getLogger(CSVSerialDataReaderWriter.class.getName());
    static String lineSep = GDE.LINE_SEPARATOR;
    static DecimalFormat df3 = new DecimalFormat("0.000");
    static StringBuffer sb;
    static final DataExplorer application;
    static final Channels channels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RecordSet read(String filePath, IDevice device, String recordNameExtend, Integer channelConfigNumber, IDataParser data) throws NotSupportedFileFormatException, IOException, DataInconsitsentException, DataTypeException {
        String line = "*";
        Channel activeChannel = null;
        String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(new File(filePath).lastModified());
        long inputFileSize = new File(filePath).length();
        int progressLineLength = Math.abs(device.getDataBlockSize(InputTypes.FILE_IO));
        boolean isOutdated = false;
        int lineNumber = 0;
        int activeChannelConfigNumber = 1;
        String recordSetNameExtend = device.getRecordSetStemNameReplacement();
        RecordSet channelRecordSet = null;
        int lastRecordSetNumberOffset = 0;
        Vector<RecordSet> createdRecordSets = new Vector<RecordSet>(1);
        StringBuilder inputLineBuffer = new StringBuilder();
        boolean isRedirect2Channel1 = data.isRedirectChannel1();
        int endIndex = 0;
        int dataBlockNumber = 1;
        String firmwareHardwareDescription = new String();
        long lastRecordEndTimeStamp_ms = 0L;
        boolean isDataConsistentChecked = false;
        try {
            activeChannel = channelConfigNumber == null ? channels.getActiveChannel() : (Channel)channels.get(channelConfigNumber);
            activeChannelConfigNumber = channels.getActiveChannelNumber();
            if (activeChannel == null) return channelRecordSet;
            GDE.getUiNotification().setStatusMessage(Messages.getString("GDE_MSGT0594") + filePath);
            GDE.getUiNotification().setProgress(0);
            activeChannelConfigNumber = activeChannel.getNumber();
            if (device.recordSetNumberFollowChannel() && activeChannel.size() != 0) {
                application.getDeviceSelectionDialog().setupDataChannels(device);
            }
            String recordSetName = activeChannel.size() + 1 + recordSetNameExtend;
            DataInputStream binReader = new DataInputStream(new FileInputStream(new File(filePath)));
            byte[] buffer = new byte[1024];
            byte[] lineEnding = device.getDataBlockEnding();
            boolean lineEndingOcurred = false;
            int chars = binReader.read(buffer);
            for (int i = 0; i < chars; ++i) {
                if (buffer[i] != lineEnding[0] || i >= chars - lineEnding.length - 1 || buffer[i + lineEnding.length + 1] == 36 || lineEnding.length > 1 && buffer[i + 1] != lineEnding[1]) continue;
                lineEndingOcurred = true;
            }
            binReader.close();
            if (!lineEndingOcurred) {
                throw new DevicePropertiesInconsistenceException(Messages.getString("GDE_MSGE0042", new Object[]{chars, filePath}));
            }
            long lastTimeStamp = 0L;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
            if (device.getStateType() == null) {
                throw new DevicePropertiesInconsistenceException(Messages.getString("GDE_MSGE0043", new Object[]{device.getPropertiesFileName()}));
            }
            while ((line = reader.readLine()) != null) {
                int progress;
                block68: {
                    block67: {
                        block69: {
                            block66: {
                                ++lineNumber;
                                if (line.startsWith(device.getDataBlockLeader())) {
                                    if (line.startsWith(device.getDataBlockLeader() + NMEAParser.NMEA.SETUP.name()) || line.startsWith(device.getDataBlockLeader() + NMEAParser.NMEA.GPGGA.name())) {
                                        data.parse(line, lineNumber);
                                        continue;
                                    }
                                    if (line.trim().endsWith(device.getDataBlockSeparator().value())) {
                                        log.log(Level.WARNING, filePath + " - skipped " + lineNumber + ", ends with " + device.getDataBlockSeparator().value());
                                        continue;
                                    }
                                } else {
                                    if (line.startsWith("@Model")) {
                                        firmwareHardwareDescription = line.substring(1).trim().replace(':', ' ');
                                        continue;
                                    }
                                    log.log(Level.WARNING, filePath + " - skipped " + lineNumber + ", it does not start with " + device.getDataBlockLeader());
                                    continue;
                                }
                                if (isRedirect2Channel1) {
                                    if (log.isLoggable(Level.FINE)) {
                                        log.log(Level.FINE, "number of values inputLineBuffer " + inputLineBuffer.toString().split(device.getDataBlockSeparator().value()).length);
                                    }
                                    if (line.startsWith("$1")) {
                                        int numValues;
                                        int n = dataBlockNumber == 2 ? 58 : (numValues = dataBlockNumber == 3 ? 75 : Math.abs(device.getDataBlockSize(InputTypes.FILE_IO)) - 25);
                                        if (inputLineBuffer.toString().split(device.getDataBlockSeparator().value()).length > numValues) {
                                            data.parse(inputLineBuffer.toString(), lineNumber);
                                            endIndex = line.lastIndexOf(59, line.lastIndexOf(59) - 3);
                                            inputLineBuffer = new StringBuilder().append(line.substring(0, endIndex));
                                            break block66;
                                        } else {
                                            endIndex = line.lastIndexOf(59, line.lastIndexOf(59) - 3);
                                            inputLineBuffer = new StringBuilder().append(line.substring(0, endIndex));
                                            continue;
                                        }
                                    }
                                    try {
                                        dataBlockNumber = line.charAt(1) - 48;
                                    }
                                    catch (Exception e) {
                                        dataBlockNumber = 1;
                                    }
                                    endIndex = line.lastIndexOf(59);
                                    inputLineBuffer.append(line.substring(line.indexOf(device.getDataBlockSeparator().value(), 6), endIndex));
                                    continue;
                                }
                                data.parse(line, lineNumber);
                            }
                            try {
                                if (data.getChannelConfigNumber() > device.getChannelCount()) continue;
                                activeChannelConfigNumber = device.recordSetNumberFollowChannel() ? data.getChannelConfigNumber() : activeChannelConfigNumber;
                                activeChannel = (Channel)channels.get(activeChannelConfigNumber);
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, device.getChannelCount() + " - data for channel = " + activeChannelConfigNumber + " state = " + data.getState());
                                }
                                if (!isDataConsistentChecked) {
                                    int measurementSize = device.getNumberOfMeasurements(activeChannelConfigNumber);
                                    int dataBlockSize = device.getDataBlockSize(InputTypes.FILE_IO);
                                    if (log.isLoggable(Level.FINE)) {
                                        log.log(Level.FINE, "measurementSize = " + measurementSize + "; dataBlockSize = " + dataBlockSize);
                                    }
                                    if (dataBlockSize < 0 && measurementSize > Math.abs(dataBlockSize)) {
                                        throw new DevicePropertiesInconsistenceException(Messages.getString("GDE_MSGE0041", new String[]{filePath}));
                                    }
                                    isDataConsistentChecked = true;
                                }
                                boolean isJunsiChargerSpecialState = device.getName().startsWith("iCharger") && data.getState() >= 128;
                                String string = recordSetNameExtend = isJunsiChargerSpecialState ? recordSetNameExtend : device.getRecordSetStateNameReplacement(data.getState());
                                if (recordNameExtend.length() > 0 && !isJunsiChargerSpecialState) {
                                    recordSetNameExtend = recordSetNameExtend + " " + "[" + recordNameExtend + "]";
                                }
                                channelRecordSet = (RecordSet)activeChannel.get(device.recordSetNumberFollowChannel() && activeChannel.getType() == ChannelTypes.TYPE_CONFIG ? activeChannel.getLastActiveRecordSetName() : recordSetName);
                                recordSetNameExtend = recordSetNameExtend.length() <= 36 ? recordSetNameExtend : recordSetNameExtend.substring(0, 35) + "]";
                            }
                            catch (Exception e) {
                                throw new DevicePropertiesInconsistenceException(Messages.getString("GDE_MSGE0044", new Object[]{data.getState(), filePath, device.getPropertiesFileName()}));
                            }
                            if (activeChannel.size() != 0 && channelRecordSet != null && recordSetName.endsWith(" " + recordSetNameExtend) && lastRecordSetNumberOffset == data.getRecordSetNumberOffset()) break block68;
                            if (lastRecordSetNumberOffset == data.getRecordSetNumberOffset() || channelRecordSet == null) break block69;
                            if (channelRecordSet.get(0).size() < 3) {
                                channelRecordSet = (RecordSet)activeChannel.get(recordSetName);
                                activeChannel.remove(recordSetName);
                                createdRecordSets.remove(channelRecordSet);
                                log.log(Level.WARNING, filePath + " - remove record set with < 3 data points, last line number = " + (lineNumber - 1));
                                activeChannel.put(recordSetName, RecordSet.createRecordSet(recordSetName, application.getActiveDevice(), activeChannelConfigNumber, true, false, true));
                                createdRecordSets.add((RecordSet)activeChannel.get(recordSetName));
                                recordSetName = channelRecordSet.getName();
                                if (activeChannel.getType() == ChannelTypes.TYPE_CONFIG) {
                                    activeChannel.applyTemplate(recordSetName, false);
                                    break block67;
                                } else {
                                    activeChannel.applyTemplateBasics(recordSetName);
                                }
                                break block67;
                            } else {
                                channelRecordSet.checkAllDisplayable();
                                if (activeChannel.getType() == ChannelTypes.TYPE_CONFIG) {
                                    activeChannel.applyTemplate(recordSetName, false);
                                } else {
                                    activeChannel.applyTemplateBasics(recordSetName);
                                }
                                device.updateVisibilityStatus((RecordSet)activeChannel.get(recordSetName), true);
                            }
                            break block67;
                        }
                        int recordNumber = device.recordSetNumberFollowChannel() && activeChannel.getType() == ChannelTypes.TYPE_CONFIG ? activeChannel.getNextRecordSetNumber(activeChannelConfigNumber) : activeChannel.getNextRecordSetNumber();
                        recordSetName = recordNumber + ") " + recordSetNameExtend;
                        recordSetName = recordSetName.length() <= 40 ? recordSetName : recordSetName.substring(0, 39) + "]";
                        activeChannel.put(recordSetName, RecordSet.createRecordSet(recordSetName, application.getActiveDevice(), activeChannelConfigNumber, true, false, true));
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, recordSetName + " created for channel " + activeChannel.getName());
                        }
                        if (activeChannel.getType() == ChannelTypes.TYPE_CONFIG) {
                            activeChannel.applyTemplate(recordSetName, false);
                        } else {
                            activeChannel.applyTemplateBasics(recordSetName);
                        }
                        activeChannel.setActiveRecordSet(recordSetName);
                        channelRecordSet = (RecordSet)activeChannel.get(recordSetName);
                        createdRecordSets.add(channelRecordSet);
                        recordSetName = channelRecordSet.getName();
                        if (firmwareHardwareDescription.length() > 10 && !activeChannel.getFileDescription().contains(firmwareHardwareDescription)) {
                            activeChannel.setFileDescription(activeChannel.getFileDescription() + " - " + firmwareHardwareDescription);
                        }
                        device.updateVisibilityStatus((RecordSet)activeChannel.get(recordSetName), true);
                        lastRecordEndTimeStamp_ms = data.getTime_ms();
                    }
                    try {
                        isOutdated = Integer.parseInt(dateTime.split("-")[0]) <= 2000;
                    }
                    catch (Exception recordNumber) {
                        // empty catch block
                    }
                    for (String recordKey : device.getMeasurementNamesReplacements(activeChannelConfigNumber)) {
                        channelRecordSet.get(recordKey).setDisplayable(true);
                    }
                    lastRecordSetNumberOffset = data.getRecordSetNumberOffset();
                }
                if (data.getTime_ms() - lastTimeStamp >= 0L) {
                    channelRecordSet.addNoneCalculationRecordsPoints(data.getValues(), data.getTime_ms() - lastRecordEndTimeStamp_ms);
                    data.setTimeResetEnabled(true);
                    lastTimeStamp = data.getTime_ms();
                }
                if ((progress = (int)((long)(lineNumber * 100) / (inputFileSize / (long)(progressLineLength = progressLineLength > line.length() ? progressLineLength : line.length())))) > 90 || progress <= GDE.getUiNotification().getProgressPercentage() || progress % 10 != 0) continue;
                GDE.getUiNotification().setProgress(progress);
                try {
                    Thread.sleep(2L);
                }
                catch (Exception dataBlockSize) {}
            }
            GDE.getUiNotification().setProgress(100);
            Iterator iterator = createdRecordSets.iterator();
            while (iterator.hasNext()) {
                RecordSet tmpRecordSet = (RecordSet)iterator.next();
                if (tmpRecordSet.get(0).realSize() < 3) {
                    ((Channel)channels.get(tmpRecordSet.getChannelConfigNumber())).remove(recordSetName);
                    log.log(Level.WARNING, filePath + " - remove record set " + tmpRecordSet.getName() + " with < 3 data points, last line number = " + (lineNumber - 1));
                    iterator.remove();
                } else {
                    if (!isOutdated) {
                        long startTimeStamp = (long)((double)new File(filePath).lastModified() - tmpRecordSet.getMaxTime_ms());
                        tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString("GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp));
                        tmpRecordSet.setStartTimeStamp(startTimeStamp);
                        String initialFileDescription = dateTime.substring(0, 10) + activeChannel.getFileDescription().substring(10);
                        activeChannel.setFileDescription(initialFileDescription);
                        if (activeChannel.getActiveRecordSet() != null && activeChannel.getActiveRecordSet().getDevice().useChannelWithSyncedDescription()) {
                            activeChannel.syncFileDescription(activeChannel, initialFileDescription);
                        }
                    } else {
                        tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString("GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(new Date()));
                    }
                    tmpRecordSet.checkAllDisplayable();
                    device.updateVisibilityStatus(tmpRecordSet, true);
                }
                tmpRecordSet.descriptionAppendFilename(filePath.substring(filePath.lastIndexOf(47) + 1));
                if (firmwareHardwareDescription.length() <= 10 || tmpRecordSet.getDescription().contains(firmwareHardwareDescription)) continue;
                tmpRecordSet.setRecordSetDescription(tmpRecordSet.getDescription() + "\n" + firmwareHardwareDescription);
            }
            if (GDE.isWithUi()) {
                if (createdRecordSets.size() == 1) {
                    channels.switchChannel(activeChannelConfigNumber, ((RecordSet)createdRecordSets.firstElement()).getName());
                } else if (createdRecordSets.size() > 1 && !device.recordSetNumberFollowChannel()) {
                    channels.switchChannel(activeChannelConfigNumber, ((RecordSet)createdRecordSets.lastElement()).getName());
                } else {
                    channels.switchChannel(activeChannelConfigNumber, "");
                }
            }
            reader.close();
            reader = null;
            return channelRecordSet;
        }
        catch (FileNotFoundException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            application.openMessageDialog(e.getMessage());
            return channelRecordSet;
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            application.openMessageDialog(e.getMessage());
            return channelRecordSet;
        }
        catch (Exception e) {
            if (activeChannel != null && activeChannel.size() > 0) {
                String recordSetName = activeChannel.getFirstRecordSetName();
                activeChannel.setActiveRecordSet(recordSetName);
                device.updateVisibilityStatus((RecordSet)activeChannel.get(recordSetName), true);
                ((RecordSet)activeChannel.get(recordSetName)).checkAllDisplayable();
                if (GDE.isWithUi()) {
                    if (createdRecordSets.size() == 0) {
                        channels.switchChannel(1, "");
                    } else if (createdRecordSets.size() == 1) {
                        channels.switchChannel(activeChannelConfigNumber, ((RecordSet)createdRecordSets.firstElement()).getName());
                    } else {
                        channels.switchChannel(activeChannelConfigNumber, ((RecordSet)createdRecordSets.lastElement()).getName());
                    }
                }
            }
            String msg = filePath + " - " + Messages.getString("GDE_MSGE0045", new Object[]{e.getMessage(), lineNumber});
            log.log(Level.WARNING, msg, e);
            application.openMessageDialog(msg);
            return channelRecordSet;
        }
        finally {
            GDE.getUiNotification().setStatusMessage("");
            GDE.getUiNotification().setProgress(100);
        }
    }

    static {
        application = DataExplorer.getInstance();
        channels = Channels.getInstance();
    }
}

