/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.log;

import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysoLogger
implements Logger {
    private String name;
    private final int shorten;

    public SysoLogger() {
        this(1);
    }

    public SysoLogger(int packageReduce) {
        this.shorten = packageReduce;
    }

    protected SysoLogger(String klass, int shorten) {
        this.shorten = shorten;
        this.name = klass;
    }

    @Override
    public Logger getLogger(Class<?> klass) {
        return new SysoLogger(klass.getName(), this.shorten);
    }

    @Override
    public Logger getLogger(String name) {
        return new SysoLogger("[itext]", 0);
    }

    @Override
    public boolean isLogging(Level level) {
        return true;
    }

    @Override
    public void warn(String message2) {
        System.out.println(String.format("%s WARN  %s", this.shorten(this.name), message2));
    }

    private String shorten(String className) {
        if (this.shorten != 0) {
            StringBuilder target = new StringBuilder();
            String name = className;
            int fromIndex = className.indexOf(46);
            while (fromIndex != -1) {
                int parseTo = fromIndex < this.shorten ? fromIndex : this.shorten;
                target.append(name.substring(0, parseTo));
                target.append('.');
                name = name.substring(fromIndex + 1);
                fromIndex = name.indexOf(46);
            }
            target.append(className.substring(className.lastIndexOf(46) + 1));
            return target.toString();
        }
        return className;
    }

    @Override
    public void trace(String message2) {
        System.out.println(String.format("%s TRACE %s", this.shorten(this.name), message2));
    }

    @Override
    public void debug(String message2) {
        System.out.println(String.format("%s DEBUG %s", this.shorten(this.name), message2));
    }

    @Override
    public void info(String message2) {
        System.out.println(String.format("%s INFO  %s", this.shorten(this.name), message2));
    }

    @Override
    public void error(String message2) {
        System.out.println(String.format("%s ERROR %s", this.name, message2));
    }

    @Override
    public void error(String message2, Exception e) {
        System.out.println(String.format("%s ERROR %s", this.name, message2));
        e.printStackTrace(System.out);
    }
}

