/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.utils;

import gde.histo.utils.Spot;
import gde.log.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public final class SingleResponseRegression<T extends Number> {
    private static final String $CLASS_NAME = SingleResponseRegression.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private int n;
    private final List<Double> xx = new ArrayList<Double>();
    private final List<Double> yy = new ArrayList<Double>();
    private final List<Double> zz = new ArrayList<Double>();
    private double xbar = 0.0;
    private double ybar = 0.0;
    private double zbar = 0.0;
    private double xxbar = 0.0;
    private double yybar = 0.0;
    private double xybar = 0.0;
    private double zzbar = 0.0;
    private double zxbar = 0.0;
    private double zybar = 0.0;
    private double rss = 0.0;
    private double ssr = 0.0;

    public SingleResponseRegression(List<Spot<T>> points, RegressionType type) {
        if (points == null || points.isEmpty()) {
            throw new IllegalArgumentException("empty points");
        }
        double sumx = 0.0;
        double sumy = 0.0;
        double sumz = 0.0;
        for (Spot<T> point : points) {
            double xValue = ((Number)point.x()).doubleValue();
            double yValue = ((Number)point.y()).doubleValue();
            this.xx.add(xValue);
            this.yy.add(yValue);
            sumx += xValue;
            sumy += yValue;
            if (type != RegressionType.QUADRATIC) continue;
            this.zz.add(xValue * xValue);
            sumz += xValue * xValue;
        }
        this.n = this.xx.size();
        if (this.n >= 1) {
            this.xbar = sumx / (double)this.n;
            this.ybar = sumy / (double)this.n;
            this.zbar = sumz / (double)this.n;
        }
        this.setCovariances();
    }

    private void setCovariances() {
        if (this.n >= 1) {
            int i;
            for (i = 0; i < this.n; ++i) {
                this.xxbar += (this.xx.get(i) - this.xbar) * (this.xx.get(i) - this.xbar);
                this.yybar += (this.yy.get(i) - this.ybar) * (this.yy.get(i) - this.ybar);
                this.xybar += (this.xx.get(i) - this.xbar) * (this.yy.get(i) - this.ybar);
            }
            if (this.isQuadratic()) {
                for (i = 0; i < this.n; ++i) {
                    this.zzbar += (this.zz.get(i) - this.zbar) * (this.zz.get(i) - this.zbar);
                    this.zxbar += (this.zz.get(i) - this.zbar) * (this.xx.get(i) - this.xbar);
                    this.zybar += (this.zz.get(i) - this.zbar) * (this.yy.get(i) - this.ybar);
                }
            }
        }
    }

    private boolean isQuadratic() {
        return !this.zz.isEmpty();
    }

    private void setErrorSums() {
        if (this.n >= 2) {
            for (int i = 0; i < this.n; ++i) {
                double fit = this.getResponse(this.xx.get(i));
                this.rss += (fit - this.yy.get(i)) * (fit - this.yy.get(i));
                this.ssr += (fit - this.ybar) * (fit - this.ybar);
            }
        }
    }

    public double getIntercept() {
        return this.ybar - this.getSlope() * this.xbar;
    }

    public double getSlope() {
        if (this.n < 2) {
            return 0.0;
        }
        return this.xybar / this.xxbar;
    }

    public double getR2() {
        if (this.ssr == 0.0) {
            this.setErrorSums();
        }
        if (this.n < 2) {
            return 0.0;
        }
        return 1.0 - this.rss / this.yybar;
    }

    public double getInterceptStdErr() {
        if (this.ssr == 0.0) {
            this.setErrorSums();
        }
        if (this.n <= 2) {
            return 0.0;
        }
        double svar = this.rss / (double)(this.n - 2);
        double svar1 = svar / this.xxbar;
        return Math.sqrt(svar / (double)this.n + this.xbar * this.xbar * svar1);
    }

    public double getSlopeStdErr() {
        if (this.ssr == 0.0) {
            this.setErrorSums();
        }
        if (this.n <= 2) {
            return 0.0;
        }
        double svar = this.rss / (double)(this.n - 2);
        return Math.sqrt(svar / this.xxbar);
    }

    public double getGamma() {
        if (!this.isQuadratic()) {
            throw new UnsupportedOperationException();
        }
        if (this.n <= 2) {
            return 0.0;
        }
        double numerator = this.zybar * this.xxbar - this.xybar * this.zxbar;
        if (numerator == 0.0) {
            return 0.0;
        }
        double denominator = this.zzbar * this.xxbar - this.zxbar * this.zxbar;
        if (denominator == 0.0) {
            log.warning(() -> "numerator=" + numerator + "  denominator=" + denominator);
            return 0.0;
        }
        return numerator / denominator;
    }

    public double getBeta() {
        if (!this.isQuadratic()) {
            throw new UnsupportedOperationException();
        }
        if (this.n <= 1) {
            return 0.0;
        }
        double numerator = this.xybar - this.getGamma() * this.zxbar;
        double denominator = this.xxbar;
        if (denominator == 0.0) {
            log.warning(() -> "numerator=" + numerator + "  denominator=" + denominator);
            return 0.0;
        }
        return numerator / denominator;
    }

    public double getAlpha() {
        if (!this.isQuadratic()) {
            throw new UnsupportedOperationException();
        }
        return this.ybar - this.getGamma() * this.zbar - this.getBeta() * this.xbar;
    }

    public List<Spot<Double>> getResponse() {
        ArrayList<Spot<Double>> responses = new ArrayList<Spot<Double>>();
        for (int i = 0; i < this.xx.size(); ++i) {
            responses.add(new Spot<Double>(this.xx.get(i), this.getResponse(this.xx.get(i))));
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINEST, "xResponse=" + ((Spot)responses.get(i)).x() + "  yResponse=" + ((Spot)responses.get(i)).y());
        }
        return responses;
    }

    public double getResponse(double xValue) {
        if (this.isQuadratic() && this.getGamma() != 0.0) {
            return this.getAlpha() + this.getBeta() * xValue + this.getGamma() * xValue * xValue;
        }
        return this.getSlope() * xValue + this.getIntercept();
    }

    public double getFirstRegressor() {
        return this.xx.get(0);
    }

    public double getRegressorDelta() {
        return this.xx.get(this.xx.size() - 1) - this.xx.get(0);
    }

    public double getDelta() {
        return this.yy.get(this.yy.size() - 1) - this.yy.get(0);
    }

    public double getParabolaExtremum() {
        if (!this.isQuadratic()) {
            throw new UnsupportedOperationException();
        }
        return this.getBeta() / this.getGamma() / -2.0;
    }

    public double getAvg() {
        return this.ybar;
    }

    public double getSigma() {
        if (this.n < 2) {
            return 0.0;
        }
        return Math.sqrt(this.yybar / (double)(this.n - 1));
    }

    public int getRealSize() {
        return this.n;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.isQuadratic()) {
            s.append(String.format("%.4f + %.4f n + %.4f n2", this.getAlpha(), this.getBeta(), this.getGamma()));
        } else {
            s.append(String.format("%.4f n + %.4f", this.getSlope(), this.getIntercept()));
            s.append("  (R^2 = " + String.format("%.3f", this.getR2()) + ")");
        }
        return s.toString();
    }

    public static enum RegressionType {
        LINEAR,
        QUADRATIC;

    }
}

