<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// darf derjenige posten?
$boardrechte = getboardrechte($aktboard["id"]);
if($_GET["type"]=="thread")
{
  if($boardrechte["threads"] == false and $boardrechte["moderieren"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");
  $benachrichtigung["abo_typ"] = 0;
}
else
{
  if(($boardrechte["posts"] == false or $aktthread["status"]=="0") and $boardrechte["moderieren"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");
  $benachrichtigungresult = sql_select("abo_typ", "thread_abos", "WHERE user_id=".$user["id"]." AND thread_id=".$aktthread["id"]);
  if(sql_num_rows($benachrichtigungresult) != 0)
  {
    $benachrichtigung = sql_fetch_assoc($benachrichtigungresult);
  }
  else
  {
    $benachrichtigung["abo_typ"] = 0;
  }
}


if(!isset($_POST["erstellen_knopf"]))
{
  // formular anzeigen
  echo "<center>\n";

  if($_GET["type"]=="thread")
  {
    echo "<h3>Neuer Thread</h3>\n";
  }
  else
  {
    echo "<h3>Antworten</h3>\n";
  }
  ?>
  <form name="form1" method="POST" action="index.php?action=newpost&amp;type=<?php echo $_GET["type"]; if($_GET["type"]=="thread") echo "&amp;boardid=".$aktboard["id"]; else echo "&amp;threadid=".$aktthread["id"]; ?>">
  <table class="maintable">
  <tr class="rowberschrift">
    <td colspan="2">Nachricht</td>
  </tr>
  <tr class="row2">
    <td>Benutzername:</td><td><?php
    if($user["id"] == 1)
    {
      ?><input class="inputtext" name="autor_name" type="text" size="40" /><?php
    }
    else
    {
      $autor = sql_fetch_assoc(sql_select("*", "users", "WHERE id=".$user["id"]));
      echo sanitize_html_string($autor["username"]);
    }
    ?></td>
  </tr>
  <tr class="row2">
    <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" /></td>
  </tr>
  <tr class="row2">
    <td>BB-Code:</td><td>
    <?php $textname = "nachricht"; $formname = "form1"; include("./bbcode_inputs.php") ?>
    </td>
  </tr>
  <tr class="row2">
    <td>Nachricht:</td><td><textarea class="inputtext" name="nachricht" cols="39" rows="15"></textarea></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Optionen</td>
  </tr>
  <tr class="row2">
    <td>BB-Code aktivieren</td><td><input name="bbcode" type="radio" value="1"<?php if($user["auto_bbcode"] == 1) echo " checked" ?> />Ja <input name="bbcode" type="radio" value="0"<?php if($user["auto_bbcode"] == 0) echo " checked" ?> />Nein</td>
  </tr>
  <tr class="row2">
    <td>Smilies aktivieren</td><td><input name="smilies" type="radio" value="1"<?php if($user["auto_smilies"] == 1) echo " checked" ?> />Ja <input name="smilies" type="radio" value="0"<?php if($user["auto_smilies"] == 0) echo " checked" ?> />Nein</td>
  </tr>
  <tr class="row2">
    <td>Signatur anhngen</td><td><input name="signatur" type="radio" value="1"<?php if($user["auto_sig"] == 1) echo " checked" ?> />Ja <input name="signatur" type="radio" value="0"<?php if($user["auto_sig"] == 0) echo " checked" ?> />Nein</td>
  </tr>
  <?php
  if($user["id"] != 1)
  {
    ?>
    <tr class="row2">
      <td>Benachrichtigung</td>
      <td><select class="inputtext" name="benachrichtigung" size="1">
      <option value="0"<?php if($benachrichtigung["abo_typ"] == 0 and $user["auto_abo"] == 0) echo " selected" ?>>keine</option>
      <option value="1"<?php if($benachrichtigung["abo_typ"] == 1 or $user["auto_abo"] == 1) echo " selected" ?>>einmalig</option>
      <option value="2"<?php if($benachrichtigung["abo_typ"] == 2 or $user["auto_abo"] == 2) echo " selected" ?>>immer</option>
      </select></td>
    </tr>
    <?php
  }

  if($_GET["type"]=="thread")
  {
    ?>
    <tr class="rowberschrift">
      <td colspan="2">Umfrage</td>
    </tr>
    <tr class="row2">
      <td>&nbsp</td><td><input name="umfrage" type="checkbox" value="1" />Umfrage mit <input class="inputtext" align="right" name="antworten" type="text" size="2" value="2" /> Auswahlmglichkeiten</td>
    </tr>
    <?php
  }
  if($boardrechte["moderieren"] == true)
  {
    ?>
    <tr class="rowberschrift">
      <td colspan="2">Moderation</td>
    </tr>
    <tr class="row2">
      <td>&nbsp</td><td><input name="abschlieen" type="checkbox" value="1" />Thread nach diesem Post schlieen</td>
    </tr>
    <?php
    $sticky = false;
    if($_GET["type"] == "post" and $aktthread["sticky"] == 1) $sticky = true;
    ?>
    <tr class="row2">
      <td>Sticky Thread:</td><td><input name="sticky" type="radio" value="1" <?php if($sticky == true) echo "checked " ?>/> Ja <input name="sticky" type="radio" value="0" <?php if($sticky == false) echo "checked " ?>/> Nein</td>
    </tr>
    <?php
  }
  ?>
  <tr class="row2">
    <td>&nbsp</td><td><input name="erstellen_knopf" type="submit" value="erstellen" /></td>
  </tr>
  </table>
  </form>
  <?php
}
else
{
  // abspeichern
  // ist benutzer eingeloggt -> id gleich bernehmen
  if($user["id"] != 1)
  {
    $autor = sql_fetch_assoc(sql_select("*", "users", "WHERE id=".$user["id"]));
  }
  else
  {
    //poster ist gast, berprfen, ob der name schon vergeben ist
    $nameresult = sql_select("*", "users", "WHERE username='".sanitize_sql_string($_POST["autor_name"])."'");
    if(sql_num_rows($nameresult)!=0) fehler("Der Benutzername ist schon an einen registrierten Benutzer vergeben!");
    $autor["id"] = 1;
    $autor["username"] = $_POST["autor_name"];
    if(trim($autor["username"]) == "") fehler("Sie haben keinen Namen angegeben!");
  }
  if($_GET["type"]=="thread")
  {
    if(trim($_POST["titel"])=="") fehler("Jeder Thread muss einen Titel haben!");
    $werte = array(
        "titel"      => sanitize_sql_string($_POST["titel"]),
        "status"     => 1,
        "board"      => $aktboard["id"],
        "autor_id"   => $autor["id"],
        "autor_name" => sanitize_sql_string($autor["username"]),
        "created"    => time(),
        "hits"       => 0
        );
    sql_insert("threads", $werte);
    $lastthread = sql_fetch_assoc(sql_select("*", "threads", "ORDER BY id DESC"));
    $postthread = $lastthread["id"];
  }
  else
  {
    $postthread = $aktthread["id"];
  }

  // thread-abos aktualisieren
  if($benachrichtigung["abo_typ"] == 0 and $_POST["benachrichtigung"] != 0 and $user["id"] != 1)
  {
    $werte = array("thread_id" => $postthread, "user_id" => $user["id"], "abo_typ" => sanitize_int($_POST["benachrichtigung"]));
    sql_insert("thread_abos", $werte);
  }
  if($benachrichtigung["abo_typ"] != 0 and $_POST["benachrichtigung"] != $benachrichtigung["abo_typ"])
  {
    $werte = array("abo_typ" => sanitize_int($_POST["benachrichtigung"]));
    sql_update("thread_abos", $werte, "WHERE thread_id=".$postthread." AND user_id=".$user["id"]);
  }
  if($benachrichtigung["abo_typ"] != 0 and $_POST["benachrichtigung"] == 0)
  {
    sql_delete("thread_abos", "WHERE thread_id=".$postthread." AND user_id=".$user["id"]);
  }

  $werte = array(
      "titel"      => sanitize_sql_string($_POST["titel"]),
      "thread"     => $postthread,
      "autor_id"   => $autor["id"],
      "autor_name" => sanitize_sql_string($autor["username"]),
      "created"    => time(),
      "nachricht"  => sanitize_sql_string($_POST["nachricht"]),
      "bbcode"     => sanitize_int($_POST["bbcode"]),
      "smilies"    => sanitize_int($_POST["smilies"]),
      "signatur"   => sanitize_int($_POST["signatur"])
      );
  sql_insert("posts", $werte);

  $post = sql_fetch_assoc(sql_select("*", "posts", "ORDER BY id DESC"));

  // hat jemand den thread abonniert?
  $abos = sql_select("user_id, abo_typ", "thread_abos", "WHERE thread_id=".$postthread);
  while($abo = sql_fetch_assoc($abos))
  {
    if($abo["user_id"] != $user["id"])  // wir wissen selbst dass wir geantwortet haben
    {
      $abonnent = sql_fetch_assoc(sql_select("username, email", "users", "WHERE id=".$abo["user_id"]));
      mail($abonnent["email"], $einstellungen["titel"].": Antwort in abonniertem Thread!", sanitize_html_string($user["username"])." hat einen neuen Post in '".sanitize_html_string($aktboard["titel"])." -> ".sanitize_html_string($aktthread["titel"])."' erstellt!\nDen Thread finden Sie hier: ".$einstellungen["adresse"]."index.php?action=viewthread&id=".$aktthread["id"], "From: ".$einstellungen["infomail"]."\nReply-To: ".$einstellungen["infomail"]."\nX-Mailer: PHP/" . phpversion());
      // einmalige benachrichtigung?
      if($abo["abo_typ"] == 1)
      {
        sql_delete("thread_abos", "WHERE thread_id=".$aktthread["id"]." AND user_id=".$abo["user_id"]);
      }
    }
  }

  if(isset($_POST["abschlieen"]) and $boardrechte["moderieren"] == false)
  {
    // thread schlieen
    $werte = array("status" => 0);
    sql_update("threads", $werte, "WHERE id=".$postthread);
  }
  if($boardrechte["moderieren"] == true)
  {
    $werte = array("sticky" => sanitize_int($_POST["sticky"]));
    sql_update("threads", $werte, "WHERE id=".$postthread);
  }
  if(!isset($_POST["umfrage"]))
  {
    $strlink = "index.php?action=viewthread&id=".$postthread;
    if($_GET["type"] == "post")   $strlink .= "#".$post["id"];
    if($_GET["type"] == "thread") $strtext  = "Der Thread";
    if($_GET["type"] == "post")   $strtext  = "Der Post";
    $strtext .= " wurde erstellt!";
    redir($strlink, $strtext);
  }
  else
  {
    redir("index.php?action=umfrage&show=create&threadid=".$postthread."&antworten=".$_POST["antworten"], "Der Thread wurde erstellt! Jetzt kann die Umfrage erstellt werden!");
  }
}
?>
