<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

include("./layouts/".$layout."/themes/".$theme."/links.php");
header("Content-type: text/html; charset=iso-8859-15\r\n");
?>
<!-- standard layout -->
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
    <meta name="AUTHOR" content="Heiko R. und Jan K. nicht" />
    <link rel="STYLESHEET" href="./layouts/<?php echo $layout ?>/themes/<?php echo $theme ?>/style.css" type="text/css" />
    <link rel="alternate" type="application/rss+xml" title="RSS" href="./rss.php" />
    <title>DasForum</title>
</head>
<body>

<span class="debuginfo">
SESSION:
<?php print_r($_SESSION); ?></span><br />
<span class="debuginfo">
POST:
<?php print_r($_POST); ?></span><br />
<span class="debuginfo">
GET:
<?php print_r($_GET); ?></span><br />

<?php
if($einstellungen["offline"] == 1 and $rechte["admin"] != 1)
{
    if(!isset($_GET["action"]) or $_GET["action"]!="login")
    {
        include ("./offline.php");
        session_destroy();
        die();
    }
}
?>

<table class="indextable" align="center">
<tr>
    <td align="center"><h2><?php echo $einstellungen["titel"] ?></h2></td>
</tr>
<tr style="height:50px">
    <td align="center"><?php include ("./nav_menue.php"); ?></td>
</tr>
<tr class="nav_bar">
    <td><?php include ("./nav_bar.php") ?></td>
</tr>

<tr>
    <td align="center"><?php include ("./nav_actions.php") ?></td>
</tr>

<tr>
    <td class="timerow"><?php echo date("d.m.Y, H:i", time() + $zeitoffset) ?></td>
</tr>
<tr>
    <td align="center">
    <br />
    <?php if((!isset($_GET["action"]) or $_GET["action"] != "statistik") and $einstellungen["showstatistics"]) include("./statistik.php") ?>
    <br />
    <?php if((!isset($_GET["action"]) or $_GET["action"] != "onlinelist") and $einstellungen["showonlinelist"]) include("./onlinelist.php") ?>
    </td>
</tr>
<tr>
    <td class="footer">layout: <?php echo $layout ?> --- theme: <?php echo $theme ?><br />powered by <a href="http://www.nongnu.org/dasforum">DasForum</a> <?php include("./version.php") ?> --- Copyright &copy; 2004 - 2007 Heiko Rothkranz<br />erzeugt in <?php echo round(microtime(true) - $startzeit,4) ?> s mit <?php echo $sqlqueries ?> SQL-Queries</td>
</tr>
</table>
</body>
</html>
<?php
@mysql_close();
?>