<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if(!isset($_POST["submit_daten"]))
{
  ?>
  <html>
  <head>
  <meta name="author" content="Jan K. und Heiko R." />
  <link rel=STYLESHEET href="./layouts/standard/themes/standard/style.css" type="text/css" />
  <title>DasForum - Installation</title>
  <script language="JavaScript">
      <!--
      function sql_select(index)
      {
        if(index == 0)
        {
          document.form1.sql_port.value = "3306";
          document.form1.sql_host.value = "localhost";
          document.form1.sql_username.value = "";
          document.form1.sql_passwort.value = "";
        }
        if(index == 1)
        {
          document.form1.sql_port.value = "5432";
          document.form1.sql_host.value = "localhost";
          document.form1.sql_username.value = "";
          document.form1.sql_passwort.value = "";
        }
        if(index == 2)
        {
          document.form1.sql_port.value = "-";
          document.form1.sql_host.value = "-";
          document.form1.sql_username.value = "-";
          document.form1.sql_passwort.value = "-";
        }
      }
      -->
  </script>
  </head>
  <body>
  <div align="center">
  <h3>'Das Forum' - Installation</h3><br /><br />
  Um das Forum nutzen zu knnen, mssen hier verschiedene Zugangsdaten eingegeben werden.<br />
  Diese Daten knnen nach der Installation nur noch manuell in der 'config.php' gendert werden.<br />
  Wenn Sie unsicher sind, lassen Sie die voreingestellten Werte fr den SQL-Server wie sie sind.<br />
  Geben Sie aber auf jeden Fall den Datenbanknamen an!<br /><br />
  <form action="./install.php" method="post" name="form1">
  <table class="maintable">
  <tr class="rowberschrift">
    <td colspan="2">SQL-Server-Einstellungen:</td>
  </tr>
  <tr>
    <td>SQL-Typ:</td>
    <td><select class="inputtext" name="sql_typ" size="1" onChange="sql_select(this.selectedIndex)">
        <option value="mysql">MySQL</option>
        <option value="postgresql">PostgreSQL</option>
        <option value="sqlite">SQLite</option>
    </select></td>
  </tr>
  <tr>
    <td>SQL-Host:</td>
    <td><input class="inputtext" type="text" name="sql_host" value="localhost" /></td>
  </tr>
  <tr>
    <td>SQL-Port:</td>
    <td><input class="inputtext" type="text" name="sql_port" value="3306" /></td>
  </tr>
  <tr>
    <td>SQL-Datenbank:</td>
    <td><input class="inputtext" type="text" name="sql_datenbank" /></td>
  </tr>
  <tr>
    <td>SQL-Username:</td>
    <td><input class="inputtext" type="text" name="sql_username" /></td>
  </tr>
  <tr>
    <td>SQL-Passwort:</td>
    <td><input class="inputtext" type="password" name="sql_passwort" /></td>
  </tr>
  <tr>
    <td>SQL-Tabellen-Prefix:</td>
    <td><input class="inputtext" type="text" name="sql_prefix" value="forum" /></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Bitte geben Sie Zugangsdaten, aus denen der Admin-Account erstellt werden soll:</td>
  </tr>
  <tr>
    <td>Admin-Username:</td>
    <td><input class="inputtext" type="text" name="admin_username" /></td>
  </tr>
  <tr>
    <td>Admin-Passwort:</td>
    <td><input class="inputtext" type="password" name="admin_passwort1" /></td>
  </tr>
  <tr>
    <td>Admin-Passwort (wiederholen):</td>
    <td><input class="inputtext" type="password" name="admin_passwort2" /></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Weitere Einstellungen:</td>
  </tr>
  <tr>
    <td>URL des Forum-Ordners:</td><td><input class="inputtext" type="text" name="adresse" /></td>
  </tr>
  <tr>
    <td colspan="2" align="center"><input type="submit" name="submit_daten" value="Besttigen" /></td>
  </tr>
  </table>
  </form>
  </div>
  </body>
  </html>
  <?php
}
else
{
  // installation

  function fehler($errstr)
  {
    ?>
    <table width="500">
    <tr>
      <td class="fehlerberschrift" align="center"><h3>Fehler!</h3></td>
    </tr>
    <tr>
      <td class="fehlertext" align="center">
      Die Installation ist fehlgeschlagen!<br />
      Stellen Sie sicher, dass die Angaben stimmen und die Datenbank bereits existiert!<br />
      Vor einem nchsten Versuch lschen Sie die Datei 'config.php' und evtl. bereits vorhandene Tabellen die<br />
      mit Ihrem SQL-Tabellen-Prefix beginnen.<br />
      Fehlermeldung:<br />
      <?php echo $errstr ?></td>
    </tr>
    </table>
    </center>
    <?php
    die();
  }

  ?>
  <html>
  <head>
  <meta name="author" content="Jan K. und Heiko R." />
  <link rel=STYLESHEET href="./layouts/standard/themes/standard/style.css" type="text/css" />
  <title>DasForum - Installation</title>
  </head>
  <body>
  <div align="center">
  <h3>'Das Forum' - Installation</h3><br /><br />
  <table class="maintable">
  <?php
  // $conf-variable herstellen
  $conf["sql_typ"]       = $_POST["sql_typ"];
  $conf["sql_host"]      = $_POST["sql_host"];
  $conf["sql_port"]      = $_POST["sql_port"];
  $conf["sql_datenbank"] = $_POST["sql_datenbank"];
  $conf["sql_username"]  = $_POST["sql_username"];
  $conf["sql_passwort"]  = $_POST["sql_passwort"];
  $conf["sql_prefix"]    = $_POST["sql_prefix"];

  // includes
  include("./sql.php");

  // gucken, ob die sicherheits-passwort-doppelt-eingeb-abfrage geklappt hat
  if ($_POST["admin_passwort1"] != $_POST["admin_passwort2"]) fehler("Die eingegebenen Admin-Passwrter sind nicht bereinstimmend. Bitte versuchen Sie es nocheinmal!");

  // Aufbauen der ersten MySQL-Verbindung
  $link = sql_connect();
  ?>
  <tr><td>SQL-Verbindung herstellen:</td><td>OK</td></tr>
  <?php

  /*########################################
  ########### Tabellen erstellen ###########
  ########################################*/

  $spalten = array(
      "id"               => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => true,  "default" => NULL),
      "typ"              => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "titel"            => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "nachricht"        => array("typ" => "text",     "size" => NULL, "unsigned" => false, "NULL" => true,  "auto" => false, "default" => NULL),
      "kategorien"       => array("typ" => "text",     "size" => NULL, "unsigned" => false, "NULL" => true,  "auto" => false, "default" => NULL),
      "boards"           => array("typ" => "text",     "size" => NULL, "unsigned" => false, "NULL" => true,  "auto" => false, "default" => NULL),
      "bbcode"           => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "smilies"          => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "KEY1"             => array("typ" => "PRIMARY",  "spalte" => "id")
      );
  sql_createtable("announcements", $spalten);

  $spalten = array(
      "id"               => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => true,  "default" => NULL),
      "umfrage"          => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "antwort"          => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "stimmen"          => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "users"            => array("typ" => "text",     "size" => NULL, "unsigned" => false, "NULL" => true,  "auto" => false, "default" => NULL),
      "KEY1"             => array("typ" => "PRIMARY",  "spalte" => "id")
      );
  sql_createtable("antworten", $spalten);

  $spalten = array(
      "gruppe_id"        => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "board_id"         => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "lesen"            => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "posts"            => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "threads"          => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "moderieren"       => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      );
  sql_createtable("boardrechte", $spalten);

  $spalten = array(
      "id"               => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => true,  "default" => NULL),
      "kategorie"        => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "titel"            => array("typ" => "varchar",  "size" => 100,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "beschreibung"     => array("typ" => "varchar",  "size" => 100,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "sort"             => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "KEY1"             => array("typ" => "PRIMARY",  "spalte" => "id")
      );
  sql_createtable("boards", $spalten);

  $spalten = array(
      "id"               => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => true,  "default" => NULL),
      "titel"            => array("typ" => "varchar",  "size" => 100,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "sort"             => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "KEY1"             => array("typ" => "PRIMARY",  "spalte" => "id")
      );
  sql_createtable("kategorien", $spalten);

  $spalten = array(
      "titel"            => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "'DasForum'"),
      "adresse"          => array("typ" => "text",     "size" => NULL, "unsigned" => false, "NULL" => false, "auto" => false, "default" => NULL),
      "theme"            => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "'standard'"),
      "layout"           => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "'standard'"),
      "smilieset"        => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "'standard'"),
      "offline"          => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 1),
      "offlinemsg"       => array("typ" => "text",     "size" => NULL, "unsigned" => false, "NULL" => true,  "auto" => false, "default" => NULL),
      "aktivierungsmail" => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "'aktivierung@diese-adresse-gibt-es-nicht.tld'"),
      "newslettermail"   => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "'newsletter@diese-adresse-gibt-es-nicht.tld'"),
      "infomail"         => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "'benachrichtigung@diese-adresse-gibt-es-nicht.tld'"),
      "htmltags"         => array("typ" => "text",     "size" => NULL, "unsigned" => false, "NULL" => true,  "auto" => false, "default" => NULL),
      "membersperpage"   => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "threadsperpage"   => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "postsperpage"     => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "standardgruppe"   => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 4),
      "rss_anzahl"       => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 10),
      "rss_boards"       => array("typ" => "text",     "size" => NULL, "unsigned" => false, "NULL" => true,  "auto" => false, "default" => NULL),
      "zeit_zone"        => array("typ" => "smallint", "size" => 3,    "unsigned" => false, "NULL" => false, "auto" => false, "default" => 0),
      "zeit_dst"         => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
	  "showstatistics"   => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 1),
	  "showonlinelist"   => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 1),
	  "maxonlinelist"    => array("typ" => "int",      "size" => 10,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 10)
      );
  sql_createtable("einstellungen", $spalten);

  $spalten = array(
      "id"               => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => true,  "default" => NULL),
      "kategorie"        => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "frage"            => array("typ" => "text",     "size" => NULL, "unsigned" => false, "NULL" => true,  "auto" => false, "default" => NULL),
      "antwort"          => array("typ" => "text",     "size" => NULL, "unsigned" => false, "NULL" => true,  "auto" => false, "default" => NULL),
      "bbcode"           => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "smilies"          => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "sort"             => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "KEY1"             => array("typ" => "PRIMARY",  "spalte" => "id")
      );
  sql_createtable("faq_fragen", $spalten);

  $spalten = array(
      "id"               => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => true,  "default" => NULL),
      "titel"            => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "sort"             => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "KEY1"             => array("typ" => "PRIMARY",  "spalte" => "id")
      );
  sql_createtable("faq_kategorien", $spalten);

  $spalten = array(
      "id"               => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => true,  "default" => NULL),
      "titel"            => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "beschreibung"     => array("typ" => "text",     "size" => NULL, "unsigned" => false, "NULL" => false, "auto" => false, "default" => NULL),
      "leader"           => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => NULL),
      "boardsbearbeiten" => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "admin"            => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "memberlist"       => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "gruppencp"        => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "sendmail"         => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "suche"            => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "KEY1"             => array("typ" => "PRIMARY",  "spalte" => "id")
      );
  sql_createtable("gruppen", $spalten);

  $spalten = array(
      "user_id"          => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "gruppe_id"        => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "akzeptiert"       => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0)
      );
  sql_createtable("gruppenmembers", $spalten);
  
  $spalten = array(
      "id"               => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => true,  "default" => NULL),
      "name"             => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "KEY1"             => array("typ" => "PRIMARY",  "spalte" => "id")
      );
  sql_createtable("module", $spalten);
  
  $spalten = array(
      "gruppe_id"        => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => NULL),
      "modul_id"         => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => NULL)
      );
  sql_createtable("modulrechte", $spalten);

  $spalten = array(
      "id"               => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => true,  "default" => NULL),
      "titel"            => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "thread"           => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "autor_id"         => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "autor_name"       => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "created"          => array("typ" => "int",      "size" => 10,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "nachricht"        => array("typ" => "text",     "size" => NULL, "unsigned" => false, "NULL" => false, "auto" => false, "default" => NULL),
      "bbcode"           => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "smilies"          => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "signatur"         => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "KEY1"             => array("typ" => "PRIMARY",  "spalte" => "id"),
      "KEY2"             => array("typ" => "FULLTEXT", "spalte" => "nachricht"),
      "KEY3"             => array("typ" => "FULLTEXT", "spalte" => "titel")
      );
  sql_createtable("posts", $spalten);

  $spalten = array(
      "thread_id"        => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "user_id"          => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "abo_typ"          => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0)
      );
  sql_createtable("thread_abos", $spalten);

  $spalten = array(
      "id"               => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => true,  "default" => NULL),
      "titel"            => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "status"           => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "board"            => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "sticky"           => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "autor_id"         => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "autor_name"       => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "created"          => array("typ" => "int",      "size" => 10,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "hits"             => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "KEY1"             => array("typ" => "PRIMARY",  "spalte" => "id")
      );
  sql_createtable("threads", $spalten);

  $spalten = array(
      "id"               => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => true,  "default" => NULL),
      "thread"           => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "frage"            => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "multiple"         => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "public"           => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "gltig_bis"       => array("typ" => "int",      "size" => 10,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "voter_ips"        => array("typ" => "text",     "size" => NULL, "unsigned" => false, "NULL" => true,  "auto" => false, "default" => NULL),
      "autor_id"         => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "moderiert_von"    => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => true,  "auto" => false, "default" => 0),
      "KEY1"             => array("typ" => "PRIMARY",  "spalte" => "id")
      );
  sql_createtable("umfragen", $spalten);

  $spalten = array(
      "id"               => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => true,  "default" => NULL),
      "titel"            => array("typ" => "varchar",  "size" => 100,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "minposts"         => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "icon"             => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => 0),
      "KEY1"             => array("typ" => "PRIMARY",  "spalte" => "id")
      );
  sql_createtable("userranks", $spalten);

  $spalten = array(
      "id"               => array("typ" => "bigint",   "size" => 20,   "unsigned" => true,  "NULL" => false, "auto" => true,  "default" => NULL),
      "username"         => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "passwort"         => array("typ" => "varchar",  "size" => 100,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "email"            => array("typ" => "varchar",  "size" => 100,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "icq"              => array("typ" => "varchar",  "size" => 10,   "unsigned" => false, "NULL" => true,  "auto" => false, "default" => "''"),
      "status"           => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "signatur"         => array("typ" => "text",     "size" => NULL, "unsigned" => false, "NULL" => false, "auto" => false, "default" => NULL),
      "sig_bbcode"       => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "sig_smilies"      => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "reg_since"        => array("typ" => "int",      "size" => 10,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "redir_type"       => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "redir_timeout"    => array("typ" => "tinyint",  "size" => 3,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 3),
      "auto_abo"         => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "layout"           => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "'standard'"),
      "theme"            => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "'standard'"),
      "smilieset"        => array("typ" => "varchar",  "size" => 255,  "unsigned" => false, "NULL" => false, "auto" => false, "default" => "'phpBB'"),
      "auto_sig"         => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "auto_bbcode"      => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "auto_smilies"     => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "zeit_zone"        => array("typ" => "smallint", "size" => 3,    "unsigned" => false, "NULL" => false, "auto" => false, "default" => 0),
      "zeit_dst"         => array("typ" => "tinyint",  "size" => 1,    "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "lastvisit"        => array("typ" => "int",      "size" => 10,   "unsigned" => true,  "NULL" => false, "auto" => false, "default" => 0),
      "lastip"           => array("typ" => "varchar",  "size" => 15,   "unsigned" => false, "NULL" => false, "auto" => false, "default" => "''"),
      "KEY1"             => array("typ" => "PRIMARY",  "spalte" => "id")
      );
  sql_createtable("users", $spalten);
  ?>
  <tr><td>Tabellen erstellen:</td><td>OK</td></tr>
  <?php

  /*########################################
  ######## Standard-Werte einfgen #########
  ########################################*/

  // Eigenschaften speichern
  // adresse aufbereiten
  $adresse = $_POST["adresse"];
  if(substr($adresse, 0, 7) != "http://") $adresse = "http://".$adresse;
  if(substr($adresse, -1) != "/") $adresse .= "/";
  $domaintemp = explode("/", $adresse);
  $domain = $domaintemp[2];

  $werte = array(
      "titel"            => "DasForum",
      "adresse"          => $adresse,
      "theme"            => "standard",
      "layout"           => "standard",
      "offline"          => 1,
      "offlinemsg"       => "Das Forum wird gerade installiert!",
      "aktivierungsmail" => "aktivierung@".$domain,
      "newslettermail"   => "newsletter@".$domain,
      "htmltags"         => "br\np\nimg\nb\nu\ni\na\nfont",
      "membersperpage"   => 25,
      "threadsperpage"   => 25,
      "postsperpage"     => 15,
      "standardgruppe"   => 4,
      "rss_anzahl"       => 10,
      "rss_boards"       => ""
      );
  sql_insert("einstellungen", $werte);

  // Standard-Gruppen einfgen
  $werte = array(
      "id"               => 1,
      "titel"            => "Gste",
      "beschreibung"     => "Nicht registrierte oder nicht eingeloggte Benutzer.",
      "leader"           => 0,
      "boardsbearbeiten" => 0,
      "admin"            => 0,
      "memberlist"       => 1,
      "gruppencp"        => 0,
      "sendmail"         => 0,
      "suche"            => 1
      );
  sql_insert("gruppen", $werte);

  $werte = array(
      "id"               => 2,
      "titel"            => "Administratoren",
      "beschreibung"     => "Die Admins, die alles mache drfen....\nZ.B. das Board abschalten, Einstellungen ndern oder Gruppen erstellen/lschen...",
      "leader"           => 2,
      "boardsbearbeiten" => 0,
      "admin"            => 1,
      "memberlist"       => 1,
      "gruppencp"        => 1,
      "sendmail"         => 1,
      "suche"            => 1
      );
  sql_insert("gruppen", $werte);

  $werte = array(
      "id"               => 3,
      "titel"            => "Moderatoren",
      "beschreibung"     => "Das sind diejenigen, die Beitrge lschen und Threads schlieen knnen.",
      "leader"           => 2,
      "boardsbearbeiten" => 0,
      "admin"            => 0,
      "memberlist"       => 1,
      "gruppencp"        => 1,
      "sendmail"         => 1,
      "suche"            => 1
      );
  sql_insert("gruppen", $werte);

  $werte = array(
      "id"               => 4,
      "titel"            => "Benutzer",
      "beschreibung"     => "Die angemeldeten Benutzer.",
      "leader"           => 2,
      "boardsbearbeiten" => 0,
      "admin"            => 0,
      "memberlist"       => 1,
      "gruppencp"        => 1,
      "sendmail"         => 1,
      "suche"            => 1
      );
  sql_insert("gruppen", $werte);

  // Gast-Account in die Datenbank einfgen
  $werte = array(
      "username"         => "Gast",
      "passwort"         => "",         // Gast hat kein Passwort
      "email"            => "",         // und keine e-mail
      "icq"              => NULL,       // keine ICQ
      "status"           => 1,          // Gast wie einen Gebannten behandeln, damit er sich nicht einloggen kann
      "signatur"         => "",         // keine Signatur
      "sig_bbcode"       => 0,          // egal, s.o.
      "sig_smilies"      => 0,          // egal, s.o.
      "reg_since"        => time(),
      "redir_type"       => 0,          // normale weiterleitungen
      "redir_timeout"    => 3,          // standard-wert
      "auto_abo"         => 0,          // gast wird nicht benachrichtigt
      "layout"           => "standard", // standard
      "theme"            => "standard", // s.o.
      "auto_sig"         => 0,          // egal
      "auto_bbcode"      => 1,          // ja
      "auto_smilies"     => 1,          // ja
      "zeit_zone"        => 0,          // GMT
      "zeit_dst"         => 0,          // Winterzeit
      "lastvisit"        => 0,          // ist beim gast egal
      "lastip"           => ''          // wird nicht berprft
      );
  sql_insert("users", $werte);

  // Admin-Account in die Datenbank einfgen
  $werte = array(
      "username"         => $_POST["admin_username"],
      "passwort"         => md5($_POST["admin_passwort1"]),
      "email"            => "",
      "icq"              => NULL,
      "status"           => 2,          // Aktiviert
      "signatur"         => "",
      "sig_bbcode"       => 1,
      "sig_smilies"      => 1,
      "reg_since"        => time(),
      "redir_type"       => 0,          // normale weiterleitungen
      "redir_timeout"    => 3,          // standard
      "auto_abo"         => 1,          // ja, einmalig
      "layout"           => "standard", // standard
      "theme"            => "standard", // s.o.
      "auto_sig"         => 1,          // ja
      "auto_bbcode"      => 1,          // ja
      "auto_smilies"     => 1,          // ja
      "zeit_zone"        => 0,          // server-zeit benutzen
      "zeit_dst"         => 0,          // s.o.
      "lastvisit"        => 0,          // war noch nicht eingeloggt
      "lastip"           => ''          // war noch nicht eingeloggt
      );
  sql_insert("users", $werte);

  // Gast und Admin ihren Gruppen hinzufgen
  $werte = array(
      "user_id"          => 1,
      "gruppe_id"        => 1,
      "akzeptiert"       => 1
      );
  sql_insert("gruppenmembers", $werte);

  $werte = array(
      "user_id"          => 2,
      "gruppe_id"        => 2,
      "akzeptiert"       => 1
      );
  sql_insert("gruppenmembers", $werte);

  // FAQ-Kategorien hinzufgen
  $werte = array(
      "titel"            => "Registrierung und Login",
      "sort"             => 1
      );
  sql_insert("faq_kategorien", $werte);

  $werte = array(
      "titel"            => "Posts und Threads",
      "sort"             => 2
      );
  sql_insert("faq_kategorien", $werte);

  // FAQ-Fragen hinzufgen
  $werte = array(
      "kategorie"        => 1,
      "frage"            => "Ich kann mich nicht einloggen!",
      "antwort"          => "Um sich einzuloggen muss man [url=index.php?action=register]registriert[/url] sein.\nEventuell sind Sie auch gebannt worden, um Ihren Zugang zu sperren.\nFalls Sie registriert und nicht gebannt sind, berprfen Sie Benutzernamen und Passwort. Bei einigen Installationen wird dabei zwischen Gro- und Kleinschreibung unterschieden.",
      "bbcode"           => 0,
      "smilies"          => 0,
      "sort"             => 1
      );
  sql_insert("faq_fragen", $werte);

  $werte = array(
      "kategorie"        => 1,
      "frage"            => "Welche Vorteile habe ich, wenn ich mich registriere?",
      "antwort"          => "Je nach Einstellung mssen Sie registriert sein, um einige Boards zu lesen oder in ihnen zu schreiben.\nAuerdem knnen Funktionen wie die Mitgliederliste, die Such-, die E-Mail-, die Kalender- und die Mailbox-Funktion nur fr registrierte Benutzer erlaubt sein.\nAls registrierter Benutzer kann der Name unter dem man schreibt nicht von anderen genutzt werden.\nDie Registrierung geht schnell und ist kostenlos.",
      "bbcode"           => 0,
      "smilies"          => 0,
      "sort"             => 2
      );
  sql_insert("faq_fragen", $werte);

  $werte = array(
      "kategorie"        => 2,
      "frage"            => "Wie kann ich Posts erstellen?",
      "antwort"          => "Sie knnen selbst Posts erstellen, indem Sie auf den Link &quot;antworten&quot; am Ende eines Threads klicken.\nDie Angabe eines Titels ist optional.\nMglicherweise mssen Sie registriert sein, um Posts erstellen zu knnen.",
      "bbcode"           => 0,
      "smilies"          => 0,
      "sort"             => 3
      );
  sql_insert("faq_fragen", $werte);

  $werte = array(
      "kategorie"        => 2,
      "frage"            => "Wie kann ich Threads erstellen?",
      "antwort"          => "Sie knnen selbst Threads erstellen, indem Sie auf den Link &quot;neuer Thread&quot; am ende der Board-bersicht klicken.\nThreads mssen immer einen Titel haben.\nSie sollten mit dem Thread-Titel den Inhalt des Threads beschreiben, ihn also z.B. nicht nur &quot;Frage&quot; nennen, sondern vielleicht: &quot;Wie mache ich ***&quot;.",
      "bbcode"           => 0,
      "smilies"          => 0,
      "sort"             => 4
      );
  sql_insert("faq_fragen", $werte);

  $werte = array(
      "kategorie"        => 2,
      "frage"            => "Wie kann ich eine Umfrage erstellen?",
      "antwort"          => "Umfragen knnen whrend der Thread-Erstellung angelegt werden.\nDazu mssen Sie das Kstchen vor &quot;Umfrage mit X Antworten&quot; markieren und die gewnschte Anzahl an Antworten in das nchste Textfeld eingeben.\nKlicken Sie auf &quot;erstellen&quot; und Sie werden zu einer Seite weitergeleitet, wo Sie Frage und Antworten angeben knnen.\nAls Gltigkeitsdauer knnen Sie einen Zeitpunkt angeben, ab dem niemand mehr abstimmen darf. &quot;0&quot; steht fr eine unbegrenzte Gltigkeit.\nUmfragen knnen spter nur von Moderatoren bearbeitet werden.",
      "bbcode"           => 0,
      "smilies"          => 0,
      "sort"             => 5
      );
  sql_insert("faq_fragen", $werte);

  $werte = array(
      "kategorie"        => 2,
      "frage"            => "Was sind BB-Code und Smilies und wie benutze ich sie?",
      "antwort"          => "BB-Code ermglicht es, Text z.B. [b]fett gedruckt[/b] oder [color=red]in einer anderen Farbe[/color] zu schreiben. Ebenso kann man [url=http://schorsch.gammelan.de/forum]Links[/url] erstellen und Listen einfgen.\nBB-Code ist HTML hnlich, verhindert jedoch, dass die &quot;Tags&quot; falsch eingesetzt werden.\nUm BB-Code zu benutzen, knnen Sie Tags wie &quot;[ b ]Text[/ b ]&quot; (nur ohne die Leerzeichen in den Tags) manuell eintippen oder die Schlatflchen ber den Textfeldern verwenden.\nSmilies, oder auch &quot;Emoticons&quot;, sind kleine Bilder wie :), :roll: oder :idea:, mit denen man z.B. Gefhle ausdrcken kann.\nUm Smilies zu verwenden, geben Sie z.B.  &quot;; )&quot; (ohne Leerzeichen) ein oder klicken Sie auf einen der Smilies ber dem Textfeld.\nUm die Schaltflchen zu benutzen muss in Ihrem Browser JavaScript aktiviert sein.\nAuerdem mssen BB-Code und/oder Smilies mit den Ja/Nein-Schaltern unter dem Textfeld aktiviert sein.\nSie sollten nicht bermig viele Smilies oder extrem groe Schriftarten verwenden, da Ihr Beitrag dadurch sehr unbersichtlich werden kann.",
      "bbcode"           => 1,
      "smilies"          => 1,
      "sort"             => 6
      );
  sql_insert("faq_fragen", $werte);

  $werte = array(
      "kategorie"        => 2,
      "frage"            => "Was sind Sticky-Threads?",
      "antwort"          => "Sticky-Threads werden in der Boardbersicht vor allen anderen Threads angezeigt. Meistens haben sie einen wichtigen Inhalt.\nNur Moderatoren knnen einen Thread sticky machen.",
      "bbcode"           => 0,
      "smilies"          => 0,
      "sort"             => 7
      );
  sql_insert("faq_fragen", $werte);

  $werte = array(
      "kategorie"        => 2,
      "frage"            => "Was ist ein geschlossener Thread?",
      "antwort"          => "Threads knnen von Moderatoren geschlossen werden. Dann kann man in diesem Thread nicht mehr antworten und nicht mehr an der Umfrage teilnehmen.",
      "bbcode"           => 0,
      "smilies"          => 0,
      "sort"             => 8
      );
  sql_insert("faq_fragen", $werte);

  $werte = array(
      "kategorie"        => 2,
      "frage"            => "Wie kann ich meine Beitrge bearbeiten?",
      "antwort"          => "Einfach indem Sie auf den &quot;bearbeiten&quot;-Link unter Ihrem Beitrag klicken.\nFalls Sie keine Moderatoren-Rechte besitzen, knnen Sie nur Ihre eigenen Beitrge bearbeiten, aber nicht Ihre Umfragen oder Threads.",
      "bbcode"           => 0,
      "smilies"          => 0,
      "sort"             => 9
      );
  sql_insert("faq_fragen", $werte);

  $werte = array(
      "titel"            => "Neuling",
      "minposts"         => 0,
      "icon"             => "neuling.png"
      );
  sql_insert("userranks", $werte);

  $werte = array(
      "titel"            => "Mitglied",
      "minposts"         => 20,
      "icon"             => "mitglied.png"
      );
  sql_insert("userranks", $werte);

  $werte = array(
      "titel"            => "Fortgeschrittener",
      "minposts"         => 100,
      "icon"             => "fortgeschrittener.png"
      );
  sql_insert("userranks", $werte);

  $werte = array(
      "titel"            => "Experte",
      "minposts"         => 500,
      "icon"             => "experte.png"
      );
  sql_insert("userranks", $werte);

  $werte = array(
      "titel"            => "Powerposter",
      "minposts"         => 1000,
      "icon"             => "powerposter.png"
      );
  sql_insert("userranks", $werte);

  sql_close();
  ?>
  <tr><td>Standard-Werte einfgen:</td><td>OK</td></tr>
  <?php

  /*########################################
  ########## config-datei anlegen ##########
  ########################################*/

  // schreibt das, was in die config.php soll schonma in eine variable
  $template =   "<?php\n";
  $template .=  "   // Diese legt die SQL-Zugangsdaten fest \n";
  $template .=  "   \$conf[\"sql_typ\"]\t\t=\t\""       . $_POST["sql_typ"]       . "\";\n";
  $template .=  "   \$conf[\"sql_host\"]\t\t=\t\""      . $_POST["sql_host"]      . "\";\n";
  $template .=  "   \$conf[\"sql_port\"]\t\t=\t\""      . $_POST["sql_port"]      . "\";\n";
  $template .=  "   \$conf[\"sql_datenbank\"]\t=\t\"" . $_POST["sql_datenbank"] . "\";\n";
  $template .=  "   \$conf[\"sql_username\"]\t=\t\""  . $_POST["sql_username"]  . "\";\n";
  $template .=  "   \$conf[\"sql_passwort\"]\t=\t\""  . $_POST["sql_passwort"]  . "\";\n";
  $template .=  "   \$conf[\"sql_prefix\"]\t\t=\t\""    . $_POST["sql_prefix"]    . "\";\n";
  $template .=  "?>";

  // ffnet die config.php und schreibt $template rein
  $pfile  = fopen ("./config.php", "w");
  $result = fputs($pfile, $template);
  fclose($pfile);

  // Hat's geklappt, von wegen Dateirechte und so?
  if (!$result)
  {
    $strerr = "Das ndern der Konfigurationseinstellungen ist fehlgeschlagen!<br />";
    $strerr .= "Stellen Sie sicher, dass jeder in die Datei \"config.php\" schreiben kann (CHMOD 777),<br />";
    $strerr .= "oder benennen Sie die Datei \"config.dist.php\" in \"config.php\" um und passen Sie diese an ihren SQL-Server an.<br />";
    $strerr .= "Legen Sie die Einstellungen manuell in der Datei \"config.php\" fest<br />";
    fehler($strerr);
  };

  ?>
  <tr><td>config.php schreiben:</td><td>OK</td></tr>
  <tr><td colspan="2" align="center"><b>Die Installation ist jetzt abgeschlossen!</b><br />
      Sie knnen nun mit der Benutzung des Forums beginnen.<br />
      Lschen Sie die Setup-Datei 'install.php'<br />
      und stellen Sie das Verzeichnis des Forums sowie<br />
      die Datei 'config.php' als schreibgeschtzt ein!<br />
      Sie sollten dann die Einstellungen in Ihrem<br />
      Benutzer-Kontroll-Zentrum und dem Admin-Control-Panel<br />
      vornehmen und das Forum 'online' schalten.<br />
      <a href="index.php">weiter...</a></td></tr>
  </table>
  </div>
  </body>
  </html>
  <?php
}
?>
