<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

include("./sql.php");
include("./sanitize.php");

$link = sql_connect();
$einstellungen = sql_fetch_assoc(sql_select("*", "einstellungen", ""));

session_name("DasForum");
session_start();

$layout    = $einstellungen["layout"];
$theme     = $einstellungen["theme"];
$smilieset = $einstellungen["smilieset"];

function fehler($errstr)
{
    global $layout, $theme;
    $fehlertext = $errstr;
    ob_clean();
    include("layouts/".$layout."/functions.php");
    ob_end_flush();
    die();
}

function redir($link, $text, $fast = true)
{
    global $user, $layout;
    if($user["redir_type"] == 0 or $fast == false)
    {
        $redirect["link"]    = $link;                               // link-adresse
        $redirect["amplink"] = str_replace("&", "&amp;", $link);    // link-adresse, & durch &amp; ersetzt
        $redirect["timeout"] = $user["redir_timeout"];              // automatische weiterleitung in x sekunden
        $redirect["text"]    = $text;                               // anzuzeigende nachricht
        include("layouts/".$layout."/functions.php");
    }
    else
    {
        header("Location: http://".$_SERVER["HTTP_HOST"].dirname($_SERVER["PHP_SELF"])."/".$link);
    }
}

if(isset($_SESSION["userid"]))
{
    // benutzer ist eingeloggt
    $user = sql_fetch_assoc(sql_select("*", "users", "WHERE id=".sanitize_int($_SESSION["userid"]))) or fehler("Ihre Session ist ungltig!");
    // ip-adresse berprfen
    if($user["lastip"] != getenv ("REMOTE_ADDR"))
    {
        // die IP-Adresse hat sich gendert. Gefahr von Session-Hi-Jacking
        session_destroy();
        fehler("Ihre IP-Adresse hat sich gendert. Aus Sicherheitsgrnden mssen Sie sich erneut einloggen!<br /><a href=\"index.php?action=login\">Login</a>");
    }
    $layout    = $user["layout"];
    $theme     = $user["theme"];
    $smilieset = $user["smilieset"];
    if($user["status"] != 2)
    {
        // benutzer ist gebannt oder nicht aktiviert -> session beenden, gast-user u. gast-gruppe verwenden
        session_destroy();
        fehler("Sie sind im Forum gebannt oder mssen Ihren Zugang aktivieren! Sie wurden daher ausgeloggt!");
    }
    
    // lastvisit und lastip aktualisieren
    $werte = array(
        "lastvisit" => time(),
        "lastip"    => getenv ("REMOTE_ADDR")
        );
    sql_update("users", $werte, "WHERE id=".$user["id"]);
    
    // zeit-offset des users zur server-zeit in sekunden berechnen
    $zeitoffset = $einstellungen["zeit_zone"] * -60 + $einstellungen["zeit_dst"] * -3600 + $user["zeit_zone"] * 60 + $user["zeit_dst"] * 3600;
}
else
{
    // benutzer ist nicht eingeloggt -> gast-user u. gast-gruppe verwenden
    $user = sql_fetch_assoc(sql_select("*", "users", "WHERE id=1"));
    
    // fr gste zeit des servers verwenden
    $zeitoffset = 0;
}

// allgemeine rechte rausfinden
function getrechte($userid)
{
    // in welchen gruppen ist der benutzer mitglied ?
    $rechte["admin"]      = false;
    $rechte["memberlist"] = false;
    $rechte["gruppencp"]  = false;
    $rechte["sendmail"]   = false;
    $rechte["suche"]      = false;
    
    $gruppen = sql_select("*", "gruppenmembers", "WHERE user_id=".$userid." AND akzeptiert=1");
    
    while($gruppe = sql_fetch_assoc($gruppen))
    {
        // rechte abfragen -> wenn recht hher, $rechte aktualisieren
        $gruppenrechte = sql_fetch_assoc(sql_select("*", "gruppen", "WHERE id=".$gruppe["gruppe_id"]));
        if($gruppenrechte["admin"]      == 1) $rechte["admin"]      = true;
        if($gruppenrechte["memberlist"] == 1) $rechte["memberlist"] = true;
        if($gruppenrechte["gruppencp"]  == 1) $rechte["gruppencp"]  = true;
        if($gruppenrechte["sendmail"]   == 1) $rechte["sendmail"]   = true;
        if($gruppenrechte["suche"]      == 1) $rechte["suche"]      = true;
    }
    return $rechte;
}
$rechte = getrechte($user["id"]);

// board-rechte rausfinden
function getboardrechte($boardid)
{
    // hnlich wie oben
    global $user;
    
    $boardrechte["lesen"]      = false;
    $boardrechte["posts"]      = false;
    $boardrechte["threads"]    = false;
    $boardrechte["moderieren"] = false;
    
    $gruppen = sql_select("*", "gruppenmembers", "WHERE user_id=".$user["id"]." AND akzeptiert=1");
    while($gruppe = sql_fetch_assoc($gruppen))
    {
        // boardrechte abfragen
        $gruppenboardrechteresult = sql_select("*", "boardrechte", "WHERE gruppe_id=".$gruppe["gruppe_id"]." AND board_id=".$boardid);
        $gruppenboardrechte = sql_fetch_assoc($gruppenboardrechteresult);
        if($gruppenboardrechte["lesen"]      == 1) $boardrechte["lesen"]      = true;
        if($gruppenboardrechte["posts"]      == 1) $boardrechte["posts"]      = true;
        if($gruppenboardrechte["threads"]    == 1) $boardrechte["threads"]    = true;
        if($gruppenboardrechte["moderieren"] == 1) $boardrechte["moderieren"] = true;
        sql_free_result($gruppenboardrechteresult);
    }
    //echo ":".$boardid.":"; print_r($boardrechte);
    return $boardrechte;
}

// modul-rechte rausfinden
function modzugriff($modul_id)
{
    global $user;
    $zugriff = false;
    
    $gruppen = sql_select("*", "gruppenmembers", "WHERE user_id=".$user["id"]." AND akzeptiert=1");
    while($gruppe = sql_fetch_assoc($gruppen))
    {
        // zugriffsrecht fr diese gruppe abfragen
        if(sql_num_rows(sql_select("*", "modulrechte", "WHERE gruppe_id=".$gruppe["gruppe_id"]." AND modul_id=".$modul_id)) == 1)
        {
            // zugriff erlaubt!
            return true;
        }
    }
}

include("./module.php");
?>