<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if(!isset($_GET["kategorie"]))
{
    // bersicht ber alle kategorien mit allen fragen zusammenstellen
    $kategorien = sql_select("id, titel", "faq_kategorien", "ORDER BY sort ASC");
    $numkategorien = sql_num_rows($kategorien);
    for($z = 1; $z <= $numkategorien; $z++)
    {
        $kategorie = sql_fetch_assoc($kategorien);
        
        $kategorienarray[$z]["id"] = $kategorie["id"];
        $kategorienarray[$z]["titel"] = $kategorie["titel"];
        
        $fragen = sql_select("id, frage", "faq_fragen", "WHERE kategorie=".$kategorie["id"]." ORDER BY sort ASC");
        $numfragen = sql_num_rows($fragen);
        for($y = 1; $y <= $numfragen; $y++)
        {
            $frage = sql_fetch_assoc($fragen);
            $fragenarray[$y]["id"]    = $frage["id"];
            $fragenarray[$y]["frage"] = $frage["frage"];
        }
        
        if(isset($fragenarray)) $kategorienarray[$z]["fragen"] = $fragenarray;
        $fragenarray = NULL;
    }
}
if(isset($_GET["kategorie"]))
{
    // alle fragen der kategorie mit antworten zusammenstellen
    
    // BB-Code-Parser laden
    include("./bbcode_parser.php");
    $parser = new HTML_BBCodeParser;
    
    // Smilie-Parser
    include("./smilie_parser.php");
    
    $kategorieresult = sql_select("titel", "faq_kategorien", "WHERE id=".sanitize_int($_GET["kategorie"]));
    if(sql_num_rows($kategorieresult) == 0) fehler("Die Kategorie ist nicht vorhanden!");
    $kategorie = sql_fetch_assoc($kategorieresult);
    $kategorietitel = $kategorie["titel"];
    
    $fragen = sql_select("*", "faq_fragen", "WHERE kategorie=".sanitize_int($_GET["kategorie"])." ORDER BY sort ASC");
    $numfragen = sql_num_rows($fragen);
    for($z = 1; $z <= $numfragen; $z++)
    {
        $frage = sql_fetch_assoc($fragen);
        
        $fragenarray[$z]["id"]    = $frage["id"];
        $fragenarray[$z]["frage"] = $frage["frage"];
        
        if($frage["bbcode"] == 1)
        {
            $parser->setText($frage["antwort"]);
            $parser->parse();
            $nachricht = $parser->getParsed();
        }
        else
        {
            $nachricht = $frage["antwort"];
        }
        if($frage["smilies"] == 1)
        {
            $nachricht = parse_smilies($nachricht);
        }
        $fragenarray[$z]["antwort"] = str_replace("\n", "<br />\n", $nachricht);
    }
}

include("layouts/".$layout."/faq.php");
?>