<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ($rechte["admin"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");

if (!isset($_GET["type"]))
{
  ?>
  <h3>Gruppen verwalten</h3>
  <table class="maintable">
  <form method="POST" action="index.php?action=admincp&amp;show=gruppen&amp;type=neu">
  <tr class="rowberschrift">
    <td colspan="2"><b>Gruppe erstellen</b></td>
  </tr>
  <tr class="row2">
    <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" /></td>
  </tr>
  <tr class="row2">
    <td>Beschreibung:</td><td><input class="inputtext" name="beschreibung" type="text" size="40" /></td>
  </tr>
  <tr class="row2">
    <td>&nbsp</td><td><input type="submit" value="erstellen" /></td>
  </tr>
  </form>
  <form method="POST" action="index.php?action=admincp&amp;show=gruppen&amp;type=bearbeiten">
  <tr class="rowberschrift">
    <td colspan="2"><b>Gruppe bearbeiten/lschen</b></td>
  </tr>
  <tr class="row2">
    <td>Gruppen-ID:</td>
    <td>
    <select class="inputtext" name="id" size="1">
    <?php
    $result = sql_select("id, titel", "gruppen", "ORDER BY id ASC", NULL, NULL);
    while ($ergebnis = sql_fetch_assoc($result))
    {
      echo "<option value=\"".$ergebnis["id"]."\">".$ergebnis["id"]." - ".$ergebnis["titel"]."</option>";
    }
    ?>
    </select>
    <input name="gruppe_bearbeiten" type="submit" value="bearbeiten" /> <input name="gruppe_loeschen" type="submit" value="lschen" />
    </td>
  </tr>
  </form>
  </table>

  <?php
}
else
{
  //******************************* neu ****************************************
  if($_GET["type"]=="neu")
  {
    if(trim($_POST["titel"])=="") fehler("Jede Gruppe muss einen Titel haben!");
    //gruppe erstellen, dann bearbeiten-seite aufrufen
    $werte = array("titel" => htmlspecialchars($_POST["titel"]), "beschreibung" => htmlspecialchars($_POST["beschreibung"]));
    sql_insert("gruppen", $werte);
    //id des neuen eintrags?
    $result = sql_select("id", "gruppen", "ORDER BY id DESC", NULL, NULL);
    $ergebnis = sql_fetch_assoc($result);
    ?>
    <h3>Gruppe erstellen</h3>
    Die Gruppe wurde erfolgreich erstellt!<br />
    Klicken Sie jetzt auf "bearbeiten" um die Einstellungen fr die Gruppe zu bearbeiten.<br />
    <form method="POST" action="index.php?action=admincp&amp;show=gruppen&amp;type=bearbeiten">
    <input name="id" type="hidden" value="<?php echo $ergebnis["id"] ?>" />
    <input name="gruppe_bearbeiten" type="submit" value="bearbeiten" />
    </form>
    <?php
  }
  if($_GET["type"]=="bearbeiten")
  {
    //lschen oder bearbeiten?
    //**************************** bearbeiten **********************************
    if(isset($_POST["gruppe_bearbeiten"]))
    {
      if(!isset($_POST["bearbeiten_knopf"]))
      {
        //bearbeiten-formular
        //bisherige einstellungen abfragen:
        $gruppenresult = sql_select("*", "gruppen", "WHERE id=".$_POST["id"], NULL, NULL);
        $gruppen = sql_fetch_assoc($gruppenresult);

        $leaderresult = sql_select("username", "users", "WHERE id=".$gruppen["leader"], NULL, NULL);
        if(sql_num_rows($leaderresult) == 0)
        {
          $leader["username"] = "";
        }
        else
        {
          $leader = sql_fetch_assoc($leaderresult);
        }
        ?>
        <h3>Gruppe bearbeiten</h3>
        <form method="POST" action="index.php?action=admincp&amp;show=gruppen&amp;type=bearbeiten">
        <input name="gruppenid" type="hidden" value="<?php echo $_POST["id"] ?>" />
        <input name="gruppe_bearbeiten" type="hidden" value="1" />
        <table class="maintable">
        <tr class="rowberschrift">
          <td colspan="2"><b>Allgemeines</b></td>
        </tr>
        <tr class="row2">
          <td>Titel:</td><td><input class="inputtext" name="titel" type="text" value="<?php echo $gruppen["titel"] ?>" size="40" /></td>
        </tr>
        <tr class="row2">
          <td>Beschreibung:</td><td><input class="inputtext" name="beschreibung" type="text" value="<?php echo $gruppen["beschreibung"] ?>" size="40" /></td>
        </tr>
        <tr class="row2">
          <td>Leader:</td><td><input class="inputtext" name="leader" type="text" value="<?php echo $leader["username"] ?>" size="40" /></td>
        </tr>
        <tr class="rowberschrift">
          <td colspan="2"><b>Rechte:</b></td>
        </tr>
        <tr class="row2">
          <td>Boards bearbeiten:</td><td><i>Diese Funktion fehlt noch!</i></td>
        </tr>
        <tr class="row2">
          <td>Admin-Rechte:</td><td><input name="admin" type="radio" value="1"<?php
          if($gruppen["admin"]==1) echo " checked" ?> />Ja <input name="admin" type="radio" value="0"<?php
          if($gruppen["admin"]==0) echo " checked" ?> />Nein</td>
        </tr>
        <tr class="row2">
          <td>Mitglieder anzeigen:</td><td><input name="memberlist" type="radio" value="1"<?php
          if($gruppen["memberlist"]==1) echo " checked" ?> />Ja <input name="memberlist" type="radio" value="0"<?php
          if($gruppen["memberlist"]==0) echo " checked" ?> />Nein</td>
        </tr>
        <tr class="row2">
          <td>Gruppen-CP anzeigen:</td><td><input name="gruppencp" type="radio" value="1"<?php
          if($gruppen["gruppencp"]==1) echo " checked" ?> />Ja <input name="gruppencp" type="radio" value="0"<?php
          if($gruppen["gruppencp"]==0) echo " checked" ?> />Nein</td>
        </tr>
        <tr class="row2">
          <td>E-Mails senden:</td><td><input name="sendmail" type="radio" value="1"<?php
          if($gruppen["sendmail"]==1) echo " checked" ?> />Ja <input name="sendmail" type="radio" value="0"<?php
          if($gruppen["sendmail"]==0) echo " checked" ?> />Nein</td>
        </tr>
        <tr class="row2">
          <td>Suche benutzen:</td><td><input name="suche" type="radio" value="1"<?php
          if($gruppen["suche"]==1) echo " checked" ?> />Ja <input name="suche" type="radio" value="0"<?php
          if($gruppen["suche"]==0) echo " checked" ?> />Nein</td>
        </tr>
        <tr class="row2">
          <td>&nbsp</td><td><input name="bearbeiten_knopf" type="submit" value="bearbeiten" /></td>
        </tr>
        </table>
        </form>
        <?php
      }
      else
      {
        if(trim($_POST["titel"])=="") fehler("Jede Gruppe muss einen Titel haben!");

        $leaderresult = sql_select("id", "users", "WHERE username='".$_POST["leader"]."'", NULL, NULL);
        if(sql_num_rows($leaderresult) == 0 and $_POST["leader"] != "") fehler("Der Benutzername ist nicht vorhanden!");
        if($_POST["leader"] == "")
        {
          $leader["id"] = 0;
        }
        else
        {
          $leader = sql_fetch_assoc($leaderresult);
        }

        //speichern
        $werte = array(
            "titel"        => htmlspecialchars($_POST["titel"]),
            "beschreibung" => htmlspecialchars($_POST["beschreibung"]),
            "leader"       => $leader["id"],
            "admin"        => $_POST["admin"],
            "memberlist"   => $_POST["memberlist"],
            "gruppencp"    => $_POST["gruppencp"],
            "sendmail"     => $_POST["sendmail"],
            "suche"        => $_POST["suche"]
            );
        sql_update("gruppen", $werte, "WHERE id=".$_POST["gruppenid"]);

        // leader ggf. zur gruppe hinzufgen
        if($_POST["leader"] != "")
        {
          $leaderresult = sql_select("user_id", "gruppenmembers", "WHERE user_id=".$leader["id"]." AND gruppe_id=".$_POST["gruppenid"], NULL, NULL);
          if(sql_num_rows($leaderresult) == 0)
          {
            // leader hinzufgen
            $werte = array("user_id" => $leader["id"], "gruppe_id" => $_POST["gruppenid"], "akzeptiert" => 1);
            sql_insert("gruppenmembers", $werte);
          }
        }

        redir("index.php?action=admincp&show=gruppen", "Die Einstellungen wurden bearbeitet!");
      }
    }
    //***************************** lschen ************************************
    elseif(isset($_POST["gruppe_loeschen"]))
    {
		// wenn die gruppe die standard-gruppe ist, verbieten, sie zu lschen
    	if($_POST["id"] == $einstellungen["standardgruppe"]) fehler("Die Standard-Gruppe darf nicht gelscht werden! ndern Sie die Standard-Gruppe vorher unter \"Einstellungen\"!");
		//sicherheitsabfrage, dann lschen
		if(!isset($_POST["bestaetigen_knopf"]))
		{
			//formular mit besttigungsknopf anzeigen
			$result = sql_select("*", "gruppen", "WHERE id=".$_POST["id"], NULL, NULL);
			$ergebnis = sql_fetch_assoc($result);
			?>
			<h3>Gruppe lschen</h3>
			<form method="POST" action="index.php?action=admincp&amp;show=gruppen&amp;type=bearbeiten">
			<input name="id" type="hidden" value="<?php echo $_POST["id"] ?>" />
			<input name="gruppe_loeschen" type="hidden" value="1" />
			Sind Sie sicher, dass Sie die Gruppe "<?php echo $ergebnis["titel"] ?>" lschen wollen?<br />
			<input name="bestaetigen_knopf" type="submit" value="lschen" />
			</form>
			<?php
		}
		else
		{
			//mitglieder, die nur in dieser gruppe sind, in die standard-gruppe bertragen
			$gruppenmembers = sql_select("user_id", "gruppenmembers", "WHERE gruppe_id=".$_POST["id"]." AND akzeptiert=1");
			while($gruppenmember = sql_fetch_assoc($gruppenmembers))
			{
				// gucken, ob der user noch in einer anderen gruppe ist
				if(sql_num_rows(sql_select("user_id", "gruppenmembers", "WHERE user_id=".$gruppenmember["user_id"]." AND gruppe_id!=".$_POST["id"]." AND akzeptiert=1")) == 0)
				{
					// nein -> in standard-gruppe bertragen
					$werte = array(
						"gruppe_id" => $einstellungen["standardgruppe"]
						);
					sql_update("gruppenmembers", $werte, "WHERE user_id=".$gruppenmember["user_id"]." AND gruppe_id=".$_POST["id"]);
				}
			}
			// gruppenmember-eintrge lschen
			sql_delete("gruppenmembers", "WHERE gruppe_id=".$_POST["id"]);
			// boardrechte entfernen
			sql_delete("boardrechte", "WHERE gruppe_id=".$_POST["id"]);
			//modulrechte entfernen
			sql_delete("modulrechte", "WHERE gruppe_id=".$_POST["id"]);
			//gruppe aus der datenbank lschen
			sql_delete("gruppen", "WHERE id=".$_POST["id"]);
			redir("index.php?action=admincp&show=gruppen", "Die Gruppe wurde gelscht!");
		}
    }
  }
}