<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

$boardrechte = getboardrechte($aktboard["id"]);

if(!isset($_GET["show"]))
{
  // umfrage anzeigen
  $umfrage = sql_fetch_assoc(sql_select("*", "umfragen", "WHERE thread=".$aktthread["id"], NULL, NULL));
  $antworten = sql_select("*", "antworten", "WHERE umfrage=".$umfrage["id"], NULL, NULL);
  // hat der user schon abgestimmt?
  $voted = false;
  // -> in forum_antworten.users nachsehen
  function checkvoterids($value, $key)
  {
    global $voted, $user;
    if($value == $user["id"] and $user["id"] != 1) $voted = true;
  }
  while($antwort = sql_fetch_assoc($antworten))
  {
    array_walk(explode(";", $antwort["users"]),"checkvoterids");
  }

  // -> in forum_umfragen.voter_ips nachsehen
  function checkvoterips($value, $key)
  {
    global $voted;
    //if($value == getenv ("REMOTE_ADDR") and getenv ("REMOTE_ADDR")!="127.0.0.1") $voted = true;
    if($value == getenv ("REMOTE_ADDR")) $voted = true;
  }
  array_walk(explode(";", $umfrage["voter_ips"]),"checkvoterips");
  // rechte?
  if($boardrechte["posts"] == false) $voted = true;

  if(($voted == false and (time() <= $umfrage["gltig_bis"] or $umfrage["gltig_bis"] == 0)) and !isset($showergebnis))
  {
    if(!isset($_POST["vote_button"]))
    {
      // formular zum abstimmen anzeigen
      ?>
      <form method="POST" action="index.php?action=umfrage&amp;umfrage=<?php echo $umfrage["id"] ?>&amp;threadid=<?php echo $aktthread["id"] ?>">
      <table class="maintable" width="100%">
      <tr class="rowberschrift">
        <td><b>Umfrage</b></td>
      </tr>
      <tr class="umfrage">
        <td align="center"><b><?php echo $umfrage["frage"] ?></b></td>
      </tr>
      <?php
      $antworten = sql_select("*", "antworten", "WHERE umfrage=".$umfrage["id"]." ORDER BY id ASC", NULL, NULL);
      while($antwort = sql_fetch_assoc($antworten))
      {
        ?>
        <tr class="umfrage">
          <td align="center"><input class="inputtext" name="antwort[]" type="<?php if($umfrage["multiple"]==true) { echo "checkbox"; } else { echo "radio"; } ?>" value="<?php echo $antwort["id"] ?>" /> <?php echo $antwort["antwort"] ?></td>
        </tr>
        <?php
      }
      if($umfrage["gltig_bis"] != 0)
      {
        ?>
        <tr class="umfrage">
          <td align="center">gltig bis: <?php echo date("d.m.Y, H:i:s", $umfrage["gltig_bis"] + $zeitoffset) ?></td>
        </tr>
        <?php
      }
      if($umfrage["public"] == 1)
      {
        ?>
        <tr class="umfrage">
          <td align="center">Dies ist keine anonyme Umfrage! Jeder kann sehen, wer wofr gestimmt hat!</td>
        </tr>
        <?php
      }
      ?>
      <tr class="umfrage">
        <td align="center"><input name="vote_button" type="submit" value="abstimmen" /> <a href="index.php?action=viewthread&amp;id=<?php echo $aktthread["id"] ?>&amp;ergebnis=1">Ergebnisse anzeigen</a></td>
      </tr>
      <?php
      if($boardrechte["moderieren"] == true)
      {
        ?><tr class="umfrage">
            <td align="right" colspan="3"><a href="index.php?action=moderate&amp;type=editumfrage&amp;id=<?php echo $umfrage["id"] ?>"><?php echo $t_bearbeiten ?></a></td>
          </tr><?php
      }
      ?>
      </table>
      <br />
      </form>
      <?php
    }
    else
    {
      // rechte?
      if($boardrechte["posts"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte um an der Umfrage teilzunehmen!");
      // ist die umfrage noch gltig?
      if($umfrage["gltig_bis"] < time() and $umfrage["gltig_bis"] != 0) fehler("Die Gltigkeit der Umfrage ist bereits abgelaufen!");
      // datenbank aktualisieren

      //if(getenv ("REMOTE_ADDR")!="127.0.0.1")
      //{
        $newips = $umfrage["voter_ips"].";".getenv ("REMOTE_ADDR");
      //}
      //else
      //{
      //  $newips = $umfrage["voter_ips"];
      //}
      $werte = array("voter_ips" => $newips);
      sql_update("umfragen", $werte, "WHERE id=".$_GET["umfrage"]);

      function updateantworten($value, $key)
      {
        global $antwort, $conf, $link, $user;
        if($user["id"] != 1)
        {
          $newusers = $antwort["users"].";".$user["id"];
        }
        else
        {
          $newusers = $antwort["users"];
        }
        $sql = "UPDATE ".$conf["sql_prefix"]."_antworten SET stimmen=stimmen+1, users='".$newusers."' WHERE id=".$value;
        if($conf["sql_typ"] == "mysql") mysql_query($sql, $link) or fehler("Die Antwort konnte nicht aktualisiert werden! ".mysql_error());
        if($conf["sql_typ"] == "postgresql") pg_query($link, $sql) or fehler("Die Antwort konnte nicht aktualisiert werden! ".mysql_error());
      }
      array_walk($_POST["antwort"],"updateantworten");

      redir("index.php?action=viewthread&id=".$aktthread["id"], "Ihre Stimme wurde gezhlt!");
    }
  }
  else
  {
    // ergebnisse anzeigen
    ?>
    <table class="maintable" width="100%">
    <tr class="rowberschrift">
      <td colspan="3"><b>Umfrage</b></td>
    </tr>
    <tr class="umfrage">
      <td class="maincontent" colspan="3" align="center"><b><?php echo $umfrage["frage"] ?></b></td>
    </tr>
    <?php
    // wie viele stimmen wurden insgesamt abgegeben?
    $allestimmen = 0;
    $countstimmenresult = sql_select("*", "antworten", "WHERE umfrage=".$umfrage["id"], NULL, NULL);
    while($countantwort = sql_fetch_assoc($countstimmenresult))
    {
      $allestimmen += $countantwort["stimmen"];
    }

    $antworten = sql_select("*", "antworten", "WHERE umfrage=".$umfrage["id"]." ORDER BY stimmen DESC", NULL, NULL);
    while($antwort = sql_fetch_assoc($antworten))
    {
      if($allestimmen == 0)
      {
        $stimmen = 0;
      }
      else
      {
        $stimmen = round($antwort["stimmen"] / $allestimmen * 100,1);
      }
      ?>
      <tr class="umfrage">
        <td align="right"><?php echo $antwort["antwort"] ?></td><td width="400"><table border="0" width="100%"><tr><td class="pollbar_l">&nbsp</td><td class="pollbar_m" width="<?php echo $stimmen ?>%">&nbsp</td><td class="pollbar_r">&nbsp</td><td width="<?php echo 100-$stimmen ?>%">&nbsp</td></tr></table></td><td align="left"><?php echo $stimmen." % [".$antwort["stimmen"]."]" ?></td>
      </tr>
      <?php
      if($umfrage["public"] == 1)
      {
        ?>
        <tr class="umfrage">
          <td>&nbsp;</td><td><?php
            $voters = explode(";", $antwort["users"]);
            $i = 1;
            foreach($voters as $voter_id)
            {
              if($voter_id == "") continue;
              if($i != 1) echo ", ";
              $voter = sql_fetch_assoc(sql_select("id, username", "users", "WHERE id=".$voter_id));
              if($rechte["memberlist"] == true)
              {
                ?><a href="index.php?action=userinfo&amp;id=<?php echo $voter["id"] ?>"><?php
              }
              echo $voter["username"];
              if($rechte["memberlist"] == true)
              {
                ?></a><?php
              }
              $i++;
            }
          ?></td><td>&nbsp;</td>
        </tr><?php
      }
    }
    ?>
    <tr class="umfrage">
      <td colspan="3" align="center"><?php echo $allestimmen ?> insgesamt</td>
    </tr>
    <?php
    if($umfrage["moderiert_von"] != 0)
    {
      ?>
      <tr class="umfrage">
        <td colspan="3" align="center">
        <?php
          $moderator = sql_fetch_assoc(sql_select("username", "users", "WHERE id=".$umfrage["moderiert_von"], NULL, NULL));
          ?><i>Bearbeitet von <?php echo $moderator["username"] ?></i>
        </td>
      </tr>
      <?php
    }
    if($voted == false)
    {
      ?>
      <tr class="umfrage">
        <td colspan="3" align="center"><a href="index.php?action=viewthread&amp;id=<?php echo $aktthread["id"] ?>">zur Abstimmung</a></td>
      </tr>
      <?php
    }
    if($boardrechte["moderieren"] == true)
    {
      ?><tr class="umfrage">
          <td align="right" colspan="3"><a href="index.php?action=moderate&amp;type=editumfrage&amp;id=<?php echo $umfrage["id"] ?>"><?php echo $t_bearbeiten ?></a></td>
        </tr><?php
    }
    ?>
    </table>
    <br />
    <?php
  }
}
if(isset($_GET["show"]) and $_GET["show"]=="create")
{
  // umfrage erstellen

  // darf derjenige threads erstellen (also auch umfragen)?
  if($boardrechte["threads"] == false and ($boardrechte["moderieren"] == true or $aktthread["autor_id"]!=$user["id"])) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");
  if(!isset($_POST["erstellen_knopf"]))
  {
    // formular ausgeben
    ?>
    <h3>Umfrage erstellen</h3>
    <form method="POST" action="index.php?action=umfrage&amp;show=create&amp;threadid=<?php echo $aktthread["id"] ?>">
    <table border="0">
    <tr class="rowberschrift">
      <td colspan="2"><b>Allgemeines</b></td>
    </tr>
    <tr class="row2">
      <td>Frage:</td><td><input class="inputtext" name="frage" type="text" size="40" /></td>
    </tr>
    <tr class="row2">
      <td>Multiple Choice:</td><td><input class="inputtext" name="multiple" type="checkbox" value="1" /> Mehrere Antworten erlauben</td>
    </tr>
    <tr class="row2">
      <td>Anonymitt:</td><td><input class="inputtext" name="public" type="checkbox" value="1" /> Anzeigen wer wofr gestimmt hat</td>
    </tr>
    <tr class="row2">
      <td>Gltig bis:</td><td><input class="inputtext" name="gueltigbis" type="text" value="tt.mm.jjjj, hh:mm:ss" size="16" /> Format beibehalten, 0: unbegrenzt</td>
    </tr>
    <tr class="rowberschrift">
      <td colspan="2"><b>Antworten</b></td>
    </tr>
    <?php
    for($i = 1; $i <= $_GET["antworten"]; $i++)
    {
      // ein textfeld pro antwort ausgeben
      ?><tr class="row2">
          <td>Antwort <?php echo $i ?>:</td><td><input class="inputtext" name="antwort[]" type="text" size="40" /></td>
        </tr><?php
    }
    ?>
    <tr class="row2">
      <td>&nbsp</td><td><input name="erstellen_knopf" type="submit" value="erstellen" /></td>
    </tr>
    </table>
    </form>
    <?php
  }
  else
  {
    // speichern
    if(trim($_POST["frage"])=="") fehler("Jede Umfrage muss eine Frage haben!");
    function checkantworten($value, $key)
    {
      if(trim($value)=="") fehler("Jede Antwort muss Text enthalten!");
    }
    array_walk($_POST["antwort"],"checkantworten");
    // timestamp aus gueltigbis erstellen
    if($_POST["gueltigbis"] != 0)
    {
      $gltigbis = mktime(substr($_POST["gueltigbis"], 12, 2), substr($_POST["gueltigbis"], 15, 2), substr($_POST["gueltigbis"], 18, 2), substr($_POST["gueltigbis"], 3, 2), substr($_POST["gueltigbis"], 0, 2), substr($_POST["gueltigbis"], 6, 4)) - $zeitoffset;
      if($gltigbis <= time()) fehler("Die Gltigkeitsdauer ist ungltig!");
    }
    else
    {
      $gltigbis = 0;
    }
    // umfrage speichern
    $multiple = 0;
    if(isset($_POST["multiple"])) $multiple = 1;
    $public = 0;
    if(isset($_POST["public"])) $public = 1;
    $werte = array(
        "thread"        => $aktthread["id"],
        "frage"         => $_POST["frage"],
        "multiple"      => $multiple,
        "public"        => $public,
        "gltig_bis"    => $gltigbis,
        "moderiert_von" => 0
        );
    sql_insert("umfragen", $werte);
    // neue id herausfinden
    $newpoll = sql_fetch_assoc(sql_select("*", "umfragen", "ORDER BY id DESC", NULL, NULL));
    // antworten speichern
    function insertantworten($value, $key)
    {
      global $newpoll;
      $werte = array(
          "umfrage" => $newpoll["id"],
          "antwort" => $value,
          "stimmen" => 0
          );
      sql_insert("antworten", $werte);
    }
    array_walk($_POST["antwort"],"insertantworten");

    redir("index.php?action=viewthread&id=".$aktthread["id"], "Die Umfrage wurde erstellt!");
  }
}

?>
