<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ($rechte["admin"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");

if(!isset($_POST["update_button"]))
{
  ?>
  <h3>Einstellungen</h3>
  <form method="POST" action="index.php?action=admincp&amp;show=einstellungen">
  <table class="maintable">
  <tr class="rowberschrift">
    <td colspan="2">Einstellungen</td>
  </tr>
  <tr class="row2">
    <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" value="<?php echo $einstellungen["titel"] ?>" /></td>
  </tr>
  <tr class="row2">
    <td>URL des Forums:</td><td><input class="inputtext" name="adresse" type="text" size="40" value="<?php echo $einstellungen["adresse"] ?>" /></td>
  </tr>
  <tr class="row2">
    <td>Standard-Theme:</td><td><select class="inputtext" name="theme" size="1"><?php
    // array mit allen dateinamen im "themes"-Verzeichnis erstellen
    $files = array();
    $fh = opendir("./layouts/".$einstellungen["layout"]."/themes");
    while (false !== ($filename = readdir($fh)))
    {
      array_push($files, $filename);
    }
    closedir($fh);
    // option-elemente erstellen
    foreach($files as $key => $value)
    {
      if (is_dir("./layouts/".$einstellungen["layout"]."/themes/".$value) and $value != "." and $value != "..")
      {
        if ($value == $einstellungen["theme"])
        {
          echo "<option value='".$value."' selected>".$value."</option>\n";
        }
        else
        {
          echo "<option value='".$value."'>".$value."</option>\n";
        }
      }
    }
    ?></select></td>
  </tr>
  <tr class="row2">
    <td>Standard-Layout:</td><td><select class="inputtext" name="layout" size="1"><?php
    // array mit allen verzeichnisnamen im "layouts"-Verzeichnis erstellen
    $files = array();
    $fh = opendir("./layouts");
    while (false != ($filename = readdir($fh)))
    {
      array_push($files, $filename);
    }
    closedir($fh);
    // option-elemente erstellen
    foreach($files as $key => $value)
    {
      if(is_dir("./layouts/".$value) and $value != "." and $value != "..")
      {
        if ($value == $einstellungen["layout"])
        {
          echo "<option value='".$value."' selected>".$value."</option>\n";
        }
        else
        {
          echo "<option value='".$value."'>".$value."</option>\n";
        }
      }
    }
    ?></select></td>
  </tr>
  <tr class="row2">
    <td>Standard-Smilieset:</td><td><select class="inputtext" name="smilieset" size="1"><?php
    // array mit allen verzeichnisnamen im "layouts"-Verzeichnis erstellen
    $files = array();
    $fh = opendir("./gfx/smilies");
    while (false != ($filename = readdir($fh)))
    {
      array_push($files, $filename);
    }
    closedir($fh);
    // option-elemente erstellen
    foreach($files as $key => $value)
    {
      if(is_dir("./gfx/smilies/".$value) and $value != "." and $value != "..")
      {
        if ($value == $einstellungen["layout"])
        {
          echo "<option value='".$value."' selected>".$value."</option>\n";
        }
        else
        {
          echo "<option value='".$value."'>".$value."</option>\n";
        }
      }
    }
    ?></select></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2"><b>Offline-Einstellungen</b></td>
  </tr>
  <tr class="row2">
    <td>Offline:</td><td><input class="inputtext" name="offline" type="radio" value="1" <?php if($einstellungen["offline"]==1) echo "checked " ?>/>Ja <input class="inputtext" name="offline" type="radio" value="0" <? if($einstellungen["offline"]==0) echo "checked " ?>/>Nein</td>
  </tr>
  <tr class="row2">
    <td>Nachricht:</td><td><textarea class="inputtext" name="offlinemsg" cols="39" rows="5"><?php echo $einstellungen["offlinemsg"] ?></textarea></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2"><b>Registrierung</b></td>
  </tr>
  <tr class="row2">
    <td>Aktivierung:</td><td><i>Fehlt noch!!!</i></td>
  </tr>
  <tr class="row2">
    <td>E-Mail-Adresse:</td><td><input class="inputtext" name="aktivierungsmail" type="text" size="40" value="<?php echo $einstellungen["aktivierungsmail"] ?>" /></td>
  </tr>
  <tr class="row2">
    <td>E-Mail-Text:</td><td><i>Fehlt noch!!!</i></td>
  </tr>
  <tr class="row2">
    <td>Standard-Gruppe:</td><td><select class="inputtext" name="standardgruppe" size="1"><?php
    // alle gruppen in option-elementen auflisten
    $gruppen = sql_select("id, titel", "gruppen", "ORDER BY id ASC", NULL, NULL);
    while($gruppe = sql_fetch_assoc($gruppen))
    {
      echo "<option value=\"".$gruppe["id"]."\"";
      if ($gruppe["id"] == $einstellungen["standardgruppe"]) echo " selected";
      echo ">".$gruppe["id"]." - ".$gruppe["titel"]."</option>";
    }
    ?></select></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2"><b>Newsletter</b></td>
  </tr>
  <tr class="row2">
    <td>E-Mail-Adresse:</td><td><input class="inputtext" name="newslettermail" type="text" size="40" value="<?php echo $einstellungen["newslettermail"] ?>" /></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2"><b>HTML- und BB-Code</b></td>
  </tr>
  <tr class="row2">
    <td>Erlaubte HTML-Tags:</td><td><textarea class="inputtext" name="htmltags" cols="39" rows="15"><?php echo $einstellungen["htmltags"] ?></textarea></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2"><b>Seitenwechsel</b></td>
  </tr>
  <tr class="row2">
    <td>Mitglier/Seite:</td><td><input class="inputtext" name="membersperpage" type="text" size="3" value="<?php echo $einstellungen["membersperpage"] ?>" /></td>
  </tr>
  <tr class="row2">
    <td>Threads/Seite:</td><td><input class="inputtext" name="threadsperpage" type="text" size="3" value="<?php echo $einstellungen["threadsperpage"] ?>" /></td>
  </tr>
  <tr class="row2">
    <td>Posts/Seite:</td><td><input class="inputtext" name="postsperpage" type="text" size="3" value="<?php echo $einstellungen["postsperpage"] ?>" /></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">RSS-Feeds:</td>
  </tr>
  <tr class="row2">
    <td>Anzahl der Threads:</td><td><input class="inputtext" name="rss_anzahl" type="text" size="3" value="<?php echo $einstellungen["rss_anzahl"] ?>" /></td>
  </tr>
  <tr class="row2">
    <td>Aus diesen Boards:</td><td><select multiple class="inputtext" name="rss_boards[]" size="8">
    <?php
    // welche boards gibt es?
    $boardresult = sql_select("id, titel", "boards", "ORDER BY id ASC");
    while($board = sql_fetch_assoc($boardresult))
    {
      echo "<option value=\"".$board["id"]."\"";
      $boardarray = explode(";", $einstellungen["rss_boards"]);
      if(in_array($board["id"], $boardarray))
      {
        echo "selected";
      }
      echo ">".$board["titel"]."</option>";
    }
    ?>
    </select></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Zeit:</td>
  </tr>
  <tr class="row2">
    <td>Server-Zeitzone:</td>
    <td><select class="inputtext" name="zeit_zone" size="1">
    <option value="-720"<?php if($einstellungen["zeit_zone"] == -720) echo " selected" ?>>GMT-12:00 : Eniwetok, Kwajalein</option>
    <option value="-660"<?php if($einstellungen["zeit_zone"] == -660) echo " selected" ?>>GMT-11:00 : Midway Island, Samoa</option>
    <option value="-600"<?php if($einstellungen["zeit_zone"] == -600) echo " selected" ?>>GMT-10:00 : Hawaii</option>
    <option value="-540"<?php if($einstellungen["zeit_zone"] == -540) echo " selected" ?>>GMT-9:00  : Alaska</option>
    <option value="-480"<?php if($einstellungen["zeit_zone"] == -480) echo " selected" ?>>GMT-8:00  : Pacific Time (US &amp; Kanada)</option>
    <option value="-420"<?php if($einstellungen["zeit_zone"] == -420) echo " selected" ?>>GMT-7:00  : Mountain Time (US &amp; Kanada)</option>
    <option value="-360"<?php if($einstellungen["zeit_zone"] == -360) echo " selected" ?>>GMT-6:00  : Central Time (US &amp; Kanada), Mexico City</option>
    <option value="-300"<?php if($einstellungen["zeit_zone"] == -300) echo " selected" ?>>GMT-5:00  : Eastern Time (US &amp; Kanada), Bogota, Lima</option>
    <option value="-240"<?php if($einstellungen["zeit_zone"] == -240) echo " selected" ?>>GMT-4:00  : Atlantic Time (US &amp; Kanada), Caracas, La Paz</option>
    <option value="-210"<?php if($einstellungen["zeit_zone"] == -210) echo " selected" ?>>GMT-3:30  : Neufundland</option>
    <option value="-180"<?php if($einstellungen["zeit_zone"] == -180) echo " selected" ?>>GMT-3:00  : Brasilien, Buenos Aires, Georgetown</option>
    <option value="-120"<?php if($einstellungen["zeit_zone"] == -120) echo " selected" ?>>GMT-2:00  : Mittlerer Atlantik</option>
    <option value="-60" <?php if($einstellungen["zeit_zone"] == -60)  echo " selected" ?>>GMT-1:00  : Azoren, Kapverdische Inseln</option>
    <option value="0"   <?php if($einstellungen["zeit_zone"] == 0)    echo " selected" ?>>GMT       : Westeuropische Zeit, London, Lissabon, Casablanca</option>
    <option value="60"  <?php if($einstellungen["zeit_zone"] == 60)   echo " selected" ?>>GMT+1:00  : Mitteleuropische Zeit, Brssel, Kopenhagen, Madrid, Paris</option>
    <option value="120" <?php if($einstellungen["zeit_zone"] == 120)  echo " selected" ?>>GMT+2:00  : Kaliningrad, Sdafrika</option>
    <option value="180" <?php if($einstellungen["zeit_zone"] == 180)  echo " selected" ?>>GMT+3:00  : Bagdad, Riad, Moskau, St. Petersburg</option>
    <option value="210" <?php if($einstellungen["zeit_zone"] == 210)  echo " selected" ?>>GMT+3:30  : Teheran</option>
    <option value="240" <?php if($einstellungen["zeit_zone"] == 240)  echo " selected" ?>>GMT+4:00  : Abu Dhabi, Masqat, Baku, Tbilisi</option>
    <option value="270" <?php if($einstellungen["zeit_zone"] == 270)  echo " selected" ?>>GMT+4:30  : Kabul</option>
    <option value="300" <?php if($einstellungen["zeit_zone"] == 300)  echo " selected" ?>>GMT+5:00  : Ekaterinburg, Islamabad, Karachi, Taschkent</option>
    <option value="330" <?php if($einstellungen["zeit_zone"] == 330)  echo " selected" ?>>GMT+5:30  : Bombay, Kalkutta, Madras, Neu Delhi</option>
    <option value="360" <?php if($einstellungen["zeit_zone"] == 360)  echo " selected" ?>>GMT+6:00  : Almaty, Dhaka, Colombo</option>
    <option value="420" <?php if($einstellungen["zeit_zone"] == 420)  echo " selected" ?>>GMT+7:00  : Bangkok, Hanoi, Jakarta</option>
    <option value="480" <?php if($einstellungen["zeit_zone"] == 480)  echo " selected" ?>>GMT+8:00  : Peking, Perth, Singapur, Hong Kong</option>
    <option value="540" <?php if($einstellungen["zeit_zone"] == 540)  echo " selected" ?>>GMT+9:00  : Tokyo, Seoul, Osaka, Sapporo, Jakutsk</option>
    <option value="570" <?php if($einstellungen["zeit_zone"] == 570)  echo " selected" ?>>GMT+9:30  : Adelaide, Darwin</option>
    <option value="600" <?php if($einstellungen["zeit_zone"] == 600)  echo " selected" ?>>GMT+10:00 : Ost-Australien, Guam, Wladiwostok</option>
    <option value="660" <?php if($einstellungen["zeit_zone"] == 660)  echo " selected" ?>>GMT+11:00 : Magadan, Solomonen, Neu-Kaledonien</option>
    <option value="720" <?php if($einstellungen["zeit_zone"] == 720)  echo " selected" ?>>GMT+12:00 : Auckland, Wellington, Fidschi, Kamschatka</option>
    </select></td>
  </tr>
  <tr class="row2">
    <td>Sommerzeit:</td><td><input class="inputtext" name="zeit_dst" type="radio" value="1" <?php if($einstellungen["zeit_dst"] == 1) echo "checked " ?>/> Ja <input class="inputtext" name="zeit_dst" type="radio" value="0" <?php if($einstellungen["zeit_dst"] == 0) echo "checked " ?>/> Nein</td>
  </tr>
  <tr class="row2">
    <td>&nbsp</td><td><input name="update_button" type="submit" value="bearbeiten" /></td>
  </tr>
  </table>
  </form>

  <?php
}
else
{
  // eingaben berprfen
  if(trim($_POST["titel"])          == "") fehler("Das Forum muss einen Titel haben!");
  if(trim($_POST["adresse"])        == "") fehler("Sie mssen eine gltige URL angeben!");
  if(trim($_POST["membersperpage"]) == "" or trim($_POST["membersperpage"]) == 0) fehler("Sie mssen eine Zahl > 0 bei Mitglieder/Seite angeben!");
  if(trim($_POST["threadsperpage"]) == "" or trim($_POST["threadsperpage"]) == 0) fehler("Sie mssen eine Zahl > 0 bei Threads/Seite angeben!");
  if(trim($_POST["postsperpage"])   == "" or trim($_POST["postsperpage"]) == 0) fehler("Sie mssen eine Zahl > 0 bei Posts/Seite angeben!");
  if(trim($_POST["rss_anzahl"])     == "") fehler("Sie mssen eine Zahl fr die Anzahl der Threads im RSS-Feed angeben!");

  // forum-url formatieren
  $adresse = $_POST["adresse"];
  if(substr($_POST["adresse"],0,7)!="http://") $adresse = "http://".$adresse;
  if(substr($_POST["adresse"],-1)!="/") $adresse = $adresse."/";

  if(isset($_POST["rss_boards"]))
  {
    $rssboards = implode(";", $_POST["rss_boards"]);
  }
  else
  {
    $rssboards = "";
  }

  // db aktualisieren
  $werte = array(
      "titel"            => $_POST["titel"],
      "adresse"          => $adresse,
      "theme"            => $_POST["theme"],
      "layout"           => $_POST["layout"],
      "smilieset"        => $_POST["smilieset"],
      "offline"          => $_POST["offline"],
      "offlinemsg"       => $_POST["offlinemsg"],
      "aktivierungsmail" => $_POST["aktivierungsmail"],
      "newslettermail"   => $_POST["newslettermail"],
      "htmltags"         => $_POST["htmltags"],
      "membersperpage"   => $_POST["membersperpage"],
      "threadsperpage"   => $_POST["threadsperpage"],
      "postsperpage"     => $_POST["postsperpage"],
      "rss_anzahl"       => $_POST["rss_anzahl"],
      "rss_boards"       => $rssboards,
      "zeit_zone"        => $_POST["zeit_zone"],
      "zeit_dst"         => $_POST["zeit_dst"]
      );
  sql_update("einstellungen", $werte, "");

  redir("index.php?action=admincp&show=einstellungen", "Die Einstellungen wurden bearbeitet!");
}
?>