<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ($rechte["admin"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");

if(!isset($_POST["announcement_erstellen"]) and !isset($_POST["announcement_bearbeiten"]) and !isset($_POST["announcement_loeschen"]))
{
  ?>
  <h3>Ankndigungen verwalten</h3>
  <form name="form1" method="POST" action="index.php?action=admincp&amp;show=announcements">
  <table class="maintable">
  <tr class="rowberschrift">
    <td colspan="2">Ankndigung erstellen</td>
  </tr>
  <tr class="row2">
    <td>Typ:</td><td><input class="inputtext" name="typ" type="radio" value="0" checked />Thread <input class="inputtext" name="typ" type="radio" value="1" />Mini</td>
  </tr>
  <tr class="row2">
    <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" /></td>
  </tr>
  <tr class="row2">
    <td>BB-Code</td>
    <td><?php $formname = "form1"; $textname = "nachricht"; include("./bbcode_inputs.php") ?></td>
  </tr>
  <tr class="row2">
    <td>Nachricht:</td><td><textarea class="inputtext" name="nachricht" cols="39" rows="8"></textarea></td>
  </tr>
  <tr class="row2">
    <td>BB-Code aktivieren:</td><td><input name="bbcode" type="radio" value="1" checked />Ja <input name="bbcode" type="radio" value="0" />Nein</td>
  </tr>
  <tr class="row2">
    <td>Smilies aktivieren:</td><td><input name="smilies" type="radio" value="1" checked />Ja <input name="smilies" type="radio" value="0" />Nein</td>
  </tr>
  <tr class="row2">
    <td>Kategorien:</td>
    <td><select class="inputtext" name="kategorien[]" size="5" multiple>
    <?php
    // welche kategorien gibt es?
    $katresult = sql_select("id, titel", "kategorien", "ORDER BY id ASC");
    while($kategorie = sql_fetch_assoc($katresult))
    {
      ?><option value="<?php echo $kategorie["id"] ?>"><?php echo $kategorie["id"]." - ".$kategorie["titel"] ?></option><?php
    }
    ?>
    </select></td>
  </tr>
  <tr class="row2">
    <td>Boards:</td>
    <td><select class="inputtext" name="boards[]" size="5" multiple>
    <?php
    // welche boards gibt es?
    $boardresult = sql_select("id, titel", "boards", "ORDER BY id ASC");
    while($board = sql_fetch_assoc($boardresult))
    {
      ?><option value="<?php echo $board["id"] ?>"><?php echo $board["id"]." - ".$board["titel"] ?></option><?php
    }
    ?>
    </select></td>
  </tr>
  <tr class="row2">
    <td>&nbsp;</td><td><input name="announcement_erstellen" type="submit" value="erstellen" /></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Ankndigung bearbeiten/lschen</td>
  </tr>
  <tr class="row2">
    <td>Ankndigung:</td>
    <td><select class="inputtext" name="announcement" size="1">
    <?php
    $result = sql_select("*", "announcements", "ORDER BY id ASC");
    while ($ergebnis = sql_fetch_assoc($result))
    {
      echo "<option value=\"".$ergebnis["id"]."\" />".$ergebnis["id"]." - ".$ergebnis["titel"]."</option>";
    }
    ?>
    </select></td>
  </tr>
  <tr class="row2">
    <td>&nbsp;</td><td><input name="announcement_bearbeiten" type="submit" value="bearbeiten" /> <input name="announcement_loeschen" type="submit" value="lschen" /></td>
  </tr>
  </table>
  </form>
  <?php
}

if(isset($_POST["announcement_erstellen"]))
{
  // alles in die db
  if(isset($_POST["kategorien"])) $kategorien = implode(";", $_POST["kategorien"]); else $kategorien = "";
  if(isset($_POST["boards"]))     $boards     = implode(";", $_POST["boards"]);     else $boards     = "";
  if(trim($_POST["titel"])     == "") fehler("Die Ankndigung muss einen Titel haben!");
  if(trim($_POST["nachricht"]) == "") fehler("Die Ankndigung muss eine Nachricht haben!");
  
  $werte = array(
      "typ"        => $_POST["typ"],
      "titel"      => $_POST["titel"],
      "nachricht"  => $_POST["nachricht"],
      "kategorien" => $kategorien,
      "boards"     => $boards,
      "bbcode"     => $_POST["bbcode"],
      "smilies"    => $_POST["smilies"]
      );
  sql_insert("announcements", $werte);
  ?>
  <h3>Ankndigung erstellen</h3>
  <?php
  redir("index.php?action=admincp&show=announcements", "Die Ankndigung wurde erfolgreich erstellt!");
}

if(isset($_POST["announcement_bearbeiten"]))
{
  ?>
  <h3>Ankndigung bearbeiten</h3>
  <?php
  if(!isset($_POST["bearbeiten_bestaetigen"]))
  {
    // formular anzeigen
    $announcement = sql_fetch_assoc(sql_select("*", "announcements", "WHERE id=".$_POST["announcement"]));
    ?>
    <form name="form1" method="POST" action="index.php?action=admincp&amp;show=announcements">
    <input name="announcement_bearbeiten" type="hidden" value="1" />
    <input name="announcement" type="hidden" value="<?php echo $announcement["id"] ?>" />
    <table class="maintable">
    <tr class="rowberschrift">
      <td colspan="2">Ankndigung bearbeiten</td>
    </tr>
    <tr class="row2">
      <td>Typ:</td><td><input class="inputtext" name="typ" type="radio" value="0"<?php if($announcement["typ"] == 0) echo " checked" ?> />Thread <input class="inputtext" name="typ" type="radio" value="1"<?php if($announcement["typ"] == 1) echo " checked" ?> />Mini</td>
    </tr>
    <tr class="row2">
      <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" value="<?php echo $announcement["titel"] ?>" /></td>
    </tr>
    <tr class="row2">
      <td>BB-Code</td>
      <td><?php $formname = "form1"; $textname = "nachricht"; include("./bbcode_inputs.php") ?></td>
    </tr>
    <tr class="row2">
      <td>Nachricht:</td><td><textarea class="inputtext" name="nachricht" cols="39" rows="8"><?php echo $announcement["nachricht"] ?></textarea></td>
    </tr>
    <tr class="row2">
      <td>BB-Code aktivieren:</td><td><input name="bbcode" type="radio" value="1"<?php if($announcement["bbcode"] == 1) echo " checked" ?> />Ja <input name="bbcode" type="radio" value="0"<?php if($announcement["bbcode"] == 0) echo " checked" ?> />Nein</td>
    </tr>
    <tr class="row2">
      <td>Smilies aktivieren:</td><td><input name="smilies" type="radio" value="1"<?php if($announcement["smilies"] == 1) echo " checked" ?> />Ja <input name="smilies" type="radio" value="0"<?php if($announcement["smilies"] == 0) echo " checked" ?> />Nein</td>
    </tr>
    <tr class="row2">
      <td>Kategorien:</td>
      <td><select class="inputtext" name="kategorien[]" size="5" multiple>
      <?php
      // welche kategorien gibt es?
      $katresult = sql_select("id, titel", "kategorien", "ORDER BY id ASC");
      while($kategorie = sql_fetch_assoc($katresult))
      {
        echo "<option value=\"".$kategorie["id"]."\"";
        $katarray = explode(";", $announcement["kategorien"]);
        if(in_array($kategorie["id"], $katarray))
        {
          echo "selected";
        }
        echo ">".$kategorie["titel"]."</option>";
      }
      ?>
      </select></td>
    </tr>
    <tr class="row2">
      <td>Boards:</td>
      <td><select class="inputtext" name="boards[]" size="5" multiple>
      <?php
      // welche boards gibt es?
      $boardresult = sql_select("id, titel", "boards", "ORDER BY id ASC");
      while($board = sql_fetch_assoc($boardresult))
      {
        echo "<option value=\"".$board["id"]."\"";
        $boardarray = explode(";", $announcement["boards"]);
        if(in_array($board["id"], $boardarray))
        {
          echo "selected";
        }
        echo ">".$board["titel"]."</option>";
      }
      ?>
      </select></td>
    </tr>
    <tr class="row2">
      <td>&nbsp;</td><td><input name="bearbeiten_bestaetigen" type="submit" value="bearbeiten" /></td>
    </tr>
    </table>
    </form>
    <?php
  }
  else
  {
    // db aktualisieren
    if(isset($_POST["kategorien"])) $kategorien = implode(";", $_POST["kategorien"]); else $kategorien = "";
    if(isset($_POST["boards"]))     $boards     = implode(";", $_POST["boards"]);     else $boards     = "";
    if(trim($_POST["titel"])     == "") fehler("Die Ankndigung muss einen Titel haben!");
    if(trim($_POST["nachricht"]) == "") fehler("Die Ankndigung muss eine Nachricht haben!");
    
    $werte = array(
        "typ"        => $_POST["typ"],
        "titel"      => $_POST["titel"],
        "nachricht"  => $_POST["nachricht"],
        "kategorien" => $kategorien,
        "boards"     => $boards,
        "bbcode"     => $_POST["bbcode"],
        "smilies"    => $_POST["smilies"]
        );
    sql_update("announcements", $werte, "WHERE id=".$_POST["announcement"]);
    redir("index.php?action=admincp&show=announcements", "Die Ankndigung wurde erfolgreich bearbeitet!");
  }
}
if(isset($_POST["announcement_loeschen"]))
{
  ?>
  <h3>Ankndigung lschen</h3>
  <?php
  if(!isset($_POST["loeschen_bestaetigen"]))
  {
    // besttigung holen
    $announcement = sql_fetch_assoc(sql_select("*", "announcements", "WHERE id=".$_POST["announcement"]));
    ?>
    Sind Sie sicher, dass Sie die Ankndigung <b>"<?php echo $announcement["titel"] ?>"</b>
    (ID: <?php echo $announcement["id"] ?>) lschen wollen?<br />
    <form method="POST" action="index.php?action=admincp&amp;show=announcements">
    <input name="announcement_loeschen" type="hidden" value="1" />
    <input name="announcement" type="hidden" value="<?php echo $announcement["id"] ?>" />
    <input name="loeschen_bestaetigen" type="submit" value="lschen" />
    </form>
    <?php
  }
  else
  {
    // announcement aus der db lschen
    sql_delete("announcements", "WHERE id=".$_POST["announcement"]);
    redir("index.php?action=admincp&show=announcements", "Die Ankndigung wurde erfolgreich gelscht!");
  }
}
?>