<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ($user["status"] != 2 or $user["id"] == 1) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");
?>
<table class="maintable" width="100%">
<tr>
<td class="leftnav">
    <a href="index.php?action=usercc&amp;show=profil">Profil</a><br />
    <a href="index.php?action=usercc&amp;show=passwort">Passwort</a><br />
    <a href="index.php?action=usercc&amp;show=signatur">Signatur</a><br />
    <a href="index.php?action=usercc&amp;show=email">E-Mail-Adresse</a><br />
    <?php if($rechte["kalender"] == true) echo "<a href=\"index.php?action=usercc&amp;show=kalender\">Kalender</a><br />\n" ?>
    <a href="index.php?action=usercc&amp;show=einstellungen">Einstellungen</a><br />
    <a href="index.php?action=usercc&amp;show=abos">Abonnierte Threads</a><br />
</td>
<td align="center">
<?php
if (!isset($_GET["show"]))
{
  // bersicht anzeigen
  ?>
  <h3>Benutzer-Kontroll-Zentrum</h3>
  <p>Hier knnen Sie Ihre Benutzerdaten und Einstellungen verwalten.</p>
  <?php
}
else
{
  //****************************** profil **************************************
  if($_GET["show"]=="profil")
  {
    if(!isset($_POST["update_button"]))
    {
      // formular fr profil-einstellungen
      ?>
      <h3>Profil bearbeiten</h3>
      <form method="POST" action="index.php?action=usercc&amp;show=profil">
      <table class="maintable">
      <tr class="row2"><td>Name:</td><td><?php echo htmlspecialchars($user["username"]) ?></td></tr>
      <tr class="row2"><td>ICQ:</td><td><input class="inputtext" name="icq" type="text" size="40" value="<?php echo $user["icq"] ?>" /></td></tr>
      <tr class="row2"><td colspan="2" align="center"><input name="update_button" type="submit" value="bearbeiten" /></td></tr>
      </table>
      </form>
      <?php
    }
    else
    {
      // datenbank-eintrag aktualisieren
      $werte = array("icq" => $_POST["icq"]);
      sql_update("users", $werte, "WHERE id=".$user["id"]);

      redir("index.php?action=usercc", "Ihr Profil wurde aktualisiert!");
    }
  } //ende-profil-bearbeiten
  //***************************** passwort *************************************
  if($_GET["show"]=="passwort")
  {
    if(!isset($_POST["update_button"]))
    {
      // formular zum ndern des passwortes
      ?>
      <h3>Passwort ndern</h3>
      <form method="POST" action="index.php?action=usercc&amp;show=passwort">
      <table class="maintable">
      <tr class="row2"><td>Altes Passwort:</td><td><input class="inputtext" name="oldpw" type="password" size="40" /></td></tr>
      <tr class="row2"><td>Neues Passwort:</td><td><input class="inputtext" name="newpw1" type="password" size="40" /></td></tr>
      <tr class="row2"><td>Wiederholung:</td><td><input class="inputtext" name="newpw2" type="password" size="40" /></td></tr>
      <tr class="row2"><td colspan="2" align="center"><input name="update_button" type="submit" value="ndern" /></td></tr>
      </table>
      </form>
      <?php
    }
    else
    {
      // prfen, ob das alte passwort richtig ist
      if(md5($_POST["oldpw"])!=$user["passwort"])
      {
        // altes passwort ist falsch!
        redir("index.php?action=usercc&show=passwort", "Das eingegebene Passwort ist falsch!", false);
      }
      else
      {
        // altes passwort ist richtig!
        // sind die neuen passwrter gleich?
        if($_POST["newpw1"]!=$_POST["newpw2"])
        {
          // passwrter sind verschieden
          redir("index.php?action=usercc&show=passwort", "Sie haben sich bei der Passwort-Wiederholung vertippt!", false);
        }
        else
        {
          // passwrter stimmen berein -> aktualisieren
          $werte = array("passwort" => md5($_POST["newpw1"]));
          sql_update("users", $werte, "WHERE id=".$user["id"]);

          redir("index.php?action=usercc", "Ihr Passwort wurde aktualisiert!");
        }
      }
    }
  } //ende-passwort-bearbeiten
  //******************************* signatur ***********************************
  if($_GET["show"]=="signatur")
  {
    if(!isset($_POST["update_button"]))
    {
      ?>
      <h3>Signatur bearbeiten</h3>
      <form name="form1" method="POST" action="index.php?action=usercc&amp;show=signatur">
      <table class="maintable">
      <tr class="rowberschrift">
        <td colspan="2">Signatur</td>
      </tr>
      <tr class="row2">
        <td>BB-Code</td>
        <td><?php $formname = "form1"; $textname = "signatur"; include("./bbcode_inputs.php") ?></td>
      </tr>
      <tr class="row2">
        <td>Signatur:</td>
        <td><textarea class="inputtext" name="signatur" rows="15" cols="35"><?php echo $user["signatur"] ?></textarea></td>
      </tr>
      <tr class="rowberschrift">
        <td colspan="2">Optionen</td>
      </tr>
      <tr class="row2">
        <td>BB-Code aktivieren:</td><td><input name="bbcode" type="radio" value="1"<?php if($user["sig_bbcode"] == 1) echo " checked" ?> />Ja <input name="bbcode" type="radio" value="0"<?php if($user["sig_bbcode"] == 0) echo " checked" ?> />Nein</td>
      </tr>
      <tr class="row2">
        <td>Smilies aktivieren:</td><td><input name="smilies" type="radio" value="1"<?php if($user["sig_smilies"] == 1) echo " checked" ?> />Ja <input name="smilies" type="radio" value="0"<?php if($user["sig_smilies"] == 0) echo " checked" ?> />Nein</td>
      </tr>
      <tr class="row2">
        <td>&nbsp</td><td><input name="update_button" type="submit" value="bearbeiten" /></td>
      </tr>
      </table>
      </form>
      <?php
    }
    else
    {
      // datenbank-eintrag aktualisieren
      $werte = array(
          "signatur"    => $_POST["signatur"],
          "sig_bbcode"  => $_POST["bbcode"],
          "sig_smilies" => $_POST["smilies"]
          );
      sql_update("users", $werte, "WHERE id=".$user["id"]);

      redir("index.php?action=usercc", "Ihre Signatur wurde aktualisiert!");
    }
  } //ende-signatur-bearbeiten
  //******************************** email *************************************
  if($_GET["show"]=="email")
  {
    if(!isset($_POST["update_button"]))
    {
      ?>
      <h3>E-Mail-Adresse ndern</h3>
      <form method="POST" action="index.php?action=usercc&amp;show=email">
      <table class="maintable">
      <tr class="row2">
        <td>Neue Adresse:</td><td><input class="inputtext" name="email" type="text" size="40" value="<?php echo $user["email"] ?>" /></td>
      </tr>
      <tr class="row2">
        <td>Wiederholung:</td><td><input class="inputtext" name="email2" type="text" size="40" value="<?php echo $user["email"] ?>" /></td>
      </tr>
      <tr class="row2">
        <td colspan="2">Im Anschluss erhalten Sie eine E-Mail an Ihre neue Adresse, um Ihren Zugang zu aktivieren!</td>
      </tr>
      <tr class="row2">
        <td>&nbsp</td><td><input name="update_button" type="submit" value="bearbeiten" /></td>
      </tr>
      </form>
      </table>
      <?php
    }
    else
    {
      // sind beide adressen gleich?
      if($_POST["email"]==$_POST["email2"] and $_POST["email"]!="")
      {
        // beide sind gleich
        $werte = array("email" => $_POST["email"], "status" => 0);
        sql_update("users", $werte, "WHERE id=".$user["id"]);
        $userergebnis = sql_fetch_assoc(sql_select("*", "users", "WHERE id=".$user["id"], NULL, NULL));
        mail($userergebnis["email"],$einstellungen["titel"]."-Aktivierung","Um ihren Zugang zum Forum zu aktivieren, besuchen Sie diesen Link:\n".$einstellungen["adresse"]."index.php?action=activate&userid=".$_SESSION["userid"]."&key=".md5(crc32(sha1($userergebnis["username"].$userergebnis["email"])))."\nViel Spa bei der Benutzung des Forums!","From: ".$einstellungen["aktivierungsmail"]."\nReply-To: ".$einstellungen["aktivierungsmail"]."\nX-Mailer: PHP/" . phpversion());
        session_destroy();
        ?>
        <b><u>Ihre E-Mail-Adresse wurde aktualisiert und die Mail mit dem neuen Aktivierungslink wurde versendet! Sie sind jetzt ausgeloggt!</u></b>
        <?php
      }
      else
      {
        redir("index.php?action=usercc&show=email", "Sie haben sich bei der E-Mail-Wiederholung vertippt!", false);
      } //ende-adressen-gleich?
    }
  } //ende-email-bearbeiten
  //***************************** kalender ***************************************
  if($_GET["show"]=="kalender")
  {
    if($rechte["kalender"] == false) fehler("Sie besitzen nicht die ntigen Zugriffsrechte, um diese Seite anzuzeigen!");
    if(!isset($_POST["installieren_knopf"]) and !isset($_POST["loeschen_knopf"]) and !isset($_POST["loeschen_bestaetigen"]))
    {
      $kalenderresult = sql_select("*", "kalender", "WHERE besitzer_id=".$user["id"]." and privat=1", NULL, NULL);
      ?>
      <h3>Kalender einrichten</h3>
      <form method="POST" action="index.php?action=usercc&amp;show=kalender">
      Ihr persnlicher Kalender ist:
      <?php
      if(sql_num_rows($kalenderresult) == 0)
      {
        // kein privater kalender
        ?>
        <b>nicht installiert</b><br />
        <input name="installieren_knopf" type="submit" value="installieren" />
        <?php
      }
      else
      {
        // privater kalender ist vorhanden
        ?>
        <b>installiert</b><br />
        <input name="loeschen_knopf" type="submit" value="lschen" />
        <?php
      }
      ?>
      </form>
      <?php
    }
    if(isset($_POST["installieren_knopf"]))
    {
      if(sql_num_rows(sql_select("*", "kalender",  "WHERE besitzer_id=".$user["id"]." AND privat=1", NULL, NULL)) != 0);
      // neuen kalender erstellen
      $werte = array(
          "titel" => $user["username"]."s Kalender",
          "beschreibung" => "Mein persnlicher Kalender",
          "besitzer_id" => $user["id"],
          "besitzer_name" => $user["username"],
          "privat" => 1
          );
      sql_insert("kalender", $werte);

      redir("index.php?action=usercc&show=kalender", "Ihr persnlicher Kalender wurde installiert!");
    }
    if(isset($_POST["loeschen_knopf"]))
    {
      ?>
      <form method="POST" action="index.php?action=usercc&amp;show=kalender">
      Sind Sie sicher, dass Sie Ihren persnlichen Kalender und alle enthaltenen Events lschen wollen?<br />
      <input name="loeschen_bestaetigen" type="submit" value="lschen" />
      </form>
      <?php
    }
    if(isset($_POST["loeschen_bestaetigen"]))
    {
      $kalenderresult = sql_select("*", "kalender", "WHERE besitzer_id=".$user["id"]." AND privat=1", NULL, NULL);
      if(sql_num_rows($kalenderresult) == 0) fehler("Ihr Kalender ist nicht installiert!");
      // kalender-id herausfinden
      $kalender = sql_fetch_assoc($kalenderresult);
      // kalender-rechte lschen
      sql_delete("kalenderrechte", "WHERE kalender_id=".$kalender["id"]);
      // alle events lschen
      sql_delete("events", "WHERE kalender=".$kalender["id"]);
      // kalender lschen
      sql_delete("kalender", "WHERE id=".$kalender["id"]);

      redir("index.php?action=usercc&show=kalender", "Ihr persnlicher Kalender und alle enthaltenen Events wurden gelscht!");
    }
  } // ende-kalender-einrichten
  //***************************** einstellungen **********************************
  if($_GET["show"] == "einstellungen")
  {
    if(!isset($_POST["bearbeiten_knopf"]))
    {
      // formular anzeigen
      ?>
      <h3>Einstellungen bearbeiten</h3>
      <form method="POST" action="index.php?action=usercc&amp;show=einstellungen">
      <table class="maintable">
      <tr class="rowberschrift">
        <td colspan="2">Weiterleitungen:</td>
      </tr>
      <tr class="row2">
        <td>Besttigungen zeigen:</td><td><input class="inputtext" name="redir_type" type="radio" value="0" <?php if($user["redir_type"] == 0) echo "checked " ?>/>Ja (JavaScript) <input class="inputtext" name="redir_type" type="radio" value="1" <?php if($user["redir_type"] == 1) echo "checked " ?>/>Nein, direkt weiterleiten</td>
      </tr>
      <tr class="row2">
        <td>Weiterleitungs-Zeit:</td><td><input class="inputtext" name="redir_timeout" type="text" size="2" value="<?php echo $user["redir_timeout"] ?>" /> Sekunden</td>
      </tr>
      <tr class="rowberschrift">
        <td colspan="2">E-Mail-Benachrichtigungen:</td>
      </tr>
      <tr class="row2">
        <td>Standard-Thread-Abo:</td><td><select class="inputtext" name="auto_abo" size="1">
        <option value="0"<?php if($user["auto_abo"] == 0) echo " selected" ?>>keine Benachrichtigung</option>
        <option value="1"<?php if($user["auto_abo"] == 1) echo " selected" ?>>einmal benachrichtigen</option>
        <option value="2"<?php if($user["auto_abo"] == 2) echo " selected" ?>>bei jedem neuen Post benachrichtigen</option>
        </select></td>
      </tr>
      <tr class="row2">
        <td>Bei neuen PNs mailen:</td><td><input name="pn_email" type="radio" value="1" <?php if($user["pn_email"] == 1) echo "checked " ?>/> Ja <input name="pn_email" type="radio" value="0" <?php if($user["pn_email"] == 0) echo "checked " ?>/> Nein</td>
      </tr>
      <tr class="rowberschrift">
        <td colspan="2">Design:</td>
      </tr>
      <tr class="row2">
        <td>Layout:</td><td><select class="inputtext" name="layout" size="1"><?php
        // array mit allen verzeichnisnamen im "layouts"-Verzeichnis erstellen
        $files = array();
        $fh = opendir("./layouts");
        while (false != ($filename = readdir($fh)))
        {
          array_push($files, $filename);
        }
        closedir($fh);
        // option-elemente erstellen
        foreach($files as $key => $value)
        {
          if(is_dir("./layouts/".$value) and $value != "." and $value != "..")
          {
            if ($value == $layout)
            {
              echo "<option value='".$value."' selected>".$value."</option>\n";
            }
            else
            {
              echo "<option value='".$value."'>".$value."</option>\n";
            }
          }
        }
        ?></select></td>
      </tr>
      <tr class="row2">
        <td>Theme:</td><td><select class="inputtext" name="theme" size="1"><?php
        // array mit allen dateinamen im "themes"-Verzeichnis erstellen
        $files = array();
        $fh = opendir("./layouts/".$layout."/themes");
        while (false !== ($filename = readdir($fh)))
        {
          array_push($files, $filename);
        }
        closedir($fh);
        // option-elemente erstellen
        foreach($files as $key => $value)
        {
          if (is_dir("./layouts/".$layout."/themes/".$value) and $value != "." and $value != "..")
          {
            if ($value == $theme)
            {
              echo "<option value='".$value."' selected>".$value."</option>\n";
            }
            else
            {
              echo "<option value='".$value."'>".$value."</option>\n";
            }
          }
        }
        ?></select></td>
      </tr>
      <tr class="rowberschrift">
        <td colspan="2">Standard-Vorgaben:</td>
      </tr>
      <tr class="row2">
        <td>Signatur anhngen:</td><td><input name="auto_sig" type="radio" value="1"<?php if($user["auto_sig"] == 1) echo " checked" ?> />Ja <input name="auto_sig" type="radio" value="0"<?php if($user["auto_sig"] == 0) echo " checked" ?> />Nein</td>
      </tr>
      <tr class="row2">
        <td>BB-Code aktivieren:</td><td><input name="auto_bbcode" type="radio" value="1"<?php if($user["auto_bbcode"] == 1) echo " checked" ?> />Ja <input name="auto_bbcode" type="radio" value="0"<?php if($user["auto_bbcode"] == 0) echo " checked" ?> />Nein</td>
      </tr>
      <tr class="row2">
        <td>Smilies aktivieren:</td><td><input name="auto_smilies" type="radio" value="1"<?php if($user["auto_smilies"] == 1) echo " checked" ?> />Ja <input name="auto_smilies" type="radio" value="0"<?php if($user["auto_smilies"] == 0) echo " checked" ?> />Nein</td>
      </tr>
      <tr class="rowberschrift">
        <td colspan="2">Zeit:</td>
      </tr>
      <tr class="row2">
        <td>Zeitzone:</td>
        <td><select class="inputtext" name="zeit_zone" size="1">
        <option value="-720"<?php if($user["zeit_zone"] == -720) echo " selected" ?>>GMT-12:00 : Eniwetok, Kwajalein</option>
        <option value="-660"<?php if($user["zeit_zone"] == -660) echo " selected" ?>>GMT-11:00 : Midway Island, Samoa</option>
        <option value="-600"<?php if($user["zeit_zone"] == -600) echo " selected" ?>>GMT-10:00 : Hawaii</option>
        <option value="-540"<?php if($user["zeit_zone"] == -540) echo " selected" ?>>GMT-9:00  : Alaska</option>
        <option value="-480"<?php if($user["zeit_zone"] == -480) echo " selected" ?>>GMT-8:00  : Pacific Time (US &amp; Kanada)</option>
        <option value="-420"<?php if($user["zeit_zone"] == -420) echo " selected" ?>>GMT-7:00  : Mountain Time (US &amp; Kanada)</option>
        <option value="-360"<?php if($user["zeit_zone"] == -360) echo " selected" ?>>GMT-6:00  : Central Time (US &amp; Kanada), Mexico City</option>
        <option value="-300"<?php if($user["zeit_zone"] == -300) echo " selected" ?>>GMT-5:00  : Eastern Time (US &amp; Kanada), Bogota, Lima</option>
        <option value="-240"<?php if($user["zeit_zone"] == -240) echo " selected" ?>>GMT-4:00  : Atlantic Time (US &amp; Kanada), Caracas, La Paz</option>
        <option value="-210"<?php if($user["zeit_zone"] == -210) echo " selected" ?>>GMT-3:30  : Neufundland</option>
        <option value="-180"<?php if($user["zeit_zone"] == -180) echo " selected" ?>>GMT-3:00  : Brasilien, Buenos Aires, Georgetown</option>
        <option value="-120"<?php if($user["zeit_zone"] == -120) echo " selected" ?>>GMT-2:00  : Mittlerer Atlantik</option>
        <option value="-60" <?php if($user["zeit_zone"] == -60)  echo " selected" ?>>GMT-1:00  : Azoren, Kapverdische Inseln</option>
        <option value="0"   <?php if($user["zeit_zone"] == 0)    echo " selected" ?>>GMT       : Westeuropische Zeit, London, Lissabon, Casablanca</option>
        <option value="60"  <?php if($user["zeit_zone"] == 60)   echo " selected" ?>>GMT+1:00  : Mitteleuropische Zeit, Brssel, Kopenhagen, Madrid, Paris</option>
        <option value="120" <?php if($user["zeit_zone"] == 120)  echo " selected" ?>>GMT+2:00  : Kaliningrad, Sdafrika</option>
        <option value="180" <?php if($user["zeit_zone"] == 180)  echo " selected" ?>>GMT+3:00  : Bagdad, Riad, Moskau, St. Petersburg</option>
        <option value="210" <?php if($user["zeit_zone"] == 210)  echo " selected" ?>>GMT+3:30  : Teheran</option>
        <option value="240" <?php if($user["zeit_zone"] == 240)  echo " selected" ?>>GMT+4:00  : Abu Dhabi, Masqat, Baku, Tbilisi</option>
        <option value="270" <?php if($user["zeit_zone"] == 270)  echo " selected" ?>>GMT+4:30  : Kabul</option>
        <option value="300" <?php if($user["zeit_zone"] == 300)  echo " selected" ?>>GMT+5:00  : Ekaterinburg, Islamabad, Karachi, Taschkent</option>
        <option value="330" <?php if($user["zeit_zone"] == 330)  echo " selected" ?>>GMT+5:30  : Bombay, Kalkutta, Madras, Neu Delhi</option>
        <option value="360" <?php if($user["zeit_zone"] == 360)  echo " selected" ?>>GMT+6:00  : Almaty, Dhaka, Colombo</option>
        <option value="420" <?php if($user["zeit_zone"] == 420)  echo " selected" ?>>GMT+7:00  : Bangkok, Hanoi, Jakarta</option>
        <option value="480" <?php if($user["zeit_zone"] == 480)  echo " selected" ?>>GMT+8:00  : Peking, Perth, Singapur, Hong Kong</option>
        <option value="540" <?php if($user["zeit_zone"] == 540)  echo " selected" ?>>GMT+9:00  : Tokyo, Seoul, Osaka, Sapporo, Jakutsk</option>
        <option value="570" <?php if($user["zeit_zone"] == 570)  echo " selected" ?>>GMT+9:30  : Adelaide, Darwin</option>
        <option value="600" <?php if($user["zeit_zone"] == 600)  echo " selected" ?>>GMT+10:00 : Ost-Australien, Guam, Wladiwostok</option>
        <option value="660" <?php if($user["zeit_zone"] == 660)  echo " selected" ?>>GMT+11:00 : Magadan, Solomonen, Neu-Kaledonien</option>
        <option value="720" <?php if($user["zeit_zone"] == 720)  echo " selected" ?>>GMT+12:00 : Auckland, Wellington, Fidschi, Kamschatka</option>
        </select></td>
      </tr>
      <tr class="row2">
        <td>Sommerzeit:</td><td><input class="inputtext" name="zeit_dst" type="radio" value="1" <?php if($user["zeit_dst"] == 1) echo "checked " ?>/> Ja <input class="inputtext" name="zeit_dst" type="radio" value="0" <?php if($user["zeit_dst"] == 0) echo "checked " ?>/> Nein</td>
      </tr>
      <tr class="row2">
        <td>&nbsp</td><td><input name="bearbeiten_knopf" type="submit" value="bearbeiten" /></td>
      </tr>
      </table>
      </form>
      <?php
    }
    if(isset($_POST["bearbeiten_knopf"]))
    {
      // db aktualisieren
      $werte = array(
          "redir_type"    => $_POST["redir_type"],
          "redir_timeout" => $_POST["redir_timeout"],
          "auto_abo"      => $_POST["auto_abo"],
          "pn_email"      => $_POST["pn_email"],
          "layout"        => $_POST["layout"],
          "theme"         => $_POST["theme"],
          "auto_sig"      => $_POST["auto_sig"],
          "auto_bbcode"   => $_POST["auto_bbcode"],
          "auto_smilies"  => $_POST["auto_smilies"],
          "zeit_zone"     => $_POST["zeit_zone"],
          "zeit_dst"      => $_POST["zeit_dst"]
          );
      sql_update("users", $werte, "WHERE id=".$user["id"]);

      redir("index.php?action=usercc&show=einstellungen", "Ihre Einstellungen wurden bearbeitet");
    }
  } // ende-einstellungen-bearbeiten
  //********************************** abos **************************************
  if($_GET["show"] == "abos")
  {
    ?><h3>Abonnierte Threads</h3><?php
    if(!isset($_POST["aendern_knopf"]))
    {
      // abonnierte threads anzeigen
      ?>
      <form method="POST" action="index.php?action=usercc&amp;show=abos">
      <table class="maintable">
      <tr class="rowberschrift">
        <td>ID</td>
        <td>Status</td>
        <td>Titel</td>
        <td>erstellt</td>
        <td>Posts</td>
        <td>Hits</td>
        <td>Letzter Post</td>
        <td>Abonnement</td>
      </tr>
      <?php
      $zeile = 2;
      $abos = sql_select("*", "thread_abos", "WHERE user_id=".$user["id"], NULL, NULL);
      while($abo = sql_fetch_assoc($abos))
      {
        $thread = sql_fetch_assoc(sql_select("*", "threads", "WHERE id=".$abo["thread_id"], NULL, NULL));
        $postsresult = sql_select("id", "posts", "WHERE thread=".$thread["id"], NULL, NULL);
        $numposts = sql_num_rows($postsresult);

        if($numposts!=0)
        {
          $lastpostresult = sql_select("*", "posts", "WHERE thread=".$thread["id"]." ORDER BY id DESC", NULL, NULL);
          $lastpost = sql_fetch_assoc($lastpostresult);
        }
        ?>
        <tr class="row<?php echo $zeile ?>">
          <td><?php echo $thread["id"] ?></td>
          <td><?php if($thread["status"] == 1) { echo "offen"; } else { echo "geschlossen"; } ?></td>
          <td><?php echo $thread["titel"] ?></td>
          <td><?php echo date("d.m.Y - H:i:s", $thread["created"] + $zeitoffset) ?></td>
          <td><?php echo $numposts ?></td>
          <td><?php echo $thread["hits"] ?></td>
          <td><?php
          if($numposts != 0)
          {
            ?>
            <a href="index.php?action=viewthread&amp;id=<?php echo $lastpost["thread"] ?>#<?php echo $lastpost["id"] ?>"><?php echo date("d.m.Y - H:i:s",$lastpost["created"] + $zeitoffset) ?></a>
            von <?php if($rechte["memberlist"] == true) { ?><a href="index.php?action=userinfo&amp;id=<?php echo $lastpost["autor_id"] ?>"><?php } echo $lastpost["autor_name"]; if($rechte["memberlist"] == true) { ?></a><?php }
          }
          else
          {
            echo " - ";
          }
          ?></td>
          <td><select class="inputtext" name="abo" size="1">
          <option value="0">lschen</option>
          <option value="1"<?php if($abo["abo_typ"] == 1) echo " selected" ?>>einmal</option>
          <option value="2"<?php if($abo["abo_typ"] == 2) echo " selected" ?>>immer</option>
          </select> <input name="aendern_knopf[<?php echo $thread["id"] ?>]" type="submit" value="ndern" /></td>
        </tr>
        <?php
        $zeile ++;
        if($zeile > 2) $zeile = 1;
      }
      ?>
      </table>
      </form>
      <?php
    }
    else
    {
      // abo_typ bearbeiten oder eintrag lschen
      $thread = key($_POST["aendern_knopf"]);
      if($_POST["abo"] != 0)
      {
        $werte = array("abo_typ" => $_POST["abo"]);
        sql_update("thread_abos", $werte, "WHERE thread_id=".$thread." AND user_id=".$user["id"]);
      }
      else
      {
        sql_delete("thread_abos", "WHERE thread_id=".$thread." AND user_id=".$user["id"]);
      }
      redir("index.php?action=usercc&show=abos", "Ihr Thread-Abonnement wurde aktualisiert!");
    }
  } // ende-abos

  // weitere einstellungen
}
?>
</td></tr>
</table>
